<?php
/**
 * All settings related to preloader.
 *
 * @package NotoMag
 */
$wp_customize->add_section(
	'preloader_options',
	array(
		'title' => esc_html__( 'Preloader Options', 'notomag' ),
		'panel' => 'general_options_panel',
	)
);

$wp_customize->add_setting(
    'notomag_options[enable_preloader_options]',
    array(
        'default'           => $notomag_default['enable_preloader_options'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_preloader_options]',
    array(
        'label'       => esc_html__( 'Enable Preloader Option', 'notomag' ),
        'section'     => 'preloader_options',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
    'notomag_options[notomag_preloader_style]',
    array(
        'default'           => $notomag_default['notomag_preloader_style'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[notomag_preloader_style]',
    array(
        'label'         => esc_html__( 'Select Preloader Style', 'notomag' ),
        'section'     => 'preloader_options',
        'type'        => 'select',
        'choices'       => notomag_preloader_style_option(),

    )
);
