<?php
// Frontline Posts Options.
$wp_customize->add_section(
    'home_page_frontline_options',
    array(
        'title' => __('Frontline Section', 'notomag'),
        'panel' => 'front_page_theme_options_panel',
    )
);
$wp_customize->add_setting(
    'notomag_options[enable_frontlines]',
    array(
        'default' => $notomag_default['enable_frontlines'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_frontlines]',
    array(
        'label' => __('Enable Frontline', 'notomag'),
        'section' => 'home_page_frontline_options',
        'type' => 'checkbox',
    )
);

// Frontline Posts Category.
$wp_customize->add_setting(
    'notomag_options[frontline_cat]',
    array(
        'default' => $notomag_default['frontline_cat'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new NotoMag_Dropdown_Taxonomies_Control(
        $wp_customize,
        'notomag_options[frontline_cat]',
        array(
            'label' => __('Choose Frontline category', 'notomag'),
            'section' => 'home_page_frontline_options',
        )
    )
);
$wp_customize->add_setting(
    'notomag_options[frontline_layout_style]',
    array(
        'default' => $notomag_default['frontline_layout_style'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[frontline_layout_style]',
    array(
        'label' => __('Select Layout Style', 'notomag'),
        'section' => 'home_page_frontline_options',
        'type' => 'select',
        'choices' => array(
            'frontline-layout-1' => __('Layout - 1', 'notomag'),
            'frontline-layout-2' => __('Layout - 2', 'notomag'),
            'frontline-layout-3' => __('Layout - 3', 'notomag'),
        ),
    )
);
// No of posts.
$wp_customize->add_setting(
    'notomag_options[no_of_frontlines]',
    array(
        'default' => $notomag_default['no_of_frontlines'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[no_of_frontlines]',
    array(
        'label' => __('Number of Posts', 'notomag'),
        'section' => 'home_page_frontline_options',
        'type' => 'number',
    )
);

// No of posts offset.
$wp_customize->add_setting(
    'notomag_options[frontlines_number_of_post_offsets]',
    array(
        'default' => $notomag_default['frontlines_number_of_post_offsets'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[frontlines_number_of_post_offsets]',
    array(
        'label' => __('Post Offset Number', 'notomag'),
        'section' => 'home_page_frontline_options',
        'type' => 'number',
    )
);
// Posts Orderby.
$wp_customize->add_setting(
    'notomag_options[frontline_orderby]',
    array(
        'default' => $notomag_default['frontline_orderby'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[frontline_orderby]',
    array(
        'label' => __('Orderby', 'notomag'),
        'section' => 'home_page_frontline_options',
        'type' => 'select',
        'choices' => array(
            'date' => __('Date', 'notomag'),
            'id' => __('ID', 'notomag'),
            'title' => __('Title', 'notomag'),
            'rand' => __('Random', 'notomag'),
        ),
    )
);
// Posts Order.
$wp_customize->add_setting(
    'notomag_options[frontline_order]',
    array(
        'default' => $notomag_default['frontline_order'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[frontline_order]',
    array(
        'label' => __('Order', 'notomag'),
        'section' => 'home_page_frontline_options',
        'type' => 'select',
        'choices' => array(
            'asc' => __('ASC', 'notomag'),
            'desc' => __('DESC', 'notomag'),
        ),
    )
);
$wp_customize->add_setting(
    'notomag_options[enable_frontline_author_meta]',
    array(
        'default' => $notomag_default['enable_frontline_author_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_frontline_author_meta]',
    array(
        'label' => esc_html__('Display Author Meta', 'notomag'),
        'section' => 'home_page_frontline_options',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_frontline_author_meta]',
    array(
        'default' => $notomag_default['select_frontline_author_meta'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_frontline_author_meta]',
    array(
        'label' => esc_html__('Select Author Meta', 'notomag'),
        'section' => 'home_page_frontline_options',
        'type' => 'select',
        'choices' => notomag_author_meta(),
    )
);
$wp_customize->add_setting(
    'notomag_options[frontline_author_meta_title]',
    array(
        'default' => $notomag_default['frontline_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[frontline_author_meta_title]',
    array(
        'label' => __('Author Meta Text', 'notomag'),
        'section' => 'home_page_frontline_options',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'notomag_options[enable_frontline_date_meta]',
    array(
        'default' => $notomag_default['enable_frontline_date_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_frontline_date_meta]',
    array(
        'label' => esc_html__('Display Published Date', 'notomag'),
        'section' => 'home_page_frontline_options',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_frontline_date]',
    array(
        'default' => $notomag_default['select_frontline_date'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_frontline_date]',
    array(
        'label' => esc_html__('Select Date Meta', 'notomag'),
        'section' => 'home_page_frontline_options',
        'type' => 'select',
        'choices' => notomag_date_meta(),
    )
);
$wp_customize->add_setting(
    'notomag_options[select_frontline_date_meta_title]',
    array(
        'default' => $notomag_default['select_frontline_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[select_frontline_date_meta_title]',
    array(
        'label' => __('Date Meta Text', 'notomag'),
        'section' => 'home_page_frontline_options',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_frontline_date_format]',
    array(
        'default' => $notomag_default['select_frontline_date_format'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_frontline_date_format]',
    array(
        'label' => esc_html__('Select Date Format', 'notomag'),
        'section' => 'home_page_frontline_options',
        'type' => 'select',
        'choices' => notomag_get_date_formats(),
    )
);
$wp_customize->add_setting(
    'notomag_options[enable_frontline_category_meta]',
    array(
        'default' => $notomag_default['enable_frontline_category_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_frontline_category_meta]',
    array(
        'label' => esc_html__('Enable Category Meta', 'notomag'),
        'section' => 'home_page_frontline_options',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_frontline_number_of_category]',
    array(
        'default' => $notomag_default['select_frontline_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[select_frontline_number_of_category]',
    array(
        'label' => __('Number of Category', 'notomag'),
        'section' => 'home_page_frontline_options',
        'type' => 'number',
    )
);
$wp_customize->add_setting(
    'notomag_options[frontline_category_label]',
    array(
        'default' => $notomag_default['frontline_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[frontline_category_label]',
    array(
        'label' => __('Category Label', 'notomag'),
        'section' => 'home_page_frontline_options',
        'type' => 'text',
    )
);

$wp_customize->add_setting(
    'notomag_options[select_frontline_category_color]',
    array(
        'default' => $notomag_default['select_frontline_category_color'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_frontline_category_color]',
    array(
        'label' => esc_html__('Select Category Color', 'notomag'),
        'section' => 'home_page_frontline_options',
        'type' => 'select',
        'choices' => notomag_category_color(),
    )
);
