<?php
/**
 * All settings related to footer recommended post.
 *
 * @package NotoMag
 */
$wp_customize->add_section(
	'footer_recommended_post',
	array(
		'title' => esc_html__( 'Recommended Section', 'notomag' ),
		'panel' => 'front_page_theme_options_panel',
	)
);

$wp_customize->add_setting(
    'notomag_options[enable_recommended_post]',
    array(
        'default'           => $notomag_default['enable_recommended_post'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_recommended_post]',
    array(
        'label'       => esc_html__( 'Enable Recommended Post', 'notomag' ),
        'section'     => 'footer_recommended_post',
        'type'        => 'checkbox',
    )
);


$wp_customize->add_setting(
    'notomag_options[recommended_post_layout]',
    array(
        'default'           => $notomag_default['recommended_post_layout'],
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'notomag_sanitize_radio'
    )
);


$wp_customize->add_control(
    new NotoMag_Custom_Radio_Image_Control(
        $wp_customize,
        'notomag_options[recommended_post_layout]',
        array(
            'label'         => esc_html__( 'Recommended Post Layout', 'notomag' ),
            'section'       => 'footer_recommended_post',
            'choices'       => notomag_get_recommended_post(),
        )
    )
);



$wp_customize->add_setting(
    'notomag_options[recommended_post_title]',
    array(
        'default'           => $notomag_default['recommended_post_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[recommended_post_title]',
    array(
        'label'    => __( 'Recommended Post', 'notomag' ),
        'section'  => 'footer_recommended_post',
        'type'     => 'text',
    )
);

$wp_customize->add_setting(
    'notomag_options[recommended_post_category]',
    array(
        'default'           => $notomag_default['recommended_post_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new NotoMag_Dropdown_Taxonomies_Control(
        $wp_customize,
        'notomag_options[recommended_post_category]',
        array(
            'label'           => __( 'Choose Category', 'notomag' ),
            'description'     => __( 'Leave Empty if you don\'t want the posts to be category specific', 'notomag' ),
            'section'         => 'footer_recommended_post',
        )
    )
);


$wp_customize->add_setting(
    'notomag_options[recommended_post_offsets]',
    array(
        'default' => $notomag_default['recommended_post_offsets'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[recommended_post_offsets]',
    array(
        'label' => __('Post Offset', 'notomag'),
        'section' => 'footer_recommended_post',
        'type' => 'number',
    )
);


$wp_customize->add_setting(
    'notomag_options[enable_recommended_post_author_meta]',
    array(
        'default' => $notomag_default['enable_recommended_post_author_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_recommended_post_author_meta]',
    array(
        'label' => esc_html__('Display Author Meta', 'notomag'),
        'section' => 'footer_recommended_post',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_recommended_post_author_meta]',
    array(
        'default' => $notomag_default['select_recommended_post_author_meta'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_recommended_post_author_meta]',
    array(
        'label' => esc_html__('Select Author Meta', 'notomag'),
        'section' => 'footer_recommended_post',
        'type' => 'select',
        'choices' => notomag_author_meta(),
    )
);
$wp_customize->add_setting(
    'notomag_options[recommended_post_author_meta_title]',
    array(
        'default' => $notomag_default['recommended_post_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[recommended_post_author_meta_title]',
    array(
        'label' => __('Author Meta Text', 'notomag'),
        'section' => 'footer_recommended_post',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'notomag_options[enable_recommended_post_date_meta]',
    array(
        'default' => $notomag_default['enable_recommended_post_date_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_recommended_post_date_meta]',
    array(
        'label' => esc_html__('Display Published Date', 'notomag'),
        'section' => 'footer_recommended_post',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_recommended_post_date]',
    array(
        'default' => $notomag_default['select_recommended_post_date'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_recommended_post_date]',
    array(
        'label' => esc_html__('Select Date Meta', 'notomag'),
        'section' => 'footer_recommended_post',
        'type' => 'select',
        'choices' => notomag_date_meta(),
    )
);
$wp_customize->add_setting(
    'notomag_options[select_recommended_post_date_meta_title]',
    array(
        'default' => $notomag_default['select_recommended_post_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[select_recommended_post_date_meta_title]',
    array(
        'label' => __('Date Meta Text', 'notomag'),
        'section' => 'footer_recommended_post',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_recommended_post_date_format]',
    array(
        'default' => $notomag_default['select_recommended_post_date_format'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_recommended_post_date_format]',
    array(
        'label' => esc_html__('Select Date Format', 'notomag'),
        'section' => 'footer_recommended_post',
        'type' => 'select',
        'choices' => notomag_get_date_formats(),
    )
);
$wp_customize->add_setting(
    'notomag_options[enable_recommended_post_category_meta]',
    array(
        'default' => $notomag_default['enable_recommended_post_category_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_recommended_post_category_meta]',
    array(
        'label' => esc_html__('Enable Category Meta', 'notomag'),
        'section' => 'footer_recommended_post',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_recommended_post_number_of_category]',
    array(
        'default' => $notomag_default['select_recommended_post_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[select_recommended_post_number_of_category]',
    array(
        'label' => __('Number of Category', 'notomag'),
        'section' => 'footer_recommended_post',
        'type' => 'number',
    )
);
$wp_customize->add_setting(
    'notomag_options[recommended_post_category_label]',
    array(
        'default' => $notomag_default['recommended_post_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[recommended_post_category_label]',
    array(
        'label' => __('Category Label', 'notomag'),
        'section' => 'footer_recommended_post',
        'type' => 'text',
    )
);

$wp_customize->add_setting(
    'notomag_options[select_recommended_post_category_color]',
    array(
        'default' => $notomag_default['select_recommended_post_category_color'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_recommended_post_category_color]',
    array(
        'label' => esc_html__('Select Category Color', 'notomag'),
        'section' => 'footer_recommended_post',
        'type' => 'select',
        'choices' => notomag_category_color(),
    )
);