<?php
/**
 * All settings related to footer recommended post.
 *
 * @package NotoMag
 */
$wp_customize->add_section(
	'dual_insights',
	array(
		'title' => esc_html__( 'Dual Insights Section', 'notomag' ),
		'panel' => 'front_page_theme_options_panel',
	)
);

$wp_customize->add_setting(
    'notomag_options[enable_dual_insights]',
    array(
        'default'           => $notomag_default['enable_dual_insights'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_dual_insights]',
    array(
        'label'       => esc_html__( 'Enable Dual Insights', 'notomag' ),
        'section'     => 'dual_insights',
        'type'        => 'checkbox',
    )
);

$wp_customize->add_setting(
  'notomag_options[dual_insights_title]',
  array(
      'default' => $notomag_default['dual_insights_title'],
      'sanitize_callback' => 'sanitize_text_field',
  )
);
$wp_customize->add_control(
  'notomag_options[dual_insights_title]',
  array(
      'label' => __('Section Title', 'notomag'),
      'section' => 'dual_insights',
      'type' => 'text',
  )
);

$wp_customize->add_setting(
    'notomag_section_seperator_dual_insights_1',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new NotoMag_Seperator_Control(
        $wp_customize,
        'notomag_section_seperator_dual_insights_1',
        array(
            'label'         => esc_html__( 'Dual Insights Column - 1', 'notomag' ),
            'settings' => 'notomag_section_seperator_dual_insights_1',
            'section' => 'dual_insights',
        )
    )
);

$wp_customize->add_setting(
    'notomag_options[main_insights_category]',
    array(
        'default'           => $notomag_default['main_insights_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new NotoMag_Dropdown_Taxonomies_Control(
        $wp_customize,
        'notomag_options[main_insights_category]',
        array(
            'label'           => __( 'Choose Column - 1 Category', 'notomag' ),
            'description'     => __( 'Leave Empty if you don\'t want the posts to be category specific', 'notomag' ),
            'section'         => 'dual_insights',
        )
    )
);

$wp_customize->add_setting(
    'notomag_options[insights_post_1_offset]',
    array(
        'default' => $notomag_default['insights_post_1_offset'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[insights_post_1_offset]',
    array(
        'label' => __('Insights Post Offset - 1', 'notomag'),
        'section' => 'dual_insights',
        'type' => 'number',
    )
);

$wp_customize->add_setting(
    'notomag_section_seperator_dual_insights_2',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new NotoMag_Seperator_Control(
        $wp_customize,
        'notomag_section_seperator_dual_insights_2',
        array(
            'label'         => esc_html__( 'Dual Insights Column - 2', 'notomag' ),
            'settings' => 'notomag_section_seperator_dual_insights_2',
            'section' => 'dual_insights',
        )
    )
);

$wp_customize->add_setting(
  'notomag_options[dual_inner_column_title]',
  array(
      'default' => $notomag_default['dual_inner_column_title'],
      'sanitize_callback' => 'sanitize_text_field',
  )
);
$wp_customize->add_control(
  'notomag_options[dual_inner_column_title]',
  array(
      'label' => __('Inner Column Title', 'notomag'),
      'section' => 'dual_insights',
      'type' => 'text',
  )
);

$wp_customize->add_setting(
    'notomag_options[trending_insights_category]',
    array(
        'default'           => $notomag_default['trending_insights_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new NotoMag_Dropdown_Taxonomies_Control(
        $wp_customize,
        'notomag_options[trending_insights_category]',
        array(
            'label'           => __( 'Choose Column - 2 Category', 'notomag' ),
            'description'     => __( 'Leave Empty if you don\'t want the posts to be category specific', 'notomag' ),
            'section'         => 'dual_insights',
        )
    )
);

$wp_customize->add_setting(
    'notomag_options[insights_post_2_offset]',
    array(
        'default' => $notomag_default['insights_post_2_offset'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[insights_post_2_offset]',
    array(
        'label' => __('Insights Post Offset - 2', 'notomag'),
        'section' => 'dual_insights',
        'type' => 'number',
    )
);


$wp_customize->add_setting(
    'notomag_options[enable_insights_author_meta]',
    array(
        'default' => $notomag_default['enable_insights_author_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_insights_author_meta]',
    array(
        'label' => esc_html__('Display Author Meta', 'notomag'),
        'section' => 'dual_insights',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_insights_author_meta]',
    array(
        'default' => $notomag_default['select_insights_author_meta'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_insights_author_meta]',
    array(
        'label' => esc_html__('Select Author Meta', 'notomag'),
        'section' => 'dual_insights',
        'type' => 'select',
        'choices' => notomag_author_meta(),
    )
);
$wp_customize->add_setting(
    'notomag_options[insights_author_meta_title]',
    array(
        'default' => $notomag_default['insights_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[insights_author_meta_title]',
    array(
        'label' => __('Author Meta Text', 'notomag'),
        'section' => 'dual_insights',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'notomag_options[enable_insights_date_meta]',
    array(
        'default' => $notomag_default['enable_insights_date_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_insights_date_meta]',
    array(
        'label' => esc_html__('Display Published Date', 'notomag'),
        'section' => 'dual_insights',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_insights_date]',
    array(
        'default' => $notomag_default['select_insights_date'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_insights_date]',
    array(
        'label' => esc_html__('Select Date Meta', 'notomag'),
        'section' => 'dual_insights',
        'type' => 'select',
        'choices' => notomag_date_meta(),
    )
);
$wp_customize->add_setting(
    'notomag_options[select_insights_date_meta_title]',
    array(
        'default' => $notomag_default['select_insights_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[select_insights_date_meta_title]',
    array(
        'label' => __('Date Meta Text', 'notomag'),
        'section' => 'dual_insights',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_insights_date_format]',
    array(
        'default' => $notomag_default['select_insights_date_format'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_insights_date_format]',
    array(
        'label' => esc_html__('Select Date Format', 'notomag'),
        'section' => 'dual_insights',
        'type' => 'select',
        'choices' => notomag_get_date_formats(),
    )
);
$wp_customize->add_setting(
    'notomag_options[enable_insights_category_meta]',
    array(
        'default' => $notomag_default['enable_insights_category_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_insights_category_meta]',
    array(
        'label' => esc_html__('Enable Category Meta', 'notomag'),
        'section' => 'dual_insights',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_insights_number_of_category]',
    array(
        'default' => $notomag_default['select_insights_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[select_insights_number_of_category]',
    array(
        'label' => __('Number of Category', 'notomag'),
        'section' => 'dual_insights',
        'type' => 'number',
    )
);
$wp_customize->add_setting(
    'notomag_options[insights_category_label]',
    array(
        'default' => $notomag_default['insights_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[insights_category_label]',
    array(
        'label' => __('Category Label', 'notomag'),
        'section' => 'dual_insights',
        'type' => 'text',
    )
);

$wp_customize->add_setting(
    'notomag_options[select_insights_category_color]',
    array(
        'default' => $notomag_default['select_insights_category_color'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_insights_category_color]',
    array(
        'label' => esc_html__('Select Category Color', 'notomag'),
        'section' => 'dual_insights',
        'type' => 'select',
        'choices' => notomag_category_color(),
    )
);