<?php
/**
 * All settings related to footer recommended post.
 *
 * @package NotoMag
 */
$wp_customize->add_section(
	'article_group',
	array(
		'title' => esc_html__( 'Article Group Section', 'notomag' ),
		'panel' => 'front_page_theme_options_panel',
	)
);

$wp_customize->add_setting(
    'notomag_options[enable_article_group]',
    array(
        'default'           => $notomag_default['enable_article_group'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_article_group]',
    array(
        'label'       => esc_html__( 'Enable Article Group Post', 'notomag' ),
        'section'     => 'article_group',
        'type'        => 'checkbox',
    )
);


$wp_customize->add_setting(
    'notomag_options[article_group_title]',
    array(
        'default' => $notomag_default['article_group_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[article_group_title]',
    array(
        'label' => __('Section Title', 'notomag'),
        'section' => 'article_group',
        'type' => 'text',
    )
);

$wp_customize->add_setting(
    'notomag_section_seperator_article_group_1',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new NotoMag_Seperator_Control(
        $wp_customize,
        'notomag_section_seperator_article_group_1',
        array(
            'label'         => esc_html__( 'Article Group Column - 1', 'notomag' ),
            'settings' => 'notomag_section_seperator_article_group_1',
            'section' => 'article_group',
        )
    )
);

$wp_customize->add_setting(
    'notomag_options[article_group_category]',
    array(
        'default'           => $notomag_default['article_group_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new NotoMag_Dropdown_Taxonomies_Control(
        $wp_customize,
        'notomag_options[article_group_category]',
        array(
            'label'           => __( 'Choose Column - 1 Category', 'notomag' ),
            'description'     => __( 'Leave Empty if you don\'t want the posts to be category specific', 'notomag' ),
            'section'         => 'article_group',
        )
    )
);


$wp_customize->add_setting(
    'notomag_options[article_group_offset]',
    array(
        'default' => $notomag_default['article_group_offset'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[article_group_offset]',
    array(
        'label' => __('Article Group Offset - 1', 'notomag'),
        'section' => 'article_group',
        'type' => 'number',
    )
);

$wp_customize->add_setting(
    'notomag_section_seperator_article_group_2',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new NotoMag_Seperator_Control(
        $wp_customize,
        'notomag_section_seperator_article_group_2',
        array(
            'label'         => esc_html__( 'Article Group Column - 2', 'notomag' ),
            'settings' => 'notomag_section_seperator_article_group_2',
            'section' => 'article_group',
        )
    )
);

$wp_customize->add_setting(
    'notomag_options[article_group_slider_category]',
    array(
        'default'           => $notomag_default['article_group_slider_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    new NotoMag_Dropdown_Taxonomies_Control(
        $wp_customize,
        'notomag_options[article_group_slider_category]',
        array(
            'label'           => __( 'Choose Column - 2 Category', 'notomag' ),
            'description'     => __( 'Leave Empty if you don\'t want the posts to be category specific', 'notomag' ),
            'section'         => 'article_group',
        )
    )
);

$wp_customize->add_setting(
    'notomag_options[article_group_offset_2]',
    array(
        'default' => $notomag_default['article_group_offset_2'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[article_group_offset_2]',
    array(
        'label' => __('Article Slider Offset', 'notomag'),
        'section' => 'article_group',
        'type' => 'number',
    )
);

$wp_customize->add_setting(
    'notomag_section_seperator_article_group_meta',
    array(
        'default'           => '',
        'capability'        => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    )
);

$wp_customize->add_control(
    new NotoMag_Seperator_Control(
        $wp_customize,
        'notomag_section_seperator_article_group_meta',
        array(
            'label'         => esc_html__( 'Article Group Meta Option', 'notomag' ),
            'settings' => 'notomag_section_seperator_article_group_meta',
            'section' => 'article_group',
        )
    )
);

$wp_customize->add_setting(
    'notomag_options[enable_article_group_author_meta]',
    array(
        'default' => $notomag_default['enable_article_group_author_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_article_group_author_meta]',
    array(
        'label' => esc_html__('Display Author Meta', 'notomag'),
        'section' => 'article_group',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_article_group_author_meta]',
    array(
        'default' => $notomag_default['select_article_group_author_meta'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_article_group_author_meta]',
    array(
        'label' => esc_html__('Select Author Meta', 'notomag'),
        'section' => 'article_group',
        'type' => 'select',
        'choices' => notomag_author_meta(),
    )
);
$wp_customize->add_setting(
    'notomag_options[article_group_author_meta_title]',
    array(
        'default' => $notomag_default['article_group_author_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[article_group_author_meta_title]',
    array(
        'label' => __('Author Meta Text', 'notomag'),
        'section' => 'article_group',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'notomag_options[enable_article_group_date_meta]',
    array(
        'default' => $notomag_default['enable_article_group_date_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_article_group_date_meta]',
    array(
        'label' => esc_html__('Display Published Date', 'notomag'),
        'section' => 'article_group',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_article_group_date]',
    array(
        'default' => $notomag_default['select_article_group_date'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_article_group_date]',
    array(
        'label' => esc_html__('Select Date Meta', 'notomag'),
        'section' => 'article_group',
        'type' => 'select',
        'choices' => notomag_date_meta(),
    )
);
$wp_customize->add_setting(
    'notomag_options[select_article_group_date_meta_title]',
    array(
        'default' => $notomag_default['select_article_group_date_meta_title'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[select_article_group_date_meta_title]',
    array(
        'label' => __('Date Meta Text', 'notomag'),
        'section' => 'article_group',
        'type' => 'text',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_article_group_date_format]',
    array(
        'default' => $notomag_default['select_article_group_date_format'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_article_group_date_format]',
    array(
        'label' => esc_html__('Select Date Format', 'notomag'),
        'section' => 'article_group',
        'type' => 'select',
        'choices' => notomag_get_date_formats(),
    )
);
$wp_customize->add_setting(
    'notomag_options[enable_article_group_category_meta]',
    array(
        'default' => $notomag_default['enable_article_group_category_meta'],
        'sanitize_callback' => 'notomag_sanitize_checkbox',
    )
);
$wp_customize->add_control(
    'notomag_options[enable_article_group_category_meta]',
    array(
        'label' => esc_html__('Enable Category Meta', 'notomag'),
        'section' => 'article_group',
        'type' => 'checkbox',
    )
);
$wp_customize->add_setting(
    'notomag_options[select_article_group_number_of_category]',
    array(
        'default' => $notomag_default['select_article_group_number_of_category'],
        'sanitize_callback' => 'absint',
    )
);
$wp_customize->add_control(
    'notomag_options[select_article_group_number_of_category]',
    array(
        'label' => __('Number of Category', 'notomag'),
        'section' => 'article_group',
        'type' => 'number',
    )
);
$wp_customize->add_setting(
    'notomag_options[article_group_category_label]',
    array(
        'default' => $notomag_default['article_group_category_label'],
        'sanitize_callback' => 'sanitize_text_field',
    )
);
$wp_customize->add_control(
    'notomag_options[article_group_category_label]',
    array(
        'label' => __('Category Label', 'notomag'),
        'section' => 'article_group',
        'type' => 'text',
    )
);

$wp_customize->add_setting(
    'notomag_options[select_article_group_category_color]',
    array(
        'default' => $notomag_default['select_article_group_category_color'],
        'sanitize_callback' => 'notomag_sanitize_select',
    )
);
$wp_customize->add_control(
    'notomag_options[select_article_group_category_color]',
    array(
        'label' => esc_html__('Select Category Color', 'notomag'),
        'section' => 'article_group',
        'type' => 'select',
        'choices' => notomag_category_color(),
    )
);