<?php
if (!function_exists('notomag_get_option')) :
    /**
     * Get customizer value by key.
     *
     * @param string $key Option key.
     * @return mixed Option value.
     * @since 1.0.0
     *
     */
    function notomag_get_option($key)
    {
        $key_value = '';
        if (!$key) {
            return $key_value;
        }
        $default_values = notomag_get_all_customizer_default_values();
        $customizer_values = get_theme_mod('notomag_options');
        $customizer_values = wp_parse_args($customizer_values, $default_values);

        $key_value = (isset($customizer_values[$key])) ? $customizer_values[$key] : '';
        return $key_value;
    }
endif;

if ( ! function_exists( 'notomag_get_archive_layouts' ) ) :
	/**
	 * Returns archive layout options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function notomag_get_archive_layouts() {
		$options = apply_filters(
			'notomag_get_archive_layouts',
			array(
				'archive_style_1' => array(
					'url'   => get_template_directory_uri() . '/assets/images/archive-1.webp',
					'label' => esc_html__( 'Archive List View', 'notomag' ),
				),
				'archive_style_2' => array(
					'url'   => get_template_directory_uri() . '/assets/images/archive-2.webp',
					'label' => esc_html__( 'Archive Grid View', 'notomag' ),
				),
				'archive_style_3' => array(
					'url'   => get_template_directory_uri() . '/assets/images/archive-3.webp',
					'label' => esc_html__( 'Archive Alternate Grid View', 'notomag' ),
				),
			)
		);
		return $options;
	}
endif;

if ( ! function_exists( 'notomag_get_date_formats' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function notomag_get_date_formats() {
		$options = apply_filters(
			'notomag_archive_date_format',
			array(
				'classic'   => __( 'Classic', 'notomag' ),
				'time_ago' => __( 'Time Ago', 'notomag' ),
			)
		);
		return $options;
	}
endif;


if ( ! function_exists( 'notomag_line_limit_choices' ) ) :
	/**
	 * Returns title limit options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function notomag_line_limit_choices() {
		$options = apply_filters(
			'notomag_title_limit_options',
			array(
				''              => __( '&mdash; No Limit &mdash;', 'notomag' ),
				'limit-line-1' => __( '1 Line', 'notomag' ),
				'limit-line-2' => __( '2 Lines', 'notomag' ),
				'limit-line-3' => __( '3 Lines', 'notomag' ),
				'limit-line-4' => __( '4 Lines', 'notomag' ),
				'limit-line-5' => __( '5 Lines', 'notomag' ),
			)
		);
		return $options;
	}
endif;
if ( ! function_exists( 'notomag_archive_category_style' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function notomag_archive_category_style() {
		$options = apply_filters(
			'notomag_archive_category_style',
			array(
				'archive_cat_style_1'   => __( 'Category Style 1', 'notomag' ),
				'archive_cat_style_2'   => __( 'Category Style 2', 'notomag' ),
				'archive_cat_style_3'   => __( 'Category Style 3', 'notomag' ),

			)
		);
		return $options;
	}
endif;

if ( ! function_exists( 'notomag_archive_read_time_style' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function notomag_archive_read_time_style() {
		$options = apply_filters(
			'notomag_archive_read_time_style',
			array(
				'archive_read_time_style_1'   => __( 'Read Time Style 1', 'notomag' ),
				'archive_read_time_style_2'   => __( 'Read Time Style 2', 'notomag' ),
				'archive_read_time_style_3'   => __( 'Read Time Style 3', 'notomag' ),

			)
		);
		return $options;
	}
endif;


if ( ! function_exists( 'notomag_get_header_layout' ) ) :
	/**
	 * Returns header layout options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function notomag_get_header_layout() {
		$options = apply_filters(
			'notomag_get_header_layout',
			array(
				'header_style_1' => array(
					'url'   => get_template_directory_uri() . '/assets/images/header-1.webp',
					'label' => esc_html__( 'Header Style 1', 'notomag' ),
				),
				'header_style_2' => array(
					'url'   => get_template_directory_uri() . '/assets/images/header-2.webp',
					'label' => esc_html__( 'Header Style 2', 'notomag' ),
				),
        'header_style_3' => array(
            'url'   => get_template_directory_uri() . '/assets/images/header-3.webp',
            'label' => esc_html__( 'Header Style 3', 'notomag' ),
        ),
        'header_style_4' => array(
            'url'   => get_template_directory_uri() . '/assets/images/header-4.webp',
            'label' => esc_html__( 'Header Style 4', 'notomag' ),
        ),
			)
		);
		return $options;
	}
endif;

if ( ! function_exists( 'notomag_social_menu_style' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function notomag_social_menu_style() {
		$options = apply_filters(
			'notomag_social_menu_style',
			array(
				'has-brand-background'   => __( 'Has Brand Background', 'notomag' ),
				'has-brand-color'   => __( 'Has Brand Color', 'notomag' ),
				'none'   => __( 'None', 'notomag' ),

			)
		);
		return $options;
	}
endif;

if ( ! function_exists( 'notomag_pagination_style_choice' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function notomag_pagination_style_choice() {
		$options = apply_filters(
			'notomag_pagination_style_choice',
			array(
				'pagination_none'   => __( 'None', 'notomag' ),
				'pagination_numeric'   => __( 'Numeric', 'notomag' ),
				'pagination_default'   => __( 'Default(New/Old Post)', 'notomag' ),
				'pagination_ajax_on_scroll'   => __( 'Load More On Scroll', 'notomag' ),
				'pagination_ajax_on_click'   => __( 'Load More On Click', 'notomag' ),

			)
		);
		return $options;
	}
endif;

if ( ! function_exists( 'notomag_category_color' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function notomag_category_color() {
		$options = apply_filters(
			'notomag_category_color',
			array(
				'none'   => __( 'None', 'notomag' ),
				'has-background'   => __( 'Has background', 'notomag' ),
				'has-text-color'   => __( 'Has text color', 'notomag' ),

			)
		);
		return $options;
	}
endif;


if ( ! function_exists( 'notomag_get_footer_layouts' ) ) :
	/**
	 * Returns footer layout options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function notomag_get_footer_layouts() {
		$options = apply_filters(
			'notomag_footer_layouts',
			array(
				'footer_layout_1' => array(
					'url'   => get_template_directory_uri() . '/assets/images/footer-col-4.webp',
					'label' => esc_html__( 'Four Columns', 'notomag' ),
				),
				'footer_layout_2' => array(
					'url'   => get_template_directory_uri() . '/assets/images/footer-col-3.webp',
					'label' => esc_html__( 'Three Columns', 'notomag' ),
				),
				'footer_layout_3' => array(
					'url'   => get_template_directory_uri() . '/assets/images/footer-col-2.webp',
					'label' => esc_html__( 'Two Columns', 'notomag' ),
				),
				'footer_layout_4' => array(
					'url'   => get_template_directory_uri() . '/assets/images/footer-col-2-big-left.webp',
					'label' => esc_html__( 'Two Columns Big Left', 'notomag' ),
				),
				'footer_layout_5' => array(
					'url'   => get_template_directory_uri() . '/assets/images/footer-col-3-big-middle.webp',
					'label' => esc_html__( 'Three Columns Big Middle', 'notomag' ),
				),
				'footer_layout_6' => array(
					'url'   => get_template_directory_uri() . '/assets/images/footer-col-2-big-right.webp',
					'label' => esc_html__( 'Two Columns Big Right', 'notomag' ),
				),
				'footer_layout_7' => array(
					'url'   => get_template_directory_uri() . '/assets/images/footer-col-1.webp',
					'label' => esc_html__( 'Single Column', 'notomag' ),
				),
			)
		);
		return $options;
	}
endif;


if ( ! function_exists( 'notomag_preloader_style_option' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function notomag_preloader_style_option() {
		$options = apply_filters(
			'notomag_preloader_style_option',
			array(
				'style-1'   => __( 'Style - 1', 'notomag' ),
				'style-2'   => __( 'Style - 2', 'notomag' ),
				'style-3'   => __( 'Style - 3', 'notomag' ),
				'style-4'   => __( 'Style - 4', 'notomag' ),
				'style-5'   => __( 'Style - 5', 'notomag' ),
				'style-6'   => __( 'Style - 6', 'notomag' ),
				'style-7'   => __( 'Style - 7', 'notomag' ),
				'style-8'   => __( 'Style - 8', 'notomag' ),
				'style-9'   => __( 'Style - 9', 'notomag' ),
				'style-10'   => __( 'Style - 10', 'notomag' ),

			)
		);
		return $options;
	}
endif;


if ( ! function_exists( 'notomag_get_recommended_post' ) ) :
	/**
	 * Returns recommended layout options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function notomag_get_recommended_post() {
		$options = apply_filters(
			'notomag_get_recommended_post',
			array(
				'wpi-post-recommendation-1' => array(
					'url'   => get_template_directory_uri() . '/assets/images/recommended-1.webp',
					'label' => esc_html__( 'Recommended List View', 'notomag' ),
				),
				'wpi-post-recommendation-2' => array(
					'url'   => get_template_directory_uri() . '/assets/images/recommended-2.webp',
					'label' => esc_html__( 'Recommended Grid View', 'notomag' ),
				),
				'wpi-post-recommendation-3' => array(
					'url'   => get_template_directory_uri() . '/assets/images/recommended-3.webp',
					'label' => esc_html__( 'Recommended Alternate Grid View', 'notomag' ),
				),
			)
		);
		return $options;
	}
endif;



if ( ! function_exists( 'notomag_author_meta' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function notomag_author_meta() {
		$options = apply_filters(
			'notomag_author_meta',
			array(
				'with_label'   => __( 'With Label', 'notomag' ),
				'with_icon'   => __( 'With Icon', 'notomag' ),
				'with_avatar_image'   => __( 'With Avatar Image', 'notomag' ),

			)
		);
		return $options;
	}
endif;

if ( ! function_exists( 'notomag_date_meta' ) ) :
	/**
	 * Returns title Alignments
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function notomag_date_meta() {
		$options = apply_filters(
			'notomag_date_meta',
			array(
				'with_label'   => __( 'With Label', 'notomag' ),
				'with_icon'   => __( 'With Icon', 'notomag' ),

			)
		);
		return $options;
	}
endif;

if ( ! function_exists( 'notomag_get_sidebar_layouts' ) ) :
	/**
	 * Returns general layout options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function notomag_get_sidebar_layouts() {
		$options = apply_filters(
			'notomag_sidebar_layouts',
			array(
				'left-sidebar'      => array(
					'url'   => get_template_directory_uri() . '/assets/images/left-sidebar.webp',
					'label' => esc_html__( 'Left Sidebar', 'notomag' ),
				),
				'right-sidebar'     => array(
					'url'   => get_template_directory_uri() . '/assets/images/right-sidebar.webp',
					'label' => esc_html__( 'Right Sidebar', 'notomag' ),
				),
				'no-sidebar'        => array(
					'url'   => get_template_directory_uri() . '/assets/images/no-sidebar.webp',
					'label' => esc_html__( 'No Sidebar - Wide', 'notomag' ),
				),
			)
		);
		return $options;
	}
endif;


if ( ! function_exists( 'notomag_get_social_links_styles' ) ) :
	/**
	 * Returns social links styles options.
	 *
	 * @since 1.0.0
	 *
	 * @return array Options array.
	 */
	function notomag_get_social_links_styles() {
		$options = apply_filters(
			'notomag_social_links_styles',
			array(
				'style_1' => __( 'Style 1', 'notomag' ),
				'style_2' => __( 'Style 2', 'notomag' ),
				'style_3' => __( 'Style 3', 'notomag' ),
				'style_4' => __( 'Style 4', 'notomag' ),
			)
		);
		return $options;
	}
endif;
