<?php
/**
 * Medicare Clinic Theme Page
 *
 * @package Medicare Clinic
 */

function medicare_clinic_admin_scripts() {
	wp_dequeue_script('medicare-clinic-custom-scripts');
}
add_action( 'admin_enqueue_scripts', 'medicare_clinic_admin_scripts' );

if ( ! defined( 'MEDICARE_CLINIC_FREE_THEME_URL' ) ) {
	define( 'MEDICARE_CLINIC_FREE_THEME_URL', 'https://www.themespride.com/products/medicare-clinic' );
}
if ( ! defined( 'MEDICARE_CLINIC_PRO_THEME_URL' ) ) {
	define( 'MEDICARE_CLINIC_PRO_THEME_URL', 'https://www.themespride.com/products/clinic-wordpress-theme' );
}
if ( ! defined( 'MEDICARE_CLINIC_DEMO_THEME_URL' ) ) {
	define( 'MEDICARE_CLINIC_DEMO_THEME_URL', 'https://page.themespride.com/medicare-clinic/' );
}
if ( ! defined( 'MEDICARE_CLINIC_DOCS_THEME_URL' ) ) {
    define( 'MEDICARE_CLINIC_DOCS_THEME_URL', 'https://page.themespride.com/demo/docs/medicare-clinic-lite/' );
}
if ( ! defined( 'MEDICARE_CLINIC_RATE_THEME_URL' ) ) {
    define( 'MEDICARE_CLINIC_RATE_THEME_URL', 'https://wordpress.org/support/theme/medicare-clinic/reviews/#new-post' );
}
if ( ! defined( 'MEDICARE_CLINIC_CHANGELOG_THEME_URL' ) ) {
    define( 'MEDICARE_CLINIC_CHANGELOG_THEME_URL', get_template_directory() . '/readme.txt' );
}
if ( ! defined( 'MEDICARE_CLINIC_SUPPORT_THEME_URL' ) ) {
    define( 'MEDICARE_CLINIC_SUPPORT_THEME_URL', 'https://wordpress.org/support/theme/medicare-clinic/' );
}
if ( ! defined( 'MEDICARE_CLINIC_THEME_BUNDLE' ) ) {
    define( 'MEDICARE_CLINIC_THEME_BUNDLE', 'https://www.themespride.com/products/wordpress-theme-bundle' );
}
/**
 * Add theme page
 */
function medicare_clinic_menu() {
	add_theme_page( esc_html__( 'About Theme', 'medicare-clinic' ), esc_html__( 'Begin Installation - Import Demo', 'medicare-clinic' ), 'edit_theme_options', 'medicare-clinic-about', 'medicare_clinic_about_display' );
}
add_action( 'admin_menu', 'medicare_clinic_menu' );


/**
 * Display About page
 */
function medicare_clinic_about_display() {
	$medicare_clinic_theme = wp_get_theme();
	?>
	<div class="wrap about-wrap full-width-layout">
		<h1><?php echo esc_html( $medicare_clinic_theme ); ?></h1>
		<div class="about-theme">
			<div class="theme-description">
				<p class="about-text">
					<?php
					// Remove last sentence of description.
					$medicare_clinic_description = explode( '. ', $medicare_clinic_theme->get( 'Description' ) );

					array_pop( $medicare_clinic_description );

					$medicare_clinic_description = implode( '. ', $medicare_clinic_description );

					echo esc_html( $medicare_clinic_description . '.' );
				?></p>
				<p class="actions">
					<a target="_blank" href="<?php echo esc_url( MEDICARE_CLINIC_FREE_THEME_URL ); ?>" class="theme-info-btn" target="_blank"><?php esc_html_e( 'Theme Info', 'medicare-clinic' ); ?></a>

					<a target="_blank" href="<?php echo esc_url( MEDICARE_CLINIC_DEMO_THEME_URL ); ?>" class="view-demo" target="_blank"><?php esc_html_e( 'View Demo', 'medicare-clinic' ); ?></a>

					<a target="_blank" href="<?php echo esc_url( MEDICARE_CLINIC_DOCS_THEME_URL ); ?>" class="instruction-theme" target="_blank"><?php esc_html_e( 'Theme Instructions', 'medicare-clinic' ); ?></a>

					<a target="_blank" href="<?php echo esc_url( MEDICARE_CLINIC_RATE_THEME_URL ); ?>" class="rate-theme" target="_blank"><?php esc_html_e( 'Rate this theme', 'medicare-clinic' ); ?></a>

					<a target="_blank" href="<?php echo esc_url( MEDICARE_CLINIC_PRO_THEME_URL ); ?>" class="pro-btn-theme" target="_blank"><?php esc_html_e( 'Upgrade to pro', 'medicare-clinic' ); ?></a>
				</p>
			</div>

			<div class="theme-screenshot">
				<img src="<?php echo esc_url( $medicare_clinic_theme->get_screenshot() ); ?>" />
			</div>

		</div>

		<nav class="nav-tab-wrapper wp-clearfix" aria-label="<?php esc_attr_e( 'Secondary menu', 'medicare-clinic' ); ?>">

			<a href="<?php echo esc_url( admin_url( add_query_arg( array( 'page' => 'medicare-clinic-about' ), 'themes.php' ) ) ); ?>" class="nav-tab<?php echo ( isset( $_GET['page'] ) && 'medicare-clinic-about' === $_GET['page'] && ! isset( $_GET['tab'] ) ) ?' nav-tab-active' : ''; ?>"><?php esc_html_e( 'One Click Demo Import', 'medicare-clinic' ); ?></a>

			<a href="<?php echo esc_url( admin_url( add_query_arg( array( 'page' => 'medicare-clinic-about', 'tab' => 'about_theme' ), 'themes.php' ) ) ); ?>" class="nav-tab<?php echo ( isset( $_GET['tab'] ) && 'about_theme' === $_GET['tab'] ) ?' nav-tab-active' : ''; ?>"><?php esc_html_e( 'About', 'medicare-clinic' ); ?></a>

			<a href="<?php echo esc_url( admin_url( add_query_arg( array( 'page' => 'medicare-clinic-about', 'tab' => 'free_vs_pro' ), 'themes.php' ) ) ); ?>" class="nav-tab<?php echo ( isset( $_GET['tab'] ) && 'free_vs_pro' === $_GET['tab'] ) ?' nav-tab-active' : ''; ?>"><?php esc_html_e( 'Compare free Vs Pro', 'medicare-clinic' ); ?></a>

			<a href="<?php echo esc_url( admin_url( add_query_arg( array( 'page' => 'medicare-clinic-about', 'tab' => 'changelog' ), 'themes.php' ) ) ); ?>" class="nav-tab<?php echo ( isset( $_GET['tab'] ) && 'changelog' === $_GET['tab'] ) ?' nav-tab-active' : ''; ?>"><?php esc_html_e( 'Changelog', 'medicare-clinic' ); ?></a>

			<a href="<?php echo esc_url( admin_url( add_query_arg( array( 'page' => 'medicare-clinic-about', 'tab' => 'get_bundle' ), 'themes.php' ) ) ); ?>" class="blink wp-bundle nav-tab<?php echo ( isset( $_GET['tab'] ) && 'get_bundle' === $_GET['tab'] ) ?' nav-tab-active' : ''; ?>"><?php esc_html_e( 'Get WordPress Theme Bundle', 'medicare-clinic' ); ?></a>

		</nav>

		<?php
			medicare_clinic_demo_import();

			medicare_clinic_main_screen();

			medicare_clinic_changelog_screen();

			medicare_clinic_free_vs_pro();

			medicare_clinic_get_bundle();

		?>

		<div class="return-to-dashboard">
			<?php if ( current_user_can( 'update_core' ) && isset( $_GET['updated'] ) ) : ?>
				<a href="<?php echo esc_url( self_admin_url( 'update-core.php' ) ); ?>">
					<?php is_multisite() ? esc_html_e( 'Return to Updates', 'medicare-clinic' ) : esc_html_e( 'Return to Dashboard &rarr; Updates', 'medicare-clinic' ); ?>
				</a> |
			<?php endif; ?>
			<a href="<?php echo esc_url( self_admin_url() ); ?>"><?php is_blog_admin() ? esc_html_e( 'Go to Dashboard &rarr; Home', 'medicare-clinic' ) : esc_html_e( 'Go to Dashboard', 'medicare-clinic' ); ?></a>
		</div>
	</div>
	<?php
}


/**
 * Output the Demo Import screen.
 */

function medicare_clinic_demo_import() {
    if ( isset( $_GET['page'] ) && 'medicare-clinic-about' === $_GET['page'] && ! isset( $_GET['tab'] ) ) {

         // Path to whizzie.php in child theme
	    $child_whizzie_path = get_stylesheet_directory() . '/inc/whizzie.php';
	    
	    // Path to whizzie.php in parent theme
	    $parent_whizzie_path = get_template_directory() . '/inc/whizzie.php';

	    // Check if the child theme is active and if whizzie.php exists in the child theme
	    if ( file_exists( $child_whizzie_path ) ) {
	        require_once $child_whizzie_path;
	    } else {
	        // Fallback to parent theme if child theme does not have whizzie.php
	        require_once $parent_whizzie_path;
	    }

        if ( isset( $_GET['import-demo'] ) && $_GET['import-demo'] == true ) { ?>
            <div class="col card success-demo" style="text-align: center;">
                <p class="imp-success"><?php echo esc_html__('Imported Successfully', 'medicare-clinic'); ?></p><br>
                <a class="button" href="<?php echo esc_url(home_url('/')); ?>" target="_blank">
                    <?php echo esc_html__('View Site', 'medicare-clinic'); ?>
                </a>
            </div>

            <!-- Modal Popup -->
            <div id="demo-success-modal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 9999;">
                <div style="background: #fff; padding: 30px; max-width: 400px; margin: 15% auto; text-align: center; border-radius: 8px;">
                    <h2 style="margin-bottom: 15px;"><?php echo esc_html__('Demo import completed successfully. You can now customize your website or view the imported content.', 'medicare-clinic'); ?></h2>
                    <button onclick="document.getElementById('demo-success-modal').style.display='none'">
                       <a class="view-demo-btn" href="<?php echo esc_url(home_url('/')); ?>" target="_blank">
                    		<?php echo esc_html__('View Site', 'medicare-clinic'); ?>
                	</a>
                    </button>
                </div>
            </div>

            <script type="text/javascript">
                window.onload = function () {
                    // Show the popup modal after load
                    document.getElementById('demo-success-modal').style.display = 'block';
                };
            </script>
        <?php } else { ?>
            <div class="col card demo-btn text-center">
                <form id="demo-importer-form" action="<?php echo esc_url(home_url()); ?>/wp-admin/themes.php" method="POST">
                    <p class="demo-title"><?php echo esc_html__('Demo Importer', 'medicare-clinic'); ?></p>
                    <p class="demo-des"><?php echo esc_html__('This theme supports importing demo content with a single click. Use the button below to quickly set up your site. You can easily customize or deactivate the imported content later through the Customizer.', 'medicare-clinic'); ?></p>
                    <i class="fas fa-long-arrow-alt-down"></i>

                    <button type="submit" class="button with-icon" id="begin-install-btn">
                        <?php echo esc_html__('Begin Installation - Import Demo', 'medicare-clinic'); ?>
                    </button>

                    <!-- Loader area shown in page content -->
                    <div id="page-loader" style="display:none; margin-top: 20px; text-align: center;">
                        <img src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/loader.png" alt="Loading..." width="40" height="40" />
                        <p style="margin-top:10px;"><?php echo esc_html__('Importing demo, please wait...', 'medicare-clinic'); ?></p>
                    </div>
                </form>
            </div>

            <script type="text/javascript">
                jQuery(document).ready(function($) {
                    $('#demo-importer-form').on('submit', function(e) {
                        e.preventDefault();

                        if (confirm("Are you sure you want to proceed with the demo import?")) {
                            $('#page-loader').show(); // Show loader
                            
                            // Redirect to same page with import-demo param
                            var url = new URL(window.location.href);
                            url.searchParams.append('import-demo', 'true');
                            window.location.href = url;
                        } else {
                            return false;
                        }
                    });
                });
            </script>
        <?php }
    }
}

/**
 * Output the main about screen.
 */
function medicare_clinic_main_screen() {
	if ( isset( $_GET['tab'] ) && 'about_theme' === $_GET['tab'] ) {
	?>
		<div class="feature-section two-col">
			<div class="col card">
				<h2 class="title"><?php esc_html_e( 'Theme Customizer', 'medicare-clinic' ); ?></h2>
				<p><?php esc_html_e( 'All Theme Options are available via Customize screen.', 'medicare-clinic' ) ?></p>
				<p><a target="_blank" href="<?php echo esc_url( admin_url( 'customize.php' ) ); ?>" class="button button-primary"><?php esc_html_e( 'Customize', 'medicare-clinic' ); ?></a></p>
			</div>

			<div class="col card">
				<h2 class="title"><?php esc_html_e( 'Got theme support question?', 'medicare-clinic' ); ?></h2>
				<p><?php esc_html_e( 'Get genuine support from genuine people. Whether it\'s customization or compatibility, our seasoned developers deliver tailored solutions to your queries.', 'medicare-clinic' ) ?></p>
				<p><a target="_blank" href="<?php echo esc_url( MEDICARE_CLINIC_SUPPORT_THEME_URL ); ?>" class="button button-primary"><?php esc_html_e( 'Support Forum', 'medicare-clinic' ); ?></a></p>
			</div>

			<div class="col card">
				<h2 class="title"><?php esc_html_e( 'Upgrade To Premium With Straight 20% OFF.', 'medicare-clinic' ); ?></h2>
				<p><?php esc_html_e( 'Get our amazing WordPress theme with exclusive 20% off use the coupon', 'medicare-clinic' ) ?>"<input type="text" value="GETPro20" id="myInput">".</p>
				<button class="button button-primary"><?php esc_html_e( 'GETPro20', 'medicare-clinic' ); ?></button>
			</div>
		</div>
	<?php
	}
}

/**
 * Output the changelog screen.
 */
function medicare_clinic_changelog_screen() {
	if ( isset( $_GET['tab'] ) && 'changelog' === $_GET['tab'] ) {
		global $wp_filesystem;
	?>
		<div class="wrap about-wrap">

			<p class="about-description"><?php esc_html_e( 'View changelog below:', 'medicare-clinic' ); ?></p>

			<?php
				$changelog_file = apply_filters( 'medicare_clinic_changelog_file', MEDICARE_CLINIC_CHANGELOG_THEME_URL );
				// Check if the changelog file exists and is readable.
				if ( $changelog_file && is_readable( $changelog_file ) ) {
					WP_Filesystem();
					$changelog = $wp_filesystem->get_contents( $changelog_file );
					$changelog_list = medicare_clinic_parse_changelog( $changelog );

					echo wp_kses_post( $changelog_list );
				}
			?>
		</div>
	<?php
	}
}

/**
 * Parse changelog from readme file.
 * @param  string $content
 * @return string
 */
function medicare_clinic_parse_changelog( $content ) {
	// Explode content with ==  to juse separate main content to array of headings.
	$content = explode ( '== ', $content );

	$changelog_isolated = '';

	// Get element with 'Changelog ==' as starting string, i.e isolate changelog.
	foreach ( $content as $key => $value ) {
		if (strpos( $value, 'Changelog ==') === 0) {
	    	$changelog_isolated = str_replace( 'Changelog ==', '', $value );
	    }
	}

	// Now Explode $changelog_isolated to manupulate it to add html elements.
	$changelog_array = explode( '= ', $changelog_isolated );

	// Unset first element as it is empty.
	unset( $changelog_array[0] );

	$changelog = '<pre class="changelog">';

	foreach ( $changelog_array as $value) {
		// Replace all enter (\n) elements with </span><span> , opening and closing span will be added in next process.
		$value = preg_replace( '/\n+/', '</span><span>', $value );

		// Add openinf and closing div and span, only first span element will have heading class.
		$value = '<div class="block"><span class="heading">= ' . $value . '</span></div>';

		// Remove empty <span></span> element which newr formed at the end.
		$changelog .= str_replace( '<span></span>', '', $value );
	}

	$changelog .= '</pre>';

	return wp_kses_post( $changelog );
}

/**
 * Import Demo data for theme using catch themes demo import plugin
 */
function medicare_clinic_free_vs_pro() {
	if ( isset( $_GET['tab'] ) && 'free_vs_pro' === $_GET['tab'] ) {
	?>
		<div class="wrap about-wrap">

			<p class="about-description"><?php esc_html_e( 'View Free vs Pro Table below:', 'medicare-clinic' ); ?></p>
			<div class="vs-theme-table">
				<table>
					<thead>
						<tr><th scope="col"></th>
							<th class="head" scope="col"><?php esc_html_e( 'Free Theme', 'medicare-clinic' ); ?></th>
							<th class="head" scope="col"><?php esc_html_e( 'Pro Theme', 'medicare-clinic' ); ?></th>
						</tr>
					</thead>
					<tbody>
						<tr class="odd" scope="row">
							<td headers="features" class="feature"><span><?php esc_html_e( 'Theme Demo Set Up', 'medicare-clinic' ); ?></span></td>
							<td><span class="dashicons dashicons-no-alt"></span></td>
							<td><span class="dashicons dashicons-saved"></span></td>
						</tr>
						<tr class="odd" scope="row">
							<td headers="features" class="feature"><?php esc_html_e( 'Additional Templates, Color options and Fonts', 'medicare-clinic' ); ?></td>
							<td><span class="dashicons dashicons-no-alt"></span></td>
							<td><span class="dashicons dashicons-saved"></span></td>
						</tr>
						<tr class="odd" scope="row">
							<td headers="features" class="feature"><?php esc_html_e( 'Included Demo Content', 'medicare-clinic' ); ?></td>
							<td><span class="dashicons dashicons-no-alt"></span></td>
							<td><span class="dashicons dashicons-saved"></span></td>
						</tr>
						<tr class="odd" scope="row">
							<td headers="features" class="feature"><?php esc_html_e( 'Section Ordering', 'medicare-clinic' ); ?></td>
							<td><span class="dashicons dashicons-no-alt"></span></td>
							<td><span class="dashicons dashicons-saved"></span></td>
						</tr>
						<tr class="odd" scope="row">
							<td headers="features" class="feature"><?php esc_html_e( 'Multiple Sections', 'medicare-clinic' ); ?></td>
							<td><span class="dashicons dashicons-no-alt"></span></td>
							<td><span class="dashicons dashicons-saved"></span></td>
						</tr>
						<tr class="odd" scope="row">
							<td headers="features" class="feature"><?php esc_html_e( 'Additional Plugins', 'medicare-clinic' ); ?></td>
							<td><span class="dashicons dashicons-no-alt"></span></td>
							<td><span class="dashicons dashicons-saved"></span></td>
						</tr>
						<tr class="odd" scope="row">
							<td headers="features" class="feature"><?php esc_html_e( 'Premium Technical Support', 'medicare-clinic' ); ?></td>
							<td><span class="dashicons dashicons-no-alt"></span></td>
							<td><span class="dashicons dashicons-saved"></span></td>
						</tr>
						<tr class="odd" scope="row">
							<td headers="features" class="feature"><?php esc_html_e( 'Access to Support Forums', 'medicare-clinic' ); ?></td>
							<td><span class="dashicons dashicons-no-alt"></span></td>
							<td><span class="dashicons dashicons-saved"></span></td>
						</tr>
						<tr class="odd" scope="row">
							<td headers="features" class="feature"><?php esc_html_e( 'Free updates', 'medicare-clinic' ); ?></td>
							<td><span class="dashicons dashicons-no-alt"></span></td>
							<td><span class="dashicons dashicons-saved"></span></td>
						</tr>
						<tr class="odd" scope="row">
							<td headers="features" class="feature"><?php esc_html_e( 'Unlimited Domains', 'medicare-clinic' ); ?></td>
							<td><span class="dashicons dashicons-saved"></span></td>
							<td><span class="dashicons dashicons-saved"></span></td>
						</tr>
						<tr class="odd" scope="row">
							<td headers="features" class="feature"><?php esc_html_e( 'Responsive Design', 'medicare-clinic' ); ?></td>
							<td><span class="dashicons dashicons-saved"></span></td>
							<td><span class="dashicons dashicons-saved"></span></td>
						</tr>
						<tr class="odd" scope="row">
							<td headers="features" class="feature"><?php esc_html_e( 'Live Customizer', 'medicare-clinic' ); ?></td>
							<td><span class="dashicons dashicons-saved"></span></td>
							<td><span class="dashicons dashicons-saved"></span></td>
						</tr>
						<tr class="odd" scope="row">
							<td class="feature feature--empty"></td>
							<td class="feature feature--empty"></td>
							<td headers="comp-2" class="td-btn-2"><a class="sidebar-button single-btn" href="<?php echo esc_url(MEDICARE_CLINIC_PRO_THEME_URL);?>" target="_blank"><?php esc_html_e( 'Go For Premium', 'medicare-clinic' ); ?></a></td>
						</tr>
					</tbody>
				</table>
			</div>
		</div>
	<?php
	}
}

function medicare_clinic_get_bundle() {
	if ( isset( $_GET['tab'] ) && 'get_bundle' === $_GET['tab'] ) {
	?>
		<div class="wrap about-wrap">

			<p class="about-description"><?php esc_html_e( 'Get WordPress Theme Bundle', 'medicare-clinic' ); ?></p>
			<div class="col card">
				<h2 class="title"><?php esc_html_e( ' WordPress Theme Bundle of 100+ Themes At 15% Discount. ', 'medicare-clinic' ); ?></h2>
				<p><?php esc_html_e( 'Spring Offer Is To Get WP Bundle of 100+ Themes At 15% Discount use the coupon', 'medicare-clinic' ) ?>"<input type="text" value=" TPRIDE15 "  id="myInput">".</p>
				<p><a target="_blank" href="<?php echo esc_url( MEDICARE_CLINIC_THEME_BUNDLE ); ?>" class="button button-primary"><?php esc_html_e( 'Theme Bundle', 'medicare-clinic' ); ?></a></p>
			</div>
		</div>
	<?php
	}
}