<?php
/**
 * Describe child theme functions
 *
 * @package Matina Blogmentor
 */

if ( ! defined( 'matina_blogmentor_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	$matina_blogmentor_theme_info = wp_get_theme();
	define( 'matina_blogmentor_VERSION', $matina_blogmentor_theme_info->get( 'Version' ) );
}

/*-------------------------------------------------------------------------------------------------------------------------------*/
/**
 * Managed the theme customizer
 */
if ( ! function_exists( 'matina_blogmentor_customize_register' ) ) :

    function matina_blogmentor_customize_register( $wp_customize ) {

        global $wp_customize;

        /**
         * Matina Blogmentor Default Primary Color.
         *
         * @since 1.0.0
         */
        $wp_customize->get_setting( 'matina_primary_theme_color' )->default = '#9e0477';
        $wp_customize->get_setting( 'matina_top_header_bg_color' )->default = '#9e0477';
        $wp_customize->get_setting( 'matina_footer_background_color' )->default = '#9e0477';
        $wp_customize->get_setting( 'matina_footer_text_color' )->default = '#fff';
        $wp_customize->get_setting( 'h1_font_family' )->default = 'Be Vietnam Pro';
        $wp_customize->get_setting( 'h2_font_family' )->default = 'Be Vietnam Pro';
        $wp_customize->get_setting( 'h3_font_family' )->default = 'Be Vietnam Pro';
        $wp_customize->get_setting( 'h4_font_family' )->default = 'Be Vietnam Pro';
    }

endif;

add_action( 'customize_register', 'matina_blogmentor_customize_register', 20 );

/*-------------------------------------------------------------------------------------------------------------------------------*/
/**
 * Enqueue child theme styles and scripts
 */
add_action( 'wp_enqueue_scripts', 'matina_blogmentor_scripts', 99 );

function matina_blogmentor_scripts() {

    wp_enqueue_style( 'matina-blogmentor-google-fonts', matina_blogmentor_enqueue_google_fonts(), array(), null );

    wp_dequeue_style( 'matina-style' );

    wp_dequeue_style( 'matina-responsive-style' );

    wp_enqueue_style( 'matina-parent-style', get_template_directory_uri() . '/style.css', array(), matina_blogmentor_VERSION );

    wp_enqueue_style( 'matina-parent-responsive', get_template_directory_uri() . '/assets/css/mt-responsive.css', array(), matina_blogmentor_VERSION );
    
    wp_enqueue_style( 'matina-blogmentor-responsive', get_stylesheet_directory_uri() . '/assets/css/mtb-responsive.css', array(), matina_blogmentor_VERSION );

    wp_enqueue_style( 'matina-blogmentor-style', get_stylesheet_uri(), array(), matina_blogmentor_VERSION );
    
    
}

/*-----------------------------------------------------------------------------*/

if ( ! function_exists( 'matina_blogmentor_general_css' ) ) :

    /**
     * function to handle the general css of all sections.
     *
     * @since 1.0.0
     */
    function matina_blogmentor_general_css( $output_css ) {

        $matina_blogmentor_primary_theme_color = get_theme_mod( 'matina_primary_theme_color', '#9e0477' );
        $matina_blogmentor_header_background_color = get_theme_mod( 'matina_top_header_bg_color', '#9e0477' );
        $matina_blogmentor_footer_background_color  = get_theme_mod( 'matina_footer_background_color', '#9e0477' );
        $matina_blogmentor_footer_text_color  = get_theme_mod( 'matina_footer_text_color', '#fff' );

        //define variable for custom css
        $custom_css = '';

        $custom_css .= "#banner-section.banner-layout-default .lSAction>.lSNext:hover,#site-navigation #primary-menu li .sub-menu li:hover>a, #site-navigation #primary-menu li .children li:hover>a,.search--at-footer .search-form-wrap .search-form .search-submit:hover,.banner-layout-one .banner-button,#featured-section .post-title a:hover,.featured-categories--layout-default.featuredCarousel .featured-carousel-control .featuredCarousel-controls:hover,.featured-categories--layout-one.featuredCarousel .featured-carousel-control .featuredCarousel-controls:hover,.archive article .cat-links,.archive article .cat-links a,.archive--layout-default .post .cat-links,.archive--layout-default article .cat-links a,.archive article .entry-title a:hover,.archive--layout-default article .entry-title a:hover,.archive--layout-one article .entry-title a:hover,.archive--layout-default article .entry-readmore a:hover,.archive--layout-one article .cat-links a,.archive--layout-one .entry-readmore .mt-button:hover,.single--layout-one article .cat-links a,.single--layout-one .entry-tags .tags-links a:hover,.entry-author-box .post-author-info .author-name a:hover,.single-post-navigation .nav-links a span.title,.single-post-navigation .nav-links a:hover span.post-title:hover,.related-posts--layout-default .related-post .post-content-wrapper .related-post-title a:hover,.related-posts--layout-one .related-post .post-content-wrapper .related-post-title a:hover,.widget-area ul li a:hover,.widget-area .tagcloud a:hover,#masthead .matina-social-icons-wrapper .single-icon a:hover,.widget.matina_latest_posts .posts-wrapper .single-post-wrap .post-content-wrap .post-title a:hover,.widget-area .widget_categories ul li.cat-item:before,.widget-area ul li:hover >a,.widget-area ul li:hover:before, .navigation .nav-links a.page-numbers:hover,.posts-navigation .nav-links a:hover,#banner-section .banner-title a:hover,.banner-layout-one .lSAction a:hover i, .featured-categories--layout-default .cat-links a, .matina_author_info .matina-social-icons-wrapper .single-icon:hover a, #masthead.has-header-media #site-navigation #primary-menu li a:hover, .cv-block-grid--layout-one .cv-read-more a, .cv-post-title a:hover,.cv-block-list--layout-one .cv-read-more  a:hover,.cv-block-list--layout-one .cv-post-cat a, .default-page-header .breadcrumbs ul li:after, .mt-page-header .breadcrumbs ul li a:hover, .mt-page-header .breadcrumbs ul li:after, .mt-page-header .woocommerce-breadcrumbs .woocommerce-breadcrumbs-wrapper a:hover, .woocommerce ul.products li.product .button.add_to_cart_button,.woocommerce ul.products li.product .button.product_type_grouped,.woocommerce ul.products li.product .button.product_type_external, ul.products li.product .woocommerce-loop-product__title:hover, .woocommerce nav.woocommerce-pagination ul li a:hover, .woocommerce .woocommerce-info a,.woocommerce-info::before, .search .entry-title a:hover,.search .entry-readmore a:hover,.search article .cat-links a, .featured-categories--layout-default .cat-links,.footer-bottom-wrapper .site-info a, #site-navigation #primary-menu li .children li:hover>a, .site-branding .site-title a:hover, #site-navigation ul li:hover > a,#site-navigation ul li.current-menu-item > a,#site-navigation ul li.current-menu-ancestor > a,#site-navigation ul li.current_page_ancestor > a,#site-navigation ul li.current_page_item > a,#site-navigation ul li.current-post-parent > a,#site-navigation ul li.focus>a,a, .archive--layout-two article .entry-readmore a:hover,.wp-block-heading, .widget-area .widget-title,.header-search-wrapper .search-icon:hover a,#mt-topbar .matina-social-icons-wrapper .single-icon a:hover, .archive--layout-two article .entry-title a:hover,.entry-author-box .author-meta-wrap .author-website a, .cv-read-more a:hover
        { color: ". esc_attr( $matina_blogmentor_primary_theme_color ) ."}\n";

        // Background theme color
        $custom_css .= ".archive--layout-two article .entry-readmore a,.archive--layout-two .mt-archive-posts-wrapper article .cat-links a,.archive--layout-two article .post-info-wrapper .cat-links a,.wp-block-heading::before, .widget-area .widget-title::before,.header-search-wrapper .search-icon,#matina-scroll-to-top:hover, .mt-wave .mt-rect, .wp-block-search__button, .edit-link a , .comments-area .comment-respond .comment-form p.form-submit .submit, .single--layout-default article .cat-links a,.widget-area .search-form .search-submit,.archive--layout-default article .entry-readmore a::after,.search--drop-down .search-form-wrap .search-close:hover, .search--drop-down .search-form .search-submit:hover, .cv-post-thumb .cv-post-date a, .cv-post-cats-wrap a, .cv-block-grid--layout-two .cv-post-cat a, .cv-block-list--layout-three .cv-post-cat a{ background-color: ". esc_attr( $matina_blogmentor_primary_theme_color ) ."}\n";

        // Border theme color
        $custom_css .= ".archive--layout-default article .entry-readmore a ,.posts-navigation .nav-links a { border-color: ". esc_attr( $matina_blogmentor_primary_theme_color ) ."}\n";

        // Border left color
        $custom_css .= "#site-navigation #primary-menu li .sub-menu li:hover, #site-navigation #primary-menu li .children li:hover, #site-navigation #primary-menu li .sub-menu li.focus, #site-navigation #primary-menu li .children li.focus, .entry-author-box.author-box--layout-one, #site-navigation #primary-menu li .children li:hover { border-left-color: ". esc_attr( $matina_blogmentor_primary_theme_color ) ."}\n";

        // Border right color
        $custom_css .= "#site-navigation #primary-menu li .sub-menu li:hover { border-right-color: ". esc_attr( $matina_blogmentor_primary_theme_color ) ."}\n";

        // header color
        $custom_css .= " #mt-topbar .matina-social-icons-wrapper .single-icon a:hover { border-color: ". esc_attr( $matina_blogmentor_header_background_color) ."}\n";

        // Footer color
        $custom_css .= " #colophon, .footer--layout-default .footer-bottom-wrapper{ background-color: ". esc_attr( $matina_blogmentor_footer_background_color ) ."}\n";

        // Footer text color
        $custom_css .= "#colophon .widget-area ul li a, #colophon .widget-area ul li, #colophon .widget-area .tagcloud a, #colophon .widget.matina_latest_posts .posts-wrapper .single-post-wrap .post-content-wrap .post-title a, #colophon .widget-area .widget_categories ul li.cat-item::before, #colophon #footer-menu li a, .footer-social-icons .matina-social-icons-wrapper .single-icon a, #colophon #bottom-area .site-info{ color: ". esc_attr( $matina_blogmentor_footer_text_color ) ."}\n";

        if ( ! empty( $custom_css ) ) {
            $output_css .= $custom_css;
        }

        return $output_css;

    }

endif;

add_filter( 'matina_head_css', 'matina_blogmentor_general_css', 999 );

add_filter( 'matina_archive_layout_choices', 'matina_blogmentor_archive_layout_choices' );

function matina_blogmentor_archive_layout_choices( $archive_layouts ) {

    $archive_layouts = array(
        'layout-default'    => array(
            'title'     => __( 'Layout Default', 'matina-blogmentor' ),
            'src'       => get_template_directory_uri() . '/inc/customizer/assets/images/archive-layout-default.png'
        ),
        'layout-one'  => array(
            'title'     => __( 'Layout One', 'matina-blogmentor' ),
            'src'       => get_template_directory_uri() . '/inc/customizer/assets/images/archive-layout-one.png'
        ),
        'layout-two'  => array(
            'title'     => __( 'Layout Two', 'matina-blogmentor' ),
            'src'       => get_stylesheet_directory_uri() . '/assets/images/archive-layout-two.png'
        )
    );

    return $archive_layouts;

}

/*----------------------------------------------------------------*/

if ( ! function_exists( 'matina_blogmentor_typography_css' ) ) :

    /**
     * function to handle the typography css.
     *
     * @since 1.0.2
     */
    function matina_blogmentor_typography_css( $output_css ) {

        $custom_css = '';

        /**
         * H1 typography
         */
        $h1_font_family          = get_theme_mod( 'h1_font_family', 'Be Vietnam Pro' );
        $h1_font_style           = get_theme_mod( 'h1_font_style', '600' );
        $h1_text_transform       = get_theme_mod( 'h1_text_transform', 'none' );

        if ( ! empty( $h1_font_style ) ) {
            $h1_font_style_weight = preg_split( '/(?<=[0-9])(?=[a-z]+)/i', $h1_font_style );
            if ( isset( $h1_font_style_weight[1] ) ) {
                $h1_font_style = $h1_font_style_weight[1];
            } else {
                $h1_font_style = 'normal';
            }

            if ( isset( $h1_font_style_weight[0] ) ) {
                $h1_font_weight = $h1_font_style_weight[0];
            } else {
                $h1_font_weight = 400;
            }
        }

        $custom_css .= "h1, single .entry-title,.site-branding .site-title a {
            font-family:        $h1_font_family;
            font-style:         $h1_font_style;
            font-weight:        $h1_font_weight;
            text-transform:     $h1_text_transform;
        }\n";

        /**
         * H2 typography
         */
        $h2_font_family          = get_theme_mod( 'h2_font_family', 'Be Vietnam Pro' );
        $h2_font_style           = get_theme_mod( 'h2_font_style', '700' );
        $h2_text_transform       = get_theme_mod( 'h2_text_transform', 'none' );

        if ( ! empty( $h2_font_style ) ) {
            $h2_font_style_weight = preg_split( '/(?<=[0-9])(?=[a-z]+)/i', $h2_font_style );
            if ( isset( $h2_font_style_weight[1] ) ) {
                $h2_font_style = $h2_font_style_weight[1];
            } else {
                $h2_font_style = 'normal';
            }

            if ( isset( $h2_font_style_weight[0] ) ) {
                $h2_font_weight = $h2_font_style_weight[0];
            } else {
                $h2_font_weight = 500;
            }
        }

        $custom_css .= "h2,.search .entry-title a {
            font-family:        $h2_font_family;
            font-style:         $h2_font_style;
            font-weight:        $h2_font_weight;
            text-transform:     $h2_text_transform;
        }\n";

        /**
         * H3 typography
         */
        $h3_font_family          = get_theme_mod( 'h3_font_family', 'Be Vietnam Pro' );
        $h3_font_style           = get_theme_mod( 'h3_font_style', '700' );
        $h3_text_transform       = get_theme_mod( 'h3_text_transform', 'none' );

        if ( ! empty( $h3_font_style ) ) {
            $h3_font_style_weight = preg_split( '/(?<=[0-9])(?=[a-z]+)/i', $h3_font_style );
            if ( isset( $h3_font_style_weight[1] ) ) {
                $h3_font_style = $h3_font_style_weight[1];
            } else {
                $h3_font_style = 'normal';
            }

            if ( isset( $h3_font_style_weight[0] ) ) {
                $h3_font_weight = $h3_font_style_weight[0];
            } else {
                $h3_font_weight = 700;
            }
        }

        $custom_css .= "h3 {
            font-family:        $h3_font_family;
            font-style:         $h3_font_style;
            font-weight:        $h3_font_weight;
            text-transform:     $h3_text_transform;
        }\n";

        /**
         * H4 typography
         */
        $h4_font_family          = get_theme_mod( 'h4_font_family', 'Be Vietnam Pro' );
        $h4_font_style           = get_theme_mod( 'h4_font_style', '700' );
        $h4_text_transform       = get_theme_mod( 'h4_text_transform', 'none' );

        if ( ! empty( $h4_font_style ) ) {
            $h4_font_style_weight = preg_split( '/(?<=[0-9])(?=[a-z]+)/i', $h4_font_style );
            if ( isset( $h4_font_style_weight[1] ) ) {
                $h4_font_style = $h4_font_style_weight[1];
            } else {
                $h4_font_style = 'normal';
            }

            if ( isset( $h4_font_style_weight[0] ) ) {
                $h4_font_weight = $h4_font_style_weight[0];
            } else {
                $h4_font_weight = 500;
            }
        }

        $custom_css .= "h4 {
            font-family:        $h4_font_family;
            font-style:         $h4_font_style;
            font-weight:        $h4_font_weight;
            text-transform:     $h4_text_transform;
        }\n";

        if ( ! empty( $custom_css ) ) {
            $output_css .= '/*/ Matina Blogmentor Typography CSS /*/'. $custom_css;
        }

        return $output_css;
    }

endif;

add_filter( 'matina_head_css', 'matina_blogmentor_typography_css', 999 );

if ( ! function_exists( 'matina_blogmentor_enqueue_google_fonts' ) ) :

    /**
     * Load google fonts from typography sections.
     *
     * @since 1.0.3
     */
    function matina_blogmentor_enqueue_google_fonts() {

        $h1_font_family = get_theme_mod( 'h1_font_family', 'Be Vietnam Pro' );
        $h1_font_style = get_theme_mod( 'h1_font_style', '700' );
        $h1_typo = $h1_font_family.":".$h1_font_style;

        $h2_font_family = get_theme_mod( 'h2_font_family', 'Be Vietnam Pro' );
        $h2_font_style = get_theme_mod( 'h2_font_style', '700' );
        $h2_typo = $h2_font_family.":".$h2_font_style;

        $h3_font_family = get_theme_mod( 'h3_font_family', 'Be Vietnam Pro' );
        $h3_font_style = get_theme_mod( 'h3_font_style', '700' );
        $h3_typo = $h3_font_family.":".$h3_font_style;

        $h4_font_family = get_theme_mod( 'h4_font_family', 'Be Vietnam Pro' );
        $h4_font_style = get_theme_mod( 'h4_font_style', '700' );
        $h4_typo = $h4_font_family.":".$h4_font_style;

        $get_fonts = array( $h1_typo, $h2_typo, $h3_typo, $h4_typo );

        $font_weight_array = array();

        foreach ( $get_fonts as $fonts ) {
            $each_font = explode( ':', $fonts );
            if ( ! isset ( $font_weight_array[$each_font[0]] ) ) {
                $font_weight_array[$each_font[0]][] = $each_font[1];
            } else {
                if ( ! in_array( $each_font[1], $font_weight_array[$each_font[0]] ) ) {
                    $font_weight_array[$each_font[0]][] = $each_font[1];
                }
            }
        }

        $final_font_array = array();

        foreach ( $font_weight_array as $font => $font_weight ) {
            $each_font_string = $font.':'.implode( ',', $font_weight );
            $final_font_array[] = $each_font_string;
        }

        $final_font_string = implode( '|', $final_font_array );

        $google_fonts_url = '';

        if ( $final_font_string ) {
            $query_args = array(
                'family' => urlencode( $final_font_string ),
                'subset' => urlencode( 'latin,cyrillic-ext,greek-ext,greek,vietnamese,latin-ext,cyrillic,khmer,devanagari,arabic,hebrew,telugu' )
            );

            $google_fonts_url = add_query_arg( $query_args, 'https://fonts.googleapis.com/css' );
        }

        return $google_fonts_url;
    }

endif;
