<?php
/**
 * Template part for displaying the services section
 *
 * @package Manufacturing Hub
 * @subpackage manufacturing_hub
 */
?>

<?php if (get_theme_mod('manufacturing_hub_show_hide_sec', true)) : ?>
  <section id="service-sec" class="py-5 px-md-0 px-3">
    <div class="container">
      <div class="text-center">
        <div class="row">
          <div class="col-lg-8 col-md-8 align-self-center">
            <?php
            $manufacturing_hub_featured_title = get_theme_mod('manufacturing_hub_featured_section_title', '');

            if (!empty($manufacturing_hub_featured_title)) :
                $manufacturing_hub_words = explode(' ', $manufacturing_hub_featured_title);
                $manufacturing_hub_first_two = array_slice($manufacturing_hub_words, 0, 2);
                $manufacturing_hub_rest = array_slice($manufacturing_hub_words, 2);

                $manufacturing_hub_first_two_text = implode(' ', $manufacturing_hub_first_two);
                $manufacturing_hub_rest_text = implode(' ', $manufacturing_hub_rest);
                ?>
                <h2 class="text-capitalize mb-4">
                  <span class="featured-title-light pe-2"><?php echo esc_html($manufacturing_hub_first_two_text); ?></span> <span class="featured-title-bold"><?php echo esc_html($manufacturing_hub_rest_text); ?></span>
                </h2>
            <?php endif; ?>
          </div>
          <div class="col-lg-4 col-md-4 align-self-center">
            <div class="main-view-btn">
              <?php
              // "View All" button
              $manufacturing_hub_product_btn_text = get_theme_mod( 'manufacturing_hub_product_section_btn_text1', __( 'View All', 'manufacturing-hub' ) );
              $manufacturing_hub_product_btn_link = get_theme_mod( 'manufacturing_hub_product_section_btn_link1' );

              if ( ! empty( $manufacturing_hub_product_btn_text ) && ! empty( $manufacturing_hub_product_btn_link ) ) : ?>
                <a class="viewall-btn mb-3" href="<?php echo esc_url( $manufacturing_hub_product_btn_link ); ?>">
                  <?php echo esc_html( $manufacturing_hub_product_btn_text ); ?>
                  <span class="screen-reader-text"><?php echo esc_html( $manufacturing_hub_product_btn_text ); ?></span>
                </a>
              <?php endif; ?>
            </div>
          </div>
        </div>
      </div>
      <div class="services-carousel owl-carousel">
        <?php
        $manufacturing_hub_post_category = get_theme_mod('manufacturing_hub_featured_section_category', '');
        $manufacturing_hub_num_posts = absint(get_theme_mod('manufacturing_hub_num_posts', 3));

        if (!empty($manufacturing_hub_post_category)) :
          $manufacturing_hub_page_query = new WP_Query(array(
            'category_name'  => sanitize_text_field($manufacturing_hub_post_category),
            'posts_per_page' => $manufacturing_hub_num_posts,
          ));

          if ($manufacturing_hub_page_query->have_posts()) :
            while ($manufacturing_hub_page_query->have_posts()) : $manufacturing_hub_page_query->the_post(); ?>
              <div class="item">
                <div class="cat-inner-box">
                  <?php if (has_post_thumbnail()) : ?>
                    <img src="<?php echo esc_url(get_the_post_thumbnail_url(null, 'full')); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" />
                  <?php else : ?>
                    <img src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/serv-img1.jpg'); ?>" alt="<?php echo esc_attr(get_the_title()); ?>" />
                  <?php endif; ?>
                  <div class="inner-content px-3 py-4">
                    <div class="serv-metafield mb-2">
                      <a class="me-md-4 me-3" href="<?php echo esc_url(get_author_posts_url(get_the_author_meta('ID'))); ?>">
                        <i class="fa fa-user pe-lg-2 pe-1"></i> <?php the_author(); ?>
                      </a>
                      <a href="<?php echo esc_url(get_day_link(get_the_date('Y'), get_the_date('m'), get_the_date('d'))); ?>" class="entry-date">
                        <i class="far fa-calendar-alt pe-lg-2 pe-1"></i> <?php echo esc_html(get_the_date('d F Y')); ?>
                      </a>
                    </div>
                    <div class="head-main mb-2">
                      <h3>
                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                      </h3>
                      <a href="<?php the_permalink(); ?>" class="arrow-icon" aria-label="<?php echo esc_attr__( 'Read more', 'manufacturing-hub' ); ?>">
                        <i class="fa-solid fa-arrow-up-right-from-square"></i>
                      </a>
                    </div>
                    <p class="main-serv-content"><?php echo esc_html(wp_trim_words(wp_kses_post(get_the_content()), 20)); ?></p>
                  </div>
                </div>
              </div>
            <?php endwhile;
            wp_reset_postdata();
          endif;
        endif;
        ?>
      </div>
    </div>
  </section>
<?php endif; ?>