<?php
/**
 * Displays footer widgets if assigned
 *
 * @package Manufacturing Hub
 * @subpackage manufacturing_hub
 */
?>
<?php

// Determine the number of columns dynamically for the footer (you can replace this with your logic).
$manufacturing_hub_no_of_footer_col = get_theme_mod('manufacturing_hub_footer_columns', 4); // Change this value as needed.

// Calculate the Bootstrap class for large screens (col-lg-X) for footer.
$manufacturing_hub_col_lg_footer_class = 'col-lg-' . (12 / $manufacturing_hub_no_of_footer_col);

// Calculate the Bootstrap class for medium screens (col-md-X) for footer.
$manufacturing_hub_col_md_footer_class = 'col-md-' . (12 / $manufacturing_hub_no_of_footer_col);
?>
<div class="container">
    <aside class="widget-area row py-2 pt-3" role="complementary" aria-label="<?php esc_attr_e( 'Footer', 'manufacturing-hub' ); ?>">
        <?php
        $manufacturing_hub_default_widgets = array(
            1 => 'search',
            2 => 'archives',
            3 => 'meta',
            4 => 'categories'
        );

        for ($manufacturing_hub_i = 1; $manufacturing_hub_i <= $manufacturing_hub_no_of_footer_col; $manufacturing_hub_i++) :
            $manufacturing_hub_lg_class = esc_attr($manufacturing_hub_col_lg_footer_class);
            $manufacturing_hub_md_class = esc_attr($manufacturing_hub_col_md_footer_class);
            echo '<div class="col-12 ' . $manufacturing_hub_lg_class . ' ' . $manufacturing_hub_md_class . '">';

            if (is_active_sidebar('footer-' . $manufacturing_hub_i)) {
                dynamic_sidebar('footer-' . $manufacturing_hub_i);
            } else {
                // Display default widget content if not active.
                switch ($manufacturing_hub_default_widgets[$manufacturing_hub_i] ?? '') {
                    case 'search':
                        ?>
                        <aside class="widget" role="complementary" aria-label="<?php esc_attr_e('Search', 'manufacturing-hub'); ?>">
                            <h3 class="widget-title"><?php esc_html_e('Search', 'manufacturing-hub'); ?></h3>
                            <?php get_search_form(); ?>
                        </aside>
                        <?php
                        break;

                    case 'archives':
                        ?>
                        <aside class="widget" role="complementary" aria-label="<?php esc_attr_e('Archives', 'manufacturing-hub'); ?>">
                            <h3 class="widget-title"><?php esc_html_e('Archives', 'manufacturing-hub'); ?></h3>
                            <ul><?php wp_get_archives(['type' => 'monthly']); ?></ul>
                        </aside>
                        <?php
                        break;

                    case 'meta':
                        ?>
                        <aside class="widget" role="complementary" aria-label="<?php esc_attr_e('Meta', 'manufacturing-hub'); ?>">
                            <h3 class="widget-title"><?php esc_html_e('Meta', 'manufacturing-hub'); ?></h3>
                            <ul>
                                <?php wp_register(); ?>
                                <li><?php wp_loginout(); ?></li>
                                <?php wp_meta(); ?>
                            </ul>
                        </aside>
                        <?php
                        break;

                    case 'categories':
                        ?>
                        <aside class="widget" role="complementary" aria-label="<?php esc_attr_e('Categories', 'manufacturing-hub'); ?>">
                            <h3 class="widget-title"><?php esc_html_e('Categories', 'manufacturing-hub'); ?></h3>
                            <ul><?php wp_list_categories(['title_li' => '']); ?></ul>
                        </aside>
                        <?php
                        break;
                }
            }

            echo '</div>';
        endfor;
        ?>
    </aside>
</div>