<?php 
if (isset($_GET['import-demo']) && $_GET['import-demo'] == true) {

    // ------- Create Nav Menu --------
$manufacturing_hub_menuname = 'Main Menus';
$manufacturing_hub_bpmenulocation = 'primary-menu';
$manufacturing_hub_menu_exists = wp_get_nav_menu_object($manufacturing_hub_menuname);

if (!$manufacturing_hub_menu_exists) {
    $manufacturing_hub_menu_id = wp_create_nav_menu($manufacturing_hub_menuname);

    // Create Home Page
    $manufacturing_hub_home_title = 'Home';
    $manufacturing_hub_home = array(
        'post_type' => 'page',
        'post_title' => $manufacturing_hub_home_title,
        'post_content' => '',
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'home'
    );
    $manufacturing_hub_home_id = wp_insert_post($manufacturing_hub_home);

    // Assign Home Page Template
    add_post_meta($manufacturing_hub_home_id, '_wp_page_template', 'page-template/front-page.php');

    // Update options to set Home Page as the front page
    update_option('page_on_front', $manufacturing_hub_home_id);
    update_option('show_on_front', 'page');

    // Add Home Page to Menu
    wp_update_nav_menu_item($manufacturing_hub_menu_id, 0, array(
        'menu-item-title' => __('Home', 'manufacturing-hub'),
        'menu-item-classes' => 'home',
        'menu-item-url' => home_url('/'),
        'menu-item-status' => 'publish',
        'menu-item-object-id' => $manufacturing_hub_home_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type'
    ));

    // Create About Us Page with Dummy Content
    $manufacturing_hub_about_title = 'About Us';
    $manufacturing_hub_about_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>

             Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br> 

                There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br> 

                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
    $manufacturing_hub_about = array(
        'post_type' => 'page',
        'post_title' => $manufacturing_hub_about_title,
        'post_content' => $manufacturing_hub_about_content,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'about-us'
    );
    $manufacturing_hub_about_id = wp_insert_post($manufacturing_hub_about);

    // Add About Us Page to Menu
    wp_update_nav_menu_item($manufacturing_hub_menu_id, 0, array(
        'menu-item-title' => __('About Us', 'manufacturing-hub'),
        'menu-item-classes' => 'about-us',
        'menu-item-url' => home_url('/about-us/'),
        'menu-item-status' => 'publish',
        'menu-item-object-id' => $manufacturing_hub_about_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type'
    ));

    // Create Services Page with Dummy Content
    $manufacturing_hub_services_title = 'Services';
    $manufacturing_hub_services_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>

             Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br> 

                There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br> 

                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
    $manufacturing_hub_services = array(
        'post_type' => 'page',
        'post_title' => $manufacturing_hub_services_title,
        'post_content' => $manufacturing_hub_services_content,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'services'
    );
    $manufacturing_hub_services_id = wp_insert_post($manufacturing_hub_services);

    // Add Services Page to Menu
    wp_update_nav_menu_item($manufacturing_hub_menu_id, 0, array(
        'menu-item-title' => __('Services', 'manufacturing-hub'),
        'menu-item-classes' => 'services',
        'menu-item-url' => home_url('/services/'),
        'menu-item-status' => 'publish',
        'menu-item-object-id' => $manufacturing_hub_services_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type'
    ));

    // Create Pages Page with Dummy Content
    $manufacturing_hub_pages_title = 'Pages';
    $manufacturing_hub_pages_content = '<h2>Our Pages</h2>
    <p>Explore all the pages we have on our website. Find information about our services, company, and more.</p>';
    $manufacturing_hub_pages = array(
        'post_type' => 'page',
        'post_title' => $manufacturing_hub_pages_title,
        'post_content' => $manufacturing_hub_pages_content,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'pages'
    );
    $manufacturing_hub_pages_id = wp_insert_post($manufacturing_hub_pages);

    // Add Pages Page to Menu
    wp_update_nav_menu_item($manufacturing_hub_menu_id, 0, array(
        'menu-item-title' => __('Pages', 'manufacturing-hub'),
        'menu-item-classes' => 'pages',
        'menu-item-url' => home_url('/pages/'),
        'menu-item-status' => 'publish',
        'menu-item-object-id' => $manufacturing_hub_pages_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type'
    ));

    // Create Contact Page with Dummy Content
    $manufacturing_hub_contact_title = 'Contact';
    $manufacturing_hub_contact_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam...<br>

             Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry standard dummy text ever since the 1500, when an unknown printer took a galley of type and scrambled it to make a type specimen book. It has survived not only five centuries, but also the leap into electronic typesetting, remaining essentially unchanged. It was popularised in the 1960 with the release of Letraset sheets containing Lorem Ipsum passages, and more recently with desktop publishing software like Aldus PageMaker including versions of Lorem Ipsum.<br> 

                There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour, or randomised words which dont look even slightly believable. If you are going to use a passage of Lorem Ipsum, you need to be sure there isnt anything embarrassing hidden in the middle of text.<br> 

                All the Lorem Ipsum generators on the Internet tend to repeat predefined chunks as necessary, making this the first true generator on the Internet. It uses a dictionary of over 200 Latin words, combined with a handful of model sentence structures, to generate Lorem Ipsum which looks reasonable. The generated Lorem Ipsum is therefore always free from repetition, injected humour, or non-characteristic words etc.';
    $manufacturing_hub_contact = array(
        'post_type' => 'page',
        'post_title' => $manufacturing_hub_contact_title,
        'post_content' => $manufacturing_hub_contact_content,
        'post_status' => 'publish',
        'post_author' => 1,
        'post_slug' => 'contact'
    );
    $manufacturing_hub_contact_id = wp_insert_post($manufacturing_hub_contact);

    // Add Contact Page to Menu
    wp_update_nav_menu_item($manufacturing_hub_menu_id, 0, array(
        'menu-item-title' => __('Contact', 'manufacturing-hub'),
        'menu-item-classes' => 'contact',
        'menu-item-url' => home_url('/contact/'),
        'menu-item-status' => 'publish',
        'menu-item-object-id' => $manufacturing_hub_contact_id,
        'menu-item-object' => 'page',
        'menu-item-type' => 'post_type'
    ));

    // Set the menu location if it's not already set
    if (!has_nav_menu($manufacturing_hub_bpmenulocation)) {
        $locations = get_theme_mod('nav_menu_locations'); // Use 'nav_menu_locations' to get locations array
        if (empty($locations)) {
            $locations = array();
        }
        $locations[$manufacturing_hub_bpmenulocation] = $manufacturing_hub_menu_id;
        set_theme_mod('nav_menu_locations', $locations);
    }
}

        //---Header--//
        set_theme_mod('manufacturing_hub_about_call_text', 'Contact Us');
        set_theme_mod('manufacturing_hub_about_call', '+01 123456789');

        set_theme_mod('manufacturing_hub_slider_short_heading', 'Over 2500 Users Have Trusted');
        
        // Slider Section
        set_theme_mod('manufacturing_hub_slider_arrows', true);

        for ($i = 1; $i <= 4; $i++) {
            $manufacturing_hub_title = 'Precision Engineering Industrial Excellence.';
            $manufacturing_hub_content = 'At the heart of our operations is a commitment to delivering superior products through cutting- edge technology and innovative processes.';

            // Create post object
            $my_post = array(
                'post_title'    => wp_strip_all_tags($manufacturing_hub_title),
                'post_content'  => $manufacturing_hub_content,
                'post_status'   => 'publish',
                'post_type'     => 'page',
            );

            // Insert the post into the database
            $post_id = wp_insert_post($my_post);

            // Check for errors when inserting the post
            if (is_wp_error($post_id)) {
                error_log('Error creating slider page: ' . $post_id->get_error_message());
                continue; // Skip to the next iteration if error occurs
            }

            // Set the theme mod for the slider page
            set_theme_mod('manufacturing_hub_slider_page' . $i, $post_id);

            // Set the slider image
            $image_url = get_template_directory_uri() . '/assets/images/slider.png';
            $image_id = media_sideload_image($image_url, $post_id, null, 'id');

            // Handle image download errors
            if (!is_wp_error($image_id)) {
                // Set the downloaded image as the post's featured image
                set_post_thumbnail($post_id, $image_id);
            } else {
                error_log('Error downloading slider image: ' . $image_id->get_error_message());
            }
        }

        // Define post category names
        $manufacturing_hub_category_names = array('postcategory1');

        // Set theme mod values for the customer review and selected category
        set_theme_mod('manufacturing_hub_star_rating', '4.9');
        set_theme_mod('manufacturing_hub_about_catData', 'postcategory1');

        foreach ($manufacturing_hub_category_names as $manufacturing_hub_category_name) {
            // Check if the category exists, and insert if necessary
            $manufacturing_hub_term = term_exists($manufacturing_hub_category_name, 'category');

            if (!$manufacturing_hub_term) {
                $manufacturing_hub_term = wp_insert_term($manufacturing_hub_category_name, 'category');

                // Handle errors during category insertion
                if (is_wp_error($manufacturing_hub_term)) {
                    error_log('Error creating category: ' . $manufacturing_hub_term->get_error_message());
                    continue;
                }
            }

            // Ensure the term ID is retrieved correctly
            $manufacturing_hub_term_id = is_array($manufacturing_hub_term) ? $manufacturing_hub_term['term_id'] : $manufacturing_hub_term;

            // Loop for creating posts under the category
            for ($manufacturing_hub_i = 0; $manufacturing_hub_i < 3; $manufacturing_hub_i++) {
                $manufacturing_hub_my_post = array(
                    'post_title'   => 'Post ' . ($manufacturing_hub_i + 1),
                    'post_content' => 'This is the content for post ' . ($manufacturing_hub_i + 1),
                    'post_status'  => 'publish',
                    'post_type'    => 'post',
                );

                // Insert the post into the database
                $manufacturing_hub_post_id = wp_insert_post($manufacturing_hub_my_post);

                // Handle post insertion errors
                if (is_wp_error($manufacturing_hub_post_id)) {
                    error_log('Error creating post: ' . $manufacturing_hub_post_id->get_error_message());
                    continue; // Skip to the next iteration if error occurs
                }

                // Assign the category to the post
                wp_set_post_categories($manufacturing_hub_post_id, array($manufacturing_hub_term_id));

                // Handle featured image
                $manufacturing_hub_image_url = get_template_directory_uri() . '/assets/images/post-img' . ($manufacturing_hub_i + 1) . '.png';
                $manufacturing_hub_image_id = media_sideload_image($manufacturing_hub_image_url, $manufacturing_hub_post_id, null, 'id');

                // Handle image download errors
                if (!is_wp_error($manufacturing_hub_image_id)) {
                    set_post_thumbnail($manufacturing_hub_post_id, $manufacturing_hub_image_id);
                } else {
                    error_log('Error downloading post image: ' . $manufacturing_hub_image_id->get_error_message());
                }
            }
        }

        set_theme_mod('manufacturing_hub_tab_heading1', 'Advanced Manufacturing Solutions');
        set_theme_mod('manufacturing_hub_tab_heading2', 'Quality Assurance Systems');
        set_theme_mod('manufacturing_hub_tab_heading3', 'State-of-the-Art Technology');

        // Our Services Section //
        set_theme_mod('manufacturing_hub_featured_section_title', 'Insights from Our Latest Blog');
        set_theme_mod('manufacturing_hub_product_section_btn_text1', 'View All');
        set_theme_mod('manufacturing_hub_product_section_btn_link1', '#');
        set_theme_mod('manufacturing_hub_featured_section_category', 'postcategory2');

        // Define post category names and post titles
        $manufacturing_hub_category_names = array('postcategory2');
        $manufacturing_hub_title_array = array(
            array(
                "Sustainable Practices Reducing Waste inb Industrial Production",
                "Sustainable Practices Reducing Waste in Industrial Production",
                "Sustainable Practices Reducing Waste in Industrial Production",
            )
        );
        
        $manufacturing_hub_content = 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna.';

        foreach ($manufacturing_hub_category_names as $manufacturing_hub_index => $manufacturing_hub_category_name) {
            // Create or retrieve the post category term ID
            $manufacturing_hub_term = term_exists($manufacturing_hub_category_name, 'category');
            if ($manufacturing_hub_term === 0 || $manufacturing_hub_term === null) {
                // If the term does not exist, create it
                $manufacturing_hub_term = wp_insert_term($manufacturing_hub_category_name, 'category');
            }
            if (is_wp_error($manufacturing_hub_term)) {
                error_log('Error creating category: ' . $manufacturing_hub_term->get_error_message());
                continue; // Skip to the next iteration if category creation fails
            }

            // Ensure we get the term ID
            $manufacturing_hub_term_id = is_array($manufacturing_hub_term) ? $manufacturing_hub_term['term_id'] : $manufacturing_hub_term;

            // Get titles for this category
            $manufacturing_hub_titles = $manufacturing_hub_title_array[$manufacturing_hub_index];

            for ($manufacturing_hub_i = 0; $manufacturing_hub_i < count($manufacturing_hub_titles); $manufacturing_hub_i++) {
                // Create post content
                $manufacturing_hub_title = $manufacturing_hub_titles[$manufacturing_hub_i];

                // Create post post object
                $manufacturing_hub_my_post = array(
                    'post_title'    => wp_strip_all_tags($manufacturing_hub_title),
                    'post_content'  => $manufacturing_hub_content,
                    'post_status'   => 'publish',
                    'post_type'     => 'post', // Post type set to 'post'
                );

                // Insert the post into the database
                $manufacturing_hub_post_id = wp_insert_post($manufacturing_hub_my_post);

                if (is_wp_error($manufacturing_hub_post_id)) {
                    error_log('Error creating post: ' . $manufacturing_hub_post_id->get_error_message());
                    continue; // Skip to the next post if creation fails
                }

                // Assign the category to the post
                wp_set_post_categories($manufacturing_hub_post_id, array((int)$manufacturing_hub_term_id));

                // Handle the featured image using media_sideload_image
                $manufacturing_hub_image_url = get_stylesheet_directory_uri() . '/assets/images/serv-img' . ($manufacturing_hub_i + 1) . '.png';
                $manufacturing_hub_image_id = media_sideload_image($manufacturing_hub_image_url, $manufacturing_hub_post_id, null, 'id');

                if (is_wp_error($manufacturing_hub_image_id)) {
                    error_log('Error downloading image: ' . $manufacturing_hub_image_id->get_error_message());
                    continue; // Skip to the next post if image download fails
                }

                // Assign featured image to post
                set_post_thumbnail($manufacturing_hub_post_id, $manufacturing_hub_image_id);
            }
        }

    }
?>