<?php
/**
 * Manufacturing Hub: Customizer
 *
 * @package Manufacturing Hub
 * @subpackage manufacturing_hub
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function manufacturing_hub_customize_register( $wp_customize ) {

	// Pro Version
    class manufacturing_hub_Customize_Pro_Version extends WP_Customize_Control {
        public $type = 'pro_options';

        public function render_content() {
            echo '<span>Unlock Premium <strong>'. esc_html( $this->label ) .'</strong>? </span>';
            echo '<a href="'. esc_url($this->description) .'" target="_blank">';
                echo '<span class="dashicons dashicons-info"></span>';
                echo '<strong> '. esc_html( MANUFACTURING_HUB_BUY_TEXT,'manufacturing-hub' ) .'<strong></a>';
            echo '</a>';
        }
    }

    // Custom Controls
    function manufacturing_hub_sanitize_custom_control( $input ) {
        return $input;
    }

	require get_parent_theme_file_path('/inc/controls/range-slider-control.php');

	require get_parent_theme_file_path('/inc/controls/icon-changer.php');
	
	// Register the custom control type.
	$wp_customize->register_control_type( 'Manufacturing_Hub_Toggle_Control' );
	
	//Register the sortable control type.
	$wp_customize->register_control_type( 'Manufacturing_Hub_Control_Sortable' );

	//add home page setting pannel
	$wp_customize->add_panel( 'manufacturing_hub_panel_id', array(
	    'priority' => 10,
	    'capability' => 'edit_theme_options',
	    'theme_supports' => '',
	    'title' => __( 'Custom Home page', 'manufacturing-hub' ),
	    'description' => __( 'Description of what this panel does.', 'manufacturing-hub' ),
	) );
	
	//TP GENRAL OPTION
	$wp_customize->add_section('manufacturing_hub_tp_general_settings',array(
        'title' => __('TP General Option', 'manufacturing-hub'),
        'priority' => 1,
        'panel' => 'manufacturing_hub_panel_id'
    ) );

    $wp_customize->add_setting('manufacturing_hub_tp_body_layout_settings',array(
        'default' => 'Full',
        'sanitize_callback' => 'manufacturing_hub_sanitize_choices'
	));
    $wp_customize->add_control('manufacturing_hub_tp_body_layout_settings',array(
        'type' => 'radio',
        'label'     => __('Body Layout Setting', 'manufacturing-hub'),
        'description'   => __('This option work for complete body, if you want to set the complete website in container.', 'manufacturing-hub'),
        'section' => 'manufacturing_hub_tp_general_settings',
        'choices' => array(
            'Full' => __('Full','manufacturing-hub'),
            'Container' => __('Container','manufacturing-hub'),
            'Container Fluid' => __('Container Fluid','manufacturing-hub')
        ),
	) );

    // Add Settings and Controls for Post Layout
	$wp_customize->add_setting('manufacturing_hub_sidebar_post_layout',array(
        'default' => 'right',
        'sanitize_callback' => 'manufacturing_hub_sanitize_choices'
	));
	$wp_customize->add_control('manufacturing_hub_sidebar_post_layout',array(
        'type' => 'radio',
        'label'     => __('Post Sidebar Position', 'manufacturing-hub'),
        'description'   => __('This option work for blog page, blog single page, archive page and search page.', 'manufacturing-hub'),
        'section' => 'manufacturing_hub_tp_general_settings',
        'choices' => array(
            'full' => __('Full','manufacturing-hub'),
            'left' => __('Left','manufacturing-hub'),
            'right' => __('Right','manufacturing-hub'),
            'three-column' => __('Three Columns','manufacturing-hub'),
            'four-column' => __('Four Columns','manufacturing-hub'),
            'grid' => __('Grid Layout','manufacturing-hub')
        ),
	) );

	// Add Settings and Controls for post sidebar Layout
	$wp_customize->add_setting('manufacturing_hub_sidebar_single_post_layout',array(
        'default' => 'right',
        'sanitize_callback' => 'manufacturing_hub_sanitize_choices'
	));
	$wp_customize->add_control('manufacturing_hub_sidebar_single_post_layout',array(
        'type' => 'radio',
        'label'     => __('Single Post Sidebar Position', 'manufacturing-hub'),
        'description'   => __('This option work for single blog page', 'manufacturing-hub'),
        'section' => 'manufacturing_hub_tp_general_settings',
        'choices' => array(
            'full' => __('Full','manufacturing-hub'),
            'left' => __('Left','manufacturing-hub'),
            'right' => __('Right','manufacturing-hub'),
        ),
	) );

	// Add Settings and Controls for Page Layout
	$wp_customize->add_setting('manufacturing_hub_sidebar_page_layout',array(
        'default' => 'right',
        'sanitize_callback' => 'manufacturing_hub_sanitize_choices'
	));
	$wp_customize->add_control('manufacturing_hub_sidebar_page_layout',array(
        'type' => 'radio',
        'label'     => __('Page Sidebar Position', 'manufacturing-hub'),
        'description'   => __('This option work for pages.', 'manufacturing-hub'),
        'section' => 'manufacturing_hub_tp_general_settings',
        'choices' => array(
            'full' => __('Full','manufacturing-hub'),
            'left' => __('Left','manufacturing-hub'),
            'right' => __('Right','manufacturing-hub')
        ),
	) );

	$wp_customize->add_setting( 'manufacturing_hub_sticky', array(
		'default'           => false,
		'transport'         => 'refresh',
		'sanitize_callback' => 'manufacturing_hub_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Manufacturing_Hub_Toggle_Control( $wp_customize, 'manufacturing_hub_sticky', array(
		'label'       => esc_html__( 'Show Sticky Header', 'manufacturing-hub' ),
		'section'     => 'manufacturing_hub_tp_general_settings',
		'type'        => 'toggle',
		'settings'    => 'manufacturing_hub_sticky',
	) ) );

	//tp typography option
	$manufacturing_hub_font_array = array(
		''                       => 'No Fonts',
		'Abril Fatface'          => 'Abril Fatface',
		'Acme'                   => 'Acme',
		'Anton'                  => 'Anton',
		'Architects Daughter'    => 'Architects Daughter',
		'Arimo'                  => 'Arimo',
		'Arsenal'                => 'Arsenal',
		'Arvo'                   => 'Arvo',
		'Alegreya'               => 'Alegreya',
		'Alfa Slab One'          => 'Alfa Slab One',
		'Averia Serif Libre'     => 'Averia Serif Libre',
		'Bangers'                => 'Bangers',
		'Boogaloo'               => 'Boogaloo',
		'Bad Script'             => 'Bad Script',
		'Bitter'                 => 'Bitter',
		'Bree Serif'             => 'Bree Serif',
		'BenchNine'              => 'BenchNine',
		'Cabin'                  => 'Cabin',
		'Cardo'                  => 'Cardo',
		'Courgette'              => 'Courgette',
		'Cherry Swash'           => 'Cherry Swash',
		'Cormorant Garamond'     => 'Cormorant Garamond',
		'Crimson Text'           => 'Crimson Text',
		'Cuprum'                 => 'Cuprum',
		'Cookie'                 => 'Cookie',
		'Chewy'                  => 'Chewy',
		'Days One'               => 'Days One',
		'Dosis'                  => 'Dosis',
		'Droid Sans'             => 'Droid Sans',
		'Economica'              => 'Economica',
		'Fredoka One'            => 'Fredoka One',
		'Fjalla One'             => 'Fjalla One',
		'Francois One'           => 'Francois One',
		'Frank Ruhl Libre'       => 'Frank Ruhl Libre',
		'Gloria Hallelujah'      => 'Gloria Hallelujah',
		'Great Vibes'            => 'Great Vibes',
		'Handlee'                => 'Handlee',
		'Hammersmith One'        => 'Hammersmith One',
		'Inconsolata'            => 'Inconsolata',
		'Indie Flower'           => 'Indie Flower',
		'Inter'                  => 'Inter',
		'IM Fell English SC'     => 'IM Fell English SC',
		'Julius Sans One'        => 'Julius Sans One',
		'Josefin Slab'           => 'Josefin Slab',
		'Josefin Sans'           => 'Josefin Sans',
		'Kanit'                  => 'Kanit',
		'Karla'                  => 'Karla',
		'Lobster'                => 'Lobster',
		'Lato'                   => 'Lato',
		'Lora'                   => 'Lora',
		'Libre Baskerville'      => 'Libre Baskerville',
		'Lobster Two'            => 'Lobster Two',
		'Manrope'           	 => 'Manrope',
		'Merriweather'           => 'Merriweather',
		'Monda'                  => 'Monda',
		'Montserrat'             => 'Montserrat',
		'Muli'                   => 'Muli',
		'Marck Script'           => 'Marck Script',
		'Noto Serif'             => 'Noto Serif',
		'Open Sans'              => 'Open Sans',
		'Overpass'               => 'Overpass',
		'Overpass Mono'          => 'Overpass Mono',
		'Oxygen'                 => 'Oxygen',
		'Oxanium'                => 'Oxanium',
		'Orbitron'               => 'Orbitron',
		'Patua One'              => 'Patua One',
		'Pacifico'               => 'Pacifico',
		'Padauk'                 => 'Padauk',
		'Playball'               => 'Playball',
		'Playfair Display'       => 'Playfair Display',
		'PT Sans'                => 'PT Sans',
		'Philosopher'            => 'Philosopher',
		'Permanent Marker'       => 'Permanent Marker',
		'Poiret One'             => 'Poiret One',
		'Quicksand'              => 'Quicksand',
		'Quattrocento Sans'      => 'Quattrocento Sans',
		'Raleway'                => 'Raleway',
		'Rubik'                  => 'Rubik',
		'Rokkitt'                => 'Rokkitt',
		'Roboto Serif'           => 'Roboto Serif',
		'Russo One'              => 'Russo One',
		'Righteous'              => 'Righteous',
		'Satisfy'                => 'Satisfy',
		'Slabo'                  => 'Slabo',
		'Source Sans Pro'        => 'Source Sans Pro',
		'Shadows Into Light Two' => 'Shadows Into Light Two',
		'Shadows Into Light'     => 'Shadows Into Light',
		'Sacramento'             => 'Sacramento',
		'Shrikhand'              => 'Shrikhand',
		'Tangerine'              => 'Tangerine',
		'Ubuntu'                 => 'Ubuntu',
		'VT323'                  => 'VT323',
		'Varela Round'           => 'Varela Round',
		'Vampiro One'            => 'Vampiro One',
		'Vollkorn'               => 'Vollkorn',
		'Volkhov'                => 'Volkhov',
		'Yanone Kaffeesatz'      => 'Yanone Kaffeesatz'
	);

	$wp_customize->add_section('manufacturing_hub_typography_option',array(
		'title'         => __('TP Typography Option', 'manufacturing-hub'),
		'priority' => 1,
		'panel' => 'manufacturing_hub_panel_id'
   	));

   	$wp_customize->add_setting('manufacturing_hub_heading_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'manufacturing_hub_sanitize_choices',
	));
	$wp_customize->add_control(	'manufacturing_hub_heading_font_family', array(
		'section' => 'manufacturing_hub_typography_option',
		'label'   => __('heading Fonts', 'manufacturing-hub'),
		'type'    => 'select',
		'choices' => $manufacturing_hub_font_array,
	));

	$wp_customize->add_setting('manufacturing_hub_body_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'manufacturing_hub_sanitize_choices',
	));
	$wp_customize->add_control(	'manufacturing_hub_body_font_family', array(
		'section' => 'manufacturing_hub_typography_option',
		'label'   => __('Body Fonts', 'manufacturing-hub'),
		'type'    => 'select',
		'choices' => $manufacturing_hub_font_array,
	));

	//TP Preloader Option
	$wp_customize->add_section('manufacturing_hub_prelaoder_option',array(
		'title'         => __('TP Preloader Option', 'manufacturing-hub'),
		'priority' => 1,
		'panel' => 'manufacturing_hub_panel_id'
	) );

	$wp_customize->add_setting( 'manufacturing_hub_preloader_show_hide', array(
		'default'           => false,
		'transport'         => 'refresh',
		'sanitize_callback' => 'manufacturing_hub_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Manufacturing_Hub_Toggle_Control( $wp_customize, 'manufacturing_hub_preloader_show_hide', array(
		'label'       => esc_html__( 'Show / Hide Preloader Option', 'manufacturing-hub' ),
		'section'     => 'manufacturing_hub_prelaoder_option',
		'type'        => 'toggle',
		'settings'    => 'manufacturing_hub_preloader_show_hide',
	) ) );

	$wp_customize->add_setting( 'manufacturing_hub_tp_preloader_color1_option', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'manufacturing_hub_tp_preloader_color1_option', array(
			'label'     => __('Preloader First Ring Color', 'manufacturing-hub'),
	    'description' => __('It will change the complete theme preloader ring 1 color in one click.', 'manufacturing-hub'),
	    'section' => 'manufacturing_hub_prelaoder_option',
	    'settings' => 'manufacturing_hub_tp_preloader_color1_option',
  	)));

  	$wp_customize->add_setting( 'manufacturing_hub_tp_preloader_color2_option', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'manufacturing_hub_tp_preloader_color2_option', array(
			'label'     => __('Preloader Second Ring Color', 'manufacturing-hub'),
	    'description' => __('It will change the complete theme preloader ring 2 color in one click.', 'manufacturing-hub'),
	    'section' => 'manufacturing_hub_prelaoder_option',
	    'settings' => 'manufacturing_hub_tp_preloader_color2_option',
  	)));

  	$wp_customize->add_setting( 'manufacturing_hub_tp_preloader_bg_color_option', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'manufacturing_hub_tp_preloader_bg_color_option', array(
			'label'     => __('Preloader Background Color', 'manufacturing-hub'),
	    'description' => __('It will change the complete theme preloader bg color in one click.', 'manufacturing-hub'),
	    'section' => 'manufacturing_hub_prelaoder_option',
	    'settings' => 'manufacturing_hub_tp_preloader_bg_color_option',
  	)));

  	// Pro Version
    $wp_customize->add_setting( 'manufacturing_hub_preloader_pro_version_logo', array(
        'sanitize_callback' => 'manufacturing_hub_sanitize_custom_control'
    ));
    $wp_customize->add_control( new manufacturing_hub_Customize_Pro_Version ( $wp_customize,'manufacturing_hub_preloader_pro_version_logo', array(
        'section'     => 'manufacturing_hub_prelaoder_option',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'manufacturing-hub' ),
        'description' => esc_url( MANUFACTURING_HUB_PRO_THEME_URL ),
        'priority'    => 100
    )));

	//TP Color Option
	$wp_customize->add_section('manufacturing_hub_color_option',array(
     'title'         => __('TP Color Option', 'manufacturing-hub'),
     'priority' => 1,
     'panel' => 'manufacturing_hub_panel_id'
    ) );
    
	$wp_customize->add_setting( 'manufacturing_hub_tp_color_option_first', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'manufacturing_hub_tp_color_option_first', array(
			'label'     => __('Theme First Color', 'manufacturing-hub'),
	    'description' => __('It will change the complete theme color in one click.', 'manufacturing-hub'),
	    'section' => 'manufacturing_hub_color_option',
	    'settings' => 'manufacturing_hub_tp_color_option_first',
  	)));

	//TP Blog Option
	$wp_customize->add_section('manufacturing_hub_blog_option',array(
        'title' => __('TP Blog Option', 'manufacturing-hub'),
        'priority' => 1,
        'panel' => 'manufacturing_hub_panel_id'
    ) );

    $wp_customize->add_setting('manufacturing_hub_edit_blog_page_title',array(
		'default'=> __('Home','manufacturing-hub'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('manufacturing_hub_edit_blog_page_title',array(
		'label'	=> __('Change Blog Page Title','manufacturing-hub'),
		'section'=> 'manufacturing_hub_blog_option',
		'type'=> 'text'
	));

	$wp_customize->add_setting('manufacturing_hub_edit_blog_page_description',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('manufacturing_hub_edit_blog_page_description',array(
		'label'	=> __('Add Blog Page Description','manufacturing-hub'),
		'section'=> 'manufacturing_hub_blog_option',
		'type'=> 'text'
	));

	/** Meta Order */
    $wp_customize->add_setting('blog_meta_order', array(
        'default' => array('date', 'author', 'comment','category', 'time'),
        'sanitize_callback' => 'manufacturing_hub_sanitize_sortable',
    ));
    $wp_customize->add_control(new Manufacturing_Hub_Control_Sortable($wp_customize, 'blog_meta_order', array(
    	'label' => esc_html__('Meta Order', 'manufacturing-hub'),
        'description' => __('Drag & Drop post items to re-arrange the order and also hide and show items as per the need by clicking on the eye icon.', 'manufacturing-hub') ,
        'section' => 'manufacturing_hub_blog_option',
        'choices' => array(
            'date' => __('date', 'manufacturing-hub') ,
            'author' => __('author', 'manufacturing-hub') ,
            'comment' => __('comment', 'manufacturing-hub') ,
            'category' => __('category', 'manufacturing-hub') ,
            'time' => __('time', 'manufacturing-hub') ,
        ) ,
    )));

    $wp_customize->add_setting( 'manufacturing_hub_excerpt_count', array(
		'default'              => 35,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'manufacturing_hub_sanitize_number_range',
		'sanitize_js_callback' => 'absint',
	) );
	$wp_customize->add_control( 'manufacturing_hub_excerpt_count', array(
		'label'       => esc_html__( 'Edit Excerpt Limit','manufacturing-hub' ),
		'section'     => 'manufacturing_hub_blog_option',
		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 2,
			'min'              => 0,
			'max'              => 50,
		),
	) );

    $wp_customize->add_setting('manufacturing_hub_read_more_text',array(
		'default'=> __('Read More','manufacturing-hub'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('manufacturing_hub_read_more_text',array(
		'label'	=> __('Edit Button Text','manufacturing-hub'),
		'section'=> 'manufacturing_hub_blog_option',
		'type'=> 'text'
	));

	$wp_customize->add_setting('manufacturing_hub_post_image_round', array(
	  'default' => '0',
      'sanitize_callback' => 'manufacturing_hub_sanitize_number_range',
	));
	$wp_customize->add_control(new Manufacturing_Hub_Range_Slider($wp_customize, 'manufacturing_hub_post_image_round', array(
       'section' => 'manufacturing_hub_blog_option',
      'label' => esc_html__('Edit Post Image Border Radius', 'manufacturing-hub'),
      'input_attrs' => array(
        'min' => 0,
        'max' => 180,
        'step' => 1
    )
	)));

	$wp_customize->add_setting('manufacturing_hub_post_image_width', array(
	  'default' => '',
      'sanitize_callback' => 'manufacturing_hub_sanitize_number_range',
	));
	$wp_customize->add_control(new Manufacturing_Hub_Range_Slider($wp_customize, 'manufacturing_hub_post_image_width', array(
       'section' => 'manufacturing_hub_blog_option',
      'label' => esc_html__('Edit Post Image Width', 'manufacturing-hub'),
      'input_attrs' => array(
        'min' => 0,
        'max' => 367,
        'step' => 1
    )
	)));

	$wp_customize->add_setting('manufacturing_hub_post_image_length', array(
	  'default' => '',
      'sanitize_callback' => 'manufacturing_hub_sanitize_number_range',
	));
	$wp_customize->add_control(new Manufacturing_Hub_Range_Slider($wp_customize, 'manufacturing_hub_post_image_length', array(
       'section' => 'manufacturing_hub_blog_option',
      'label' => esc_html__('Edit Post Image height', 'manufacturing-hub'),
      'input_attrs' => array(
        'min' => 0,
        'max' => 900,
        'step' => 1
    )
	)));
	
	$wp_customize->add_setting( 'manufacturing_hub_remove_read_button', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'manufacturing_hub_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Manufacturing_Hub_Toggle_Control( $wp_customize, 'manufacturing_hub_remove_read_button', array(
		'label'       => esc_html__( 'Show / Hide Read More Button', 'manufacturing-hub' ),
		'section'     => 'manufacturing_hub_blog_option',
		'type'        => 'toggle',
		'settings'    => 'manufacturing_hub_remove_read_button',
	) ) );

	$wp_customize->add_setting( 'manufacturing_hub_remove_tags', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'manufacturing_hub_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Manufacturing_Hub_Toggle_Control( $wp_customize, 'manufacturing_hub_remove_tags', array(
		'label'       => esc_html__( 'Show / Hide Tags Option', 'manufacturing-hub' ),
		'section'     => 'manufacturing_hub_blog_option',
		'type'        => 'toggle',
		'settings'    => 'manufacturing_hub_remove_tags',
	) ) );

	$wp_customize->add_setting( 'manufacturing_hub_remove_category', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'manufacturing_hub_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Manufacturing_Hub_Toggle_Control( $wp_customize, 'manufacturing_hub_remove_category', array(
		'label'       => esc_html__( 'Show / Hide Category Option', 'manufacturing-hub' ),
		'section'     => 'manufacturing_hub_blog_option',
		'type'        => 'toggle',
		'settings'    => 'manufacturing_hub_remove_category',
	) ) );

	$wp_customize->add_setting( 'manufacturing_hub_remove_comment', array(
	 'default'           => true,
	 'transport'         => 'refresh',
	 'sanitize_callback' => 'manufacturing_hub_sanitize_checkbox',
 	) );

	$wp_customize->add_control( new Manufacturing_Hub_Toggle_Control( $wp_customize, 'manufacturing_hub_remove_comment', array(
	 'label'       => esc_html__( 'Show / Hide Comment Form', 'manufacturing-hub' ),
	 'section'     => 'manufacturing_hub_blog_option',
	 'type'        => 'toggle',
	 'settings'    => 'manufacturing_hub_remove_comment',
	) ) );

	$wp_customize->add_setting( 'manufacturing_hub_remove_related_post', array(
	 'default'           => true,
	 'transport'         => 'refresh',
	 'sanitize_callback' => 'manufacturing_hub_sanitize_checkbox',
 	) );
	$wp_customize->add_control( new Manufacturing_Hub_Toggle_Control( $wp_customize, 'manufacturing_hub_remove_related_post', array(
	 'label'       => esc_html__( 'Show / Hide Related Post', 'manufacturing-hub' ),
	 'section'     => 'manufacturing_hub_blog_option',
	 'type'        => 'toggle',
	 'settings'    => 'manufacturing_hub_remove_related_post',
	) ) );

	$wp_customize->add_setting('manufacturing_hub_related_post_heading',array(
		'default'=> __('Related Posts','manufacturing-hub'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('manufacturing_hub_related_post_heading',array(
		'label'	=> __('Edit Section Title','manufacturing-hub'),
		'section'=> 'manufacturing_hub_blog_option',
		'type'=> 'text'
	));

	$wp_customize->add_setting( 'manufacturing_hub_related_post_per_page', array(
		'default'              => 3,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'manufacturing_hub_sanitize_number_range',
		'sanitize_js_callback' => 'absint',
	) );
	$wp_customize->add_control( 'manufacturing_hub_related_post_per_page', array(
		'label'       => esc_html__( 'Related Post Per Page','manufacturing-hub' ),
		'section'     => 'manufacturing_hub_blog_option',
		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 3,
			'max'              => 9,
		),
	) );

	$wp_customize->add_setting( 'manufacturing_hub_related_post_per_columns', array(
		'default'              => 3,
		'type'                 => 'theme_mod',
		'transport' 		   => 'refresh',
		'sanitize_callback'    => 'manufacturing_hub_sanitize_number_range',
		'sanitize_js_callback' => 'absint',
	) );
	$wp_customize->add_control( 'manufacturing_hub_related_post_per_columns', array(
		'label'       => esc_html__( 'Related Post Per Row','manufacturing-hub' ),
		'section'     => 'manufacturing_hub_blog_option',
		'type'        => 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 4,
		),
	) );

	$wp_customize->add_setting('manufacturing_hub_post_layout',array(
        'default' => 'image-content',
        'sanitize_callback' => 'manufacturing_hub_sanitize_choices'
	));
	$wp_customize->add_control('manufacturing_hub_post_layout',array(
        'type' => 'radio',
        'label'     => __('Post Layout', 'manufacturing-hub'),
        'section' => 'manufacturing_hub_blog_option',
        'choices' => array(
            'image-content' => __('Media-Content','manufacturing-hub'),
            'content-image' => __('Content-Media','manufacturing-hub'),
        ),
	) );

	//MENU TYPOGRAPHY
	$wp_customize->add_section( 'manufacturing_hub_menu_typography', array(
    	'title'      => __( 'Menu Typography', 'manufacturing-hub' ),
    	'priority' => 2,
		'panel' => 'manufacturing_hub_panel_id'
	) );

	$wp_customize->add_setting('manufacturing_hub_menu_font_family', array(
		'default'           => '',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'manufacturing_hub_sanitize_choices',
	));
	$wp_customize->add_control(	'manufacturing_hub_menu_font_family', array(
		'section' => 'manufacturing_hub_menu_typography',
		'label'   => __('Menu Fonts', 'manufacturing-hub'),
		'type'    => 'select',
		'choices' => $manufacturing_hub_font_array,
	));

	$wp_customize->add_setting('manufacturing_hub_menu_font_weight',array(
        'default' => '',
        'sanitize_callback' => 'manufacturing_hub_sanitize_choices'
	));
	$wp_customize->add_control('manufacturing_hub_menu_font_weight',array(
     'type' => 'radio',
     'label'     => __('Font Weight', 'manufacturing-hub'),
     'section' => 'manufacturing_hub_menu_typography',
     'type' => 'select',
     'choices' => array(
         '100' => __('100','manufacturing-hub'),
         '200' => __('200','manufacturing-hub'),
         '300' => __('300','manufacturing-hub'),
         '400' => __('400','manufacturing-hub'),
         '500' => __('500','manufacturing-hub'),
         '600' => __('600','manufacturing-hub'),
         '700' => __('700','manufacturing-hub'),
         '800' => __('800','manufacturing-hub'),
         '900' => __('900','manufacturing-hub')
     ),
	) );

	$wp_customize->add_setting('manufacturing_hub_menu_text_tranform',array(
		'default' => '',
		'sanitize_callback' => 'manufacturing_hub_sanitize_choices'
 	));
 	$wp_customize->add_control('manufacturing_hub_menu_text_tranform',array(
		'type' => 'select',
		'label' => __('Menu Text Transform','manufacturing-hub'),
		'section' => 'manufacturing_hub_menu_typography',
		'choices' => array(
		   'Uppercase' => __('Uppercase','manufacturing-hub'),
		   'Lowercase' => __('Lowercase','manufacturing-hub'),
		   'Capitalize' => __('Capitalize','manufacturing-hub'),
		),
	) );
	$wp_customize->add_setting('manufacturing_hub_menu_font_size', array(
	  'default' => '',
      'sanitize_callback' => 'manufacturing_hub_sanitize_number_range',
	));
	$wp_customize->add_control(new Manufacturing_Hub_Range_Slider($wp_customize, 'manufacturing_hub_menu_font_size', array(
        'section' => 'manufacturing_hub_menu_typography',
        'label' => esc_html__('Font Size', 'manufacturing-hub'),
        'input_attrs' => array(
          'min' => 0,
          'max' => 20,
          'step' => 1
    )
	)));

	$wp_customize->add_setting( 'manufacturing_hub_menu_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'manufacturing_hub_menu_color', array(
			'label'     => __('Change Menu Color', 'manufacturing-hub'),
	    'section' => 'manufacturing_hub_menu_typography',
	    'settings' => 'manufacturing_hub_menu_color',
  	)));

  	// Pro Version
    $wp_customize->add_setting( 'manufacturing_hub_menu_pro_version_logo', array(
        'sanitize_callback' => 'manufacturing_hub_sanitize_custom_control'
    ));
    $wp_customize->add_control( new manufacturing_hub_Customize_Pro_Version ( $wp_customize,'manufacturing_hub_menu_pro_version_logo', array(
        'section'     => 'manufacturing_hub_menu_typography',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'manufacturing-hub' ),
        'description' => esc_url( MANUFACTURING_HUB_PRO_THEME_URL ),
        'priority'    => 100
    )));

  	// header detail
	$wp_customize->add_section( 'manufacturing_hub_header_sec', array(
    	'title'      => __( 'Header Details', 'manufacturing-hub' ),
    	'description' => __( 'Add your Contact details here', 'manufacturing-hub' ),
		'panel' => 'manufacturing_hub_panel_id',
      'priority' => 2,
	) );

	$wp_customize->add_setting(
		'manufacturing_hub_about_call_text',array(
			'default'=> '',
			'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(
		'manufacturing_hub_about_call_text',array(
			'label'	=> __('Add Contact Text','manufacturing-hub'),
			'section'=> 'manufacturing_hub_header_sec',
			'type'=> 'text'
	));

	$wp_customize->add_setting(
		'manufacturing_hub_about_call',
		array(
			'default'=> '',
			'sanitize_callback'	=> 'manufacturing_hub_sanitize_phone_number'
	));
	$wp_customize->add_control(
		'manufacturing_hub_about_call',array(
			'label'	=> __('Add Contact Number','manufacturing-hub'),
			'section'=> 'manufacturing_hub_header_sec',
			'type'=> 'text'
	));

	// Pro Version
    $wp_customize->add_setting( 'manufacturing_hub_header_pro_version_logo', array(
        'sanitize_callback' => 'manufacturing_hub_sanitize_custom_control'
    ));
    $wp_customize->add_control( new manufacturing_hub_Customize_Pro_Version ( $wp_customize,'manufacturing_hub_header_pro_version_logo', array(
        'section'     => 'manufacturing_hub_header_sec',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'manufacturing-hub' ),
        'description' => esc_url( MANUFACTURING_HUB_PRO_THEME_URL ),
        'priority'    => 100
    )));

	//home page slider
	$wp_customize->add_section( 'manufacturing_hub_slider_section' , array(
    	'title'      => __( 'Slider Section', 'manufacturing-hub' ),
    	'priority' => 3,
		'panel' => 'manufacturing_hub_panel_id'
	) );

	$wp_customize->add_setting( 'manufacturing_hub_slider_arrows', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'manufacturing_hub_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Manufacturing_Hub_Toggle_Control( $wp_customize, 'manufacturing_hub_slider_arrows', array(
		'label'       => esc_html__( 'Show / Hide slider', 'manufacturing-hub' ),
		'section'     => 'manufacturing_hub_slider_section',
		'priority' => 1,
		'type'        => 'toggle',
		'settings'    => 'manufacturing_hub_slider_arrows',
	) ) );

	$wp_customize->add_setting( 'manufacturing_hub_show_slider_title', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'manufacturing_hub_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Manufacturing_Hub_Toggle_Control( $wp_customize, 'manufacturing_hub_show_slider_title', array(
		'label'       => esc_html__( 'Show / Hide Slider Heading', 'manufacturing-hub' ),
		'section'     => 'manufacturing_hub_slider_section',
		'type'        => 'toggle',
		'settings'    => 'manufacturing_hub_show_slider_title',
	) ) );

	$wp_customize->add_setting( 'manufacturing_hub_show_slider_content', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'manufacturing_hub_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Manufacturing_Hub_Toggle_Control( $wp_customize, 'manufacturing_hub_show_slider_content', array(
		'label'       => esc_html__( 'Show / Hide Slider Content', 'manufacturing-hub' ),
		'section'     => 'manufacturing_hub_slider_section',
		'type'        => 'toggle',
		'settings'    => 'manufacturing_hub_show_slider_content',
	) ) );

	for ( $manufacturing_hub_count = 1; $manufacturing_hub_count <= 4; $manufacturing_hub_count++ ) {

	// Add color scheme setting and control.
	$wp_customize->add_setting( 'manufacturing_hub_slider_page' . $manufacturing_hub_count, array(
		'default'           => '',
		'sanitize_callback' => 'manufacturing_hub_sanitize_dropdown_pages'
	) );

	$wp_customize->add_control( 'manufacturing_hub_slider_page' . $manufacturing_hub_count, array(
		'label'    => __( 'Select Slide Image Page', 'manufacturing-hub' ),
		'section'  => 'manufacturing_hub_slider_section',
		'type'     => 'dropdown-pages'
	) );

	}

	$wp_customize->add_setting('manufacturing_hub_btn_text1',array(
		'default' => __( 'Explore More', 'manufacturing-hub' ),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('manufacturing_hub_btn_text1',array(
		'label'	=> esc_html__('Change Slider Button Text','manufacturing-hub'),
		'section'=> 'manufacturing_hub_slider_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('manufacturing_hub_btn_link1',array(
		'default'=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('manufacturing_hub_btn_link1',array(
		'label'	=> esc_html__('Add Slider Button url','manufacturing-hub'),
		'section'=> 'manufacturing_hub_slider_section',
		'type'=> 'url'
	));

	$wp_customize->add_setting('manufacturing_hub_slider_short_heading',array(
		'default'=> '',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('manufacturing_hub_slider_short_heading',array(
		'label'	=> __('Add short Heading','manufacturing-hub'),
		'section'=> 'manufacturing_hub_slider_section',
		'type'=> 'text'
	));

	$categories = get_categories();
	$manufacturing_hub_offer_cat = array('select' => 'Select');

	foreach ($categories as $category) {
	    $manufacturing_hub_offer_cat[$category->slug] = $category->name;
	}

	$wp_customize->add_setting('manufacturing_hub_about_catData', array(
	    'default' => 'select',
	    'sanitize_callback' => 'manufacturing_hub_sanitize_choices',
	));
	$wp_customize->add_control('manufacturing_hub_about_catData', array(
	    'type' => 'select',
	    'choices' => $manufacturing_hub_offer_cat,
	    'label' => __('Select a category to highlight Reviewers photos', 'manufacturing-hub'),
	    'section' => 'manufacturing_hub_slider_section',
	));

	$wp_customize->add_setting('manufacturing_hub_star_rating', array(
            'default'           => '',
            'sanitize_callback' => 'sanitize_text_field',
        ));

        $wp_customize->add_control('manufacturing_hub_star_rating', array(
            'label'       => __('Add Rating', 'manufacturing-hub'),
            'section'     => 'manufacturing_hub_slider_section',
            'type'        => 'text',
            'input_attrs' => array(
                'step' => 1,
                'min'  => 0,
                'max'  => 5,
            ),
        ));

        for($manufacturing_hub_i=1;$manufacturing_hub_i<=3;$manufacturing_hub_i++) {

	    $wp_customize->add_setting('manufacturing_hub_tab_icon'.$manufacturing_hub_i,array(
			'default'	=> 'fas fa-check',
			'sanitize_callback'	=> 'sanitize_text_field'
		));
		$wp_customize->add_control(new Manufacturing_Hub_Icon_Changer(
	        $wp_customize,'manufacturing_hub_tab_icon'.$manufacturing_hub_i,array(
			'label'	=> __('About Text Icon','manufacturing-hub').$manufacturing_hub_i,
			'transport' => 'refresh',
			'section'	=> 'manufacturing_hub_slider_section',
			'type'		=> 'icon'
		)));

	    $wp_customize->add_setting('manufacturing_hub_tab_heading'.$manufacturing_hub_i,array(
	        'default'=> '',
	        'sanitize_callback' => 'sanitize_text_field'
	    ));
	    $wp_customize->add_control('manufacturing_hub_tab_heading'.$manufacturing_hub_i,array(
	        'label' => __('About Title ','manufacturing-hub').$manufacturing_hub_i,
	        'section'=> 'manufacturing_hub_slider_section',
	        'setting'=> 'manufacturing_hub_tab_heading'.$manufacturing_hub_i,
	        'type'=> 'text'
	    ));
  	}

    //Slider height
    $wp_customize->add_setting('manufacturing_hub_slider_img_height',array(
        'default'=> '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('manufacturing_hub_slider_img_height',array(
        'label' => __('Slider Height','manufacturing-hub'),
        'description'   => __('Add slider height in px(eg. 700px).','manufacturing-hub'),
        'section'=> 'manufacturing_hub_slider_section',
        'type'=> 'text'
    ));

    // Pro Version
    $wp_customize->add_setting( 'manufacturing_hub_slider_pro_version_logo', array(
        'sanitize_callback' => 'manufacturing_hub_sanitize_custom_control'
    ));
    $wp_customize->add_control( new manufacturing_hub_Customize_Pro_Version ( $wp_customize,'manufacturing_hub_slider_pro_version_logo', array(
        'section'     => 'manufacturing_hub_slider_section',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'manufacturing-hub' ),
        'description' => esc_url( MANUFACTURING_HUB_PRO_THEME_URL ),
        'priority'    => 100
    )));

	/*=========================================
	service Section
	=========================================*/
	// Service Section Settings
	$wp_customize->add_section('manufacturing_hub_service_section', array(
	  'title' => __('Our Latest BLog Section', 'manufacturing-hub'),
	  'panel' => 'manufacturing_hub_panel_id',
	  'priority' => 4,
	));

	$wp_customize->add_setting( 'manufacturing_hub_show_hide_sec', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'manufacturing_hub_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Manufacturing_Hub_Toggle_Control( $wp_customize, 'manufacturing_hub_show_hide_sec', array(
		'label'       => esc_html__( 'Show / Hide Service Section', 'manufacturing-hub' ),
		'section'     => 'manufacturing_hub_service_section',
		'type'        => 'toggle',
		'settings'    => 'manufacturing_hub_show_hide_sec',
	) ) );

	$wp_customize->add_setting('manufacturing_hub_featured_section_title', array(
	  'default' => '',
	  'sanitize_callback' => 'sanitize_text_field'
	));
	$wp_customize->add_control('manufacturing_hub_featured_section_title', array(
	  'label' => __('Add Heading', 'manufacturing-hub'),
	  'section' => 'manufacturing_hub_service_section',
	  'type' => 'text'
	));

	$wp_customize->add_setting('manufacturing_hub_product_section_btn_text1',array(
		'default'=> 'View All',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('manufacturing_hub_product_section_btn_text1',array(
		'label'	=> esc_html__('Add Button Text','manufacturing-hub'),
		'section'=> 'manufacturing_hub_service_section',
		'type'=> 'text'
	));

	$wp_customize->add_setting('manufacturing_hub_product_section_btn_link1',array(
		'default'=> '',
		'sanitize_callback'	=> 'esc_url_raw'
	));
	$wp_customize->add_control('manufacturing_hub_product_section_btn_link1',array(
		'label'	=> esc_html__('Add Button link','manufacturing-hub'),
		'section'=> 'manufacturing_hub_service_section',
		'type'=> 'url'
	));

	$categories = get_categories();
	$cats = array();
	$manufacturing_hub_i = 0;
	$manufacturing_hub_offer_cat[] = 'select';
	foreach ($categories as $category) {
	  if ($manufacturing_hub_i == 0) {
	    $default = $category->slug;
	    $manufacturing_hub_i++;
	  }
	  $manufacturing_hub_offer_cat[$category->slug] = $category->name;
	}

	$wp_customize->add_setting('manufacturing_hub_featured_section_category', array(
	  'default' => 'select',
	  'sanitize_callback' => 'manufacturing_hub_sanitize_choices',
	));
	$wp_customize->add_control('manufacturing_hub_featured_section_category', array(
	  'type' => 'select',
	  'choices' => $manufacturing_hub_offer_cat,
	  'label' => __('Select Category', 'manufacturing-hub'),
	  'section' => 'manufacturing_hub_service_section',
	));

	$wp_customize->add_setting('manufacturing_hub_num_posts', array(
	  'default' => 3,
	  'sanitize_callback' => 'absint',
	));
	$wp_customize->add_control('manufacturing_hub_num_posts', array(
	  'label' => __('Number of Posts to Show', 'manufacturing-hub'),
	  'section' => 'manufacturing_hub_service_section',
	  'type' => 'number',
	));

	// Pro Version
    $wp_customize->add_setting( 'manufacturing_hub_about_pro_version_logo', array(
        'sanitize_callback' => 'manufacturing_hub_sanitize_custom_control'
    ));
    $wp_customize->add_control( new manufacturing_hub_Customize_Pro_Version ( $wp_customize,'manufacturing_hub_about_pro_version_logo', array(
        'section'     => 'manufacturing_hub_service_section',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'manufacturing-hub' ),
        'description' => esc_url( MANUFACTURING_HUB_PRO_THEME_URL ),
    )));

	//footer
	$wp_customize->add_section('manufacturing_hub_footer_section',array(
		'title'	=> __('Footer Widget Settings','manufacturing-hub'),
		'panel' => 'manufacturing_hub_panel_id',
		'priority' => 4,
	));

	$wp_customize->add_setting('manufacturing_hub_footer_columns',array(
		'default'	=> 4,
		'sanitize_callback'	=> 'manufacturing_hub_sanitize_number_absint'
	));
	$wp_customize->add_control('manufacturing_hub_footer_columns',array(
		'label'	=> __('Footer Widget Columns','manufacturing-hub'),
		'section'	=> 'manufacturing_hub_footer_section',
		'setting'	=> 'manufacturing_hub_footer_columns',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 1,
			'max'              => 4,
		),
	));
	$wp_customize->add_setting( 'manufacturing_hub_tp_footer_bg_color_option', array(
		'default' => '#151515',
		'sanitize_callback' => 'sanitize_hex_color'
	));
	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'manufacturing_hub_tp_footer_bg_color_option', array(
		'label'     => __('Footer Widget Background Color', 'manufacturing-hub'),
		'description' => __('It will change the complete footer widget backgorund color.', 'manufacturing-hub'),
		'section' => 'manufacturing_hub_footer_section',
		'settings' => 'manufacturing_hub_tp_footer_bg_color_option',
	)));

	$wp_customize->add_setting('manufacturing_hub_footer_widget_image',array(
		'default'	=> '',
		'sanitize_callback'	=> 'esc_url_raw',
	));
	$wp_customize->add_control( new WP_Customize_Image_Control($wp_customize,'manufacturing_hub_footer_widget_image',array(
       'label' => __('Footer Widget Background Image','manufacturing-hub'),
       'section' => 'manufacturing_hub_footer_section'
	)));

	//footer widget title font size
	$wp_customize->add_setting('manufacturing_hub_footer_widget_title_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'manufacturing_hub_sanitize_number_absint'
	));
	$wp_customize->add_control('manufacturing_hub_footer_widget_title_font_size',array(
		'label'	=> __('Change Footer Widget Title Font Size in PX','manufacturing-hub'),
		'section'	=> 'manufacturing_hub_footer_section',
	    'setting'	=> 'manufacturing_hub_footer_widget_title_font_size',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	));

	$wp_customize->add_setting( 'manufacturing_hub_footer_widget_title_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'manufacturing_hub_footer_widget_title_color', array(
			'label'     => __('Change Footer Widget Title Color', 'manufacturing-hub'),
	    'section' => 'manufacturing_hub_footer_section',
	    'settings' => 'manufacturing_hub_footer_widget_title_color',
  	)));
  	
	$wp_customize->add_setting( 'manufacturing_hub_return_to_header', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'manufacturing_hub_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Manufacturing_Hub_Toggle_Control( $wp_customize, 'manufacturing_hub_return_to_header', array(
		'label'       => esc_html__( 'Show / Hide Return to header', 'manufacturing-hub' ),
		'section'     => 'manufacturing_hub_footer_section',
		'type'        => 'toggle',
		'settings'    => 'manufacturing_hub_return_to_header',
	) ) );

	$wp_customize->add_setting('manufacturing_hub_return_icon',array(
		'default'	=> 'fas fa-arrow-up',
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control(new Manufacturing_Hub_Icon_Changer(
       $wp_customize,'manufacturing_hub_return_icon',array(
		'label'	=> __('Return to header Icon','manufacturing-hub'),
		'transport' => 'refresh',
		'section'	=> 'manufacturing_hub_footer_section',
		'type'		=> 'manufacturing-hub-icon'
	)));

    // Add Settings and Controls for Scroll top
	$wp_customize->add_setting('manufacturing_hub_scroll_top_position',array(
        'default' => 'Right',
        'sanitize_callback' => 'manufacturing_hub_sanitize_choices'
	));
	$wp_customize->add_control('manufacturing_hub_scroll_top_position',array(
        'type' => 'radio',
        'label'     => __('Scroll to top Position', 'manufacturing-hub'),
        'description'   => __('This option work for scroll to top', 'manufacturing-hub'),
        'section' => 'manufacturing_hub_footer_section',
        'choices' => array(
            'Right' => __('Right','manufacturing-hub'),
            'Left' => __('Left','manufacturing-hub'),
            'Center' => __('Center','manufacturing-hub')
        ),
	) );

	// Pro Version
    $wp_customize->add_setting( 'manufacturing_hub_footer_widget_pro_version_logo', array(
        'sanitize_callback' => 'manufacturing_hub_sanitize_custom_control'
    ));
    $wp_customize->add_control( new manufacturing_hub_Customize_Pro_Version ( $wp_customize,'manufacturing_hub_footer_widget_pro_version_logo', array(
        'section'     => 'manufacturing_hub_footer_section',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'manufacturing-hub' ),
        'description' => esc_url( MANUFACTURING_HUB_PRO_THEME_URL ),
        'priority'    => 100
    )));

	//footer
	$wp_customize->add_section('manufacturing_hub_footer_copyright_section',array(
		'title'	=> __('Footer Copyright Settings','manufacturing-hub'),
		'description'	=> __('Add copyright text.','manufacturing-hub'),
		'panel' => 'manufacturing_hub_panel_id',
		'priority' => 5,
	));

	$wp_customize->add_setting('manufacturing_hub_footer_text',array(
		'default' => __( 'Manufacturing Hub WordPress Theme', 'manufacturing-hub' ),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('manufacturing_hub_footer_text',array(
		'label'	=> __('Copyright Text','manufacturing-hub'),
		'section'	=> 'manufacturing_hub_footer_copyright_section',
		'type'		=> 'text'
	));

	$wp_customize->add_setting('manufacturing_hub_footer_copyright_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'manufacturing_hub_sanitize_number_absint'
	));
	$wp_customize->add_control('manufacturing_hub_footer_copyright_font_size',array(
		'label'	=> __('Change Footer Copyright Font Size in PX','manufacturing-hub'),
		'section'	=> 'manufacturing_hub_footer_copyright_section',
	    'setting'	=> 'manufacturing_hub_footer_copyright_font_size',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	));

	$wp_customize->add_setting( 'manufacturing_hub_footer_copyright_text_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'manufacturing_hub_footer_copyright_text_color', array(
			'label'     => __('Change Footer Copyright Text Color', 'manufacturing-hub'),
	    'section' => 'manufacturing_hub_footer_copyright_section',
	    'settings' => 'manufacturing_hub_footer_copyright_text_color',
  	)));

  	$wp_customize->add_setting('manufacturing_hub_footer_copyright_top_bottom_padding',array(
		'default'	=> '',
		'sanitize_callback'	=> 'manufacturing_hub_sanitize_number_absint'
	));
	$wp_customize->add_control('manufacturing_hub_footer_copyright_top_bottom_padding',array(
		'label'	=> __('Change Footer Copyright Padding in PX','manufacturing-hub'),
		'section'	=> 'manufacturing_hub_footer_copyright_section',
	    'setting'	=> 'manufacturing_hub_footer_copyright_top_bottom_padding',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 50,
		),
	));

	// Add Settings and Controls for Scroll top
	$wp_customize->add_setting('manufacturing_hub_copyright_text_position',array(
        'default' => 'Center',
        'sanitize_callback' => 'manufacturing_hub_sanitize_choices'
	));
	$wp_customize->add_control('manufacturing_hub_copyright_text_position',array(
        'type' => 'radio',
        'label'     => __('Copyright Text Position', 'manufacturing-hub'),
        'description'   => __('This option work for Copyright', 'manufacturing-hub'),
        'section' => 'manufacturing_hub_footer_copyright_section',
        'choices' => array(
            'Right' => __('Right','manufacturing-hub'),
            'Left' => __('Left','manufacturing-hub'),
            'Center' => __('Center','manufacturing-hub')
        ),
	) );

	// Pro Version
    $wp_customize->add_setting( 'manufacturing_hub_copyright_pro_version_logo', array(
        'sanitize_callback' => 'manufacturing_hub_sanitize_custom_control'
    ));
    $wp_customize->add_control( new manufacturing_hub_Customize_Pro_Version ( $wp_customize,'manufacturing_hub_copyright_pro_version_logo', array(
        'section'     => 'manufacturing_hub_footer_copyright_section',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'manufacturing-hub' ),
        'description' => esc_url( MANUFACTURING_HUB_PRO_THEME_URL ),
        'priority'    => 100
    )));

	//Mobile resposnsive
	$wp_customize->add_section('manufacturing_hub_mobile_media_option',array(
		'title'         => __('Mobile Responsive media', 'manufacturing-hub'),
		'description' => __('Control will not function if the toggle in the main settings is off.', 'manufacturing-hub'),
		'priority' => 5,
		'panel' => 'manufacturing_hub_panel_id'
	) );

	$wp_customize->add_setting( 'manufacturing_hub_mobile_blog_description', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'manufacturing_hub_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Manufacturing_Hub_Toggle_Control( $wp_customize, 'manufacturing_hub_mobile_blog_description', array(
		'label'       => esc_html__( 'Show / Hide Blog Page Description', 'manufacturing-hub' ),
		'section'     => 'manufacturing_hub_mobile_media_option',
		'type'        => 'toggle',
		'settings'    => 'manufacturing_hub_mobile_blog_description',
	) ) );

	$wp_customize->add_setting( 'manufacturing_hub_return_to_header_mob', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'manufacturing_hub_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Manufacturing_Hub_Toggle_Control( $wp_customize, 'manufacturing_hub_return_to_header_mob', array(
		'label'       => esc_html__( 'Show / Hide Return to header', 'manufacturing-hub' ),
		'section'     => 'manufacturing_hub_mobile_media_option',
		'type'        => 'toggle',
		'settings'    => 'manufacturing_hub_return_to_header_mob',
	) ) );

	$wp_customize->add_setting( 'manufacturing_hub_slider_buttom_mob', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'manufacturing_hub_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Manufacturing_Hub_Toggle_Control( $wp_customize, 'manufacturing_hub_slider_buttom_mob', array(
		'label'       => esc_html__( 'Show / Hide Slider Button', 'manufacturing-hub' ),
		'section'     => 'manufacturing_hub_mobile_media_option',
		'type'        => 'toggle',
		'settings'    => 'manufacturing_hub_slider_buttom_mob',
	) ) );

	$wp_customize->add_setting( 'manufacturing_hub_related_post_mob', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'manufacturing_hub_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Manufacturing_Hub_Toggle_Control( $wp_customize, 'manufacturing_hub_related_post_mob', array(
		'label'       => esc_html__( 'Show / Hide Related Post', 'manufacturing-hub' ),
		'section'     => 'manufacturing_hub_mobile_media_option',
		'type'        => 'toggle',
		'settings'    => 'manufacturing_hub_related_post_mob',
	) ) );

	//Slider height
    $wp_customize->add_setting('manufacturing_hub_slider_img_height_responsive',array(
        'default'=> '',
        'sanitize_callback' => 'sanitize_text_field'
    ));
    $wp_customize->add_control('manufacturing_hub_slider_img_height_responsive',array(
        'label' => __('Slider Height','manufacturing-hub'),
        'description'   => __('Add slider height in px(eg. 700px).','manufacturing-hub'),
        'section'=> 'manufacturing_hub_mobile_media_option',
        'type'=> 'text'
    ));

	// Pro Version
    $wp_customize->add_setting( 'manufacturing_hub_responsive_pro_version_logo', array(
        'sanitize_callback' => 'manufacturing_hub_sanitize_custom_control'
    ));
    $wp_customize->add_control( new manufacturing_hub_Customize_Pro_Version ( $wp_customize,'manufacturing_hub_responsive_pro_version_logo', array(
        'section'     => 'manufacturing_hub_mobile_media_option',
        'type'        => 'pro_options',
        'label'       => esc_html__( 'Features ', 'manufacturing-hub' ),
        'description' => esc_url( MANUFACTURING_HUB_PRO_THEME_URL ),
        'priority'    => 100
    )));
	
	$wp_customize->get_setting( 'blogname' )->transport          = 'postMessage';
	$wp_customize->get_setting( 'blogdescription' )->transport   = 'postMessage';

	//site Title
	$wp_customize->selective_refresh->add_partial( 'blogname', array(
		'selector' => '.site-title a',
		'render_callback' => 'Manufacturing_Hub_Customize_partial_blogname',
	) );

	$wp_customize->selective_refresh->add_partial( 'blogdescription', array(
		'selector' => '.site-description',
		'render_callback' => 'Manufacturing_Hub_Customize_partial_blogdescription',
	) );

	$wp_customize->add_setting( 'manufacturing_hub_site_title', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'manufacturing_hub_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Manufacturing_Hub_Toggle_Control( $wp_customize, 'manufacturing_hub_site_title', array(
		'label'       => esc_html__( 'Show / Hide Site Title', 'manufacturing-hub' ),
		'section'     => 'title_tagline',
		'type'        => 'toggle',
		'settings'    => 'manufacturing_hub_site_title',
	) ) );

	// logo site title size
	$wp_customize->add_setting('manufacturing_hub_site_title_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'manufacturing_hub_sanitize_number_absint'
	));
	$wp_customize->add_control('manufacturing_hub_site_title_font_size',array(
		'label'	=> __('Site Title Font Size in PX','manufacturing-hub'),
		'section'	=> 'title_tagline',
		'setting'	=> 'manufacturing_hub_site_title_font_size',
		'type'	=> 'number',
		'input_attrs' => array(
		    'step'             => 1,
			'min'              => 0,
			'max'              => 30,
			),
	));

	$wp_customize->add_setting( 'manufacturing_hub_site_tagline_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'manufacturing_hub_site_tagline_color', array(
			'label'     => __('Change Site Title Color', 'manufacturing-hub'),
	    'section' => 'title_tagline',
	    'settings' => 'manufacturing_hub_site_tagline_color',
  	)));

	$wp_customize->add_setting( 'manufacturing_hub_site_tagline', array(
		'default'           => false,
		'transport'         => 'refresh',
		'sanitize_callback' => 'manufacturing_hub_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Manufacturing_Hub_Toggle_Control( $wp_customize, 'manufacturing_hub_site_tagline', array(
		'label'       => esc_html__( 'Show / Hide Site Tagline', 'manufacturing-hub' ),
		'section'     => 'title_tagline',
		'type'        => 'toggle',
		'settings'    => 'manufacturing_hub_site_tagline',
	) ) );

	// logo site tagline size
	$wp_customize->add_setting('manufacturing_hub_site_tagline_font_size',array(
		'default'	=> '',
		'sanitize_callback'	=> 'manufacturing_hub_sanitize_number_absint'
	));
	$wp_customize->add_control('manufacturing_hub_site_tagline_font_size',array(
		'label'	=> __('Site Tagline Font Size in PX','manufacturing-hub'),
		'section'	=> 'title_tagline',
		'setting'	=> 'manufacturing_hub_site_tagline_font_size',
		'type'	=> 'number',
		'input_attrs' => array(
			'step'             => 1,
			'min'              => 0,
			'max'              => 30,
		),
	));

	$wp_customize->add_setting( 'manufacturing_hub_logo_tagline_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'manufacturing_hub_logo_tagline_color', array(
			'label'     => __('Change Site Tagline Color', 'manufacturing-hub'),
	    'section' => 'title_tagline',
	    'settings' => 'manufacturing_hub_logo_tagline_color',
  	)));

    $wp_customize->add_setting('manufacturing_hub_logo_width',array(
	   'default' => 80,
	   'sanitize_callback'	=> 'manufacturing_hub_sanitize_number_absint'
	));
	$wp_customize->add_control('manufacturing_hub_logo_width',array(
		'label'	=> esc_html__('Here You Can Customize Your Logo Size','manufacturing-hub'),
		'section'	=> 'title_tagline',
		'type'		=> 'number'
	));

	$wp_customize->add_setting('manufacturing_hub_per_columns',array(
		'default'=> 3,
		'sanitize_callback'	=> 'manufacturing_hub_sanitize_number_absint'
	));
	$wp_customize->add_control('manufacturing_hub_per_columns',array(
		'label'	=> __('Product Per Row','manufacturing-hub'),
		'section'=> 'woocommerce_product_catalog',
		'type'=> 'number'
	));

	$wp_customize->add_setting('manufacturing_hub_product_per_page',array(
		'default'=> 9,
		'sanitize_callback'	=> 'manufacturing_hub_sanitize_number_absint'
	));
	$wp_customize->add_control('manufacturing_hub_product_per_page',array(
		'label'	=> __('Product Per Page','manufacturing-hub'),
		'section'=> 'woocommerce_product_catalog',
		'type'=> 'number'
	));

	$wp_customize->add_setting( 'manufacturing_hub_product_sidebar', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'manufacturing_hub_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Manufacturing_Hub_Toggle_Control( $wp_customize, 'manufacturing_hub_product_sidebar', array(
		'label'       => esc_html__( 'Show / Hide Shop Page Sidebar', 'manufacturing-hub' ),
		'section'     => 'woocommerce_product_catalog',
		'type'        => 'toggle',
		'settings'    => 'manufacturing_hub_product_sidebar',
	) ) );
	$wp_customize->add_setting('manufacturing_hub_sale_tag_position',array(
        'default' => 'right',
        'sanitize_callback' => 'manufacturing_hub_sanitize_choices'
	));
	$wp_customize->add_control('manufacturing_hub_sale_tag_position',array(
        'type' => 'radio',
        'label'     => __('Sale Badge Position', 'manufacturing-hub'),
        'description'   => __('This option work for Archieve Products', 'manufacturing-hub'),
        'section' => 'woocommerce_product_catalog',
        'choices' => array(
            'left' => __('Left','manufacturing-hub'),
            'right' => __('Right','manufacturing-hub'),
        ),
	) );
	$wp_customize->add_setting( 'manufacturing_hub_single_product_sidebar', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'manufacturing_hub_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Manufacturing_Hub_Toggle_Control( $wp_customize, 'manufacturing_hub_single_product_sidebar', array(
		'label'       => esc_html__( 'Show / Hide Product Page Sidebar', 'manufacturing-hub' ),
		'section'     => 'woocommerce_product_catalog',
		'type'        => 'toggle',
		'settings'    => 'manufacturing_hub_single_product_sidebar',
	) ) );

	$wp_customize->add_setting( 'manufacturing_hub_related_product', array(
		'default'           => true,
		'transport'         => 'refresh',
		'sanitize_callback' => 'manufacturing_hub_sanitize_checkbox',
	) );
	$wp_customize->add_control( new Manufacturing_Hub_Toggle_Control( $wp_customize, 'manufacturing_hub_related_product', array(
		'label'       => esc_html__( 'Show / Hide related product', 'manufacturing-hub' ),
		'section'     => 'woocommerce_product_catalog',
		'type'        => 'toggle',
		'settings'    => 'manufacturing_hub_related_product',
	) ) );

	
	//Page template settings
	$wp_customize->add_panel( 'manufacturing_hub_page_panel_id', array(
	    'priority' => 10,
	    'capability' => 'edit_theme_options',
	    'theme_supports' => '',
	    'title' => __( 'Page Template Settings', 'manufacturing-hub' ),
	    'description' => __( 'Description of what this panel does.', 'manufacturing-hub' ),
	) );

	// 404 PAGE
	$wp_customize->add_section('manufacturing_hub_404_page_section',array(
		'title'         => __('404 Page', 'manufacturing-hub'),
		'description'   => __('Here you can customize 404 Page content.', 'manufacturing-hub'),
		'panel' => 'manufacturing_hub_page_panel_id'
	) );

	$wp_customize->add_setting('manufacturing_hub_edit_404_title',array(
		'default'=> __('Oops! That page cant be found.','manufacturing-hub'),
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control('manufacturing_hub_edit_404_title',array(
		'label'	=> __('Edit Title','manufacturing-hub'),
		'section'=> 'manufacturing_hub_404_page_section',
		'type'=> 'text',
	));

	$wp_customize->add_setting('manufacturing_hub_edit_404_text',array(
		'default'=> __('It looks like nothing was found at this location. Maybe try a search?','manufacturing-hub'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('manufacturing_hub_edit_404_text',array(
		'label'	=> __('Edit Text','manufacturing-hub'),
		'section'=> 'manufacturing_hub_404_page_section',
		'type'=> 'text'
	));

	// Search Results
	$wp_customize->add_section('manufacturing_hub_no_result_section',array(
		'title'         => __('Search Results', 'manufacturing-hub'),
		'description'  => __('Here you can customize Search Result content.', 'manufacturing-hub'),
		'panel' => 'manufacturing_hub_page_panel_id'
	) );

	$wp_customize->add_setting('manufacturing_hub_edit_no_result_title',array(
		'default'=> __('Nothing Found','manufacturing-hub'),
		'sanitize_callback'	=> 'sanitize_text_field',
	));
	$wp_customize->add_control('manufacturing_hub_edit_no_result_title',array(
		'label'	=> __('Edit Title','manufacturing-hub'),
		'section'=> 'manufacturing_hub_no_result_section',
		'type'=> 'text',
	));

	$wp_customize->add_setting('manufacturing_hub_edit_no_result_text',array(
		'default'=> __('Sorry, but nothing matched your search terms. Please try again with some different keywords.','manufacturing-hub'),
		'sanitize_callback'	=> 'sanitize_text_field'
	));
	$wp_customize->add_control('manufacturing_hub_edit_no_result_text',array(
		'label'	=> __('Edit Text','manufacturing-hub'),
		'section'=> 'manufacturing_hub_no_result_section',
		'type'=> 'text'
	));

	 // Header Image Height
    $wp_customize->add_setting(
        'manufacturing_hub_header_image_height',
        array(
            'default'           => 500,
            'sanitize_callback' => 'absint',
        )
    );
    $wp_customize->add_control(
        'manufacturing_hub_header_image_height',
        array(
            'label'       => esc_html__( 'Header Image Height', 'manufacturing-hub' ),
            'section'     => 'header_image',
            'type'        => 'number',
            'description' => esc_html__( 'Control the height of the header image. Default is 350px.', 'manufacturing-hub' ),
            'input_attrs' => array(
                'min'  => 220,
                'max'  => 1000,
                'step' => 1,
            ),
        )
    );

    // Header Background Position
    $wp_customize->add_setting(
        'manufacturing_hub_header_background_position',
        array(
            'default'           => 'center',
            'sanitize_callback' => 'sanitize_text_field',
        )
    );
    $wp_customize->add_control(
        'manufacturing_hub_header_background_position',
        array(
            'label'       => esc_html__( 'Header Background Position', 'manufacturing-hub' ),
            'section'     => 'header_image',
            'type'        => 'select',
            'choices'     => array(
                'top'    => esc_html__( 'Top', 'manufacturing-hub' ),
                'center' => esc_html__( 'Center', 'manufacturing-hub' ),
                'bottom' => esc_html__( 'Bottom', 'manufacturing-hub' ),
            ),
            'description' => esc_html__( 'Choose how you want to position the header image.', 'manufacturing-hub' ),
        )
    );

    // Header Image Parallax Effect
    $wp_customize->add_setting(
        'manufacturing_hub_header_background_attachment',
        array(
            'default'           => 1,
            'sanitize_callback' => 'absint',
        )
    );
    $wp_customize->add_control(
        'manufacturing_hub_header_background_attachment',
        array(
            'label'       => esc_html__( 'Header Image Parallax', 'manufacturing-hub' ),
            'section'     => 'header_image',
            'type'        => 'checkbox',
            'description' => esc_html__( 'Add a parallax effect on page scroll.', 'manufacturing-hub' ),
        )
    );

        //Opacity
	$wp_customize->add_setting('manufacturing_hub_header_banner_opacity_color',array(
       'default'              => '0.5',
       'sanitize_callback' => 'manufacturing_hub_sanitize_choices'
	));
    $wp_customize->add_control( 'manufacturing_hub_header_banner_opacity_color', array(
		'label'       => esc_html__( 'Header Image Opacity','manufacturing-hub' ),
		'section'     => 'header_image',
		'type'        => 'select',
		'settings'    => 'manufacturing_hub_header_banner_opacity_color',
		'choices' => array(
           '0' =>  esc_attr(__('0','manufacturing-hub')),
           '0.1' =>  esc_attr(__('0.1','manufacturing-hub')),
           '0.2' =>  esc_attr(__('0.2','manufacturing-hub')),
           '0.3' =>  esc_attr(__('0.3','manufacturing-hub')),
           '0.4' =>  esc_attr(__('0.4','manufacturing-hub')),
           '0.5' =>  esc_attr(__('0.5','manufacturing-hub')),
           '0.6' =>  esc_attr(__('0.6','manufacturing-hub')),
           '0.7' =>  esc_attr(__('0.7','manufacturing-hub')),
           '0.8' =>  esc_attr(__('0.8','manufacturing-hub')),
           '0.9' =>  esc_attr(__('0.9','manufacturing-hub'))
		), 
	) );

   $wp_customize->add_setting( 'manufacturing_hub_header_banner_image_overlay', array(
	    'default'   => true,
	    'transport' => 'refresh',
	    'sanitize_callback' => 'manufacturing_hub_sanitize_checkbox',
	));
	$wp_customize->add_control( new Manufacturing_Hub_Toggle_Control( $wp_customize, 'manufacturing_hub_header_banner_image_overlay', array(
	    'label'   => esc_html__( 'Show / Hide Header Image Overlay', 'manufacturing-hub' ),
	    'section' => 'header_image',
	)));

    $wp_customize->add_setting('manufacturing_hub_header_banner_image_ooverlay_color', array(
		'default'           => '#000',
		'sanitize_callback' => 'sanitize_hex_color',
	));
	$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'manufacturing_hub_header_banner_image_ooverlay_color', array(
		'label'    => __('Header Image Overlay Color', 'manufacturing-hub'),
		'section'  => 'header_image',
	)));

    $wp_customize->add_setting(
        'manufacturing_hub_header_image_title_font_size',
        array(
            'default'           => 40,
            'sanitize_callback' => 'absint',
        )
    );
    $wp_customize->add_control(
        'manufacturing_hub_header_image_title_font_size',
        array(
            'label'       => esc_html__( 'Change Header Image Title Font Size', 'manufacturing-hub' ),
            'section'     => 'header_image',
            'type'        => 'number',
            'description' => esc_html__( 'Control the font Size of the header image title. Default is 40px.', 'manufacturing-hub' ),
            'input_attrs' => array(
                'min'  => 10,
                'max'  => 200,
                'step' => 1,
            ),
        )
    );

	$wp_customize->add_setting( 'manufacturing_hub_header_image_title_text_color', array(
	    'default' => '',
	    'sanitize_callback' => 'sanitize_hex_color'
  	));
  	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'manufacturing_hub_header_image_title_text_color', array(
			'label'     => __('Change Header Image Title Color', 'manufacturing-hub'),
	    'section' => 'header_image',
	    'settings' => 'manufacturing_hub_header_image_title_text_color',
  	)));

}
add_action( 'customize_register', 'manufacturing_hub_customize_register' );

/**
 * Render the site title for the selective refresh partial.
 *
 * @since Manufacturing Hub 1.0
 * @see manufacturing_hub_customize_register()
 *
 * @return void
 */
function Manufacturing_Hub_Customize_partial_blogname() {
	bloginfo( 'name' );
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @since Manufacturing Hub 1.0
 * @see manufacturing_hub_customize_register()
 *
 * @return void
 */
function Manufacturing_Hub_Customize_partial_blogdescription() {
	bloginfo( 'description' );
}

if ( ! defined( 'MANUFACTURING_HUB_PRO_THEME_NAME' ) ) {
	define( 'MANUFACTURING_HUB_PRO_THEME_NAME', esc_html__( 'Manufacturing Hub Pro', 'manufacturing-hub'));
}
if ( ! defined( 'MANUFACTURING_HUB_PRO_THEME_URL' ) ) {
	define( 'MANUFACTURING_HUB_PRO_THEME_URL', esc_url('https://www.themespride.com/products/manufacturing-wordpress-theme', 'manufacturing-hub'));
}

if ( ! defined( 'MANUFACTURING_HUB_DOCS_URL' ) ) {
	define( 'MANUFACTURING_HUB_DOCS_URL', esc_url('https://page.themespride.com/demo/docs/manufacturing-hub-lite/'));
}
if ( ! defined( 'MANUFACTURING_HUB_TEXT' ) ) {
    define( 'MANUFACTURING_HUB_TEXT', __( 'Manufacturing Hub Pro','manufacturing-hub' ));
}
if ( ! defined( 'MANUFACTURING_HUB_BUY_TEXT' ) ) {
    define( 'MANUFACTURING_HUB_BUY_TEXT', __( 'Upgrade Pro','manufacturing-hub' ));
}


add_action( 'customize_register', function( $manager ) {

// Load custom sections.
load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

    $manager->register_section_type( Manufacturing_Hub_Button::class );

    $manager->add_section(
        new Manufacturing_Hub_Button( $manager, 'manufacturing_hub_pro', [
            'title'       => esc_html( MANUFACTURING_HUB_TEXT,'manufacturing-hub' ),
            'priority'    => 0,
            'button_text' => __( 'GET PREMIUM', 'manufacturing-hub' ),
            'button_url'  => esc_url( MANUFACTURING_HUB_PRO_THEME_URL )
        ] )
    );

} );

/**
 * Singleton class for handling the theme's customizer integration.
 *
 * @since  1.0.0
 * @access public
 */
final class Manufacturing_Hub_Customize {

	/**
	 * Returns the instance.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return object
	 */
	public static function get_instance() {

		static $instance = null;

		if ( is_null( $instance ) ) {
			$instance = new self;
			$instance->setup_actions();
		}

		return $instance;
	}

	/**
	 * Constructor method.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function __construct() {}

	/**
	 * Sets up initial actions.
	 *
	 * @since  1.0.0
	 * @access private
	 * @return void
	 */
	private function setup_actions() {

		// Register panels, sections, settings, controls, and partials.
		add_action( 'customize_register', array( $this, 'sections' ) );

		// Register scripts and styles for the controls.
		add_action( 'customize_controls_enqueue_scripts', array( $this, 'enqueue_control_scripts' ), 0 );
	}

	/**
	 * Sets up the customizer sections.
	 *
	 * @since  1.0.0
	 * @access public
	 * @param  object  $manager
	 * @return void
	 */
	public function sections( $manager ) {

		// Load custom sections.
		load_template( trailingslashit( get_template_directory() ) . '/inc/section-pro.php' );

		// Register custom section types.
		$manager->register_section_type( 'Manufacturing_Hub_Customize_Section_Pro' );

		// Register sections.
		$manager->add_section(
			new Manufacturing_Hub_Customize_Section_Pro(
				$manager,
				'manufacturing_hub_section_pro',
				array(
					'priority'   => 9,
					'title'    => MANUFACTURING_HUB_PRO_THEME_NAME,
					'pro_text' => esc_html__( 'Upgrade Pro', 'manufacturing-hub' ),
					'pro_url'  => esc_url( MANUFACTURING_HUB_PRO_THEME_URL, 'manufacturing-hub' ),
				)
			)
		);

		// Register sections.
		$manager->add_section(
			new manufacturing_hub_Customize_Section_Pro(
				$manager,
				'manufacturing_hub_documentation',
				array(
					'priority'   => 500,
					'title'    => esc_html__( 'Theme Documentation', 'manufacturing-hub' ),
					'pro_text' => esc_html__( 'Click Here', 'manufacturing-hub' ),
					'pro_url'  => esc_url( MANUFACTURING_HUB_DOCS_URL, 'manufacturing-hub'),
				)
			)
		);

	}
	/**
	 * Loads theme customizer CSS.
	 *
	 * @since  1.0.0
	 * @access public
	 * @return void
	 */
	public function enqueue_control_scripts() {

		wp_enqueue_script( 'manufacturing-hub-customize-controls', trailingslashit( esc_url( get_template_directory_uri() ) ) . '/assets/js/customize-controls.js', array( 'customize-controls' ) );

		wp_enqueue_style( 'manufacturing-hub-customize-controls', trailingslashit( esc_url( get_template_directory_uri() ) ) . '/assets/css/customize-controls.css' );
	}
}

// Doing this customizer thang!
Manufacturing_Hub_Customize::get_instance();