( function( window, document ) {
  function manufacturing_hub_keepFocusInMenu() {
    document.addEventListener( 'keydown', function( e ) {
      const manufacturing_hub_nav = document.querySelector( '.sidenav' );
      if ( ! manufacturing_hub_nav || ! manufacturing_hub_nav.classList.contains( 'open' ) ) {
        return;
      }
      const elements = [...manufacturing_hub_nav.querySelectorAll( 'input, a, button' )],
        manufacturing_hub_lastEl = elements[ elements.length - 1 ],
        manufacturing_hub_firstEl = elements[0],
        manufacturing_hub_activeEl = document.activeElement,
        tabKey = e.keyCode === 9,
        shiftKey = e.shiftKey;
      if ( ! shiftKey && tabKey && manufacturing_hub_lastEl === manufacturing_hub_activeEl ) {
        e.preventDefault();
        manufacturing_hub_firstEl.focus();
      }
      if ( shiftKey && tabKey && manufacturing_hub_firstEl === manufacturing_hub_activeEl ) {
        e.preventDefault();
        manufacturing_hub_lastEl.focus();
      }
    } );
  }
  manufacturing_hub_keepFocusInMenu();
} )( window, document );