jQuery(document).ready(function ($) {

    // Preloader
    jQuery('#preloader').delay(1500).fadeOut();
    jQuery('#loader').delay(1500).fadeOut("slow");

    // Scroll to Top Button
    if ($('.go-to-top').length) {
        var scrollTrigger = $('body').position(); // px
        var goToTop = function () {
            var scrollTop = $(window).scrollTop();
            if (scrollTop > 150) {
                $('.footer-go-to-top').addClass('show');
            } else {
                $('.footer-go-to-top').removeClass('show');
            }
        };
        goToTop();
        $(window).on('scroll', function () {
            goToTop();
        });
        $('.go-to-top').on('click', function (e) {
            e.preventDefault();
            $('html, body').animate({
                scrollTop: scrollTrigger.top
            }, 700);
        });
    }

    // Mobile Menu Focus
    $(window).resize(local_business_directory_navTrapp);

    function local_business_directory_navTrapp() {
        var width = $(window).width();
        if (width < 992) {
            $('.main-navigation').on('keydown', function (e) {
                if ($('.main-navigation').hasClass('toggled')) {
                    var focusableEls = $('.main-navigation a[href]:not([disabled]), .main-navigation button');
                    var firstFocusableEl = focusableEls[0];
                    var lastFocusableEl = focusableEls[focusableEls.length - 1];
                    var KEYCODE_TAB = 9;
                    var KEYCODE_ESC = 27;
                    if (e.key === 'Tab' || e.keyCode === KEYCODE_TAB) {
                        if (e.shiftKey) { // shift + tab
                            if (document.activeElement === firstFocusableEl) {
                                lastFocusableEl.focus();
                                e.preventDefault();
                            }
                        } else { // tab
                            if (document.activeElement === lastFocusableEl) {
                                firstFocusableEl.focus();
                                e.preventDefault();
                            }
                        }
                    }
                    if (e.keyCode === KEYCODE_ESC) {
                        $('.main-navigation').removeClass('toggled');
                        return;
                    }
                }
            });
        }
    }

    local_business_directory_navTrapp();

    $('#slider-section .owl-carousel').owlCarousel({
        loop: true,
        margin: 30,
        nav: false,
        dots: false,
        autoplay: false,
        responsive: {
            0: {
                items: 1
            },
            768: {
                items: 1
            },
            1000: {
                items: 1
            }
        }
    });

});

jQuery(document).ready(function($) {
  $('.offer-carousel').owlCarousel({
    loop: true,
    margin: 18,
    nav: false,
    dots: false,
    responsive: {
      0: {
        items: 1
      },
      768: {
        items: 2
      },
      1024: {
        items: 3
      }
    }
  });
});

// dropdown category
jQuery(document).ready(function(){
    // Show/hide the category dropdown
    jQuery(".category-btn").click(function(e){
        e.preventDefault();
        jQuery(".category-dropdown").toggle();
    });

    // Set the hidden input value based on the selected category
    jQuery(".category-dropdown a").click(function(e){
        e.preventDefault();
        var categoryId = jQuery(this).data("id");
        jQuery("#categoryInput").val(categoryId);
        jQuery(".category-btn").text(jQuery(this).text() + ' ').append('<i class="fas fa-chevron-down ps-5"></i>');
        jQuery(".category-dropdown").hide();
    });

    // Handle focus using Tab and Shift+Tab
    jQuery(".category-btn, .category-dropdown").on("keydown", function(e) {
        var dropdownItems = jQuery(".category-dropdown").find("a");
        
        if (e.keyCode === 9) { // Tab key
            if (!e.shiftKey && document.activeElement === dropdownItems.last().get(0)) {
                e.preventDefault();
                jQuery(".category-btn").focus();
            } else if (e.shiftKey && document.activeElement === dropdownItems.first().get(0)) {
                e.preventDefault();
                jQuery(".category-btn").focus();
            }
        }
    });

    // Submit the form when the search button is clicked
    jQuery("#searchButton").click(function(e){
        e.preventDefault();
        jQuery("#searchForm").submit();
    });
});