<?php
/**
 * Local Business Directory functions and definitions
 *
 * @package Local Business Directory
 */

if ( ! defined( 'LOCAL_BUSINESS_DIRECTORY_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( 'LOCAL_BUSINESS_DIRECTORY_VERSION', '1.0.0' );
}

function local_business_directory_setup() {

	add_theme_support( 'automatic-feed-links' );
	add_theme_support( 'title-tag' );
	add_theme_support( 'post-thumbnails' );
	add_theme_support( 'woocommerce' );
	add_theme_support( "align-wide" );
	add_theme_support( "responsive-embeds" );

	register_nav_menus(
		array(
			'menu-1' => esc_html__( 'Primary', 'local-business-directory' ),
			'social-menu' => esc_html__('Social Menu', 'local-business-directory'),
		)
	);

	add_theme_support(
		'html5',
		array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
			'style',
			'script',
		)
	);

	add_theme_support(
		'custom-background',
		apply_filters(
			'local_business_directory_custom_background_args',
			array(
				'default-color' => '#fafafa',
				'default-image' => '',
			)
		)
	);

	add_theme_support( 'customize-selective-refresh-widgets' );

	add_theme_support(
		'custom-logo',
		array(
			'height'      => 250,
			'width'       => 250,
			'flex-width'  => true,
			'flex-height' => true,
		)
	);

	add_theme_support( 'post-formats', array(
        'image',
        'video',
        'gallery',
        'audio', 
    ));
	
}
add_action( 'after_setup_theme', 'local_business_directory_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $local_business_directory_content_width
 */
function local_business_directory_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'local_business_directory_content_width', 640 );
}
add_action( 'after_setup_theme', 'local_business_directory_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function local_business_directory_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'local-business-directory' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'local-business-directory' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer 1', 'local-business-directory' ),
			'id'            => 'footer-1',
			'description'   => esc_html__( 'Add widgets here.', 'local-business-directory' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer 2', 'local-business-directory' ),
			'id'            => 'footer-2',
			'description'   => esc_html__( 'Add widgets here.', 'local-business-directory' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'Footer 3', 'local-business-directory' ),
			'id'            => 'footer-3',
			'description'   => esc_html__( 'Add widgets here.', 'local-business-directory' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);
}
add_action( 'widgets_init', 'local_business_directory_widgets_init' );


function local_business_directory_social_menu()
    {
        if (has_nav_menu('social-menu')) :
            wp_nav_menu(array(
                'theme_location' => 'social-menu',
                'container' => 'ul',
                'menu_class' => 'social-menu menu',
                'menu_id'  => 'menu-social',
            ));
        endif;
    }

/**
 * Enqueue scripts and styles.
 */

function local_business_directory_scripts() {
    // Google Fonts
    $query_args = array(
	    'family' => 'Archivo:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900',
	    'display' => 'swap',
	);
	wp_enqueue_style('local-business-directory-google-fonts', add_query_arg($query_args, 'https://fonts.googleapis.com/css2'), array(), null);


    // Font Awesome CSS
    wp_enqueue_style('font-awesome-5', get_template_directory_uri() . '/revolution/assets/vendors/font-awesome-5/css/all.min.css', array(), '5.15.3');

    // Owl Carousel CSS
    wp_enqueue_style('owl-carousel-style', get_template_directory_uri() . '/revolution/assets/css/owl.carousel.css', array(), wp_get_theme()->get('Version'));

    // Main stylesheet
    wp_enqueue_style('local-business-directory-style', get_stylesheet_uri(), array(), wp_get_theme()->get('Version'));

    // Add custom inline styles
    require get_parent_theme_file_path('/custom-style.php');
	wp_add_inline_style('local-business-directory-style', $local_business_directory_custom_css);

    // RTL styles if needed
    if (file_exists(get_stylesheet_directory() . '/rtl.css')) {
        wp_style_add_data('local-business-directory-style', 'rtl', 'replace');
    }

    // Navigation script
    wp_enqueue_script('local-business-directory-navigation', get_template_directory_uri() . '/js/navigation.js', array(), wp_get_theme()->get('Version'), true);

    // Owl Carousel script
    wp_enqueue_script('owl-carousel-jquery', get_template_directory_uri() . '/revolution/assets/js/owl.carousel.js', array('jquery'), wp_get_theme()->get('Version'), true);

    // Custom script
    wp_enqueue_script('local-business-directory-custom-js', get_template_directory_uri() . '/revolution/assets/js/custom.js', array('jquery'), wp_get_theme()->get('Version'), true);

    // Comments reply script
    if (is_singular() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }
}
add_action('wp_enqueue_scripts', 'local_business_directory_scripts');

if (!function_exists('local_business_directory_related_post')) :
    /**
     * Display related posts from same category
     *
     */

    function local_business_directory_related_post($post_id){        
        $local_business_directory_categories = get_the_category($post_id);
        if ($local_business_directory_categories) {
            $local_business_directory_category_ids = array();
            $local_business_directory_category = get_category($local_business_directory_category_ids);
            $local_business_directory_categories = get_the_category($post_id);
            foreach ($local_business_directory_categories as $local_business_directory_category) {
                $local_business_directory_category_ids[] = $local_business_directory_category->term_id;
            }
            $local_business_directory_count = $local_business_directory_category->category_count;
            if ($local_business_directory_count > 1) { ?>

         	<?php
		$local_business_directory_related_post_wrap = absint(get_theme_mod('local_business_directory_enable_related_post', 1));
		if($local_business_directory_related_post_wrap == 1){ ?>
                <div class="related-post">
                    
                    <h2 class="post-title"><?php esc_html_e(get_theme_mod('local_business_directory_related_post_text', __('Related Post', 'local-business-directory'))); ?></h2>
                    <?php
                    $local_business_directory_cat_post_args = array(
                        'category__in' => $local_business_directory_category_ids,
                        'post__not_in' => array($post_id),
                        'post_type' => 'post',
                        'posts_per_page' =>  get_theme_mod( 'local_business_directory_related_post_count', '3' ),
                        'post_status' => 'publish',
                        'orderby'           => 'rand',
                        'ignore_sticky_posts' => true
                    );
                    $local_business_directory_featured_query = new WP_Query($local_business_directory_cat_post_args);
                    ?>
                    <div class="rel-post-wrap">
                        <?php
                        if ($local_business_directory_featured_query->have_posts()) :

                        while ($local_business_directory_featured_query->have_posts()) : $local_business_directory_featured_query->the_post();
                            ?>
                            <div class="card-item rel-card-item">
								<div class="card-content">
                                    <?php if ( has_post_thumbnail() ) { ?>
                                        <div class="card-media">
                                            <?php local_business_directory_post_thumbnail(); ?>
                                        </div>
                                    <?php } else {
                                        // Fallback default image
                                        $local_business_directory_default_post_thumbnail = get_template_directory_uri() . '/revolution/assets/images/slider.png';
                                        echo '<img class="default-post-img" src="' . esc_url( $local_business_directory_default_post_thumbnail ) . '" alt="' . esc_attr( get_the_title() ) . '">';
                                    } ?>
									<div class="entry-title">
										<h3>
											<a href="<?php the_permalink() ?>">
												<?php the_title(); ?>
											</a>
										</h3>
									</div>
									<div class="entry-meta">
                                        <?php
                                        local_business_directory_posted_on();
                                        local_business_directory_posted_by();
                                        ?>
                                    </div>
								</div>
							</div>
                        <?php
                        endwhile;
                        ?>
                <?php
                endif;
                wp_reset_postdata();
                ?>
                </div>
                <?php } ?>
                <?php
            }
        }
    }
endif;
add_action('local_business_directory_related_posts', 'local_business_directory_related_post', 10, 1);

/**
 * Checkbox sanitization callback example.
 *
 * Sanitization callback for 'checkbox' type controls. This callback sanitizes `$local_business_directory_checked`
 * as a boolean value, either TRUE or FALSE.
 */
function local_business_directory_sanitize_checkbox($local_business_directory_checked)
{
    // Boolean check.
    return ((isset($local_business_directory_checked) && true == $local_business_directory_checked) ? true : false);
}

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/revolution/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/revolution/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/revolution/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/revolution/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/revolution/inc/jetpack.php';
}

/**
 * Breadcrumb File.
 */
require get_template_directory() . '/revolution/inc/breadcrumbs.php';

/**
 * Custom typography options for this theme.
 */
require get_template_directory() . '/revolution/inc/typography-options.php';

function local_business_directory_remove_customize_register() {
    global $wp_customize;

    $wp_customize->remove_setting( 'display_header_text' );
    $wp_customize->remove_control( 'display_header_text' );

}

add_action( 'customize_register', 'local_business_directory_remove_customize_register', 11 );

/************************************************************************************/

/**
 * WooCommerce custom filters
 */
add_filter('loop_shop_columns', 'local_business_directory_loop_columns');

if (!function_exists('local_business_directory_loop_columns')) {

	function local_business_directory_loop_columns() {

		$local_business_directory_columns = get_theme_mod( 'local_business_directory_per_columns', 3 );

		return $local_business_directory_columns;
	}
}

/************************************************************************************/

add_filter( 'loop_shop_per_page', 'local_business_directory_per_page', 20 );

function local_business_directory_per_page( $local_business_directory_cols ) {

  	$local_business_directory_cols = get_theme_mod( 'local_business_directory_product_per_page', 9 );

	return $local_business_directory_cols;
}

/************************************************************************************/

add_filter( 'woocommerce_output_related_products_args', 'local_business_directory_products_args' );

function local_business_directory_products_args( $local_business_directory_args ) {

    $local_business_directory_args['posts_per_page'] = get_theme_mod( 'custom_related_products_number', 6 );

    $local_business_directory_args['columns'] = get_theme_mod( 'custom_related_products_number_per_row', 3 );

    return $local_business_directory_args;
}

/************************************************************************************/

/**
 * Custom logo
 */

function local_business_directory_custom_css() {
?>
	<style type="text/css" id="custom-theme-colors" >
        :root {
           
            --local_business_directory_logo_width: <?php echo absint(get_theme_mod('local_business_directory_logo_width')); ?> ;   
        }
        .site-branding img {
            max-width:<?php echo esc_html(get_theme_mod('local_business_directory_logo_width')); ?>px ;    
        }         
	</style>
<?php
}
add_action( 'wp_head', 'local_business_directory_custom_css' );

function local_business_directory_sanitize_choices( $local_business_directory_input, $local_business_directory_setting ) {
    global $wp_customize; 
    $local_business_directory_control = $wp_customize->get_control( $local_business_directory_setting->id ); 
    if ( array_key_exists( $local_business_directory_input, $local_business_directory_control->choices ) ) {
        return $local_business_directory_input;
    } else {
        return $local_business_directory_setting->default;
    }
}

function local_business_directory_sanitize_phone_number( $local_business_directory_phone ) {
	return preg_replace( '/[^\d+]/', '', $local_business_directory_phone );
}

//Excerpt 
function local_business_directory_excerpt_function($local_business_directory_excerpt_count = 35) {
    $local_business_directory_excerpt = get_the_excerpt();
    $local_business_directory_text_excerpt = wp_strip_all_tags($local_business_directory_excerpt);
    $local_business_directory_excerpt_limit = (int) get_theme_mod('local_business_directory_excerpt_limit', $local_business_directory_excerpt_count);
    $local_business_directory_words = preg_split('/\s+/', $local_business_directory_text_excerpt); 
    $local_business_directory_trimmed_words = array_slice($local_business_directory_words, 0, $local_business_directory_excerpt_limit);
    $local_business_directory_theme_excerpt = implode(' ', $local_business_directory_trimmed_words);

    return $local_business_directory_theme_excerpt;
}


//////////////////////////////////////////////   Function for Translation Error   //////////////////////////////////////////////////////
function local_business_directory_enqueue_function() {

    /**
    * GET START.
    */
    require get_template_directory() . '/getstarted/local_business_directory_about_page.php';

    /**
    * DEMO IMPORT.
    */
    require get_template_directory() . '/demo-import/local_business_directory_config_file.php';

    define('LOCAL_BUSINESS_DIRECTORY_FREE_SUPPORT',__('https://www.revolutionwp.com/products/local-business-directory','local-business-directory'));
    define('LOCAL_BUSINESS_DIRECTORY_PRO_SUPPORT',__('https://www.revolutionwp.com/support/revolution-wp/','local-business-directory'));
    define('LOCAL_BUSINESS_DIRECTORY_REVIEW',__('https://wordpress.org/support/theme/local-business-directory/reviews/','local-business-directory'));
    define('LOCAL_BUSINESS_DIRECTORY_BUY_NOW',__('https://www.revolutionwp.com/products/business-directory-wordpress-theme','local-business-directory'));
    define('LOCAL_BUSINESS_DIRECTORY_LIVE_DEMO',__('https://demo.revolutionwp.com/local-business-directory-pro/','local-business-directory'));
    define('LOCAL_BUSINESS_DIRECTORY_PRO_DOC',__('https://demo.revolutionwp.com/wpdocs/local-business-directory-pro/','local-business-directory'));
    define('LOCAL_BUSINESS_DIRECTORY_LITE_DOC',__('https://demo.revolutionwp.com/wpdocs/local-business-directory-free/','local-business-directory'));
    
}
add_action( 'after_setup_theme', 'local_business_directory_enqueue_function' );



// Add admin notice
function local_business_directory_admin_notice() { 
    global $pagenow;
    $local_business_directory_theme_args      = wp_get_theme();
    $local_business_directory_meta            = get_option( 'local_business_directory_admin_notice' );
    $name            = $local_business_directory_theme_args->__get( 'Name' );
    $local_business_directory_current_screen  = get_current_screen();

    if( !$local_business_directory_meta ){
        if( is_network_admin() ){
            return;
        }

        if( ! current_user_can( 'manage_options' ) ){
            return;
        } 
        
        if( $local_business_directory_current_screen->base !== 'appearance_page_local_business_directory_guide' && 
            $local_business_directory_current_screen->base !== 'toplevel_page_localbusinessdirectory-demoimport' ) { ?>

            <div class="notice notice-success local-business-directory-welcome-notice">
                <p class="local-business-directory-dismiss-link">
                    <strong>
                        <a href="<?php echo esc_url( add_query_arg( 'local_business_directory_admin_notice', '1' ) ); ?>">
                            <?php esc_html_e( 'Dismiss', 'local-business-directory' ); ?>
                        </a>
                    </strong>
                </p>

                <div class="local-business-directory-welcome-notice-wrap">
                    <h2 class="local-business-directory-notice-title">
                        <span class="dashicons dashicons-admin-home"></span> 
                        <?php 
                            $local_business_directory_theme_name = wp_get_theme()->get( 'Name' );
                            /* translators: %s!: Theme Name. */
                            echo esc_html( sprintf( __( 'Welcome to the free theme: %s!', 'local-business-directory' ), $local_business_directory_theme_name ) );
                        ?>
                    </h2>
                    <p class="local-business-directory-notice-desc">
                        <?php esc_html_e( 'Get started by exploring the features of your new theme. Customize your design, add your content, and create a site that fits your vision.', 'local-business-directory' ); ?>
                    </p>

                    <div class="local-business-directory-welcome-info">
                        <div class="local-business-directory-welcome-thumb">
                            <img src="<?php echo esc_url( get_stylesheet_directory_uri() . '/screenshot.png' ); ?>" alt="<?php esc_attr_e( 'Theme Screenshot', 'local-business-directory' ); ?>">
                        </div>

                        <div class="local-business-directory-welcome-import">
                            <h3><span class="dashicons dashicons-download"></span> <?php esc_html_e( 'Quick Start: Import Demo', 'local-business-directory' ); ?></h3>
                            <p><?php esc_html_e( 'Use the Demo Importer to quickly set up your site with a pre-made layout. Get a complete site in minutes.', 'local-business-directory' ); ?></p>
                            <p><a class="button info-link button-primary" href="<?php echo esc_url( admin_url( 'themes.php?page=localbusinessdirectory-demoimport' ) ); ?>"><?php esc_html_e( 'Go to Demo Importer', 'local-business-directory' ); ?></a></p>
                        </div>

                        <div class="local-business-directory-welcome-getting-started">
                            <h3><span class="dashicons dashicons-art"></span> <?php esc_html_e( 'Customize Your Theme', 'local-business-directory' ); ?></h3>
                            <p><?php esc_html_e( 'Want to make it truly yours? Explore the Getting Started Guide to personalize your site to suit your needs.', 'local-business-directory' ); ?></p>
                            <p><a class="info-link button" href="<?php echo esc_url( admin_url( 'themes.php?page=local-business-directory-getstart-page' ) ); ?>"><?php esc_html_e( 'View Getting Started Guide', 'local-business-directory' ); ?></a></p>
                        </div>
                    </div>
                </div>
            </div>

            <?php
        }

    }
}

add_action( 'admin_notices', 'local_business_directory_admin_notice' );

if( ! function_exists( 'local_business_directory_update_admin_notice' ) ) :
/**
 * Updating admin notice on dismiss
*/
function local_business_directory_update_admin_notice(){
    if ( isset( $_GET['local_business_directory_admin_notice'] ) && $_GET['local_business_directory_admin_notice'] = '1' ) {
        update_option( 'local_business_directory_admin_notice', true );
    }
}
endif;
add_action( 'admin_init', 'local_business_directory_update_admin_notice' );

add_action('after_switch_theme', 'local_business_directory_setup_options');
function local_business_directory_setup_options () {
    update_option('local_business_directory_admin_notice', FALSE );
}

// changelog
function local_business_directory_get_changelog_from_readme() {
    $file_path = get_template_directory() . '/readme.txt'; // Adjust path if necessary

    if (file_exists($file_path)) {
        $content = file_get_contents($file_path);

        // Extract changelog section
        $changelog_start = strpos($content, "== Changelog ==");
        $changelog = substr($content, $changelog_start);

        // Split changelog into versions
        preg_match_all('/\*\s([\d\.]+)\s-\s(.+?)\n((?:\t-\s.+?\n)+)/', $changelog, $matches, PREG_SET_ORDER);
        
        return $matches;
    }
    return [];
}

add_filter( 'woocommerce_enable_setup_wizard', '__return_false' );