<?php
    $mustread_title       = iconic_blog_get_option( 'mustread_title' );
    $mustread_subtitle       = iconic_blog_get_option( 'mustread_subtitle' );
    $mustread_content_type     = iconic_blog_get_option( 'mustread_content_type' );
    $enable_category     = iconic_blog_get_option( 'mustread_category_enable' );
    $enable_content     = iconic_blog_get_option( 'mustread_content_enable' );
    $enable_author     = iconic_blog_get_option( 'mustread_author_enable' );
    $enable_posted_on     = iconic_blog_get_option( 'mustread_posted_on_enable' );
    $number_of_mustread_items  = iconic_blog_get_option( 'number_of_mustread_items' );
    $mustread_category = iconic_blog_get_option( 'mustread_category' );
    $header_font_size = iconic_blog_get_option( 'mustread_font_size');
    $number_of_mustread_column = iconic_blog_get_option('number_of_mustread_column');
    $content_align = iconic_blog_get_option('mustread_content_align');
    $excerpt_length =iconic_blog_get_option( 'mustread_excerpt_length');
    $homepage_layout_options =iconic_blog_get_option( 'homepage_design_layout_options');

    $see_more_txt     = iconic_blog_get_option( 'mustread_see_all_txt' );
    $see_more_url     = iconic_blog_get_option( 'mustread_see_all_url' );

    for( $i=1; $i<=$number_of_mustread_items; $i++ ) :
        $mustread_page_posts[] = absint(iconic_blog_get_option( 'mustread_page_'.$i ) );
        $mustread_post_posts[] = absint(iconic_blog_get_option( 'mustread_post_'.$i ) );
    endfor;

?>
<style>
    <?php if ($header_font_size != 0): ?>
        #mustread .section-title{
            font-size:<?php echo esc_attr($header_font_size); ?>px;
        }
    <?php endif ?>
</style>
<?php if(!empty($mustread_title) ):?>
    <div class="section-header">
        <?php if (!empty($mustread_title)): ?>
            <div class="section-inner-header">
                <h2 class="section-title"><?php echo esc_html($mustread_title);?></h2>
            </div>
            <?php if (!empty($see_more_txt) && !empty($see_more_url)): ?>
                <div class="section-header-btn">
                    <a class="see-all" href="<?php echo esc_url($see_more_url) ?>"><?php echo esc_html($see_more_txt); ?></a>
                </div>
            <?php endif ?>
        <?php endif; ?>
    </div>       
<?php endif;?>  

<div class="must-read-wrapper clear col-<?php echo esc_attr($number_of_mustread_column); ?> ">
    <?php 
            $args = array (
                'post_type'     => 'post',
                'post_per_page' => count( $mustread_post_posts ),
                'post__in'      => $mustread_post_posts,
                'orderby'       =>'post__in', 
                'ignore_sticky_posts' => true, 
            ); 
        $loop = new WP_Query($args);                        
        if ( $loop->have_posts() ) :
            $i=0;  
            while ($loop->have_posts()) : $loop->the_post(); $i++;?>        
                <article>
                    <div class="mustread-item-wrapper solid-border">
                        <?php if (has_post_thumbnail()) : ?>
                            <div class="post-featured-image">
                                <div class="featured-image post-bg-image" style="background-image: url('<?php the_post_thumbnail_url( 'blog-thumbnails');?>');">
                                    <a href="<?php the_permalink();?>" class="post-thumbnail-link"></a>
                                    <?php $homepage_video_url = get_post_meta( get_the_ID(), 'iconic-blog-video-url', true ); ?>
                                    <?php if (!empty($homepage_video_url)): ?>
                                       <a href="<?php the_permalink();?>"> <div class="homepage-video-icon"><i class="fa fa-play"></i></div></a>
                                    <?php endif ?>
                                </div><!-- .featured-image -->
                            </div>
                        <?php endif; ?>
                        <div class="entry-container <?php echo esc_attr($content_align); ?>">
                            <div class="inner-container">
                                <?php if ( ($mustread_content_type !== 'mustread_page') && ($enable_category==true) ) : ?>
                                    <div class="entry-meta">
                                        <?php iconic_blog_entry_meta(); ?>
                                    </div><!-- .entry-meta -->
                                <?php endif; ?>
                                <header class="entry-header">
                                    <h2 class="entry-title"><a href="<?php the_permalink();?>"><?php the_title();?></a></h2>
                                </header>
                                <?php if (($enable_posted_on==true) || ($enable_author==true)) : ?>
                                    <div class="entry-meta">
                                        <?php 
                                            if (($enable_posted_on==true)) {
                                                iconic_blog_posted_on();
                                            } 
                                            if (($enable_author==true)) {
                                                iconic_blog_author();
                                            }
                                         ?>
                                    </div><!-- .entry-meta -->
                                <?php endif; ?>
                                <?php if (($enable_content==true)) : ?>
                                    <div class="entry-content">
                                        <?php 
                                            $excerpt = iconic_blog_the_excerpt( $excerpt_length );
                                            echo wp_kses_post( wpautop( $excerpt ) );
                                        ?>
                                    </div><!-- .entry-content -->
                                <?php endif; ?> 
                            </div> 
                        </div><!-- .entry-container -->
                    </div>
                </article>

            <?php endwhile;?>
        <?php endif; ?>
        <?php wp_reset_postdata(); ?>
</div>