<?php
/**
 * Iconic Blog metabox file.
 *
 * This is the template that includes all the other files for metaboxes of Iconic Blog theme
 *
 * @package Iconic Blog
 * @since Iconic Blog 0.1
 */
// Include Post subtitle meta
require get_template_directory() . '/inc/metabox/video-url.php'; 


if ( ! function_exists( 'iconic_blog_custom_meta' ) ) : 
    /**
     * Adds meta box to the post editing screen
     */
    function iconic_blog_custom_meta() {
        $post_type = array( 'post', 'page' );

        // POST Subtitle 
        add_meta_box( 'iconic_blog_video_url', esc_html__( 'Video Links', 'iconic-blog' ), 'iconic_blog_video_url_callback', $post_type, 'side' );
               
    }
endif;
add_action( 'add_meta_boxes', 'iconic_blog_custom_meta' );



