<?php 

/**
 * Theme Options.
 *
 * @package Iconic Blog
 */

$default = iconic_blog_get_default_theme_options();
//For General Option
$wp_customize->add_section('site_layouts', array(    
'title'       => __('Site Layout', 'iconic-blog'),
'panel'       => 'theme_option_panel'    
));

//Layout Options for Blog
$wp_customize->add_setting('theme_options[site_layout_theme_options]', 
	array(
	'default' 			=> $default['site_layout_theme_options'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'iconic_blog_sanitize_select'
	)
);

$wp_customize->add_control(new Iconic_Blog_Image_Radio_Control($wp_customize, 'theme_options[site_layout_theme_options]', 
	array(		
	'label' 	=> __('Layout Option For Site', 'iconic-blog'),
	'section' 	=> 'site_layouts',
	'settings'  => 'theme_options[site_layout_theme_options]',
	'type' 		=> 'radio-image',
	'choices' 	=> array(		
		'default-site-layout' 	=> get_template_directory_uri() . '/assets/images/default-layout.png',						
		'boxed-layout' 	=> get_template_directory_uri() . '/assets/images/boxed.png',
		),	
	))
);
 ?>