<?php
/**
 * Catgeory Design Options.
 *
 * @package Iconic Blog
 */

$default = iconic_blog_get_default_theme_options();

// Catgeory Design Options
$wp_customize->add_section( 'section_home_category_design',
	array(
		'title'      => __( 'Catgeory Design', 'iconic-blog' ),
		'capability' => 'edit_theme_options',
		'panel'      => 'theme_option_panel',
		)
);
$wp_customize->add_setting('theme_options[category_design_content_type]', 
	array(
	'default' 			=> $default['category_design_content_type'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'iconic_blog_sanitize_select'
	)
);

$wp_customize->add_control('theme_options[category_design_content_type]', 
	array(
	'label'       => __('Category Design Options', 'iconic-blog'),
	'section'     => 'section_home_category_design',   
	'settings'    => 'theme_options[category_design_content_type]',		
	'type'        => 'select',
	'choices'	  => array(
			'category-one'	  => __('No Background','iconic-blog'),
			'category-two'	  => __('Theme Color Background','iconic-blog'),
		),
	)
);

// Add category icon enable setting and control.
$wp_customize->add_setting( 'theme_options[enable_category_icon]', array(
	'default'           => $default['enable_category_icon'],
	'sanitize_callback' => 'iconic_blog_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[enable_category_icon]', array(
	'label'             => esc_html__( 'Enable Category Icon', 'iconic-blog' ),
	'section'           => 'section_home_category_design',
	'type'              => 'checkbox',

) );