<?php
/**
 * Catgeory Design Options.
 *
 * @package Iconic Blog
 */

$default = iconic_blog_get_default_theme_options();

// Catgeory Design Options
$wp_customize->add_section( 'theme_options_animation',
	array(
		'title'      => __( 'Animation', 'iconic-blog' ),
		'capability' => 'edit_theme_options',
		'panel'      => 'theme_option_panel',
		)
);
// Add category icon enable setting and control.
$wp_customize->add_setting( 'theme_options[enable_animation]', array(
	'default'           => $default['enable_animation'],
	'sanitize_callback' => 'iconic_blog_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[enable_animation]', array(
	'label'             => esc_html__( 'Enable Animation', 'iconic-blog' ),
	'section'           => 'theme_options_animation',
	'type'              => 'checkbox',

) );

// Lite/Dark Setting.
$wp_customize->add_setting( 'theme_options[animation_slide_type]', array(
	'default'           => $default['animation_slide_type'],
	'sanitize_callback' => 'iconic_blog_sanitize_select',
) );

$wp_customize->add_control( 'theme_options[animation_slide_type]', array(
	'label'             => esc_html__( 'Choose Animation Type', 'iconic-blog' ),
	'section'           => 'theme_options_animation',
	'type'              => 'radio',
	'choices'				=> array( 
		'animation-b-t'     => esc_html__( 'Buttom To Top Slide', 'iconic-blog' ), 
		)
) );

