<?php
/**
 * Category List options.
 *
 * @package Iconic Blog
 */

$default = iconic_blog_get_default_theme_options();
$homepage_design_layout     = iconic_blog_get_option( 'homepage_design_layout_options' );

// Category List Author Section
$wp_customize->add_section( 'section_home_catlist',
	array(
		'title'      => __( 'Category List', 'iconic-blog' ),
		'capability' => 'edit_theme_options',
		'panel'      => 'home_page_panel',
		)
);

$wp_customize->add_setting( 'theme_options[disable_catlist_section]',
	array(
		'default'           => $default['disable_catlist_section'],
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'iconic_blog_sanitize_switch_control',
	)
);
$wp_customize->add_control( new Iconic_Blog_Switch_Control( $wp_customize, 'theme_options[disable_catlist_section]',
    array(
		'label' 			=> __('Enable/Disable Category List Section', 'iconic-blog'),
		'section'    		=> 'section_home_catlist',
		'settings'  		=> 'theme_options[disable_catlist_section]',
		'on_off_label' 		=> iconic_blog_switch_options(),
    )
) );

//Catlist Section title
$wp_customize->add_setting('theme_options[catlist_title]', 
	array(
	'default'           => $default['catlist_title'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control('theme_options[catlist_title]', 
	array(
	'label'       => __('Section Title', 'iconic-blog'),
	'section'     => 'section_home_catlist',   
	'settings'    => 'theme_options[catlist_title]',
	'active_callback' => 'iconic_blog_catlist_active',		
	'type'        => 'text'
	)
);

	
// Setting  Team Category.
$wp_customize->add_setting( 'theme_options[catlist_category]',
	array(

	'capability'        => 'edit_theme_options',
	'sanitize_callback' => 'iconic_blog_sanitize_category_list',
	)
);
$wp_customize->add_control(
	new Iconic_Blog_Dropdown_Multiple_Chooser( $wp_customize, 'theme_options[catlist_category]',
		array(
		'label'    => __( 'Select Categories', 'iconic-blog' ),
		'description' => __('Press Ctrl and select categories for multiple categories', 'iconic-blog'),
		'section'  => 'section_home_catlist',
		'settings' => 'theme_options[catlist_category]',
		'type'           	=> 'dropdown_multiple_chooser',
		'choices'  => iconic_blog_category_choices(),
		'active_callback' => 'iconic_blog_catlist_active',		
		)
	)
);

