<?php
/**
 * The template for displaying archive pages
 *
 * @link https://codex.wordpress.org/Template_Hierarchy
 *
 * @package Iconic Blog
 */

get_header(); 
$iconic_blog_latest_post_column = iconic_blog_get_option( 'number_of_latest_posts_column' );
$iconic_blog_layout_content_type = iconic_blog_get_option( 'blog_layout_content_type' );?>
	<div class="wrapper page-section">
		<div id="primary" class="content-area clear">
			<main id="main" class="site-main blog-posts-wrapper" role="main">
				<div id="infinite-post-wrap" class="
					<?php if($iconic_blog_layout_content_type == 'blog-one'|| $iconic_blog_layout_content_type == 'blog-five') { ?>
						col-<?php echo esc_attr($iconic_blog_latest_post_column) ?>
			 			<?php if(($iconic_blog_latest_post_column > 1) && $iconic_blog_layout_content_type == 'blog-one') { ?> 
			 				grid 
			 			<?php }
			 		} elseif($iconic_blog_layout_content_type == 'blog-two'|| $iconic_blog_layout_content_type == 'blog-three'|| $iconic_blog_layout_content_type == 'blog-four'){ ?> 
			 			col-1 
			 		<?php } elseif($iconic_blog_layout_content_type == 'blog-six'){ ?> 
			 			col-2
			 		<?php } elseif($iconic_blog_layout_content_type == 'blog-seven'){ ?> 
			 			grid
			 		<?php } ?>
				">

					<?php
					if ( have_posts() ) : 
						/* Start the Loop */
						while ( have_posts() ) : the_post();

							/*
							 * Include the Post-Format-specific template for the content.
							 * If you want to override this in a child theme, then include a file
							 * called content-___.php (where ___ is the Post Format name) and that will be used instead.
							 */
							get_template_part( 'template-parts/content', get_post_format() );

						endwhile;
					else :

						get_template_part( 'template-parts/content', 'none' );

					endif; ?>
				</div>
			<?php
				/**
			* Hook - iconic_blog_pagination_action.
			*
			* @hooked iconic_blog_pagination 
			*/
			 do_action('iconic_blog_pagination_action');
			// the_posts_navigation(); ?>
			</main><!-- #main -->
		</div><!-- #primary -->

		<?php get_sidebar(); ?>
	</div><!-- .wrapper/.page-section-->
<?php get_footer();