<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package ello-photographer-services
 */

?>

<!-- footer -->
<div class="footer-height"></div>
    <footer class="site-footer">
        <div class="container">
            <!-- display text -->
            <h3 class="title-logo"><?php bloginfo( 'name' ); ?></h3>
            <div class="footer-cotact-info">
            <?php $footer_adress = get_theme_mod( 'ello_footer_adress', '<span>address: </span> Beverly Hills, Los Angeles CA, USA' ); ?>
            <?php $footer_phone = get_theme_mod( 'ello_footer_phone', '<span>phone: </span> +(123) 456 789' ); ?>
            <?php $footer_email = get_theme_mod( 'ello_footer_email', sprintf( __( '<span>e-mail: </span>%s', 'ello-photographer-services' ), 'info@thedomain.com' ) ); ?>
               <p><?php echo wp_kses_post( $footer_adress ); ?></p>
               <p><?php echo wp_kses_post( $footer_phone ); ?></p>
               <p><?php echo wp_kses_post( $footer_email ); ?></p> 
           
            </div>
            <div class="line"></div>
          <!-- Footer Social Icons --> 
        <?php do_action( 'ellolite_social' ); ?>
        </div>
        <div class="copyright">
    <?php
    $ello_copyright = get_theme_mod('ello_copyright', sprintf( __('2025 - <span>%s</span> ALL RIGHTS RESERVED.', 'ello-photographer-services'), get_bloginfo('name')));
    ?>
    <p>
        <?php echo wp_kses_post( $ello_copyright ); ?> | <?php echo esc_html__( 'WORDPRESS THEME', 'ello-photographer-services' ); ?>  
        <a href="https://pixelonetry.com/downloads/ello-photographer-services-wordpress-theme/">
            <span><?php echo esc_html__('ELLO PHOTOGRAPHER SERVICES', 'ello-photographer-services'); ?></span> 
        </a> <?php echo esc_html__( 'BY', 'ello-photographer-services' ); ?> |
        <a href="https://pixelonetry.com/">
            <span><?php echo esc_html__('PIXELONETRY', 'ello-photographer-services'); ?></span>
        </a> |
        <a href="<?php echo esc_url( __( 'https://wordpress.org/', 'ello-photographer-services' ) ); ?>">
            <span>
                <?php
                /* translators: %s: CMS name, i.e. WordPress. */
                printf( esc_html__( 'PROUDLY POWERED BY %s', 'ello-photographer-services' ), 'WORDPRESS' );
                ?>
            </span>
        </a>
    </p>
</div>
    </footer>

<?php wp_footer(); ?>

</body>
</html>
