<?php
/**
 * Getting Started Page.
 *
 * @package electrical_repair
 */


if( ! function_exists( 'electrical_repair_getting_started_menu' ) ) :
/**
 * Adding Getting Started Page in admin menu
 */
function electrical_repair_getting_started_menu(){	
	add_theme_page(
		__( 'Getting Started', 'electrical-repair' ),
		__( 'Getting Started', 'electrical-repair' ),
		'manage_options',
		'electrical-repair-getting-started',
		'electrical_repair_getting_started_page'
	);
}
endif;
add_action( 'admin_menu', 'electrical_repair_getting_started_menu' );

if( ! function_exists( 'electrical_repair_getting_started_admin_scripts' ) ) :
/**
 * Load Getting Started styles in the admin
 */
function electrical_repair_getting_started_admin_scripts( $hook ){
	// Load styles only on our page
	if( 'appearance_page_electrical-repair-getting-started' != $hook ) return;

    wp_enqueue_style( 'electrical-repair-getting-started', get_template_directory_uri() . '/resource/css/getting-started.css', false, ELECTRICAL_REPAIR_THEME_VERSION );

    wp_enqueue_script( 'electrical-repair-getting-started', get_template_directory_uri() . '/resource/js/getting-started.js', array( 'jquery' ), ELECTRICAL_REPAIR_THEME_VERSION, true );
}
endif;
add_action( 'admin_enqueue_scripts', 'electrical_repair_getting_started_admin_scripts' );

if( ! function_exists( 'electrical_repair_getting_started_page' ) ) :
/**
 * Callback function for admin page.
*/
function electrical_repair_getting_started_page(){ 
	$electrical_repair_theme = wp_get_theme();?>
	<div class="wrap getting-started">
		<div class="intro-wrap">
			<div class="intro cointaner">
				<div class="intro-content">
					<h3><?php echo esc_html( 'Welcome to', 'electrical-repair' );?> <span class="theme-name"><?php echo esc_html( ELECTRICAL_REPAIR_THEME_NAME ); ?></span></h3>
					<p class="about-text">
						<?php
						// Remove last sentence of description.
						$electrical_repair_description = explode( '. ', $electrical_repair_theme->get( 'Description' ) );

						$electrical_repair_description = implode( '. ', $electrical_repair_description );

						echo esc_html( $electrical_repair_description . '' );
					?></p>
					<div class="btns-getstart">
						<a href="<?php echo esc_url( admin_url( 'customize.php' ) ); ?>"target="_blank" class="button button-primary"><?php esc_html_e( 'Customize', 'electrical-repair' ); ?></a>
						<a class="button button-primary" href="<?php echo esc_url( 'https://wordpress.org/support/theme/electrical-repair/reviews/' ); ?>" title="<?php esc_attr_e( 'Visit the Review', 'electrical-repair' ); ?>" target="_blank">
							<?php esc_html_e( 'Review', 'electrical-repair' ); ?>
						</a>
						<a class="button button-primary" href="<?php echo esc_url( 'https://wordpress.org/support/theme/electrical-repair' ); ?>" title="<?php esc_attr_e( 'Visit the Support', 'electrical-repair' ); ?>" target="_blank">
							<?php esc_html_e( 'Contact Support', 'electrical-repair' ); ?>
						</a>
					</div>
					<div class="btns-wizard">
						<a class="wizard" href="<?php echo esc_url( admin_url( 'themes.php?page=electricalrepair-wizard' ) ); ?>"target="_blank" class="button button-primary"><?php esc_html_e( 'One Click Demo Setup', 'electrical-repair' ); ?></a>
					</div>
				</div>
				<div class="intro-img">
					<img src="<?php echo esc_url(get_template_directory_uri()) .'/screenshot.png'; ?>" />
				</div>
				
			</div>
		</div>

		<div class="cointaner panels">
			<ul class="inline-list">
				<li class="current">
                    <a id="help" href="javascript:void(0);">
                        <?php esc_html_e( 'Getting Started', 'electrical-repair' ); ?>
                    </a>
                </li>
				<li>
                    <a id="free-pro-panel" href="javascript:void(0);">
                        <?php esc_html_e( 'Free Vs Pro', 'electrical-repair' ); ?>
                    </a>
                </li>
			</ul>
			<div id="panel" class="panel">
				<?php require get_template_directory() . '/theme-library/getting-started/tabs/help-panel.php'; ?>
				<?php require get_template_directory() . '/theme-library/getting-started/tabs/free-vs-pro-panel.php'; ?>
				<?php require get_template_directory() . '/theme-library/getting-started/tabs/link-panel.php'; ?>
			</div>
		</div>
	</div>
	<?php
}
endif;