<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package electrical_repair
 */

function electrical_repair_body_classes( $electrical_repair_classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$electrical_repair_classes[] = 'hfeed';
	}

	// Adds a class of no-sidebar when there is no sidebar present.
	if ( ! is_active_sidebar( 'sidebar-1' ) ) {
		$electrical_repair_classes[] = 'no-sidebar';
	}

	$electrical_repair_classes[] = electrical_repair_sidebar_layout();

	return $electrical_repair_classes;
}
add_filter( 'body_class', 'electrical_repair_body_classes' );

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function electrical_repair_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
	}
}
add_action( 'wp_head', 'electrical_repair_pingback_header' );


/**
 * Get all posts for customizer Post content type.
 */
function electrical_repair_get_post_choices() {
	$electrical_repair_choices = array( '' => esc_html__( '--Select--', 'electrical-repair' ) );
	$electrical_repair_args    = array( 'numberposts' => -1 );
	$electrical_repair_posts   = get_posts( $electrical_repair_args );

	foreach ( $electrical_repair_posts as $electrical_repair_post ) {
		$electrical_repair_id             = $electrical_repair_post->ID;
		$electrical_repair_title          = $electrical_repair_post->post_title;
		$electrical_repair_choices[ $electrical_repair_id ] = $electrical_repair_title;
	}

	return $electrical_repair_choices;
}
/**
 * Get all pages for customizer Page content type.
 */
function electrical_repair_get_page_choices() {
	$electrical_repair_choices = array( '' => esc_html__( '--Select--', 'electrical-repair' ) );
	$electrical_repair_pages   = get_pages();

	foreach ( $electrical_repair_pages as $electrical_repair_page ) {
		$electrical_repair_choices[ $electrical_repair_page->ID ] = $electrical_repair_page->post_title;
	}

	return $electrical_repair_choices;
}

if ( ! function_exists( 'electrical_repair_excerpt_length' ) ) :
	/**
	 * Excerpt length.
	 */
	function electrical_repair_excerpt_length( $electrical_repair_length ) {
		if ( is_admin() ) {
			return $electrical_repair_length;
		}

		return get_theme_mod( 'electrical_repair_excerpt_length', 20 );
	}
endif;
add_filter( 'excerpt_length', 'electrical_repair_excerpt_length', 999 );

if ( ! function_exists( 'electrical_repair_excerpt_more' ) ) :
	/**
	 * Excerpt more.
	 */
	function electrical_repair_excerpt_more( $electrical_repair_more ) {
		if ( is_admin() ) {
			return $electrical_repair_more;
		}

		return '&hellip;';
	}
endif;
add_filter( 'excerpt_more', 'electrical_repair_excerpt_more' );

if ( ! function_exists( 'electrical_repair_sidebar_layout' ) ) {
	/**
	 * Get sidebar layout.
	 */
	function electrical_repair_sidebar_layout() {
		$electrical_repair_sidebar_position      = get_theme_mod( 'electrical_repair_sidebar_position', 'right-sidebar' );
		$electrical_repair_sidebar_position_page = get_theme_mod( 'electrical_repair_page_sidebar_position', 'right-sidebar' );

		if ( is_page() ) {
			$electrical_repair_sidebar_position = $electrical_repair_sidebar_position_page;
		}

		return $electrical_repair_sidebar_position;
	}
}

if ( ! function_exists( 'electrical_repair_is_sidebar_enabled' ) ) {
	/**
	 * Check if sidebar is enabled.
	 */
	function electrical_repair_is_sidebar_enabled() {
		$electrical_repair_sidebar_position      = get_theme_mod( 'electrical_repair_sidebar_position', 'right-sidebar' );
		$electrical_repair_sidebar_position_page = get_theme_mod( 'electrical_repair_page_sidebar_position', 'right-sidebar' );

		$electrical_repair_sidebar_enabled = true;
		if ( is_home() || is_archive() || is_search() ) {
			if ( 'no-sidebar' === $electrical_repair_sidebar_position ) {
				$electrical_repair_sidebar_enabled = false;
			}
		} elseif ( is_page() ) {
			if ( 'no-sidebar' === $electrical_repair_sidebar_position || 'no-sidebar' === $electrical_repair_sidebar_position_page ) {
				$electrical_repair_sidebar_enabled = false;
			}
		}
		return $electrical_repair_sidebar_enabled;
	}
}

if ( ! function_exists( 'electrical_repair_get_homepage_sections ' ) ) {
	/**
	 * Returns homepage sections.
	 */
	function electrical_repair_get_homepage_sections() {
		$electrical_repair_sections = array(
			'banner'  => esc_html__( 'Banner Section', 'electrical-repair' ),
			'product' => esc_html__( 'Product Section', 'electrical-repair' ),
		);
		return $electrical_repair_sections;
	}
}

/**
 * Renders customizer section link
 */
function electrical_repair_section_link( $electrical_repair_section_id ) {
	$electrical_repair_section_name      = str_replace( 'electrical_repair_', ' ', $electrical_repair_section_id );
	$electrical_repair_section_name      = str_replace( '_', ' ', $electrical_repair_section_name );
	$electrical_repair_starting_notation = '#';
	?>
	<span class="section-link">
		<span class="section-link-title"><?php echo esc_html( $electrical_repair_section_name ); ?></span>
	</span>
	<style type="text/css">
		<?php echo $electrical_repair_starting_notation . $electrical_repair_section_id; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>:hover .section-link {
			visibility: visible;
		}
	</style>
	<?php
}

/**
 * Adds customizer section link css
 */
function electrical_repair_section_link_css() {
	if ( is_customize_preview() ) {
		?>
		<style type="text/css">
			.section-link {
				visibility: hidden;
				background-color: black;
				position: relative;
				top: 80px;
				z-index: 99;
				left: 40px;
				color: #fff;
				text-align: center;
				font-size: 20px;
				border-radius: 10px;
				padding: 20px 10px;
				text-transform: capitalize;
			}

			.section-link-title {
				padding: 0 10px;
			}

			.banner-section {
				position: relative;
			}

			.banner-section .section-link {
				position: absolute;
				top: 100px;
			}
		</style>
		<?php
	}
}
add_action( 'wp_head', 'electrical_repair_section_link_css' );

/**
 * Breadcrumb.
 */
function electrical_repair_breadcrumb( $electrical_repair_args = array() ) {
	if ( ! get_theme_mod( 'electrical_repair_enable_breadcrumb', true ) ) {
		return;
	}

	$electrical_repair_args = array(
		'show_on_front' => false,
		'show_title'    => true,
		'show_browse'   => false,
	);
	breadcrumb_trail( $electrical_repair_args );
}
add_action( 'electrical_repair_breadcrumb', 'electrical_repair_breadcrumb', 10 );

/**
 * Add separator for breadcrumb trail.
 */
function electrical_repair_breadcrumb_trail_print_styles() {
	$electrical_repair_breadcrumb_separator = get_theme_mod( 'electrical_repair_breadcrumb_separator', '/' );

	$electrical_repair_style = '
		.trail-items li::after {
			content: "' . $electrical_repair_breadcrumb_separator . '";
		}'; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped

	$electrical_repair_style = apply_filters( 'electrical_repair_breadcrumb_trail_inline_style', trim( str_replace( array( "\r", "\n", "\t", '  ' ), '', $electrical_repair_style ) ) );

	if ( $electrical_repair_style ) {
		echo "\n" . '<style type="text/css" id="breadcrumb-trail-css">' . $electrical_repair_style . '</style>' . "\n"; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	}
}
add_action( 'wp_head', 'electrical_repair_breadcrumb_trail_print_styles' );

/**
 * Pagination for archive.
 */
function electrical_repair_render_posts_pagination() {
	$electrical_repair_is_pagination_enabled = get_theme_mod( 'electrical_repair_enable_pagination', true );
	if ( $electrical_repair_is_pagination_enabled ) {
		$electrical_repair_pagination_type = get_theme_mod( 'electrical_repair_pagination_type', 'default' );
		if ( 'default' === $electrical_repair_pagination_type ) :
			the_posts_navigation();
		else :
			the_posts_pagination();
		endif;
	}
}
add_action( 'electrical_repair_posts_pagination', 'electrical_repair_render_posts_pagination', 10 );

/**
 * Pagination for single post.
 */
function electrical_repair_render_post_navigation() {
	the_post_navigation(
		array(
			'prev_text' => '<span>&#10229;</span> <span class="nav-title">%title</span>',
			'next_text' => '<span class="nav-title">%title</span> <span>&#10230;</span>',
		)
	);
}
add_action( 'electrical_repair_post_navigation', 'electrical_repair_render_post_navigation' );

/**
 * Adds footer copyright text.
 */
function electrical_repair_output_footer_copyright_content() {
    $electrical_repair_theme_data = wp_get_theme();
    $electrical_repair_copyright_text = get_theme_mod('electrical_repair_footer_copyright_text');

	if (!empty($electrical_repair_copyright_text)) {
        $electrical_repair_text = $electrical_repair_copyright_text;
    } else {

		$electrical_repair_default_text = '<a href="'. esc_url(__('https://asterthemes.com/products/electrical-repair','electrical-repair')) . '" target="_blank"> ' . esc_html($electrical_repair_theme_data->get('Name')) . '</a>' . '&nbsp;' . esc_html__('by', 'electrical-repair') . '&nbsp;<a target="_blank" href="' . esc_url($electrical_repair_theme_data->get('AuthorURI')) . '">' . esc_html(ucwords($electrical_repair_theme_data->get('Author'))) . '</a>';
		/* translators: %s: WordPress.org URL */
        $electrical_repair_default_text .= sprintf(esc_html__(' | Powered by %s', 'electrical-repair'), '<a href="' . esc_url(__('https://wordpress.org/', 'electrical-repair')) . '" target="_blank">WordPress</a>. ');

        $electrical_repair_text = $electrical_repair_default_text;

    }
    ?>
    <span><?php echo wp_kses_post($electrical_repair_text); ?></span>
    <?php
}
add_action('electrical_repair_footer_copyright', 'electrical_repair_output_footer_copyright_content');

/* Footer Social Icons */ 
function electrical_repair_footer_social_links() {

    if ( get_theme_mod('electrical_repair_enable_footer_icon_section', true) ) {

            ?>
            <div class="socialicons">
                <?php if ( get_theme_mod('electrical_repair_footer_facebook_link', 'https://www.facebook.com/') != '' ) { ?>
                    <a target="_blank" href="<?php echo esc_url(get_theme_mod('electrical_repair_footer_facebook_link', 'https://www.facebook.com/')); ?>">
                        <i class="<?php echo esc_attr(get_theme_mod('electrical_repair_facebook_icon', 'fab fa-facebook-f')); ?>"></i>
                        <span class="screen-reader-text"><?php esc_html_e('Facebook', 'electrical-repair'); ?></span>
                    </a>
                <?php } ?>
                <?php if ( get_theme_mod('electrical_repair_footer_twitter_link', 'https://x.com/') != '' ) { ?>
                    <a target="_blank" href="<?php echo esc_url(get_theme_mod('electrical_repair_footer_twitter_link', 'https://x.com/')); ?>">
                        <i class="<?php echo esc_attr(get_theme_mod('electrical_repair_twitter_icon', 'fab fa-twitter')); ?>"></i>
                        <span class="screen-reader-text"><?php esc_html_e('Twitter', 'electrical-repair'); ?></span>
                    </a>
                <?php } ?>
				<?php if ( get_theme_mod('electrical_repair_footer_instagram_link', 'https://www.instagram.com/') != '' ) { ?>
                    <a target="_blank" href="<?php echo esc_url(get_theme_mod('electrical_repair_footer_instagram_link', 'https://www.instagram.com/')); ?>">
                        <i class="<?php echo esc_attr(get_theme_mod('electrical_repair_instagram_icon', 'fab fa-instagram')); ?>"></i>
                        <span class="screen-reader-text"><?php esc_html_e('Instagram', 'electrical-repair'); ?></span>
                    </a>
                <?php } ?>
                <?php if ( get_theme_mod('electrical_repair_footer_linkedin_link', 'https://in.linkedin.com/') != '' ) { ?>
                    <a target="_blank" href="<?php echo esc_url(get_theme_mod('electrical_repair_footer_linkedin_link', 'https://in.linkedin.com/')); ?>">
                        <i class="<?php echo esc_attr(get_theme_mod('electrical_repair_linkedin_icon', 'fab fa-linkedin')); ?>"></i>
                        <span class="screen-reader-text"><?php esc_html_e('Linkedin', 'electrical-repair'); ?></span>
                    </a>
                <?php } ?>
				<?php if ( get_theme_mod('electrical_repair_footer_youtube_link', 'https://www.youtube.com/') != '' ) { ?>
                    <a target="_blank" href="<?php echo esc_url(get_theme_mod('electrical_repair_footer_youtube_link', 'https://www.youtube.com/')); ?>">
                        <i class="<?php echo esc_attr(get_theme_mod('electrical_repair_youtube_icon', 'fab fa-youtube')); ?>"></i>
                        <span class="screen-reader-text"><?php esc_html_e('Youtube', 'electrical-repair'); ?></span>
                    </a>
                <?php } ?>
            </div>
            <?php
    }
}
add_action('wp_footer', 'electrical_repair_footer_social_links');

if ( ! function_exists( 'electrical_repair_footer_widget' ) ) :
	function electrical_repair_footer_widget() {
		$electrical_repair_footer_widget_column = get_theme_mod('electrical_repair_footer_widget_column','4');

		$electrical_repair_column_class = '';
		if ($electrical_repair_footer_widget_column == '1') {
			$electrical_repair_column_class = 'one-column';
		} elseif ($electrical_repair_footer_widget_column == '2') {
			$electrical_repair_column_class = 'two-columns';
		} elseif ($electrical_repair_footer_widget_column == '3') {
			$electrical_repair_column_class = 'three-columns';
		} else {
			$electrical_repair_column_class = 'four-columns';
		}
	
		if($electrical_repair_footer_widget_column !== ''): 
		?>
		<div class="dt_footer-widgets <?php echo esc_attr($electrical_repair_column_class); ?>">
			<div class="footer-widgets-column">
				<?php
				$footer_widgets_active = false;

				// Loop to check if any footer widget is active
				for ($electrical_repair_i = 1; $electrical_repair_i <= $electrical_repair_footer_widget_column; $electrical_repair_i++) {
					if (is_active_sidebar('electrical-repair-footer-widget-' . $electrical_repair_i)) {
						$footer_widgets_active = true;
						break;
					}
				}

				if ($footer_widgets_active) {
					// Display active footer widgets
					for ($electrical_repair_i = 1; $electrical_repair_i <= $electrical_repair_footer_widget_column; $electrical_repair_i++) {
						if (is_active_sidebar('electrical-repair-footer-widget-' . $electrical_repair_i)) : ?>
							<div class="footer-one-column">
								<?php dynamic_sidebar('electrical-repair-footer-widget-' . $electrical_repair_i); ?>
							</div>
						<?php endif;
					}
				} else {
				?>
				<div class="footer-one-column default-widgets">
					<aside id="search-2" class="widget widget_search default_footer_search">
						<div class="widget-header">
							<h4 class="widget-title"><?php esc_html_e('Search Here', 'electrical-repair'); ?></h4>
						</div>
						<?php get_search_form(); ?>
					</aside>
				</div>
				<div class="footer-one-column default-widgets">
					<aside id="recent-posts-2" class="widget widget_recent_entries">
						<h2 class="widget-title"><?php esc_html_e('Recent Posts', 'electrical-repair'); ?></h2>
						<ul>
							<?php
							$recent_posts = wp_get_recent_posts(array(
								'numberposts' => 5,
								'post_status' => 'publish',
							));
							foreach ($recent_posts as $post) {
								echo '<li><a href="' . esc_url(get_permalink($post['ID'])) . '">' . esc_html($post['post_title']) . '</a></li>';
							}
							wp_reset_query();
							?>
						</ul>
					</aside>
				</div>
				<div class="footer-one-column default-widgets">
					<aside id="recent-comments-2" class="widget widget_recent_comments">
						<h2 class="widget-title"><?php esc_html_e('Recent Comments', 'electrical-repair'); ?></h2>
						<ul>
							<?php
							$recent_comments = get_comments(array(
								'number' => 5,
								'status' => 'approve',
							));
							foreach ($recent_comments as $comment) {
								echo '<li><a href="' . esc_url(get_comment_link($comment)) . '">' .
									/* translators: %s: details. */
									sprintf(esc_html__('Comment on %s', 'electrical-repair'), get_the_title($comment->comment_post_ID)) .
									'</a></li>';
							}
							?>
						</ul>
					</aside>
				</div>
				<div class="footer-one-column default-widgets">
					<aside id="calendar-2" class="widget widget_calendar">
						<h2 class="widget-title"><?php esc_html_e('Calendar', 'electrical-repair'); ?></h2>
						<?php get_calendar(); ?>
					</aside>
				</div>
			</div>
			<?php } ?>
		</div>
		<?php
		endif;
	}
	endif;
add_action( 'electrical_repair_footer_widget', 'electrical_repair_footer_widget' );

function electrical_repair_footer_text_transform_css() {
    $electrical_repair_footer_text_transform = get_theme_mod('footer_text_transform', 'none');
    ?>
    <style type="text/css">
        .site-footer h4,footer#colophon h2.wp-block-heading,footer#colophon .widgettitle,footer#colophon .widget-title {
            text-transform: <?php echo esc_html($electrical_repair_footer_text_transform); ?>;
        }
    </style>
    <?php
}
add_action('wp_head', 'electrical_repair_footer_text_transform_css');

/**
 * GET START FUNCTION
 */

 function electrical_repair_getpage_css($hook) {
	wp_enqueue_script( 'electrical-repair-admin-script', get_template_directory_uri() . '/resource/js/electrical-repair-admin-notice-script.js', array( 'jquery' ) );
    wp_localize_script( 'electrical-repair-admin-script', 'electrical_repair_ajax_object',
        array( 'ajax_url' => admin_url( 'admin-ajax.php' ) )
    );
    wp_enqueue_style( 'electrical-repair-notice-style', get_template_directory_uri() . '/resource/css/notice.css' );
}

add_action( 'admin_enqueue_scripts', 'electrical_repair_getpage_css' );

add_action('wp_ajax_electrical_repair_dismissable_notice', 'electrical_repair_dismissable_notice');
function electrical_repair_switch_theme() {
    delete_user_meta(get_current_user_id(), 'electrical_repair_dismissable_notice');
}
add_action('after_switch_theme', 'electrical_repair_switch_theme');
function electrical_repair_dismissable_notice() {
    update_user_meta(get_current_user_id(), 'electrical_repair_dismissable_notice', true);
    die();
}

function electrical_repair_deprecated_hook_admin_notice() {
    global $pagenow;
    
    // Check if the current page is the one where you don't want the notice to appear
    if ( $pagenow === 'themes.php' && isset( $_GET['page'] ) && $_GET['page'] === 'electrical-repair-getting-started' ) {
        return;
    }

    $dismissed = get_user_meta( get_current_user_id(), 'electrical_repair_dismissable_notice', true );
    if ( !$dismissed) { ?>
        <div class="getstrat updated notice notice-success is-dismissible notice-get-started-class">
            <div class="at-admin-content" >
                <h2><?php esc_html_e('Welcome to Electrical Repair', 'electrical-repair'); ?></h2>
                <p><?php _e('Explore the features of our Pro Theme and take your Electrical Repair journey to the next level.', 'electrical-repair'); ?></p>
                <p ><?php _e('Get Started With Theme By Clicking On Getting Started.', 'electrical-repair'); ?><p>
                <div style="display: flex; justify-content: center;">
                    <a class="admin-notice-btn button button-primary button-hero" href="<?php echo esc_url( admin_url( 'themes.php?page=electrical-repair-getting-started' )); ?>"><?php esc_html_e( 'Get started', 'electrical-repair' ) ?></a>
                    <a  class="admin-notice-btn button button-primary button-hero" target="_blank" href="https://demo.asterthemes.com/electrical-repair/"><?php esc_html_e('View Demo', 'electrical-repair') ?></a>
                    <a  class="admin-notice-btn button button-primary button-hero" target="_blank" href="https://asterthemes.com/products/electrical-repair-wordpress-theme"><?php esc_html_e('Buy Now', 'electrical-repair') ?></a>
                    <a  class="admin-notice-btn button button-primary button-hero" target="_blank" href="https://demo.asterthemes.com/docs/electrical-repair-free/"><?php esc_html_e('Free Doc', 'electrical-repair') ?></a>
                </div>
            </div>
            <div class="at-admin-image">
                <img style="width: 100%;max-width: 320px;line-height: 40px;display: inline-block;vertical-align: top;border: 2px solid #ddd;border-radius: 4px;" src="<?php echo esc_url(get_stylesheet_directory_uri()) .'/screenshot.png'; ?>" />
            </div>
        </div>
    <?php }
}

add_action( 'admin_notices', 'electrical_repair_deprecated_hook_admin_notice' );


//Admin Notice For Getstart
function electrical_repair_ajax_notice_handler() {
    if ( isset( $_POST['type'] ) ) {
        $type = sanitize_text_field( wp_unslash( $_POST['type'] ) );
        update_option( 'dismissed-' . $type, TRUE );
    }
}