<?php
/**
 * Dynamic CSS
 */
function electrical_repair_dynamic_css() {
	$electrical_repair_primary_color = get_theme_mod( 'primary_color', '#1F87FF' );

	$electrical_repair_site_title_font       = get_theme_mod( 'electrical_repair_site_title_font', 'Playfair Display' );
	$electrical_repair_site_description_font = get_theme_mod( 'electrical_repair_site_description_font', 'Raleway' );
	$electrical_repair_header_font           = get_theme_mod( 'electrical_repair_header_font', 'Oswald' );
	$electrical_repair_content_font             = get_theme_mod( 'electrical_repair_content_font', 'Open Sans' );

	// Enqueue Google Fonts
	$electrical_repair_fonts_url = electrical_repair_get_fonts_url();
	if ( ! empty( $electrical_repair_fonts_url ) ) {
		wp_enqueue_style( 'electrical-repair-google-fonts', esc_url( $electrical_repair_fonts_url ), array(), null );
	}

	$electrical_repair_custom_css  = '';
	$electrical_repair_custom_css .= '
    /* Color */
    :root {
        --primary-color: ' . esc_attr( $electrical_repair_primary_color ) . ';
        --header-text-color: ' . esc_attr( '#' . get_header_textcolor() ) . ';
    }
    ';

	$electrical_repair_custom_css .= '
    /* Typography */
    :root {
        --font-heading: "' . esc_attr( $electrical_repair_header_font ) . '", serif;
        --font-main: -apple-system, BlinkMacSystemFont, "' . esc_attr( $electrical_repair_content_font ) . '", "Segoe UI", Roboto, Oxygen-Sans, Ubuntu, Cantarell, "Helvetica Neue", sans-serif;
    }

    body,
	button, input, select, optgroup, textarea, p {
        font-family: "' . esc_attr( $electrical_repair_content_font ) . '", serif;
	}

	.site-identity p.site-title, h1.site-title a, h1.site-title, p.site-title a, .site-branding h1.site-title a {
        font-family: "' . esc_attr( $electrical_repair_site_title_font ) . '", serif;
	}
    
	p.site-description {
        font-family: "' . esc_attr( $electrical_repair_site_description_font ) . '", serif !important;
	}
    ';

	wp_add_inline_style( 'electrical-repair-style', $electrical_repair_custom_css );
}
add_action( 'wp_enqueue_scripts', 'electrical_repair_dynamic_css', 99 );