<?php
/**
 * Typography Setting
 *
 * @package electrical_repair
 */

// Typography Setting
$wp_customize->add_section(
    'electrical_repair_typography_setting',
    array(
        'panel' => 'electrical_repair_theme_options',
        'title' => esc_html__( 'Typography Setting', 'electrical-repair' ),
    )
);

$wp_customize->add_setting(
    'electrical_repair_site_title_font',
    array(
        'default'           => 'Playfair Display',
        'sanitize_callback' => 'electrical_repair_sanitize_google_fonts',
    )
);

$wp_customize->add_control(
    'electrical_repair_site_title_font',
    array(
        'label'    => esc_html__( 'Site Title Font Family', 'electrical-repair' ),
        'section'  => 'electrical_repair_typography_setting',
        'settings' => 'electrical_repair_site_title_font',
        'type'     => 'select',
        'choices'  => electrical_repair_get_all_google_font_families(),
    )
);

// Typography - Site Description Font.
$wp_customize->add_setting(
	'electrical_repair_site_description_font',
	array(
		'default'           => 'Raleway',
		'sanitize_callback' => 'electrical_repair_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'electrical_repair_site_description_font',
	array(
		'label'    => esc_html__( 'Site Description Font Family', 'electrical-repair' ),
		'section'  => 'electrical_repair_typography_setting',
		'settings' => 'electrical_repair_site_description_font',
		'type'     => 'select',
		'choices'  => electrical_repair_get_all_google_font_families(),
	)
);

// Typography - Header Font.
$wp_customize->add_setting(
	'electrical_repair_header_font',
	array(
		'default'           => 'Oswald',
		'sanitize_callback' => 'electrical_repair_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'electrical_repair_header_font',
	array(
		'label'    => esc_html__( 'Heading Font Family', 'electrical-repair' ),
		'section'  => 'electrical_repair_typography_setting',
		'settings' => 'electrical_repair_header_font',
		'type'     => 'select',
		'choices'  => electrical_repair_get_all_google_font_families(),
	)
);

// Typography - Body Font.
$wp_customize->add_setting(
	'electrical_repair_content_font',
	array(
		'default'           => 'Open Sans',
		'sanitize_callback' => 'electrical_repair_sanitize_google_fonts',
	)
);

$wp_customize->add_control(
	'electrical_repair_content_font',
	array(
		'label'    => esc_html__( 'Content Font Family', 'electrical-repair' ),
		'section'  => 'electrical_repair_typography_setting',
		'settings' => 'electrical_repair_content_font',
		'type'     => 'select',
		'choices'  => electrical_repair_get_all_google_font_families(),
	)
);
