<?php
/**
 * Sidebar Position
 *
 * @package electrical_repair
 */

$wp_customize->add_section(
	'electrical_repair_sidebar_position',
	array(
		'title' => esc_html__( 'Sidebar Position', 'electrical-repair' ),
		'panel' => 'electrical_repair_theme_options',
	)
);


// Add Separator Custom Control
$wp_customize->add_setting( 'electrical_repair_global_sidebar_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Electrical_Repair_Separator_Custom_Control( $wp_customize, 'electrical_repair_global_sidebar_separator', array(
	'label' => __( 'Global Sidebar Position', 'electrical-repair' ),
	'section' => 'electrical_repair_sidebar_position',
	'settings' => 'electrical_repair_global_sidebar_separator',
)));

// Sidebar Position - Global Sidebar Position.
$wp_customize->add_setting(
	'electrical_repair_sidebar_position',
	array(
		'sanitize_callback' => 'electrical_repair_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'electrical_repair_sidebar_position',
	array(
		'label'   => esc_html__( 'Select Sidebar Position', 'electrical-repair' ),
		'section' => 'electrical_repair_sidebar_position',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'electrical-repair' ),
			'left-sidebar'  => esc_html__( 'Left Sidebar', 'electrical-repair' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'electrical-repair' ),
		),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'electrical_repair_page_sidebar_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Electrical_Repair_Separator_Custom_Control( $wp_customize, 'electrical_repair_page_sidebar_separator', array(
	'label' => __( 'Page Sidebar Position', 'electrical-repair' ),
	'section' => 'electrical_repair_sidebar_position',
	'settings' => 'electrical_repair_page_sidebar_separator',
)));


// Sidebar Position - Page Sidebar Position.
$wp_customize->add_setting(
	'electrical_repair_page_sidebar_position',
	array(
		'sanitize_callback' => 'electrical_repair_sanitize_select',
		'default'           => 'right-sidebar',
	)
);

$wp_customize->add_control(
	'electrical_repair_page_sidebar_position',
	array(
		'label'   => esc_html__( 'Select Sidebar Position', 'electrical-repair' ),
		'section' => 'electrical_repair_sidebar_position',
		'type'    => 'select',
		'choices' => array(
			'right-sidebar' => esc_html__( 'Right Sidebar', 'electrical-repair' ),
			'left-sidebar'  => esc_html__( 'Left Sidebar', 'electrical-repair' ),
			'no-sidebar'    => esc_html__( 'No Sidebar', 'electrical-repair' ),
		),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'electrical_repair_sidebar_width_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Electrical_Repair_Separator_Custom_Control( $wp_customize, 'electrical_repair_sidebar_width_separator', array(
	'label' => __( 'Sidebar Width Setting', 'electrical-repair' ),
	'section' => 'electrical_repair_sidebar_position',
	'settings' => 'electrical_repair_sidebar_width_separator',
)));


$wp_customize->add_setting( 'electrical_repair_sidebar_width', array(
	'default'           => '30',
	'sanitize_callback' => 'electrical_repair_sanitize_range_value',
) );

$wp_customize->add_control(new Electrical_Repair_Customize_Range_Control($wp_customize, 'electrical_repair_sidebar_width', array(
	'section'     => 'electrical_repair_sidebar_position',
	'label'       => __( 'Adjust Sidebar Width', 'electrical-repair' ),
	'description' => __( 'Adjust the width of the sidebar.', 'electrical-repair' ),
	'input_attrs' => array(
		'min'  => 10,
		'max'  => 50,
		'step' => 1,
	),
)));
$wp_customize->add_setting( 'electrical_repair_sidebar_widget_font_size', array(
    'default'           => 24,
    'sanitize_callback' => 'absint',
) );

// Add control for site title size
$wp_customize->add_control( 'electrical_repair_sidebar_widget_font_size', array(
    'type'        => 'number',
    'section'     => 'electrical_repair_sidebar_position',
    'label'       => __( 'Sidebar Widgets Heading Font Size ', 'electrical-repair' ),
    'input_attrs' => array(
        'min'  => 10,
        'max'  => 100,
        'step' => 1,
    ),
));