<?php
/**
 * Pige Title Options
 *
 * @package electrical_repair
 */

$wp_customize->add_section(
	'electrical_repair_page_title_options',
	array(
		'panel' => 'electrical_repair_theme_options',
		'title' => esc_html__( 'Page Title', 'electrical-repair' ),
	)
);

$wp_customize->add_setting(
    'electrical_repair_page_header_visibility',
    array(
        'default'           => 'all-devices',
        'sanitize_callback' => 'electrical_repair_sanitize_select',
    )
);

$wp_customize->add_control(
    new WP_Customize_Control(
        $wp_customize,
        'electrical_repair_page_header_visibility',
        array(
            'label'    => esc_html__( 'Page Header Visibility', 'electrical-repair' ),
            'type'     => 'select',
            'section'  => 'electrical_repair_page_title_options',
            'settings' => 'electrical_repair_page_header_visibility',
            'priority' => 10,
            'choices'  => array(
                'all-devices'        => esc_html__( 'Show on all devices', 'electrical-repair' ),
                'hide-tablet'        => esc_html__( 'Hide on Tablet', 'electrical-repair' ),
                'hide-mobile'        => esc_html__( 'Hide on Mobile', 'electrical-repair' ),
                'hide-tablet-mobile' => esc_html__( 'Hide on Tablet & Mobile', 'electrical-repair' ),
                'hide-all-devices'   => esc_html__( 'Hide on all devices', 'electrical-repair' ),
            ),
        )
    )
);


$wp_customize->add_setting( 'electrical_repair_page_title_background_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Electrical_Repair_Separator_Custom_Control( $wp_customize, 'electrical_repair_page_title_background_separator', array(
	'label' => __( 'Page Title BG Image & Color Setting', 'electrical-repair' ),
	'section' => 'electrical_repair_page_title_options',
	'settings' => 'electrical_repair_page_title_background_separator',
)));


$wp_customize->add_setting(
	'electrical_repair_page_header_style',
	array(
		'sanitize_callback' => 'electrical_repair_sanitize_switch',
		'default'           => False,
	)
);

$wp_customize->add_control(
	new Electrical_Repair_Toggle_Switch_Custom_Control(
		$wp_customize,
		'electrical_repair_page_header_style',
		array(
			'label'   => esc_html__('Page Title Background Image', 'electrical-repair'),
			'section' => 'electrical_repair_page_title_options',
		)
	)
);

$wp_customize->add_setting( 'electrical_repair_page_header_background_image', array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
) );

$wp_customize->add_control( new WP_Customize_Image_Control( $wp_customize, 'electrical_repair_page_header_background_image', array(
    'label'    => __( 'Background Image', 'electrical-repair' ),
	'description' => __('Choose either a background image or a color. If a background image is selected, the background color will not be visible.', 'electrical-repair'),
    'section'  => 'electrical_repair_page_title_options',
    'settings' => 'electrical_repair_page_header_background_image',
	'active_callback' => 'electrical_repair_is_pagetitle_bcakground_image_enabled',
)));


$wp_customize->add_setting('electrical_repair_page_header_image_height', array(
	'default'           => 200,
	'sanitize_callback' => 'electrical_repair_sanitize_range_value',
));

$wp_customize->add_control(new Electrical_Repair_Customize_Range_Control($wp_customize, 'electrical_repair_page_header_image_height', array(
		'label'       => __('Image Height', 'electrical-repair'),
		'section'     => 'electrical_repair_page_title_options',
		'settings'    => 'electrical_repair_page_header_image_height',
		'active_callback' => 'electrical_repair_is_pagetitle_bcakground_image_enabled',
		'input_attrs' => array(
			'min'  => 0,
			'max'  => 1000,
			'step' => 5,
		),
)));


$wp_customize->add_setting('electrical_repair_page_title_background_color_setting', array(
    'default' => '#f5f5f5',
    'sanitize_callback' => 'sanitize_hex_color',
));

$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'electrical_repair_page_title_background_color_setting', array(
    'label' => __('Page Title Background Color', 'electrical-repair'),
    'section' => 'electrical_repair_page_title_options',
)));

$wp_customize->add_setting('electrical_repair_pagetitle_height', array(
    'default'           => 50,
    'sanitize_callback' => 'electrical_repair_sanitize_range_value',
));

$wp_customize->add_control(new Electrical_Repair_Customize_Range_Control($wp_customize, 'electrical_repair_pagetitle_height', array(
    'label'       => __('Set Height', 'electrical-repair'),
    'description' => __('This setting controls the page title height when no background image is set. If a background image is set, this setting will not apply.', 'electrical-repair'),
    'section'     => 'electrical_repair_page_title_options',
    'settings'    => 'electrical_repair_pagetitle_height',
    'input_attrs' => array(
        'min'  => 0,
        'max'  => 300,
        'step' => 5,
    ),
)));

$wp_customize->add_setting( 'electrical_repair_page_title_style_separator', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Electrical_Repair_Separator_Custom_Control( $wp_customize, 'electrical_repair_page_title_style_separator', array(
	'label' => __( 'Page Title Styling Setting', 'electrical-repair' ),
	'section' => 'electrical_repair_page_title_options',
	'settings' => 'electrical_repair_page_title_style_separator',
)));


$wp_customize->add_setting( 'electrical_repair_page_header_heading_tag', array(
	'default'   => 'h1',
	'sanitize_callback' => 'electrical_repair_sanitize_select',
) );

$wp_customize->add_control( 'electrical_repair_page_header_heading_tag', array(
	'label'   => __( 'Page Title Heading Tag', 'electrical-repair' ),
	'section' => 'electrical_repair_page_title_options',
	'type'    => 'select',
	'choices' => array(
		'h1' => __( 'H1', 'electrical-repair' ),
		'h2' => __( 'H2', 'electrical-repair' ),
		'h3' => __( 'H3', 'electrical-repair' ),
		'h4' => __( 'H4', 'electrical-repair' ),
		'h5' => __( 'H5', 'electrical-repair' ),
		'h6' => __( 'H6', 'electrical-repair' ),
		'p' => __( 'p', 'electrical-repair' ),
		'a' => __( 'a', 'electrical-repair' ),
		'div' => __( 'div', 'electrical-repair' ),
		'span' => __( 'span', 'electrical-repair' ),
	),
) );



$wp_customize->add_setting('electrical_repair_page_header_layout', array(
	'default' => 'left',
	'sanitize_callback' => 'sanitize_text_field',
));

$wp_customize->add_control('electrical_repair_page_header_layout', array(
	'label' => __('Style', 'electrical-repair'),
	'section' => 'electrical_repair_page_title_options',
	'description' => __('"Flex Layout Style" wont work below 600px (mobile media)', 'electrical-repair'),
	'settings' => 'electrical_repair_page_header_layout',
	'type' => 'radio',
	'choices' => array(
		'left' => __('Classic', 'electrical-repair'),
		'right' => __('Aligned Right', 'electrical-repair'),
		'center' => __('Centered Focus', 'electrical-repair'),
		'flex' => __('Flex Layout', 'electrical-repair'),
	),
));