<?php
/**
 * Footer Social Icons
 *
 * @package electrical_repair
 */

$wp_customize->add_section(
	'electrical_repair_footer_icon_options',
	array(
		'panel' => 'electrical_repair_theme_options',
		'title' => esc_html__( 'Footer Social Icons', 'electrical-repair' ),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'electrical_repair_footer_icon_separators', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Electrical_Repair_Separator_Custom_Control( $wp_customize, 'electrical_repair_footer_icon_separators', array(
	'label' => __( 'Footer Icon Settings', 'electrical-repair' ),
	'section' => 'electrical_repair_footer_icon_options',
	'settings' => 'electrical_repair_footer_icon_separators',
)));

// Footer Section - Enable Section.
$wp_customize->add_setting(
	'electrical_repair_enable_footer_icon_section',
	array(
		'default'           => true,
		'sanitize_callback' => 'electrical_repair_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Electrical_Repair_Toggle_Switch_Custom_Control(
		$wp_customize,
		'electrical_repair_enable_footer_icon_section',
		array(
			'label'    => esc_html__( 'Show / Hide Footer Icon', 'electrical-repair' ),
			'section'  => 'electrical_repair_footer_icon_options',
			'settings' => 'electrical_repair_enable_footer_icon_section',
		)
	)
);

// Add setting for Facebook Link
$wp_customize->add_setting(
	'electrical_repair_footer_facebook_link',
	array(
		'default'           => 'https://www.facebook.com/',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'electrical_repair_footer_facebook_link',
	array(
		'label'           => esc_html__( 'Facebook Link', 'electrical-repair'  ),
		'section'         => 'electrical_repair_footer_icon_options',
		'settings'        => 'electrical_repair_footer_facebook_link',
		'type'      => 'url'
	)
);

// Add setting for Facebook Icon Changing
$wp_customize->add_setting(
	'electrical_repair_facebook_icon',
	array(
        'default' => 'fab fa-facebook-f',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
		
	)
);	

$wp_customize->add_control(new Electrical_Repair_Change_Icon_Control($wp_customize, 
	'electrical_repair_facebook_icon',
	array(
	    'label'   		=> __('Facebook Icon','electrical-repair'),
	    'section' 		=> 'electrical_repair_footer_icon_options',
		'iconset' => 'fb',
	))  
);


// Add setting for Twitter Link
$wp_customize->add_setting(
	'electrical_repair_footer_twitter_link',
	array(
		'default'           => 'https://x.com/',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'electrical_repair_footer_twitter_link',
	array(
		'label'           => esc_html__( 'Twitter Link', 'electrical-repair'  ),
		'section'         => 'electrical_repair_footer_icon_options',
		'settings'        => 'electrical_repair_footer_twitter_link',
		'type'      => 'url'
	)
);

// Add setting for Twitter Icon Changing
$wp_customize->add_setting(
	'electrical_repair_twitter_icon',
	array(
        'default' => 'fab fa-twitter',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
		
	)
);	

$wp_customize->add_control(new Electrical_Repair_Change_Icon_Control($wp_customize, 
	'electrical_repair_twitter_icon',
	array(
	    'label'   		=> __('Twitter Icon','electrical-repair'),
	    'section' 		=> 'electrical_repair_footer_icon_options',
		'iconset' => 'fb',
	))  
);

// Add setting for Instagram Link
$wp_customize->add_setting(
	'electrical_repair_footer_instagram_link',
	array(
		'default'           => 'https://www.instagram.com/',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'electrical_repair_footer_instagram_link',
	array(
		'label'           => esc_html__( 'Instagram Link', 'electrical-repair'  ),
		'section'         => 'electrical_repair_footer_icon_options',
		'settings'        => 'electrical_repair_footer_instagram_link',
		'type'      => 'url'
	)
);

// Add setting for Instagram Icon Changing
$wp_customize->add_setting(
	'electrical_repair_instagram_icon',
	array(
        'default' => 'fab fa-instagram',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
		
	)
);	

$wp_customize->add_control(new Electrical_Repair_Change_Icon_Control($wp_customize, 
	'electrical_repair_instagram_icon',
	array(
	    'label'   		=> __('Instagram Icon','electrical-repair'),
	    'section' 		=> 'electrical_repair_footer_icon_options',
		'iconset' => 'fb',
	))  
);

// Add setting for Linkedin Link
$wp_customize->add_setting(
	'electrical_repair_footer_linkedin_link',
	array(
		'default'           => 'https://in.linkedin.com/',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'electrical_repair_footer_linkedin_link',
	array(
		'label'           => esc_html__( 'Linkedin Link', 'electrical-repair'  ),
		'section'         => 'electrical_repair_footer_icon_options',
		'settings'        => 'electrical_repair_footer_linkedin_link',
		'type'      => 'url'
	)
);

// Add setting for Linkedin Icon Changing
$wp_customize->add_setting(
	'electrical_repair_linkedin_icon',
	array(
        'default' => 'fab fa-linkedin',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
		
	)
);	

$wp_customize->add_control(new Electrical_Repair_Change_Icon_Control($wp_customize, 
	'electrical_repair_linkedin_icon',
	array(
	    'label'   		=> __('Linkedin Icon','electrical-repair'),
	    'section' 		=> 'electrical_repair_footer_icon_options',
		'iconset' => 'fb',
	))  
);

// Add setting for Youtube Link
$wp_customize->add_setting(
	'electrical_repair_footer_youtube_link',
	array(
		'default'           => 'https://www.youtube.com/',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'electrical_repair_footer_youtube_link',
	array(
		'label'           => esc_html__( 'Youtube Link', 'electrical-repair'  ),
		'section'         => 'electrical_repair_footer_icon_options',
		'settings'        => 'electrical_repair_footer_youtube_link',
		'type'      => 'url'
	)
);

// Add setting for Youtube Icon Changing
$wp_customize->add_setting(
	'electrical_repair_youtube_icon',
	array(
        'default' => 'fab fa-youtube',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
		
	)
);	

$wp_customize->add_control(new Electrical_Repair_Change_Icon_Control($wp_customize, 
	'electrical_repair_youtube_icon',
	array(
	    'label'   		=> __('Youtube Icon','electrical-repair'),
	    'section' 		=> 'electrical_repair_footer_icon_options',
		'iconset' => 'fb',
	))  
);