<?php
/**
 * Footer Options
 *
 * @package electrical_repair
 */

$wp_customize->add_section(
	'electrical_repair_footer_options',
	array(
		'panel' => 'electrical_repair_theme_options',
		'title' => esc_html__( 'Footer Options', 'electrical-repair' ),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'electrical_repair_footer_separators', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Electrical_Repair_Separator_Custom_Control( $wp_customize, 'electrical_repair_footer_separators', array(
	'label' => __( 'Footer Settings', 'electrical-repair' ),
	'section' => 'electrical_repair_footer_options',
	'settings' => 'electrical_repair_footer_separators',
)));

// Footer Section - Enable Section.
$wp_customize->add_setting(
	'electrical_repair_enable_footer_section',
	array(
		'default'           => true,
		'sanitize_callback' => 'electrical_repair_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Electrical_Repair_Toggle_Switch_Custom_Control(
		$wp_customize,
		'electrical_repair_enable_footer_section',
		array(
			'label'    => esc_html__( 'Show / Hide Footer', 'electrical-repair' ),
			'section'  => 'electrical_repair_footer_options',
			'settings' => 'electrical_repair_enable_footer_section',
		)
	)
);

// column // 
$wp_customize->add_setting(
	'electrical_repair_footer_widget_column',
	array(
        'default'			=> '4',
		'capability'     	=> 'edit_theme_options',
		'sanitize_callback' => 'electrical_repair_sanitize_select',
		
	)
);	

$wp_customize->add_control(
	'electrical_repair_footer_widget_column',
	array(
		'label'   		=> __('Select Footer Widget Column','electrical-repair'),
		'description' => __('Note: Default footer widgets are shown. Add your preferred widgets in (Appearance > Widgets > Footer) to see changes.', 'electrical-repair'),	    'section' 		=> 'electrical_repair_footer_options',
		'type'			=> 'select',
		'choices'        => 
		array(
			'' => __( 'None', 'electrical-repair' ),
			'1' => __( '1 Column', 'electrical-repair' ),
			'2' => __( '2 Column', 'electrical-repair' ),
			'3' => __( '3 Column', 'electrical-repair' ),
			'4' => __( '4 Column', 'electrical-repair' )
		) 
	) 
);
//  Image // 
$wp_customize->add_setting('electrical_repair_footer_background_color_setting', array(
    'default' => '#000',
    'sanitize_callback' => 'sanitize_hex_color',
));

$wp_customize->add_control(new WP_Customize_Color_Control($wp_customize, 'electrical_repair_footer_background_color_setting', array(
    'label' => __('Footer Background Color', 'electrical-repair'),
    'section' => 'electrical_repair_footer_options',
)));

// Footer Background Image Setting
$wp_customize->add_setting('electrical_repair_footer_background_image_setting', array(
    'default' => '',
    'sanitize_callback' => 'esc_url_raw',
));

$wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'electrical_repair_footer_background_image_setting', array(
    'label' => __('Footer Background Image', 'electrical-repair'),
    'section' => 'electrical_repair_footer_options',
)));

// Footer Background Attachment
$wp_customize->add_setting(
	'electrical_repair_footer_image_attachment_setting',
	array(
		'default'=> 'scroll',
		'sanitize_callback' => 'electrical_repair_sanitize_choices'
	)
);

$wp_customize->add_control(
	'electrical_repair_footer_image_attachment_setting',
	array(
		'type' => 'select',
		'label' => __('Footer Background Attatchment','electrical-repair'),
		'choices' => array(
			'fixed' => __('fixed','electrical-repair'),
			'scroll' => __('scroll','electrical-repair'),
		),
		'section'=> 'electrical_repair_footer_options',
  	)
);

//Footer Image Position
$wp_customize->add_setting(
	'electrical_repair_footer_img_position_setting',
	array(
        'default'			=> 'center center',
		'capability'     	=> 'edit_theme_options',
		'sanitize_callback' => 'electrical_repair_sanitize_choices',
		
	)
);	

$wp_customize->add_control(
	'electrical_repair_footer_img_position_setting',
	array(
		'label'   		=> __('Footer Image Position','electrical-repair'),
	    'section' 		=> 'electrical_repair_footer_options',
		'type'			=> 'select',
		'choices'       => 
		array(
			'center center'   => __( 'Center', 'electrical-repair' ),
			'center top'   	  => __( 'Top', 'electrical-repair' ),
			'center bottom'   => __( 'Bottom', 'electrical-repair' ),
		) 
	) 
);

$wp_customize->add_setting('footer_text_transform', array(
    'default' => 'none',
    'sanitize_callback' => 'sanitize_text_field',
));

// Add Footer Heading Text Transform Control
$wp_customize->add_control('footer_text_transform', array(
    'label' => __('Footer Heading Text Transform', 'electrical-repair'),
    'section' => 'electrical_repair_footer_options',
    'settings' => 'footer_text_transform',
    'type' => 'select',
    'choices' => array(
        'none' => __('None', 'electrical-repair'),
        'capitalize' => __('Capitalize', 'electrical-repair'),
        'uppercase' => __('Uppercase', 'electrical-repair'),
        'lowercase' => __('Lowercase', 'electrical-repair'),
    ),
));

// Footer Heading Alignment
$wp_customize->add_setting(
	'electrical_repair_footer_header_align',
	array(
		'default' 			=> 'left',
		'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control(
	'electrical_repair_footer_header_align',
	array(
		'label' => __('Footer Heading Alignment ','electrical-repair'),
		'section' => 'electrical_repair_footer_options',
		'type'			=> 'select',
		'choices' => 
		array(
			'left' => __('Left','electrical-repair'),
			'right' => __('Right','electrical-repair'),
			'center' => __('Center','electrical-repair'),
		),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'electrical_repair_copyright_separators', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Electrical_Repair_Separator_Custom_Control( $wp_customize, 'electrical_repair_copyright_separators', array(
	'label' => __( 'Copyright Settings', 'electrical-repair' ),
	'section' => 'electrical_repair_footer_options',
	'settings' => 'electrical_repair_copyright_separators',
)));

// Copyright Section - Enable Section.
$wp_customize->add_setting(
	'electrical_repair_enable_copyright_section',
	array(
		'default'           => true,
		'sanitize_callback' => 'electrical_repair_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Electrical_Repair_Toggle_Switch_Custom_Control(
		$wp_customize,
		'electrical_repair_enable_copyright_section',
		array(
			'label'    => esc_html__( 'Show / Hide Copyright', 'electrical-repair' ),
			'section'  => 'electrical_repair_footer_options',
			'settings' => 'electrical_repair_enable_copyright_section',
		)
	)
);

$wp_customize->add_setting(
	'electrical_repair_footer_copyright_text',
	array(
		'default'           => '',
		'sanitize_callback' => 'wp_kses_post',
		'transport'         => 'refresh',
	)
);

$wp_customize->add_control(
	'electrical_repair_footer_copyright_text',
	array(
		'label'    => esc_html__( 'Copyright Text', 'electrical-repair' ),
		'section'  => 'electrical_repair_footer_options',
		'settings' => 'electrical_repair_footer_copyright_text',
		'type'     => 'textarea',
	)
);

//Copyright Alignment
$wp_customize->add_setting(
	'electrical_repair_footer_bottom_align',
	array(
		'default' 			=> 'center',
		'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control(
	'electrical_repair_footer_bottom_align',
	array(
		'label' => __('Copyright Alignment ','electrical-repair'),
		'section' => 'electrical_repair_footer_options',
		'type'			=> 'select',
		'choices' => 
		array(
			'left' => __('Left','electrical-repair'),
			'right' => __('Right','electrical-repair'),
			'center' => __('Center','electrical-repair'),
		),
	)
);

//Copyright Font Size
$wp_customize->add_setting( 
	'electrical_repair_copyright_font_size', 
	array(
		'default'           => 16,
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control( 'electrical_repair_copyright_font_size', 
	array(
		'type'        => 'number',
		'section'     => 'electrical_repair_footer_options',
		'label'       => __( 'Copyright Font Size ', 'electrical-repair' ),
		'input_attrs' => 
		array(
			'min'  => 10,
			'max'  => 100,
			'step' => 1,
		),
	)
);

// Add Separator Custom Control
$wp_customize->add_setting( 'electrical_repair_scroll_separators', array(
	'sanitize_callback' => 'sanitize_text_field',
) );

$wp_customize->add_control( new Electrical_Repair_Separator_Custom_Control( $wp_customize, 'electrical_repair_scroll_separators', array(
	'label' => __( 'Scroll Top Settings', 'electrical-repair' ),
	'section' => 'electrical_repair_footer_options',
	'settings' => 'electrical_repair_scroll_separators',
)));

// Footer Options - Scroll Top.
$wp_customize->add_setting(
	'electrical_repair_scroll_top',
	array(
		'sanitize_callback' => 'electrical_repair_sanitize_switch',
		'default'           => true,
	)
);

$wp_customize->add_control(
	new Electrical_Repair_Toggle_Switch_Custom_Control(
		$wp_customize,
		'electrical_repair_scroll_top',
		array(
			'label'   => esc_html__( 'Enable Scroll Top Button', 'electrical-repair' ),
			'section' => 'electrical_repair_footer_options',
		)
	)
);

// icon // 
$wp_customize->add_setting(
	'electrical_repair_scroll_btn_icon',
	array(
        'default' => 'fas fa-chevron-up',
		'sanitize_callback' => 'sanitize_text_field',
		'capability' => 'edit_theme_options',
		
	)
);	

$wp_customize->add_control(new Electrical_Repair_Change_Icon_Control($wp_customize, 
	'electrical_repair_scroll_btn_icon',
	array(
	    'label'   		=> __('Scroll Top Icon','electrical-repair'),
	    'section' 		=> 'electrical_repair_footer_options',
		'iconset' => 'fa',
	))  
);

$wp_customize->add_setting( 'electrical_repair_scroll_top_position', array(
    'default'           => 'bottom-right',
    'sanitize_callback' => 'electrical_repair_sanitize_scroll_top_position',
) );

// Add control for Scroll Top Button Position
$wp_customize->add_control( 'electrical_repair_scroll_top_position', array(
    'label'    => __( 'Scroll Top Button Position', 'electrical-repair' ),
    'section'  => 'electrical_repair_footer_options',
    'settings' => 'electrical_repair_scroll_top_position',
    'type'     => 'select',
    'choices'  => array(
        'bottom-right' => __( 'Bottom Right', 'electrical-repair' ),
        'bottom-left'  => __( 'Bottom Left', 'electrical-repair' ),
        'bottom-center'=> __( 'Bottom Center', 'electrical-repair' ),
    ),
) );

$wp_customize->add_setting( 'electrical_repair_scroll_top_shape', array(
	'default'           => 'box',
	'sanitize_callback' => 'sanitize_text_field',
));

$wp_customize->add_control( 'electrical_repair_scroll_top_shape', array(
	'label'    => __( 'Scroll to Top Button Shape', 'electrical-repair' ),
	'section'  => 'electrical_repair_footer_options',
	'settings' => 'electrical_repair_scroll_top_shape',
	'type'     => 'radio',
	'choices'  => array(
		'box'        => __( 'Box', 'electrical-repair' ),
		'curved-box' => __( 'Curved Box', 'electrical-repair' ),
		'circle'     => __( 'Circle', 'electrical-repair' ),
	),
));