<?php
/**
 * Excerpt
 *
 * @package electrical_repair
 */

$wp_customize->add_section(
	'electrical_repair_excerpt_options',
	array(
		'panel' => 'electrical_repair_theme_options',
		'title' => esc_html__( 'Excerpt', 'electrical-repair' ),
	)
);

// Excerpt - Excerpt Length.
$wp_customize->add_setting(
	'electrical_repair_excerpt_length',
	array(
		'default'           => 20,
		'sanitize_callback' => 'absint',
		'transport'         => 'refresh',
	)
);

$wp_customize->add_control(
	'electrical_repair_excerpt_length',
	array(
		'label'       => esc_html__( 'Excerpt Length (no. of words)', 'electrical-repair' ),
		'section'     => 'electrical_repair_excerpt_options',
		'settings'    => 'electrical_repair_excerpt_length',
		'type'        => 'number',
		'input_attrs' => array(
			'min'  => 10,
			'max'  => 200,
			'step' => 1,
		),
	)
);