<?php
/**
 * 404 page
 *
 * @package electrical_repair
 */


/*=========================================
404 Page
=========================================*/
$wp_customize->add_section(
	'404_pg_options', array(
		'title' => esc_html__( '404 Page', 'electrical-repair' ),
		'panel' => 'electrical_repair_theme_options',
	)
);

/*=========================================
404 Page
=========================================*/

//  Title // 
$wp_customize->add_setting(
	'electrical_repair_pg_404_ttl',
	array(
        'default'			=> __('404 Page Not Found','electrical-repair'),
		'capability'     	=> 'edit_theme_options',
		'sanitize_callback' => 'electrical_repair_sanitize_html',
	)
);	

$wp_customize->add_control( 
	'electrical_repair_pg_404_ttl',
	array(
	    'label'   => __('Title','electrical-repair'),
	    'section' => '404_pg_options',
		'type'           => 'text',
	)  
);

$wp_customize->add_setting('electrical_repair_pg_404_image', array(
        'default'           => '',
        'sanitize_callback' => 'esc_url_raw',
    ));

    $wp_customize->add_control(new WP_Customize_Image_Control($wp_customize, 'electrical_repair_pg_404_image', array(
        'label'    => __('404 Page Image', 'electrical-repair'),
        'section'  => '404_pg_options', // Add this section if it doesn't exist
        'settings' => 'electrical_repair_pg_404_image',
    )));

    // Existing settings for 404 title, text, button label, and link
    $wp_customize->add_setting('electrical_repair_pg_404_ttl', array(
        'default' => __( '404 Page Not Found', 'electrical-repair' ),
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control('electrical_repair_pg_404_ttl', array(
        'label'    => __('404 Page Title', 'electrical-repair'),
        'section'  => '404_pg_options',
        'settings' => 'electrical_repair_pg_404_ttl',
    ));

    $wp_customize->add_setting('electrical_repair_pg_404_text', array(
        'default' => __( 'Apologies, but the page you are seeking cannot be found.', 'electrical-repair' ),
        'sanitize_callback' => 'sanitize_textarea_field',
    ));

    $wp_customize->add_control('electrical_repair_pg_404_text', array(
        'label'    => __('404 Page Text', 'electrical-repair'),
        'section'  => '404_pg_options',
        'settings' => 'electrical_repair_pg_404_text',
        'type'     => 'textarea',
    ));

    $wp_customize->add_setting('electrical_repair_pg_404_btn_lbl', array(
        'default' => __( 'Go Back Home', 'electrical-repair' ),
        'sanitize_callback' => 'sanitize_text_field',
    ));

    $wp_customize->add_control('electrical_repair_pg_404_btn_lbl', array(
        'label'    => __('404 Button Label', 'electrical-repair'),
        'section'  => '404_pg_options',
        'settings' => 'electrical_repair_pg_404_btn_lbl',
    ));

    $wp_customize->add_setting('electrical_repair_pg_404_btn_link', array(
        'default'           => esc_url(home_url('/')),
        'sanitize_callback' => 'esc_url_raw',
    ));

    $wp_customize->add_control('electrical_repair_pg_404_btn_link', array(
        'label'    => __('404 Button Link', 'electrical-repair'),
        'section'  => '404_pg_options',
        'settings' => 'electrical_repair_pg_404_btn_link',
    ));
