<?php
/**
 * Product Section
 *
 * @package electrical_repair
 */

$wp_customize->add_section(
	'electrical_repair_products_section',
	array(
		'panel'    => 'electrical_repair_front_page_options',
		'title'    => esc_html__( 'Product Section', 'electrical-repair' ),
		'priority' => 10,
	)
);

// Product Section - Enable Section.
$wp_customize->add_setting(
	'electrical_repair_enable_product_section',
	array(
		'default'           => false,
		'sanitize_callback' => 'electrical_repair_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Electrical_Repair_Toggle_Switch_Custom_Control(
		$wp_customize,
		'electrical_repair_enable_product_section',
		array(
			'label'    => esc_html__( 'Enable Product Section', 'electrical-repair' ),
			'section'  => 'electrical_repair_products_section',
			'settings' => 'electrical_repair_enable_product_section',
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'electrical_repair_enable_product_section',
		array(
			'selector' => '#electrical_repair_service_section .section-link',
			'settings' => 'electrical_repair_enable_product_section',
		)
	);
}

// Product Section - Heading.
$wp_customize->add_setting(
	'electrical_repair_trending_product_heading',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'electrical_repair_trending_product_heading',
	array(
		'label'           => esc_html__( 'Heading', 'electrical-repair' ),
		'section'         => 'electrical_repair_products_section',
		'settings'        => 'electrical_repair_trending_product_heading',
		'type'            => 'text',
		'active_callback' => 'electrical_repair_is_product_section_enabled',
	)
);

// Product Section - Subheading.
$wp_customize->add_setting(
	'electrical_repair_trending_product_subheading',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'electrical_repair_trending_product_subheading',
	array(
		'label'           => esc_html__( 'Subheading', 'electrical-repair' ),
		'section'         => 'electrical_repair_products_section',
		'settings'        => 'electrical_repair_trending_product_subheading',
		'type'            => 'text',
		'active_callback' => 'electrical_repair_is_product_section_enabled',
	)
);

// Number of Service Posts to Show
$wp_customize->add_setting(
	'electrical_repair_service_post_count',
	array(
		'default'           => 4,
		'sanitize_callback' => 'absint',
	)
);

$wp_customize->add_control(
	'electrical_repair_service_post_count',
	array(
		'label'           => esc_html__( 'Number of Posts to Show', 'electrical-repair' ),
		'section'         => 'electrical_repair_products_section',
		'settings'        => 'electrical_repair_service_post_count',
		'type'            => 'number',
		'input_attrs'     => array(
			'min' => 1,
			'max' => 12,
		),
		'active_callback' => 'electrical_repair_is_product_section_enabled',
	)
);

if(class_exists('woocommerce')){

$electrical_repair_args = array(
	'type'                     => 'product',
	'child_of'                 => 0,
	'parent'                   => '',
	'orderby'                  => 'term_group',
	'order'                    => 'ASC',
	'hide_empty'               => false,
	'hierarchical'             => 1,
	'number'                   => '',
	'taxonomy'                 => 'product_cat',
	'pad_counts'               => false
);
$electrical_repair_categories = get_categories($electrical_repair_args);
$electrical_repair_cat_posts = array();
$electrical_repair_m = 0;
$electrical_repair_cat_posts[]='Select';
foreach($electrical_repair_categories as $electrical_repair_category){
	if($electrical_repair_m==0){
		$electrical_repair_default = $electrical_repair_category->slug;
		$electrical_repair_m++;
	}
	$electrical_repair_cat_posts[$electrical_repair_category->slug] = $electrical_repair_category->name;
}

$wp_customize->add_setting('electrical_repair_trending_product_category',array(
	'default'	=> 'uncategorized',
	'sanitize_callback' => 'electrical_repair_sanitize_select',
));
$wp_customize->add_control('electrical_repair_trending_product_category',array(
	'type'    => 'select',
	'choices' => $electrical_repair_cat_posts,
	'label' => __('Select category to display products ','electrical-repair'),
	'section' => 'electrical_repair_products_section',
	'active_callback' => 'electrical_repair_is_product_section_enabled',
));
}