jQuery(function($) {

    /* -----------------------------------------
    Preloader
    ----------------------------------------- */
    $('#preloader').delay(1000).fadeOut();
    $('#loader').delay(1000).fadeOut("slow");

    /* -----------------------------------------
    Navigation
    ----------------------------------------- */
    $('.menu-toggle').click(function() {
        $(this).toggleClass('open');
    });

    /* -----------------------------------------
    Keyboard Navigation
    ----------------------------------------- */
    $(window).on('load resize', electrical_repair_testing)

    function electrical_repair_testing(event) {
        if ($(window).width() < 1200) {
            $('.main-navigation').find("li").last().bind('keydown', function(e) {
                if (e.shiftKey && e.which === 9) {
                    if ($(this).hasClass('focus')) {
                    }

                } else if (e.which === 9) {
                    e.preventDefault();
                    $('#masthead').find('.menu-toggle').focus();
                }                
            })
        } else {
            $('.main-navigation').find("li").unbind('keydown')
        }
    }

    electrical_repair_testing()

    var electrical_repair_primary_menu_toggle = $('#masthead .menu-toggle');
    electrical_repair_primary_menu_toggle.on('keydown', function(e) {
        var tabKey = e.keyCode === 9;
        var shiftKey = e.shiftKey;

        if (electrical_repair_primary_menu_toggle.hasClass('open')) {
            if (shiftKey && tabKey) {
                e.preventDefault();
                const $the_last_li = $('.main-navigation').find("li").last()
                $the_last_li.find('a').focus()
                if (!$the_last_li.hasClass('focus')) {

                    const $is_parent_on_top = true
                    let $the_parent_ul = $the_last_li.closest('ul.sub-menu')

                    let count = 0

                    while (!!$the_parent_ul.length) {
                        ++count

                        const $the_parent_li = $the_parent_ul.closest('li')

                        if (!!$the_parent_li.length) {
                            $the_parent_li.addClass('focus')
                            $the_parent_ul = $the_parent_li.closest('ul.sub-menu')

                            // Blur the cross
                            $(this).blur()
                            $the_last_li.addClass('focus')
                        }

                        if (!$the_parent_ul.length) {
                            break;
                        }
                    }

                }

            };
        }
    })

    /* -----------------------------------------
    Main Slider
    ----------------------------------------- */

    // Determine if the document is RTL
    var isRtl = $('html').attr('dir') === 'rtl';
    
    $('.banner-slider').slick({
        autoplaySpeed: 3000,
        dots: false,
        arrows: true,
        nextArrow: '<button class="fas fa-angle-right slick-next"></button>',
        prevArrow: '<button class="fas fa-angle-left slick-prev"></button>',
        rtl: isRtl, // Set the rtl option
        responsive: [{
            
            breakpoint: 1025,
            settings: {
                dots: true,
                arrows: false,
            }
        },
        {
            breakpoint: 480,
            settings: {
                dots: true,
                arrows: false,
            }
        }]
    });

    /* -----------------------------------------
    Scroll Top
    ----------------------------------------- */
    var electrical_repair_scrollToTopBtn = $('.electrical-repair-scroll-to-top');

    $(window).scroll(function() {
        if ($(window).scrollTop() > 400) {
            electrical_repair_scrollToTopBtn.addClass('show');
        } else {
            electrical_repair_scrollToTopBtn.removeClass('show');
        }
    });

    electrical_repair_scrollToTopBtn.on('click', function(e) {
        e.preventDefault();
        $('html, body').animate({
            scrollTop: 0
        }, '300');
    });

    //search js

    $(".input").focus(function() {
        $(".form").addClass("move");
    });
    $(".input").focusout(function() {
        $(".form").removeClass("move");
        $(".input").val("");
    });

    $(".search-main .btn").click(function() {
        $(".input").toggleClass("active");
        $(".form").toggleClass("active");
    });    
    
});

document.addEventListener('DOMContentLoaded', function() {
    const header = document.querySelector('.sticky-header');
    if (header) { // Check if header exists
      window.addEventListener('scroll', function() {
        if (window.scrollY > 0) {
          header.classList.add('is-sticky');
        } else {
          header.classList.remove('is-sticky');
        }
      });
    }
  });

jQuery(function($) {
    // Wrap last 3 words in banner
    $(".banner-section.banner-style-1 .banner-single .banner-caption .banner-catption-wrapper .banner-caption-title a").html(function() {
        var textArray = $(this).text().trim().split(" ");
        if (textArray.length > 3) {
            var lastThreeWords = textArray.splice(-3).join(" ");
            var remainingText = textArray.join(" ");
            return remainingText + " <span class='banner-text'>" + lastThreeWords + "</span>";
        } else {
            return "<span class='banner-text'>" + textArray.join(" ") + "</span>";
        }
    });

    // Wrap last 3 characters in site title
    $("p.site-title a").html(function() {
        var text = $(this).text().trim();
        if (text.length > 3) {
            var lastThreeChars = text.slice(-3);
            var remainingText = text.slice(0, -3);
            return remainingText + "<span class='site-title-highlight'>" + lastThreeChars + "</span>";
        } else {
            return "<span class='site-title-highlight'>" + text + "</span>";
        }
    });
});

