<?php
/**
 * The header for our theme
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package electrical_repair
 */
$electrical_repair_menu_text_transform = get_theme_mod( 'electrical_repair_menu_text_transform', 'uppercase' );
$electrical_repair_menu_text_transform_css = 'text-transform: ' . esc_attr( $electrical_repair_menu_text_transform ) . ';';
$electrical_repair_menu_text_color = get_theme_mod('electrical_repair_menu_text_color', ''); 
$electrical_repair_sub_menu_text_color = get_theme_mod('electrical_repair_sub_menu_text_color', ''); 

$electrical_repair_opening_timing = get_theme_mod('electrical_repair_opening_timing', 'Tuesday-Sunday 9:00AM - 9:00PM'); 
$electrical_repair_email_topbar_address = get_theme_mod('electrical_repair_email_topbar_address', 'Green Land, Road Garden, United State of America'); 
$electrical_repair_phone_number = get_theme_mod('electrical_repair_phone_number', '+1234 567 789'); 

?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="https://gmpg.org/xfn/11">
	<?php wp_head(); ?>
</head>

<body <?php body_class(get_theme_mod('electrical_repair_website_layout', false) ? 'site-boxed--layout' : ''); ?>>
<?php wp_body_open(); ?>
<div id="page" class="site asterthemes-site-wrapper">
<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'electrical-repair' ); ?></a>
    <?php if (get_theme_mod('electrical_repair_enable_preloader', false)) : ?>
        <div id="loader" class="<?php echo esc_attr(get_theme_mod('electrical_repair_preloader_style', 'style1')); ?>">
            <div class="loader-container">
                <div id="preloader">
                    <?php 
                    $electrical_repair_preloader_style = get_theme_mod('electrical_repair_preloader_style', 'style1');
                    if ($electrical_repair_preloader_style === 'style1') : ?>
                        <!-- STYLE 1 -->
                        <img src="<?php echo esc_url(get_template_directory_uri() . '/resource/loader.gif'); ?>" alt="<?php esc_attr_e('Loading...', 'electrical-repair'); ?>">
                    <?php elseif ($electrical_repair_preloader_style === 'style2') : ?>
                        <!-- STYLE 2 -->
                        <div class="dot"></div>
                    <?php elseif ($electrical_repair_preloader_style === 'style3') : ?>
                        <!-- STYLE 3 -->
                        <div class="bars">
                            <div class="bar"></div>
                            <div class="bar"></div>
                            <div class="bar"></div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <header id="masthead" class="site-header">
        <div class="header-main-wrapper">
            <?php if ( get_theme_mod( 'electrical_repair_enable_topbar', true ) === true ) {

                $electrical_repair_email_topbar_address = get_theme_mod( 'electrical_repair_email_topbar_address', '' );
				$electrical_repair_phone_number = get_theme_mod( 'electrical_repair_phone_number');
                $electrical_repair_opening_timing = get_theme_mod( 'electrical_repair_opening_timing');

            ?>
                <div class="top-header-part">
                    <div class="asterthemes-wrapper">
                        <div class="bottom-header-part-wrapper">
                            <div class="bottom-header-left-part">
                                <div class="site-branding">
                                    <?php
                                    // Check if the 'Enable Site Logo' setting is true.
                                    if ( get_theme_mod( 'electrical_repair_enable_site_logo', true ) ) {
                                        if ( has_custom_logo() ) { ?>
                                            <div class="site-logo">
                                                <?php the_custom_logo(); ?>
                                            </div>
                                        <?php } else { ?>
                                            <div class="site-logo">
                                                <!-- Fallback logo if no custom logo is set -->
                                                <a href="<?php echo esc_url(home_url('/')); ?>" rel="home">
                                                    <img src="<?php echo esc_url(get_template_directory_uri() . '/resource/img/Logo.png'); ?>" alt="<?php bloginfo('name'); ?>">
                                                </a>
                                            </div>
                                        <?php }
                                    } ?>
                                    <div class="site-identity">
                                        <?php
                                        $electrical_repair_site_title_size = get_theme_mod('electrical_repair_site_title_size', 30);

                                        if (get_theme_mod('electrical_repair_enable_site_title_setting', false)) {
                                            if (is_front_page() && is_home()) : ?>
                                                <h1 class="site-title" style="font-size: <?php echo esc_attr($electrical_repair_site_title_size); ?>px;">
                                                    <a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>
                                                </h1>
                                            <?php else : ?>
                                                <p class="site-title" style="font-size: <?php echo esc_attr($electrical_repair_site_title_size); ?>px;">
                                                    <a href="<?php echo esc_url(home_url('/')); ?>" rel="home"><?php bloginfo('name'); ?></a>
                                                </p>
                                            <?php endif;
                                        }

                                        if (get_theme_mod('electrical_repair_enable_tagline_setting', false)) :
                                            $electrical_repair_description = get_bloginfo('description', 'display');
                                            if ($electrical_repair_description || is_customize_preview()) : ?>
                                                <p class="site-description"><?php echo esc_html($electrical_repair_description); ?></p>
                                            <?php endif;
                                        endif;
                                        ?>
                                    </div>
                                </div>
                            </div>
                            <div class="bottom-header-middle-part">
                                <div class="header-middle-content">
                                    <div class="header-time">
                                        <?php if ( ! empty( $electrical_repair_opening_timing ) ) { ?>
                                            <span><?php echo esc_html( $electrical_repair_opening_timing ); ?></span>
                                        <?php } ?>
                                    </div>
                                    <div class="header-location">
                                        <?php if ( ! empty( $electrical_repair_email_topbar_address ) ) { ?>
                                            <a href="https://www.google.com/maps/search/<?php echo urlencode( $electrical_repair_email_topbar_address ); ?>" target="_blank" rel="noopener">
                                                <i class="<?php echo esc_attr( get_theme_mod( 'electrical_repair_location_header_icon', 'fas fa-map-marker-alt' ) ); ?>"></i>
                                                <?php echo esc_html( $electrical_repair_email_topbar_address ); ?>
                                            </a>
                                        <?php } ?>
                                    </div>
                                </div>
                            </div>
                            <div class="bottom-header-right-part">
                                <?php if ( ! empty( $electrical_repair_phone_number ) ) { ?>
                                    <a href="tel:<?php echo esc_attr(  substr( $electrical_repair_phone_number, 0, 21 )  ); ?>"><i class="<?php echo esc_attr( get_theme_mod( 'electrical_repair_header_phone_icon', 'fas fa-phone-alt' ) ); ?>"></i><span><?php echo esc_html(  substr( $electrical_repair_phone_number, 0, 21 )  ); ?></span></a>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php } ?>
            <div class="bottom-header-outer-wrapper">
                <div class="bottom-header-part">
                    <div class="asterthemes-wrapper">
                        <div class="bottom-header-part-wrapper hello <?php echo esc_attr( get_theme_mod( 'electrical_repair_enable_sticky_header', false ) ? 'sticky-header' : '' ); ?>">
                            <div class="navigation-menus">
                                <div class="asterthemes-wrapper">
                                    <div class="navigation-part">
                                        <nav id="site-navigation" class="main-navigation">
                                            <button class="menu-toggle" aria-controls="primary-menu" aria-expanded="false">
                                                <span></span>
                                                <span></span>
                                                <span></span>
                                            </button>
                                            <div class="main-navigation-links">
                                                <?php
                                                    wp_nav_menu(
                                                        array(
                                                            'theme_location' => 'primary',
                                                        )
                                                    );
                                                ?>
                                            </div>
                                            <style>
                                                /* Main Menu Links */
                                                .main-navigation ul li a, .menu a {
                                                    color: <?php echo esc_attr($electrical_repair_menu_text_color); ?>;
                                                }

                                                /* Submenu Links */
                                                .main-navigation ul.children a, 
                                                .home .main-navigation ul.children a, 
                                                .main-navigation ul.menu li .sub-menu a, 
                                                .home .main-navigation ul ul a {
                                                    color: <?php echo esc_attr($electrical_repair_sub_menu_text_color); ?>;
                                                }
                                            </style>
                                        </nav>
                                    </div>
                                </div>
                            </div>
                            <div class="contact-info">
                                <?php
                                $electrical_repair_enable_header_search_section = get_theme_mod( 'electrical_repair_enable_header_search_section', true );
                                if ( $electrical_repair_enable_header_search_section ) :
                                ?>
                                    <span class="search-main">
                                        <span class="btn">
                                            <i class="fa fa-search" aria-hidden="true"></i>
                                            <span class="label-text"><?php echo esc_html__( 'Search', 'electrical-repair' ); ?></span>
                                        </span>
                                        <div class="form">
                                            <form method="get" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
                                                <label>
                                                    <span class="screen-reader-text"><?php echo esc_html__( 'Search for:', 'electrical-repair' ); ?></span>
                                                    <input type="search" class="search-field" placeholder="<?php echo esc_attr_x( 'Search...', 'placeholder', 'electrical-repair' ); ?>" value="<?php echo esc_attr( get_search_query() ); ?>" name="s" />
                                                </label>
                                                <button type="submit" class="search-submit">
                                                    <span class="screen-reader-text"><?php echo esc_html__( 'Search', 'electrical-repair' ); ?></span>
                                                </button>
                                            </form>
                                        </div>
                                    </span>
                                <?php endif; ?>

                                <?php if ( class_exists( 'WooCommerce' ) ) : ?>
                                    <a class="cart-customlocation" href="<?php echo esc_url( wc_get_cart_url() ); ?>" title="<?php echo esc_attr__( 'View Shopping Cart', 'electrical-repair' ); ?>">
                                        <i class="fas fa-shopping-bag mr-2" aria-hidden="true"></i>
                                        <span class="label-text"><?php echo esc_html__( 'Cart', 'electrical-repair' ); ?></span>
                                    </a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>      
        </div>
    </header>
<?php
    if ( ! is_front_page() || is_home() ) {
	if ( is_front_page() ) {
		require get_template_directory() . '/sections/sections.php';
		electrical_repair_homepage_sections();
	}
	?>
    <?php
        if (!is_front_page() || is_home()) {
            get_template_part('page-header');
        }
    ?>
	<div id="content" class="site-content">
		<div class="asterthemes-wrapper">
			<div class="asterthemes-page">
			<?php } ?>