<?php
/**
 * Title: Products Grid - Style 8 with Filters
 * Slug: acai/wc-products-grid-8-filters
 * Categories: acai_parts
 * Block Types: core/template-part/products
 * Template Types: products
 */
?>
<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|20","bottom":"var:preset|spacing|20"}}},"backgroundColor":"base-2","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull has-base-2-background-color has-background" style="padding-top:var(--wp--preset--spacing--20);padding-bottom:var(--wp--preset--spacing--20)">
	<!-- wp:group {"align":"wide","style":{"spacing":{"blockGap":"var:preset|spacing|40","padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"},"margin":{"top":"var:preset|spacing|50"}},"border":{"width":"4px"}},"backgroundColor":"base","fontSize":"small","borderColor":"contrast","layout":{"type":"flex","flexWrap":"wrap","verticalAlignment":"top","orientation":"horizontal","justifyContent":"space-between"}} -->
	<div class="wp-block-group alignwide has-border-color has-contrast-border-color has-base-background-color has-background has-small-font-size" style="border-width:4px;margin-top:var(--wp--preset--spacing--50);padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
		<!-- wp:woocommerce/filter-wrapper {"filterType":"active-filters","heading":"Active filters"} -->
		<div class="wp-block-woocommerce-filter-wrapper">
			<!-- wp:heading {"level":4,"style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"fontSize":"medium"} -->
			<h4 class="wp-block-heading has-medium-font-size" style="margin-top:0;margin-bottom:0">Active filters</h4>
			<!-- /wp:heading -->

			<!-- wp:woocommerce/active-filters {"displayStyle":"chips","heading":"","lock":{"remove":true}} -->
			<div class="wp-block-woocommerce-active-filters is-loading"><span aria-hidden="true" class="wc-block-active-filters__placeholder"></span></div>
			<!-- /wp:woocommerce/active-filters -->
		</div>
		<!-- /wp:woocommerce/filter-wrapper -->

		<?php acai_wc_attribute_filters_block_markup(); ?>

		<!-- wp:woocommerce/filter-wrapper {"filterType":"price-filter","heading":"Filter by price"} -->
		<div class="wp-block-woocommerce-filter-wrapper">
			<!-- wp:heading {"level":4,"style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"fontSize":"medium"} -->
			<h4 class="wp-block-heading has-medium-font-size" style="margin-top:0;margin-bottom:0">Price</h4>
			<!-- /wp:heading -->

			<!-- wp:woocommerce/price-filter {"heading":"","lock":{"remove":true}} -->
			<div class="wp-block-woocommerce-price-filter is-loading"><span aria-hidden="true" class="wc-block-product-categories__placeholder"></span></div>
			<!-- /wp:woocommerce/price-filter -->
		</div>
		<!-- /wp:woocommerce/filter-wrapper -->

		<!-- wp:woocommerce/filter-wrapper {"filterType":"rating-filter","heading":"Filter by rating"} -->
		<div class="wp-block-woocommerce-filter-wrapper">
			<!-- wp:heading {"level":4,"style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"fontSize":"medium"} -->
			<h4 class="wp-block-heading has-medium-font-size" style="margin-top:0;margin-bottom:0">Rating</h4>
			<!-- /wp:heading -->

			<!-- wp:woocommerce/rating-filter {"showCounts":true,"lock":{"remove":true}} -->
			<div class="wp-block-woocommerce-rating-filter is-loading"></div>
			<!-- /wp:woocommerce/rating-filter -->
		</div>
		<!-- /wp:woocommerce/filter-wrapper -->

		<!-- wp:woocommerce/filter-wrapper {"filterType":"stock-filter","heading":"Filter by stock status"} -->
		<div class="wp-block-woocommerce-filter-wrapper">
			<!-- wp:heading {"level":4,"style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"fontSize":"medium"} -->
			<h4 class="wp-block-heading has-medium-font-size" style="margin-top:0;margin-bottom:0">Stock status</h4>
			<!-- /wp:heading -->

			<!-- wp:woocommerce/stock-filter {"showCounts":true,"heading":"","lock":{"remove":true}} -->
			<div class="wp-block-woocommerce-stock-filter is-loading"></div>
			<!-- /wp:woocommerce/stock-filter -->
		</div>
		<!-- /wp:woocommerce/filter-wrapper -->
	</div>
	<!-- /wp:group -->

	<!-- wp:woocommerce/product-collection {"queryId":0,"query":{"woocommerceAttributes":[],"woocommerceStockStatus":["instock","outofstock","onbackorder"],"taxQuery":[],"isProductCollectionBlock":true,"perPage":10,"pages":0,"offset":0,"postType":"product","order":"desc","orderBy":"date","author":"","search":"","exclude":[],"sticky":"","inherit":true,"filterable":false},"tagName":"div","displayLayout":{"type":"list","columns":2,"shrinkColumns":true},"dimensions":{"widthType":"fill"},"queryContextIncludes":["collection"],"__privatePreviewState":{"isPreview":true,"previewMessage":"Actual products will vary depending on the page being viewed."},"align":"wide"} -->
	<div class="wp-block-woocommerce-product-collection alignwide">
		<!-- wp:woocommerce/product-template -->
		<!-- wp:group {"style":{"spacing":{"margin":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50"}}},"layout":{"type":"default"}} -->
		<div class="wp-block-group" style="margin-top:var(--wp--preset--spacing--50);margin-bottom:var(--wp--preset--spacing--50)">
			<!-- wp:columns {"verticalAlignment":"center","style":{"spacing":{"blockGap":{"top":"0","left":"0"}}}} -->
			<div class="wp-block-columns are-vertically-aligned-center">
				<!-- wp:column {"verticalAlignment":"center","width":""} -->
				<div class="wp-block-column is-vertically-aligned-center">
					<!-- wp:woocommerce/product-image {"saleBadgeAlign":"left","isDescendentOfQueryLoop":true,"acaiExtraProductImg":true,"style":{"spacing":{"margin":{"top":"0","bottom":"0"}}}} /-->
				</div>
				<!-- /wp:column -->

				<!-- wp:column {"width":"2.4rem"} -->
				<div class="wp-block-column" style="flex-basis:2.4rem"></div>
				<!-- /wp:column -->

				<!-- wp:column {"verticalAlignment":"center","width":"","style":{"spacing":{"blockGap":"var:preset|spacing|30","padding":{"right":"0","left":"0"}}}} -->
				<div class="wp-block-column is-vertically-aligned-center" style="padding-right:0;padding-left:0">
					<!-- wp:group {"className":"acai-overlap-14 acia-mobile-overlap-off","style":{"border":{"bottom":{"color":"var:preset|color|contrast","width":"4px"}}},"layout":{"type":"default"},"acaiOverlap":-14,"acaiOverlapMobileOff":true} -->
					<div class="wp-block-group acai-overlap-14 acia-mobile-overlap-off" style="border-bottom-color:var(--wp--preset--color--contrast);border-bottom-width:4px"></div>
					<!-- /wp:group -->

					<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40","left":"var:preset|spacing|40","right":"var:preset|spacing|40"},"margin":{"top":"-4px"}},"elements":{"link":{"color":{"text":"var:preset|color|contrast"}}},"border":{"width":"4px"}},"backgroundColor":"base","textColor":"contrast","borderColor":"contrast","layout":{"type":"default"}} -->
					<div class="wp-block-group has-border-color has-contrast-border-color has-contrast-color has-base-background-color has-text-color has-background has-link-color" style="border-width:4px;margin-top:-4px;padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)">
						<!-- wp:post-title {"textAlign":"left","level":3,"isLink":true,"className":"is-style-links-underline-on-hover","__woocommerceNamespace":"woocommerce/product-collection/product-title"} /-->

						<!-- wp:woocommerce/product-price {"isDescendentOfQueryLoop":true,"textAlign":"left","fontSize":"large","style":{"typography":{"fontStyle":"normal","fontWeight":"500"}}} /-->

						<!-- wp:woocommerce/product-rating {"isDescendentOfQueryLoop":true,"textColor":"accent-3","style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-3"}}}}} /-->

						<!-- wp:post-excerpt {"excerptLength":100} /-->

						<!-- wp:woocommerce/product-sku {"isDescendentOfQueryLoop":true} /-->

						<!-- wp:woocommerce/product-stock-indicator {"isDescendentOfQueryLoop":true,"fontSize":"medium"} /-->

						<!-- wp:woocommerce/product-button {"textAlign":"left","isDescendentOfQueryLoop":true,"fontSize":"medium","style":{"typography":{"textTransform":"uppercase"}}} /-->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:column -->
			</div>
			<!-- /wp:columns -->
		</div>
		<!-- /wp:group -->
		<!-- /wp:woocommerce/product-template -->

		<!-- wp:group {"style":{"spacing":{"margin":{"top":"var:preset|spacing|50"}}}} -->
		<div class="wp-block-group" style="margin-top:var(--wp--preset--spacing--50)">
			<!-- wp:query-pagination {"paginationArrow":"arrow","showLabel":false,"style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast"}}}},"textColor":"contrast","layout":{"type":"flex","justifyContent":"center"}} -->
			<!-- wp:query-pagination-previous {"className":"is-style-links-plain","fontSize":"large"} /-->

			<!-- wp:query-pagination-numbers {"className":"is-style-circle-current"} /-->

			<!-- wp:query-pagination-next {"className":"is-style-links-plain","fontSize":"large"} /-->
			<!-- /wp:query-pagination -->
		</div>
		<!-- /wp:group -->

		<!-- wp:woocommerce/product-collection-no-results -->
		<!-- wp:group {"layout":{"type":"flex","orientation":"vertical","justifyContent":"center","flexWrap":"wrap"}} -->
		<div class="wp-block-group">
			<!-- wp:paragraph {"fontSize":"medium"} -->
			<p class="has-medium-font-size"><strong>No results found</strong></p>
			<!-- /wp:paragraph -->

			<!-- wp:paragraph -->
			<p>You can try <a class="wc-link-clear-any-filters" href="#">clearing any filters</a> or head to our <a class="wc-link-stores-home" href="#">store's home</a></p>
			<!-- /wp:paragraph -->
		</div>
		<!-- /wp:group -->
		<!-- /wp:woocommerce/product-collection-no-results -->
	</div>
	<!-- /wp:woocommerce/product-collection -->
</div>
<!-- /wp:group -->
