<?php
/**
 * Title: Products Grid - Style 4 with Filters
 * Slug: acai/wc-products-grid-4-filters
 * Categories: acai_parts
 * Block Types: core/template-part/products
 * Template Types: products
 */
?>
<!-- wp:group {"align":"full","style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast"}},"heading":{"color":{"text":"var:preset|color|contrast"}}},"spacing":{"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50"}}},"textColor":"contrast","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull has-contrast-color has-text-color has-link-color" style="padding-top:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50)">
	<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|30","left":"var:preset|spacing|30"}}}} -->
	<div class="wp-block-columns alignwide">
		<!-- wp:column {"width":"14%","style":{"border":{"width":"1px","color":"var:preset|color|base-3","radius":"9px"},"spacing":{"padding":{"right":"var:preset|spacing|30","left":"var:preset|spacing|30","top":"var:preset|spacing|30","bottom":"var:preset|spacing|30"}}},"backgroundColor":"base-2"} -->
		<div class="wp-block-column has-border-color has-base-2-background-color has-background" style="border-color:var(--wp--preset--color--base-3);border-width:1px;border-radius:9px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30);flex-basis:14%">
			<!-- wp:group {"style":{"spacing":{"blockGap":"var:preset|spacing|40"}},"fontSize":"small","layout":{"type":"flex","flexWrap":"wrap","verticalAlignment":"top","orientation":"horizontal"}} -->
			<div class="wp-block-group has-small-font-size">
				<!-- wp:woocommerce/filter-wrapper {"filterType":"active-filters","heading":"Active filters"} -->
				<div class="wp-block-woocommerce-filter-wrapper">
					<!-- wp:heading {"level":4,"style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"fontSize":"medium"} -->
					<h4 class="wp-block-heading has-medium-font-size" style="margin-top:0;margin-bottom:0">Active filters</h4>
					<!-- /wp:heading -->

					<!-- wp:woocommerce/active-filters {"displayStyle":"chips","heading":"","lock":{"remove":true}} -->
					<div class="wp-block-woocommerce-active-filters is-loading"><span aria-hidden="true" class="wc-block-active-filters__placeholder"></span></div>
					<!-- /wp:woocommerce/active-filters -->
				</div>
				<!-- /wp:woocommerce/filter-wrapper -->

				<?php acai_wc_attribute_filters_block_markup(); ?>

				<!-- wp:woocommerce/filter-wrapper {"filterType":"price-filter","heading":"Filter by price"} -->
				<div class="wp-block-woocommerce-filter-wrapper">
					<!-- wp:heading {"level":4,"style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"fontSize":"medium"} -->
					<h4 class="wp-block-heading has-medium-font-size" style="margin-top:0;margin-bottom:0">Price</h4>
					<!-- /wp:heading -->

					<!-- wp:woocommerce/price-filter {"heading":"","lock":{"remove":true}} -->
					<div class="wp-block-woocommerce-price-filter is-loading"><span aria-hidden="true" class="wc-block-product-categories__placeholder"></span></div>
					<!-- /wp:woocommerce/price-filter -->
				</div>
				<!-- /wp:woocommerce/filter-wrapper -->

				<!-- wp:woocommerce/filter-wrapper {"filterType":"rating-filter","heading":"Filter by rating"} -->
				<div class="wp-block-woocommerce-filter-wrapper">
					<!-- wp:heading {"level":4,"style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"fontSize":"medium"} -->
					<h4 class="wp-block-heading has-medium-font-size" style="margin-top:0;margin-bottom:0">Rating</h4>
					<!-- /wp:heading -->

					<!-- wp:woocommerce/rating-filter {"showCounts":true,"lock":{"remove":true}} -->
					<div class="wp-block-woocommerce-rating-filter is-loading"></div>
					<!-- /wp:woocommerce/rating-filter -->
				</div>
				<!-- /wp:woocommerce/filter-wrapper -->

				<!-- wp:woocommerce/filter-wrapper {"filterType":"stock-filter","heading":"Filter by stock status"} -->
				<div class="wp-block-woocommerce-filter-wrapper">
					<!-- wp:heading {"level":4,"style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"fontSize":"medium"} -->
					<h4 class="wp-block-heading has-medium-font-size" style="margin-top:0;margin-bottom:0">Stock status</h4>
					<!-- /wp:heading -->

					<!-- wp:woocommerce/stock-filter {"showCounts":true,"heading":"","lock":{"remove":true}} -->
					<div class="wp-block-woocommerce-stock-filter is-loading"></div>
					<!-- /wp:woocommerce/stock-filter -->
				</div>
				<!-- /wp:woocommerce/filter-wrapper -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:woocommerce/product-collection {"queryId":0,"query":{"woocommerceAttributes":[],"woocommerceStockStatus":["instock","outofstock","onbackorder"],"taxQuery":[],"isProductCollectionBlock":true,"perPage":12,"pages":0,"offset":0,"postType":"product","order":"desc","orderBy":"date","author":"","search":"","exclude":[],"sticky":"","inherit":true},"tagName":"div","displayLayout":{"type":"flex","columns":4,"shrinkColumns":true},"dimensions":{"widthType":"fill"},"queryContextIncludes":["collection"],"__privatePreviewState":{"isPreview":true,"previewMessage":"Actual products will vary depending on the page being viewed."},"align":"wide"} -->
			<div class="wp-block-woocommerce-product-collection alignwide">
				<!-- wp:woocommerce/product-template -->
				<!-- wp:group {"style":{"border":{"width":"1px","color":"var:preset|color|base-3","radius":"9px"}},"backgroundColor":"base-2","layout":{"type":"default"}} -->
				<div class="wp-block-group has-border-color has-base-2-background-color has-background" style="border-color:var(--wp--preset--color--base-3);border-width:1px;border-radius:9px">
					<!-- wp:group {"className":"is-style-last-child-hover","layout":{"type":"default"}} -->
					<div class="wp-block-group is-style-last-child-hover">
						<!-- wp:woocommerce/product-image {"imageSizing":"thumbnail","isDescendentOfQueryLoop":true,"style":{"border":{"radius":{"topLeft":"9px","topRight":"9px"}},"spacing":{"margin":{"top":"0","bottom":"0"}}}} /-->

						<!-- wp:group {"style":{"dimensions":{"minHeight":"100%"},"border":{"radius":{"topLeft":"9px","topRight":"9px"}},"color":{"background":"#05011f3d"}},"layout":{"type":"flex","orientation":"vertical","justifyContent":"center","verticalAlignment":"center"}} -->
						<div class="wp-block-group has-background" style="border-top-left-radius:9px;border-top-right-radius:9px;background-color:#05011f3d;min-height:100%">
							<!-- wp:woocommerce/product-button {"textAlign":"center","isDescendentOfQueryLoop":true,"fontSize":"small","style":{"spacing":{"margin":{"bottom":"1rem"}}}} /-->
						</div>
						<!-- /wp:group -->
					</div>
					<!-- /wp:group -->

					<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"},"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"default"}} -->
					<div class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
						<!-- wp:post-title {"textAlign":"center","level":3,"isLink":true,"className":"is-style-links-underline-on-hover","fontSize":"medium","__woocommerceNamespace":"woocommerce/product-collection/product-title"} /-->

						<!-- wp:woocommerce/product-price {"isDescendentOfQueryLoop":true,"textAlign":"center","fontSize":"small","style":{"spacing":{"margin":{"bottom":"1rem"}}}} /-->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->
				<!-- /wp:woocommerce/product-template -->

				<!-- wp:group {"style":{"spacing":{"margin":{"top":"var:preset|spacing|50"}}}} -->
				<div class="wp-block-group" style="margin-top:var(--wp--preset--spacing--50)">
					<!-- wp:query-pagination {"paginationArrow":"arrow","showLabel":false,"style":{"elements":{"link":{"color":{"text":"var:preset|color|contrast"}}}},"textColor":"contrast","layout":{"type":"flex","justifyContent":"center"}} -->
					<!-- wp:query-pagination-previous {"className":"is-style-links-plain","fontSize":"large"} /-->

					<!-- wp:query-pagination-numbers {"className":"is-style-circle-current"} /-->

					<!-- wp:query-pagination-next {"className":"is-style-links-plain","fontSize":"large"} /-->
					<!-- /wp:query-pagination -->
				</div>
				<!-- /wp:group -->

				<!-- wp:woocommerce/product-collection-no-results -->
				<!-- wp:group {"layout":{"type":"flex","orientation":"vertical","justifyContent":"center","flexWrap":"wrap"}} -->
				<div class="wp-block-group">
					<!-- wp:paragraph {"fontSize":"medium"} -->
					<p class="has-medium-font-size"><strong>No results found</strong></p>
					<!-- /wp:paragraph -->

					<!-- wp:paragraph -->
					<p>You can try <a class="wc-link-clear-any-filters" href="#">clearing any filters</a> or head to our <a class="wc-link-stores-home" href="#">store's home</a></p>
					<!-- /wp:paragraph -->
				</div>
				<!-- /wp:group -->
				<!-- /wp:woocommerce/product-collection-no-results -->
			</div>
			<!-- /wp:woocommerce/product-collection -->
		</div>
		<!-- /wp:column -->
	</div>
	<!-- /wp:columns -->
</div>
<!-- /wp:group -->
