<?php
/**
 * Title: A Preview of Product Layout Styles
 * Slug: acai/a-preview-products
 * Categories: acai_shop
 */
?>
<!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group">
	<!-- wp:paragraph -->
	<p><?php esc_html_e( 'This pattern is a preview of the various product design and layout styles that you can use for your online store. When the WooCommerce plugin is active on your site, these layout and design styles are available as separate patterns that can be used to display your actual products on your shop page or anywhere else on any page of your website.', 'acai' ); ?></p>
	<!-- /wp:paragraph -->
</div>
<!-- /wp:group -->

<!-- wp:spacer -->
<div style="height:100px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull">
	<!-- wp:heading {"align":"wide","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|40"}}}} -->
	<h2 class="wp-block-heading alignwide" style="margin-bottom:var(--wp--preset--spacing--40)"><?php esc_html_e( '1. Default style', 'acai' ); ?></h2>
	<!-- /wp:heading -->

	<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|30","left":"var:preset|spacing|30"}}}} -->
	<div class="wp-block-columns alignwide">
		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"style":{"border":{"radius":"9px"},"shadow":"var:preset|shadow|natural"},"layout":{"type":"default"}} -->
			<div class="wp-block-group" style="border-radius:9px;box-shadow:var(--wp--preset--shadow--natural)">
				<!-- wp:image {"aspectRatio":"1","scale":"cover","linkDestination":"none","style":{"border":{"radius":{"topLeft":"8px","topRight":"8px"}}}} -->
				<figure class="wp-block-image has-custom-border"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/700x700-ladies-jacket.jpg') ); ?>" alt="" style="border-top-left-radius:8px;border-top-right-radius:8px;aspect-ratio:1;object-fit:cover" /></figure>
				<!-- /wp:image -->

				<!-- wp:group {"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}}},"layout":{"type":"constrained"}} -->
				<div class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
					<!-- wp:heading {"level":3,"fontSize":"medium"} -->
					<h3 class="wp-block-heading has-medium-font-size"><?php esc_html_e( 'Example One', 'acai' ); ?></h3>
					<!-- /wp:heading -->

					<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|mid"}}},"typography":{"fontStyle":"normal","fontWeight":"300"}},"textColor":"mid","fontSize":"small"} -->
					<p class="has-mid-color has-text-color has-link-color has-small-font-size" style="font-style:normal;font-weight:300"><?php esc_html_e( 'A short example product summary...', 'acai' ); ?></p>
					<!-- /wp:paragraph -->

					<!-- wp:group {"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"space-between","orientation":"horizontal"}} -->
					<div class="wp-block-group">
						<!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"400"}},"fontSize":"small"} -->
						<p class="has-small-font-size" style="font-style:normal;font-weight:400"><?php esc_html_e( '$99.99', 'acai' ); ?></p>
						<!-- /wp:paragraph -->

						<!-- wp:buttons -->
						<div class="wp-block-buttons">
							<!-- wp:button {"style":{"spacing":{"padding":{"left":"var:preset|spacing|20","right":"var:preset|spacing|20","top":"0","bottom":"0"}},"typography":{"lineHeight":"1","fontStyle":"normal","fontWeight":"400"},"border":{"radius":"99px"}},"fontSize":"large","fontFamily":"instrument-sans"} -->
							<div class="wp-block-button"><a class="wp-block-button__link has-instrument-sans-font-family has-large-font-size has-custom-font-size wp-element-button" style="border-radius:99px;padding-top:0;padding-right:var(--wp--preset--spacing--20);padding-bottom:0;padding-left:var(--wp--preset--spacing--20);font-style:normal;font-weight:400;line-height:1">+</a></div>
							<!-- /wp:button -->
						</div>
						<!-- /wp:buttons -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"style":{"border":{"radius":"9px"},"shadow":"var:preset|shadow|natural"},"layout":{"type":"default"}} -->
			<div class="wp-block-group" style="border-radius:9px;box-shadow:var(--wp--preset--shadow--natural)">
				<!-- wp:image {"aspectRatio":"1","scale":"cover","linkDestination":"none","style":{"border":{"radius":{"topLeft":"8px","topRight":"8px"}}}} -->
				<figure class="wp-block-image has-custom-border"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/700x700-mens-shirt.jpg') ); ?>" alt="" style="border-top-left-radius:8px;border-top-right-radius:8px;aspect-ratio:1;object-fit:cover" /></figure>
				<!-- /wp:image -->

				<!-- wp:group {"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}}},"layout":{"type":"constrained"}} -->
				<div class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
					<!-- wp:heading {"level":3,"fontSize":"medium"} -->
					<h3 class="wp-block-heading has-medium-font-size"><?php esc_html_e( 'Example Two', 'acai' ); ?></h3>
					<!-- /wp:heading -->

					<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|mid"}}},"typography":{"fontStyle":"normal","fontWeight":"300"}},"textColor":"mid","fontSize":"small"} -->
					<p class="has-mid-color has-text-color has-link-color has-small-font-size" style="font-style:normal;font-weight:300"><?php esc_html_e( 'A short example product summary...', 'acai' ); ?></p>
					<!-- /wp:paragraph -->

					<!-- wp:group {"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"space-between","orientation":"horizontal"}} -->
					<div class="wp-block-group">
						<!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"400"}},"fontSize":"small"} -->
						<p class="has-small-font-size" style="font-style:normal;font-weight:400"><?php esc_html_e( '$59.99', 'acai' ); ?></p>
						<!-- /wp:paragraph -->

						<!-- wp:buttons -->
						<div class="wp-block-buttons">
							<!-- wp:button {"style":{"spacing":{"padding":{"left":"var:preset|spacing|20","right":"var:preset|spacing|20","top":"0","bottom":"0"}},"typography":{"lineHeight":"1","fontStyle":"normal","fontWeight":"400"},"border":{"radius":"99px"}},"fontSize":"large","fontFamily":"instrument-sans"} -->
							<div class="wp-block-button"><a class="wp-block-button__link has-instrument-sans-font-family has-large-font-size has-custom-font-size wp-element-button" style="border-radius:99px;padding-top:0;padding-right:var(--wp--preset--spacing--20);padding-bottom:0;padding-left:var(--wp--preset--spacing--20);font-style:normal;font-weight:400;line-height:1">+</a></div>
							<!-- /wp:button -->
						</div>
						<!-- /wp:buttons -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"style":{"border":{"radius":"9px"},"shadow":"var:preset|shadow|natural"},"layout":{"type":"default"}} -->
			<div class="wp-block-group" style="border-radius:9px;box-shadow:var(--wp--preset--shadow--natural)">
				<!-- wp:image {"aspectRatio":"1","scale":"cover","linkDestination":"none","style":{"border":{"radius":{"topLeft":"8px","topRight":"8px"}}}} -->
				<figure class="wp-block-image has-custom-border"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/700x700-watch.jpg') ); ?>" alt="" style="border-top-left-radius:8px;border-top-right-radius:8px;aspect-ratio:1;object-fit:cover" /></figure>
				<!-- /wp:image -->

				<!-- wp:group {"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}}},"layout":{"type":"constrained"}} -->
				<div class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
					<!-- wp:heading {"level":3,"fontSize":"medium"} -->
					<h3 class="wp-block-heading has-medium-font-size"><?php esc_html_e( 'Example Three', 'acai' ); ?></h3>
					<!-- /wp:heading -->

					<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|mid"}}},"typography":{"fontStyle":"normal","fontWeight":"300"}},"textColor":"mid","fontSize":"small"} -->
					<p class="has-mid-color has-text-color has-link-color has-small-font-size" style="font-style:normal;font-weight:300"><?php esc_html_e( 'A short example product summary...', 'acai' ); ?></p>
					<!-- /wp:paragraph -->

					<!-- wp:group {"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"space-between","orientation":"horizontal"}} -->
					<div class="wp-block-group">
						<!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"400"}},"fontSize":"small"} -->
						<p class="has-small-font-size" style="font-style:normal;font-weight:400"><?php esc_html_e( '$49.99', 'acai' ); ?></p>
						<!-- /wp:paragraph -->

						<!-- wp:buttons -->
						<div class="wp-block-buttons">
							<!-- wp:button {"style":{"spacing":{"padding":{"left":"var:preset|spacing|20","right":"var:preset|spacing|20","top":"0","bottom":"0"}},"typography":{"lineHeight":"1","fontStyle":"normal","fontWeight":"400"},"border":{"radius":"99px"}},"fontSize":"large","fontFamily":"instrument-sans"} -->
							<div class="wp-block-button"><a class="wp-block-button__link has-instrument-sans-font-family has-large-font-size has-custom-font-size wp-element-button" style="border-radius:99px;padding-top:0;padding-right:var(--wp--preset--spacing--20);padding-bottom:0;padding-left:var(--wp--preset--spacing--20);font-style:normal;font-weight:400;line-height:1">+</a></div>
							<!-- /wp:button -->
						</div>
						<!-- /wp:buttons -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"style":{"shadow":"var:preset|shadow|natural","border":{"radius":"9px"}},"layout":{"type":"default"}} -->
			<div class="wp-block-group" style="border-radius:9px;box-shadow:var(--wp--preset--shadow--natural)">
				<!-- wp:image {"aspectRatio":"1","scale":"cover","linkDestination":"none","style":{"border":{"radius":{"topLeft":"8px","topRight":"8px"}}}} -->
				<figure class="wp-block-image has-custom-border"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/700x700-shoes.jpg') ); ?>" alt="" style="border-top-left-radius:8px;border-top-right-radius:8px;aspect-ratio:1;object-fit:cover" /></figure>
				<!-- /wp:image -->

				<!-- wp:group {"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}}},"layout":{"type":"constrained"}} -->
				<div class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
					<!-- wp:heading {"level":3,"fontSize":"medium"} -->
					<h3 class="wp-block-heading has-medium-font-size"><?php esc_html_e( 'Example Four', 'acai' ); ?></h3>
					<!-- /wp:heading -->

					<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|mid"}}},"typography":{"fontStyle":"normal","fontWeight":"300"}},"textColor":"mid","fontSize":"small"} -->
					<p class="has-mid-color has-text-color has-link-color has-small-font-size" style="font-style:normal;font-weight:300"><?php esc_html_e( 'A short example product summary...', 'acai' ); ?></p>
					<!-- /wp:paragraph -->

					<!-- wp:group {"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"space-between","orientation":"horizontal"}} -->
					<div class="wp-block-group">
						<!-- wp:paragraph {"style":{"typography":{"fontStyle":"normal","fontWeight":"400"}},"fontSize":"small"} -->
						<p class="has-small-font-size" style="font-style:normal;font-weight:400"><?php esc_html_e( '$79.99', 'acai' ); ?></p>
						<!-- /wp:paragraph -->

						<!-- wp:buttons -->
						<div class="wp-block-buttons">
							<!-- wp:button {"style":{"spacing":{"padding":{"left":"var:preset|spacing|20","right":"var:preset|spacing|20","top":"0","bottom":"0"}},"typography":{"lineHeight":"1","fontStyle":"normal","fontWeight":"400"},"border":{"radius":"99px"}},"fontSize":"large","fontFamily":"instrument-sans"} -->
							<div class="wp-block-button"><a class="wp-block-button__link has-instrument-sans-font-family has-large-font-size has-custom-font-size wp-element-button" style="border-radius:99px;padding-top:0;padding-right:var(--wp--preset--spacing--20);padding-bottom:0;padding-left:var(--wp--preset--spacing--20);font-style:normal;font-weight:400;line-height:1">+</a></div>
							<!-- /wp:button -->
						</div>
						<!-- /wp:buttons -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->
	</div>
	<!-- /wp:columns -->
</div>
<!-- /wp:group -->

<!-- wp:spacer -->
<div style="height:100px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50"}},"elements":{"link":{"color":{"text":"var:preset|color|contrast"}},"heading":{"color":{"text":"var:preset|color|contrast"}}}},"backgroundColor":"base-2","textColor":"contrast","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull has-contrast-color has-base-2-background-color has-text-color has-background has-link-color" style="padding-top:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50)">
	<!-- wp:heading {"align":"wide","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|40"}}}} -->
	<h2 class="wp-block-heading alignwide" style="margin-bottom:var(--wp--preset--spacing--40)"><?php esc_html_e( '2. Rounded image style', 'acai' ); ?></h2>
	<!-- /wp:heading -->

	<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|30","left":"var:preset|spacing|30"}}}} -->
	<div class="wp-block-columns alignwide">
		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"style":{"border":{"radius":"9px"},"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"},"blockGap":"var:preset|spacing|30"}},"backgroundColor":"base","layout":{"type":"default"}} -->
			<div class="wp-block-group has-base-background-color has-background" style="border-radius:9px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
				<!-- wp:heading {"level":3,"fontSize":"medium"} -->
				<h3 class="wp-block-heading has-medium-font-size"><?php esc_html_e( 'Example One', 'acai' ); ?></h3>
				<!-- /wp:heading -->

				<!-- wp:image {"aspectRatio":"1","scale":"cover","linkDestination":"none","className":"is-style-rounded"} -->
				<figure class="wp-block-image is-style-rounded"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/700x700-ladies-jacket.jpg') ); ?>" alt="" style="aspect-ratio:1;object-fit:cover" /></figure>
				<!-- /wp:image -->

				<!-- wp:group {"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"space-between","orientation":"horizontal"}} -->
				<div class="wp-block-group">
					<!-- wp:paragraph {"fontSize":"small"} -->
					<p class="has-small-font-size"><?php esc_html_e( '$99.99', 'acai' ); ?></p>
					<!-- /wp:paragraph -->

					<!-- wp:buttons -->
					<div class="wp-block-buttons">
						<!-- wp:button {"style":{"spacing":{"padding":{"left":"var:preset|spacing|20","right":"var:preset|spacing|20","top":"0","bottom":"0"}},"typography":{"lineHeight":"1","fontStyle":"normal","fontWeight":"400"},"border":{"radius":"99px"}},"fontSize":"large","fontFamily":"instrument-sans"} -->
						<div class="wp-block-button"><a class="wp-block-button__link has-instrument-sans-font-family has-large-font-size has-custom-font-size wp-element-button" style="border-radius:99px;padding-top:0;padding-right:var(--wp--preset--spacing--20);padding-bottom:0;padding-left:var(--wp--preset--spacing--20);font-style:normal;font-weight:400;line-height:1">+</a></div>
						<!-- /wp:button -->
					</div>
					<!-- /wp:buttons -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"style":{"border":{"radius":"9px"},"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"},"blockGap":"var:preset|spacing|30"}},"backgroundColor":"base","layout":{"type":"default"}} -->
			<div class="wp-block-group has-base-background-color has-background" style="border-radius:9px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
				<!-- wp:heading {"level":3,"fontSize":"medium"} -->
				<h3 class="wp-block-heading has-medium-font-size"><?php esc_html_e( 'Example Two', 'acai' ); ?></h3>
				<!-- /wp:heading -->

				<!-- wp:image {"aspectRatio":"1","scale":"cover","linkDestination":"none","className":"is-style-rounded"} -->
				<figure class="wp-block-image is-style-rounded"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/700x700-mens-shirt.jpg') ); ?>" alt="" style="aspect-ratio:1;object-fit:cover" /></figure>
				<!-- /wp:image -->

				<!-- wp:group {"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"space-between","orientation":"horizontal"}} -->
				<div class="wp-block-group">
					<!-- wp:paragraph {"fontSize":"small"} -->
					<p class="has-small-font-size"><?php esc_html_e( '$59.99', 'acai' ); ?></p>
					<!-- /wp:paragraph -->

					<!-- wp:buttons -->
					<div class="wp-block-buttons">
						<!-- wp:button {"style":{"spacing":{"padding":{"left":"var:preset|spacing|20","right":"var:preset|spacing|20","top":"0","bottom":"0"}},"typography":{"lineHeight":"1","fontStyle":"normal","fontWeight":"400"},"border":{"radius":"99px"}},"fontSize":"large","fontFamily":"instrument-sans"} -->
						<div class="wp-block-button"><a class="wp-block-button__link has-instrument-sans-font-family has-large-font-size has-custom-font-size wp-element-button" style="border-radius:99px;padding-top:0;padding-right:var(--wp--preset--spacing--20);padding-bottom:0;padding-left:var(--wp--preset--spacing--20);font-style:normal;font-weight:400;line-height:1">+</a></div>
						<!-- /wp:button -->
					</div>
					<!-- /wp:buttons -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"style":{"border":{"radius":"9px"},"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"},"blockGap":"var:preset|spacing|30"}},"backgroundColor":"base","layout":{"type":"default"}} -->
			<div class="wp-block-group has-base-background-color has-background" style="border-radius:9px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
				<!-- wp:heading {"level":3,"fontSize":"medium"} -->
				<h3 class="wp-block-heading has-medium-font-size"><?php esc_html_e( 'Example Three', 'acai' ); ?></h3>
				<!-- /wp:heading -->

				<!-- wp:image {"aspectRatio":"1","scale":"cover","linkDestination":"none","className":"is-style-rounded"} -->
				<figure class="wp-block-image is-style-rounded"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/700x700-watch.jpg') ); ?>" alt="" style="aspect-ratio:1;object-fit:cover" /></figure>
				<!-- /wp:image -->

				<!-- wp:group {"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"space-between","orientation":"horizontal"}} -->
				<div class="wp-block-group">
					<!-- wp:paragraph {"fontSize":"small"} -->
					<p class="has-small-font-size"><?php esc_html_e( '$49.99', 'acai' ); ?></p>
					<!-- /wp:paragraph -->

					<!-- wp:buttons -->
					<div class="wp-block-buttons">
						<!-- wp:button {"style":{"spacing":{"padding":{"left":"var:preset|spacing|20","right":"var:preset|spacing|20","top":"0","bottom":"0"}},"typography":{"lineHeight":"1","fontStyle":"normal","fontWeight":"400"},"border":{"radius":"99px"}},"fontSize":"large","fontFamily":"instrument-sans"} -->
						<div class="wp-block-button"><a class="wp-block-button__link has-instrument-sans-font-family has-large-font-size has-custom-font-size wp-element-button" style="border-radius:99px;padding-top:0;padding-right:var(--wp--preset--spacing--20);padding-bottom:0;padding-left:var(--wp--preset--spacing--20);font-style:normal;font-weight:400;line-height:1">+</a></div>
						<!-- /wp:button -->
					</div>
					<!-- /wp:buttons -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"style":{"border":{"radius":"9px"},"spacing":{"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"},"blockGap":"var:preset|spacing|30"}},"backgroundColor":"base","layout":{"type":"default"}} -->
			<div class="wp-block-group has-base-background-color has-background" style="border-radius:9px;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
				<!-- wp:heading {"level":3,"fontSize":"medium"} -->
				<h3 class="wp-block-heading has-medium-font-size"><?php esc_html_e( 'Example Four', 'acai' ); ?></h3>
				<!-- /wp:heading -->

				<!-- wp:image {"aspectRatio":"1","scale":"cover","linkDestination":"none","className":"is-style-rounded"} -->
				<figure class="wp-block-image is-style-rounded"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/700x700-shoes.jpg') ); ?>" alt="" style="aspect-ratio:1;object-fit:cover" /></figure>
				<!-- /wp:image -->

				<!-- wp:group {"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"space-between","orientation":"horizontal"}} -->
				<div class="wp-block-group">
					<!-- wp:paragraph {"fontSize":"small"} -->
					<p class="has-small-font-size"><?php esc_html_e( '$79.99', 'acai' ); ?></p>
					<!-- /wp:paragraph -->

					<!-- wp:buttons -->
					<div class="wp-block-buttons">
						<!-- wp:button {"style":{"spacing":{"padding":{"left":"var:preset|spacing|20","right":"var:preset|spacing|20","top":"0","bottom":"0"}},"typography":{"lineHeight":"1","fontStyle":"normal","fontWeight":"400"},"border":{"radius":"99px"}},"fontSize":"large","fontFamily":"instrument-sans"} -->
						<div class="wp-block-button"><a class="wp-block-button__link has-instrument-sans-font-family has-large-font-size has-custom-font-size wp-element-button" style="border-radius:99px;padding-top:0;padding-right:var(--wp--preset--spacing--20);padding-bottom:0;padding-left:var(--wp--preset--spacing--20);font-style:normal;font-weight:400;line-height:1">+</a></div>
						<!-- /wp:button -->
					</div>
					<!-- /wp:buttons -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->
	</div>
	<!-- /wp:columns -->
</div>
<!-- /wp:group -->

<!-- wp:spacer -->
<div style="height:100px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50"}},"elements":{"link":{"color":{"text":"var:preset|color|contrast"}},"heading":{"color":{"text":"var:preset|color|contrast"}}}},"backgroundColor":"base-2","textColor":"contrast","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull has-contrast-color has-base-2-background-color has-text-color has-background has-link-color" style="padding-top:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50)">
	<!-- wp:heading {"align":"wide","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|40"}}}} -->
	<h2 class="wp-block-heading alignwide" style="margin-bottom:var(--wp--preset--spacing--40)"><?php esc_html_e( '3. List style', 'acai' ); ?></h2>
	<!-- /wp:heading -->

	<!-- wp:group {"align":"wide","style":{"border":{"radius":"9px"},"spacing":{"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50","left":"var:preset|spacing|50","right":"var:preset|spacing|50"},"blockGap":"var:preset|spacing|30"}},"backgroundColor":"base","layout":{"type":"default"}} -->
	<div class="wp-block-group alignwide has-base-background-color has-background" style="border-radius:9px;padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)">
		<!-- wp:columns {"verticalAlignment":"center","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|70"}}}} -->
		<div class="wp-block-columns are-vertically-aligned-center">
			<!-- wp:column {"verticalAlignment":"center"} -->
			<div class="wp-block-column is-vertically-aligned-center">
				<!-- wp:image {"aspectRatio":"4/3","scale":"cover","linkDestination":"none","style":{"border":{"radius":"9px"}}} -->
				<figure class="wp-block-image has-custom-border"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/700x700-ladies-jacket.jpg') ); ?>" alt="" style="border-radius:9px;aspect-ratio:4/3;object-fit:cover" /></figure>
				<!-- /wp:image -->
			</div>
			<!-- /wp:column -->

			<!-- wp:column {"verticalAlignment":"center","style":{"spacing":{"blockGap":"var:preset|spacing|30"}}} -->
			<div class="wp-block-column is-vertically-aligned-center">
				<!-- wp:heading {"level":3} -->
				<h3 class="wp-block-heading"><?php esc_html_e( 'Example One', 'acai' ); ?></h3>
				<!-- /wp:heading -->

				<!-- wp:paragraph {"fontSize":"large"} -->
				<p class="has-large-font-size"><?php esc_html_e( '$99.99', 'acai' ); ?></p>
				<!-- /wp:paragraph -->

				<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-3"}}}},"textColor":"accent-3","fontSize":"large"} -->
				<p class="has-accent-3-color has-text-color has-link-color has-large-font-size">★★★★★</p>
				<!-- /wp:paragraph -->

				<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|mid"}}}},"textColor":"mid"} -->
				<p class="has-mid-color has-text-color has-link-color">Lorem ipsum dolor sit amet consectetur adipiscing elit varius mus, morbi eros faucibus nam eu nullam tellus bibendum euismod, fringilla felis nulla turpis inceptos habitasse.</p>
				<!-- /wp:paragraph -->

				<!-- wp:paragraph -->
				<p><?php esc_html_e( 'SKU: ABC-123', 'acai' ); ?></p>
				<!-- /wp:paragraph -->

				<!-- wp:buttons -->
				<div class="wp-block-buttons">
					<!-- wp:button -->
					<div class="wp-block-button"><a class="wp-block-button__link wp-element-button"><?php esc_html_e( 'Add to cart', 'acai' ); ?></a></div>
					<!-- /wp:button -->
				</div>
				<!-- /wp:buttons -->
			</div>
			<!-- /wp:column -->
		</div>
		<!-- /wp:columns -->
	</div>
	<!-- /wp:group -->

	<!-- wp:group {"align":"wide","style":{"border":{"radius":"9px"},"spacing":{"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50","left":"var:preset|spacing|50","right":"var:preset|spacing|50"},"blockGap":"var:preset|spacing|30","margin":{"top":"var:preset|spacing|50"}}},"backgroundColor":"base","layout":{"type":"default"}} -->
	<div class="wp-block-group alignwide has-base-background-color has-background" style="border-radius:9px;margin-top:var(--wp--preset--spacing--50);padding-top:var(--wp--preset--spacing--50);padding-right:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50);padding-left:var(--wp--preset--spacing--50)">
		<!-- wp:columns {"verticalAlignment":"center","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|40","left":"var:preset|spacing|70"}}}} -->
		<div class="wp-block-columns are-vertically-aligned-center">
			<!-- wp:column {"verticalAlignment":"center"} -->
			<div class="wp-block-column is-vertically-aligned-center">
				<!-- wp:image {"aspectRatio":"4/3","scale":"cover","linkDestination":"none","style":{"border":{"radius":"9px"}}} -->
				<figure class="wp-block-image has-custom-border"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/700x700-mens-shirt.jpg') ); ?>" alt="" style="border-radius:9px;aspect-ratio:4/3;object-fit:cover" /></figure>
				<!-- /wp:image -->
			</div>
			<!-- /wp:column -->

			<!-- wp:column {"verticalAlignment":"center","style":{"spacing":{"blockGap":"var:preset|spacing|30"}}} -->
			<div class="wp-block-column is-vertically-aligned-center">
				<!-- wp:heading {"level":3} -->
				<h3 class="wp-block-heading"><?php esc_html_e( 'Example Two', 'acai' ); ?></h3>
				<!-- /wp:heading -->

				<!-- wp:paragraph {"fontSize":"large"} -->
				<p class="has-large-font-size"><?php esc_html_e( '$59.99', 'acai' ); ?></p>
				<!-- /wp:paragraph -->

				<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-3"}}}},"textColor":"accent-3","fontSize":"large"} -->
				<p class="has-accent-3-color has-text-color has-link-color has-large-font-size">★★★★★</p>
				<!-- /wp:paragraph -->

				<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|mid"}}}},"textColor":"mid"} -->
				<p class="has-mid-color has-text-color has-link-color">Lorem ipsum dolor sit amet consectetur adipiscing elit varius mus, morbi eros faucibus nam eu nullam tellus bibendum euismod, fringilla felis nulla turpis inceptos habitasse.</p>
				<!-- /wp:paragraph -->

				<!-- wp:paragraph -->
				<p><?php esc_html_e( 'SKU: ABC-123', 'acai' ); ?></p>
				<!-- /wp:paragraph -->

				<!-- wp:buttons -->
				<div class="wp-block-buttons">
					<!-- wp:button -->
					<div class="wp-block-button"><a class="wp-block-button__link wp-element-button"><?php esc_html_e( 'Add to cart', 'acai' ); ?></a></div>
					<!-- /wp:button -->
				</div>
				<!-- /wp:buttons -->
			</div>
			<!-- /wp:column -->
		</div>
		<!-- /wp:columns -->
	</div>
	<!-- /wp:group -->
</div>
<!-- /wp:group -->

<!-- wp:spacer -->
<div style="height:100px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull">
	<!-- wp:group {"align":"wide","layout":{"type":"default"}} -->
	<div class="wp-block-group alignwide">
		<!-- wp:heading -->
		<h2 class="wp-block-heading"><?php esc_html_e( '4. Hover cart style', 'acai' ); ?></h2>
		<!-- /wp:heading -->

		<!-- wp:paragraph {"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|40"}}}} -->
		<p style="margin-bottom:var(--wp--preset--spacing--40)"><?php esc_html_e( 'Hover over product image for add to cart button', 'acai' ); ?></p>
		<!-- /wp:paragraph -->
	</div>
	<!-- /wp:group -->

	<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|30","left":"var:preset|spacing|30"}},"elements":{"link":{"color":{"text":"var:preset|color|contrast"}},"heading":{"color":{"text":"var:preset|color|contrast"}}}},"textColor":"contrast"} -->
	<div class="wp-block-columns alignwide has-contrast-color has-text-color has-link-color">
		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"style":{"border":{"radius":"9px","width":"1px"}},"backgroundColor":"base-2","borderColor":"base-3","layout":{"type":"default"}} -->
			<div class="wp-block-group has-border-color has-base-3-border-color has-base-2-background-color has-background" style="border-width:1px;border-radius:9px">
				<!-- wp:group {"className":"is-style-last-child-hover-no-editor","layout":{"type":"default"}} -->
				<div class="wp-block-group is-style-last-child-hover-no-editor">
					<!-- wp:image {"aspectRatio":"1","scale":"cover","linkDestination":"none","style":{"border":{"radius":{"topLeft":"8px","topRight":"8px"}}}} -->
					<figure class="wp-block-image has-custom-border"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/700x700-ladies-jacket.jpg') ); ?>" alt="" style="border-top-left-radius:8px;border-top-right-radius:8px;aspect-ratio:1;object-fit:cover" /></figure>
					<!-- /wp:image -->

					<!-- wp:group {"style":{"dimensions":{"minHeight":"100%"},"border":{"radius":{"topLeft":"9px","topRight":"9px"}},"color":{"background":"#05011f3d"}},"layout":{"type":"flex","orientation":"vertical","flexWrap":"nowrap","justifyContent":"center","verticalAlignment":"center"}} -->
					<div class="wp-block-group has-background" style="border-top-left-radius:9px;border-top-right-radius:9px;background-color:#05011f3d;min-height:100%">
						<!-- wp:buttons -->
						<div class="wp-block-buttons">
							<!-- wp:button -->
							<div class="wp-block-button"><a class="wp-block-button__link wp-element-button"><?php esc_html_e( 'Add to cart', 'acai' ); ?></a></div>
							<!-- /wp:button -->
						</div>
						<!-- /wp:buttons -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->

				<!-- wp:group {"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}}},"layout":{"type":"constrained"}} -->
				<div class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
					<!-- wp:heading {"textAlign":"center","level":3,"fontSize":"medium"} -->
					<h3 class="wp-block-heading has-text-align-center has-medium-font-size"><?php esc_html_e( 'Example One', 'acai' ); ?></h3>
					<!-- /wp:heading -->

					<!-- wp:paragraph {"align":"center","fontSize":"small"} -->
					<p class="has-text-align-center has-small-font-size"><?php esc_html_e( '$99.99', 'acai' ); ?></p>
					<!-- /wp:paragraph -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"style":{"border":{"radius":"9px","width":"1px"}},"backgroundColor":"base-2","borderColor":"base-3","layout":{"type":"default"}} -->
			<div class="wp-block-group has-border-color has-base-3-border-color has-base-2-background-color has-background" style="border-width:1px;border-radius:9px">
				<!-- wp:group {"className":"is-style-last-child-hover-no-editor","layout":{"type":"default"}} -->
				<div class="wp-block-group is-style-last-child-hover-no-editor">
					<!-- wp:image {"aspectRatio":"1","scale":"cover","linkDestination":"none","style":{"border":{"radius":{"topLeft":"8px","topRight":"8px"}}}} -->
					<figure class="wp-block-image has-custom-border"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/700x700-mens-shirt.jpg') ); ?>" alt="" style="border-top-left-radius:8px;border-top-right-radius:8px;aspect-ratio:1;object-fit:cover" /></figure>
					<!-- /wp:image -->

					<!-- wp:group {"style":{"dimensions":{"minHeight":"100%"},"border":{"radius":{"topLeft":"9px","topRight":"9px"}},"color":{"background":"#05011f3d"}},"layout":{"type":"flex","orientation":"vertical","flexWrap":"nowrap","justifyContent":"center","verticalAlignment":"center"}} -->
					<div class="wp-block-group has-background" style="border-top-left-radius:9px;border-top-right-radius:9px;background-color:#05011f3d;min-height:100%">
						<!-- wp:buttons -->
						<div class="wp-block-buttons">
							<!-- wp:button -->
							<div class="wp-block-button"><a class="wp-block-button__link wp-element-button"><?php esc_html_e( 'Add to cart', 'acai' ); ?></a></div>
							<!-- /wp:button -->
						</div>
						<!-- /wp:buttons -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->

				<!-- wp:group {"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}}},"layout":{"type":"constrained"}} -->
				<div class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
					<!-- wp:heading {"textAlign":"center","level":3,"fontSize":"medium"} -->
					<h3 class="wp-block-heading has-text-align-center has-medium-font-size"><?php esc_html_e( 'Example Two', 'acai' ); ?></h3>
					<!-- /wp:heading -->

					<!-- wp:paragraph {"align":"center","fontSize":"small"} -->
					<p class="has-text-align-center has-small-font-size"><?php esc_html_e( '$59.99', 'acai' ); ?></p>
					<!-- /wp:paragraph -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"style":{"border":{"radius":"9px","width":"1px"}},"backgroundColor":"base-2","borderColor":"base-3","layout":{"type":"default"}} -->
			<div class="wp-block-group has-border-color has-base-3-border-color has-base-2-background-color has-background" style="border-width:1px;border-radius:9px">
				<!-- wp:group {"className":"is-style-last-child-hover-no-editor","layout":{"type":"default"}} -->
				<div class="wp-block-group is-style-last-child-hover-no-editor">
					<!-- wp:image {"aspectRatio":"1","scale":"cover","linkDestination":"none","style":{"border":{"radius":{"topLeft":"8px","topRight":"8px"}}}} -->
					<figure class="wp-block-image has-custom-border"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/700x700-watch.jpg') ); ?>" alt="" style="border-top-left-radius:8px;border-top-right-radius:8px;aspect-ratio:1;object-fit:cover" /></figure>
					<!-- /wp:image -->

					<!-- wp:group {"style":{"dimensions":{"minHeight":"100%"},"border":{"radius":{"topLeft":"9px","topRight":"9px"}},"color":{"background":"#05011f3d"}},"layout":{"type":"flex","orientation":"vertical","flexWrap":"nowrap","justifyContent":"center","verticalAlignment":"center"}} -->
					<div class="wp-block-group has-background" style="border-top-left-radius:9px;border-top-right-radius:9px;background-color:#05011f3d;min-height:100%">
						<!-- wp:buttons -->
						<div class="wp-block-buttons">
							<!-- wp:button -->
							<div class="wp-block-button"><a class="wp-block-button__link wp-element-button"><?php esc_html_e( 'Add to cart', 'acai' ); ?></a></div>
							<!-- /wp:button -->
						</div>
						<!-- /wp:buttons -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->

				<!-- wp:group {"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}}},"layout":{"type":"constrained"}} -->
				<div class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
					<!-- wp:heading {"textAlign":"center","level":3,"fontSize":"medium"} -->
					<h3 class="wp-block-heading has-text-align-center has-medium-font-size"><?php esc_html_e( 'Example Three', 'acai' ); ?></h3>
					<!-- /wp:heading -->

					<!-- wp:paragraph {"align":"center","fontSize":"small"} -->
					<p class="has-text-align-center has-small-font-size"><?php esc_html_e( '$49.99', 'acai' ); ?></p>
					<!-- /wp:paragraph -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"style":{"border":{"radius":"9px","width":"1px"}},"backgroundColor":"base-2","borderColor":"base-3","layout":{"type":"default"}} -->
			<div class="wp-block-group has-border-color has-base-3-border-color has-base-2-background-color has-background" style="border-width:1px;border-radius:9px">
				<!-- wp:group {"className":"is-style-last-child-hover-no-editor","layout":{"type":"default"}} -->
				<div class="wp-block-group is-style-last-child-hover-no-editor">
					<!-- wp:image {"aspectRatio":"1","scale":"cover","linkDestination":"none","style":{"border":{"radius":{"topLeft":"8px","topRight":"8px"}}}} -->
					<figure class="wp-block-image has-custom-border"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/700x700-shoes.jpg') ); ?>" alt="" style="border-top-left-radius:8px;border-top-right-radius:8px;aspect-ratio:1;object-fit:cover" /></figure>
					<!-- /wp:image -->

					<!-- wp:group {"style":{"dimensions":{"minHeight":"100%"},"border":{"radius":{"topLeft":"9px","topRight":"9px"}},"color":{"background":"#05011f3d"}},"layout":{"type":"flex","orientation":"vertical","flexWrap":"nowrap","justifyContent":"center","verticalAlignment":"center"}} -->
					<div class="wp-block-group has-background" style="border-top-left-radius:9px;border-top-right-radius:9px;background-color:#05011f3d;min-height:100%">
						<!-- wp:buttons -->
						<div class="wp-block-buttons">
							<!-- wp:button -->
							<div class="wp-block-button"><a class="wp-block-button__link wp-element-button"><?php esc_html_e( 'Add to cart', 'acai' ); ?></a></div>
							<!-- /wp:button -->
						</div>
						<!-- /wp:buttons -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->

				<!-- wp:group {"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}}},"layout":{"type":"constrained"}} -->
				<div class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
					<!-- wp:heading {"textAlign":"center","level":3,"fontSize":"medium"} -->
					<h3 class="wp-block-heading has-text-align-center has-medium-font-size"><?php esc_html_e( 'Example Four', 'acai' ); ?></h3>
					<!-- /wp:heading -->

					<!-- wp:paragraph {"align":"center","fontSize":"small"} -->
					<p class="has-text-align-center has-small-font-size"><?php esc_html_e( '$79.99', 'acai' ); ?></p>
					<!-- /wp:paragraph -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->
	</div>
	<!-- /wp:columns -->
</div>
<!-- /wp:group -->

<!-- wp:spacer -->
<div style="height:100px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull">
	<!-- wp:group {"align":"wide","layout":{"type":"default"}} -->
	<div class="wp-block-group alignwide">
		<!-- wp:heading -->
		<h2 class="wp-block-heading"><?php esc_html_e( '5. Full width framed', 'acai' ); ?></h2>
		<!-- /wp:heading -->

		<!-- wp:paragraph {"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|40"}}}} -->
		<p style="margin-bottom:var(--wp--preset--spacing--40)"><?php esc_html_e( 'Hover over product for highlighted frame', 'acai' ); ?></p>
		<!-- /wp:paragraph -->
	</div>
	<!-- /wp:group -->

	<!-- wp:columns {"align":"full","style":{"spacing":{"blockGap":{"top":"2px","left":"2px"},"padding":{"top":"2px","bottom":"2px","left":"2px","right":"2px"}},"elements":{"link":{"color":{"text":"var:preset|color|contrast"}},"heading":{"color":{"text":"var:preset|color|contrast"}}}},"backgroundColor":"base-3","textColor":"contrast"} -->
	<div class="wp-block-columns alignfull has-contrast-color has-base-3-background-color has-text-color has-background has-link-color" style="padding-top:2px;padding-right:2px;padding-bottom:2px;padding-left:2px">
		<!-- wp:column {"backgroundColor":"base"} -->
		<div class="wp-block-column has-base-background-color has-background">
			<!-- wp:group {"className":"is-style-hover-shadow-framed","layout":{"type":"default"}} -->
			<div class="wp-block-group is-style-hover-shadow-framed">
				<!-- wp:image {"aspectRatio":"1","scale":"cover","linkDestination":"none"} -->
				 <figure class="wp-block-image"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/700x700-ladies-jacket.jpg') ); ?>" alt="" style="aspect-ratio:1;object-fit:cover" /></figure>
				<!-- /wp:image -->

				<!-- wp:group {"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}}},"layout":{"type":"constrained"}} -->
				<div class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
					<!-- wp:heading {"level":3,"fontSize":"medium"} -->
					<h3 class="wp-block-heading has-medium-font-size"><?php esc_html_e( 'Example One', 'acai' ); ?></h3>
					<!-- /wp:heading -->

					<!-- wp:group {"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"space-between","orientation":"horizontal"}} -->
					<div class="wp-block-group">
						<!-- wp:paragraph {"fontSize":"small"} -->
						<p class="has-small-font-size"><?php esc_html_e( '$99.99', 'acai' ); ?></p>
						<!-- /wp:paragraph -->

						<!-- wp:buttons -->
						<div class="wp-block-buttons">
							<!-- wp:button {"style":{"spacing":{"padding":{"left":"var:preset|spacing|20","right":"var:preset|spacing|20","top":"0","bottom":"0"}},"typography":{"lineHeight":"1","fontStyle":"normal","fontWeight":"400"},"border":{"radius":"99px"}},"fontSize":"large","fontFamily":"instrument-sans"} -->
							<div class="wp-block-button"><a class="wp-block-button__link has-instrument-sans-font-family has-large-font-size has-custom-font-size wp-element-button" style="border-radius:99px;padding-top:0;padding-right:var(--wp--preset--spacing--20);padding-bottom:0;padding-left:var(--wp--preset--spacing--20);font-style:normal;font-weight:400;line-height:1">+</a></div>
							<!-- /wp:button -->
						</div>
						<!-- /wp:buttons -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column {"backgroundColor":"base"} -->
		<div class="wp-block-column has-base-background-color has-background">
			<!-- wp:group {"className":"is-style-hover-shadow-framed","layout":{"type":"default"}} -->
			<div class="wp-block-group is-style-hover-shadow-framed">
				<!-- wp:image {"aspectRatio":"1","scale":"cover","linkDestination":"none"} -->
				 <figure class="wp-block-image"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/700x700-mens-shirt.jpg') ); ?>" alt="" style="aspect-ratio:1;object-fit:cover" /></figure>
				<!-- /wp:image -->

				<!-- wp:group {"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}}},"layout":{"type":"constrained"}} -->
				<div class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
					<!-- wp:heading {"level":3,"fontSize":"medium"} -->
					<h3 class="wp-block-heading has-medium-font-size"><?php esc_html_e( 'Example Two', 'acai' ); ?></h3>
					<!-- /wp:heading -->

					<!-- wp:group {"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"space-between","orientation":"horizontal"}} -->
					<div class="wp-block-group">
						<!-- wp:paragraph {"fontSize":"small"} -->
						<p class="has-small-font-size"><?php esc_html_e( '$59.99', 'acai' ); ?></p>
						<!-- /wp:paragraph -->

						<!-- wp:buttons -->
						<div class="wp-block-buttons">
							<!-- wp:button {"style":{"spacing":{"padding":{"left":"var:preset|spacing|20","right":"var:preset|spacing|20","top":"0","bottom":"0"}},"typography":{"lineHeight":"1","fontStyle":"normal","fontWeight":"400"},"border":{"radius":"99px"}},"fontSize":"large","fontFamily":"instrument-sans"} -->
							<div class="wp-block-button"><a class="wp-block-button__link has-instrument-sans-font-family has-large-font-size has-custom-font-size wp-element-button" style="border-radius:99px;padding-top:0;padding-right:var(--wp--preset--spacing--20);padding-bottom:0;padding-left:var(--wp--preset--spacing--20);font-style:normal;font-weight:400;line-height:1">+</a></div>
							<!-- /wp:button -->
						</div>
						<!-- /wp:buttons -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column {"backgroundColor":"base"} -->
		<div class="wp-block-column has-base-background-color has-background">
			<!-- wp:group {"className":"is-style-hover-shadow-framed","layout":{"type":"default"}} -->
			<div class="wp-block-group is-style-hover-shadow-framed">
				<!-- wp:image {"aspectRatio":"1","scale":"cover","linkDestination":"none"} -->
				 <figure class="wp-block-image"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/700x700-watch.jpg') ); ?>" alt="" style="aspect-ratio:1;object-fit:cover" /></figure>
				<!-- /wp:image -->

				<!-- wp:group {"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}}},"layout":{"type":"constrained"}} -->
				<div class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
					<!-- wp:heading {"level":3,"fontSize":"medium"} -->
					<h3 class="wp-block-heading has-medium-font-size"><?php esc_html_e( 'Example Three', 'acai' ); ?></h3>
					<!-- /wp:heading -->

					<!-- wp:group {"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"space-between","orientation":"horizontal"}} -->
					<div class="wp-block-group">
						<!-- wp:paragraph {"fontSize":"small"} -->
						<p class="has-small-font-size"><?php esc_html_e( '$49.99', 'acai' ); ?></p>
						<!-- /wp:paragraph -->

						<!-- wp:buttons -->
						<div class="wp-block-buttons">
							<!-- wp:button {"style":{"spacing":{"padding":{"left":"var:preset|spacing|20","right":"var:preset|spacing|20","top":"0","bottom":"0"}},"typography":{"lineHeight":"1","fontStyle":"normal","fontWeight":"400"},"border":{"radius":"99px"}},"fontSize":"large","fontFamily":"instrument-sans"} -->
							<div class="wp-block-button"><a class="wp-block-button__link has-instrument-sans-font-family has-large-font-size has-custom-font-size wp-element-button" style="border-radius:99px;padding-top:0;padding-right:var(--wp--preset--spacing--20);padding-bottom:0;padding-left:var(--wp--preset--spacing--20);font-style:normal;font-weight:400;line-height:1">+</a></div>
							<!-- /wp:button -->
						</div>
						<!-- /wp:buttons -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column {"backgroundColor":"base"} -->
		<div class="wp-block-column has-base-background-color has-background">
			<!-- wp:group {"className":"is-style-hover-shadow-framed","layout":{"type":"default"}} -->
			<div class="wp-block-group is-style-hover-shadow-framed">
				<!-- wp:image {"aspectRatio":"1","scale":"cover","linkDestination":"none"} -->
				 <figure class="wp-block-image"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/700x700-shoes.jpg') ); ?>" alt="" style="aspect-ratio:1;object-fit:cover" /></figure>
				<!-- /wp:image -->

				<!-- wp:group {"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}}},"layout":{"type":"constrained"}} -->
				<div class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
					<!-- wp:heading {"level":3,"fontSize":"medium"} -->
					<h3 class="wp-block-heading has-medium-font-size"><?php esc_html_e( 'Example Four', 'acai' ); ?></h3>
					<!-- /wp:heading -->

					<!-- wp:group {"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"space-between","orientation":"horizontal"}} -->
					<div class="wp-block-group">
						<!-- wp:paragraph {"fontSize":"small"} -->
						<p class="has-small-font-size"><?php esc_html_e( '$79.99', 'acai' ); ?></p>
						<!-- /wp:paragraph -->

						<!-- wp:buttons -->
						<div class="wp-block-buttons">
							<!-- wp:button {"style":{"spacing":{"padding":{"left":"var:preset|spacing|20","right":"var:preset|spacing|20","top":"0","bottom":"0"}},"typography":{"lineHeight":"1","fontStyle":"normal","fontWeight":"400"},"border":{"radius":"99px"}},"fontSize":"large","fontFamily":"instrument-sans"} -->
							<div class="wp-block-button"><a class="wp-block-button__link has-instrument-sans-font-family has-large-font-size has-custom-font-size wp-element-button" style="border-radius:99px;padding-top:0;padding-right:var(--wp--preset--spacing--20);padding-bottom:0;padding-left:var(--wp--preset--spacing--20);font-style:normal;font-weight:400;line-height:1">+</a></div>
							<!-- /wp:button -->
						</div>
						<!-- /wp:buttons -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column {"backgroundColor":"base"} -->
		<div class="wp-block-column has-base-background-color has-background">
			<!-- wp:group {"className":"is-style-hover-shadow-framed","layout":{"type":"default"}} -->
			<div class="wp-block-group is-style-hover-shadow-framed">
				<!-- wp:image {"aspectRatio":"1","scale":"cover","linkDestination":"none"} -->
				 <figure class="wp-block-image"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/700x700-vase.jpg') ); ?>" alt="" style="aspect-ratio:1;object-fit:cover" /></figure>
				<!-- /wp:image -->

				<!-- wp:group {"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}}},"layout":{"type":"constrained"}} -->
				<div class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
					<!-- wp:heading {"level":3,"fontSize":"medium"} -->
					<h3 class="wp-block-heading has-medium-font-size"><?php esc_html_e( 'Example Five', 'acai' ); ?></h3>
					<!-- /wp:heading -->

					<!-- wp:group {"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"space-between","orientation":"horizontal"}} -->
					<div class="wp-block-group">
						<!-- wp:paragraph {"fontSize":"small"} -->
						<p class="has-small-font-size"><?php esc_html_e( '$99.99', 'acai' ); ?></p>
						<!-- /wp:paragraph -->

						<!-- wp:buttons -->
						<div class="wp-block-buttons">
							<!-- wp:button {"style":{"spacing":{"padding":{"left":"var:preset|spacing|20","right":"var:preset|spacing|20","top":"0","bottom":"0"}},"typography":{"lineHeight":"1","fontStyle":"normal","fontWeight":"400"},"border":{"radius":"99px"}},"fontSize":"large","fontFamily":"instrument-sans"} -->
							<div class="wp-block-button"><a class="wp-block-button__link has-instrument-sans-font-family has-large-font-size has-custom-font-size wp-element-button" style="border-radius:99px;padding-top:0;padding-right:var(--wp--preset--spacing--20);padding-bottom:0;padding-left:var(--wp--preset--spacing--20);font-style:normal;font-weight:400;line-height:1">+</a></div>
							<!-- /wp:button -->
						</div>
						<!-- /wp:buttons -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->
	</div>
	<!-- /wp:columns -->
</div>
<!-- /wp:group -->

<!-- wp:spacer -->
<div style="height:100px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull">
	<!-- wp:group {"align":"wide","layout":{"type":"default"}} -->
	<div class="wp-block-group alignwide">
		<!-- wp:heading -->
		<h2 class="wp-block-heading"><?php esc_html_e( '6. Deep shadow style', 'acai' ); ?></h2>
		<!-- /wp:heading -->

		<!-- wp:paragraph {"style":{"spacing":{"margin":{"bottom":"var:preset|spacing|40"}}}} -->
		<p style="margin-bottom:var(--wp--preset--spacing--40)"><?php esc_html_e( 'Hover over product for deeper shadow effect', 'acai' ); ?></p>
		<!-- /wp:paragraph -->
	</div>
	<!-- /wp:group -->

	<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|30","left":"var:preset|spacing|30"}}}} -->
	<div class="wp-block-columns alignwide">
		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"className":"is-style-hover-shadow-deep","style":{"border":{"radius":"9px"},"shadow":"var:preset|shadow|natural"},"layout":{"type":"default"}} -->
			<div class="wp-block-group is-style-hover-shadow-deep" style="border-radius:9px;box-shadow:var(--wp--preset--shadow--natural)">
				<!-- wp:image {"aspectRatio":"1","scale":"cover","linkDestination":"none","style":{"border":{"radius":{"topLeft":"8px","topRight":"8px"}}}} -->
				<figure class="wp-block-image has-custom-border"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/700x700-ladies-jacket.jpg') ); ?>" alt="" style="border-top-left-radius:8px;border-top-right-radius:8px;aspect-ratio:1;object-fit:cover" /></figure>
				<!-- /wp:image -->

				<!-- wp:group {"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}}},"layout":{"type":"constrained"}} -->
				<div class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
					<!-- wp:group {"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"space-between","orientation":"horizontal"}} -->
					<div class="wp-block-group">
						<!-- wp:heading {"level":3,"style":{"typography":{"fontStyle":"normal","fontWeight":"400"}},"fontSize":"small"} -->
						<h3 class="wp-block-heading has-small-font-size" style="font-style:normal;font-weight:400"><?php esc_html_e( 'Example One', 'acai' ); ?></h3>
						<!-- /wp:heading -->

						<!-- wp:paragraph {"fontSize":"small"} -->
						<p class="has-small-font-size"><?php esc_html_e( '$99.99', 'acai' ); ?></p>
						<!-- /wp:paragraph -->
					</div>
					<!-- /wp:group -->

					<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
					<div class="wp-block-buttons">
						<!-- wp:button {"style":{"typography":{"fontStyle":"normal","fontWeight":"400"}},"fontSize":"small"} -->
						<div class="wp-block-button"><a class="wp-block-button__link has-small-font-size has-custom-font-size wp-element-button" style="font-style:normal;font-weight:400"><?php esc_html_e( 'Add to cart', 'acai' ); ?></a></div>
						<!-- /wp:button -->
					</div>
					<!-- /wp:buttons -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"className":"is-style-hover-shadow-deep","style":{"border":{"radius":"9px"},"shadow":"var:preset|shadow|natural"},"layout":{"type":"default"}} -->
			<div class="wp-block-group is-style-hover-shadow-deep" style="border-radius:9px;box-shadow:var(--wp--preset--shadow--natural)">
				<!-- wp:image {"aspectRatio":"1","scale":"cover","linkDestination":"none","style":{"border":{"radius":{"topLeft":"8px","topRight":"8px"}}}} -->
				<figure class="wp-block-image has-custom-border"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/700x700-mens-shirt.jpg') ); ?>" alt="" style="border-top-left-radius:8px;border-top-right-radius:8px;aspect-ratio:1;object-fit:cover" /></figure>
				<!-- /wp:image -->

				<!-- wp:group {"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}}},"layout":{"type":"constrained"}} -->
				<div class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
					<!-- wp:group {"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"space-between","orientation":"horizontal"}} -->
					<div class="wp-block-group">
						<!-- wp:heading {"level":3,"style":{"typography":{"fontStyle":"normal","fontWeight":"400"}},"fontSize":"small"} -->
						<h3 class="wp-block-heading has-small-font-size" style="font-style:normal;font-weight:400"><?php esc_html_e( 'Example Two', 'acai' ); ?></h3>
						<!-- /wp:heading -->

						<!-- wp:paragraph {"fontSize":"small"} -->
						<p class="has-small-font-size"><?php esc_html_e( '$59.99', 'acai' ); ?></p>
						<!-- /wp:paragraph -->
					</div>
					<!-- /wp:group -->

					<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
					<div class="wp-block-buttons">
						<!-- wp:button {"style":{"typography":{"fontStyle":"normal","fontWeight":"400"}},"fontSize":"small"} -->
						<div class="wp-block-button"><a class="wp-block-button__link has-small-font-size has-custom-font-size wp-element-button" style="font-style:normal;font-weight:400"><?php esc_html_e( 'Add to cart', 'acai' ); ?></a></div>
						<!-- /wp:button -->
					</div>
					<!-- /wp:buttons -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"className":"is-style-hover-shadow-deep","style":{"border":{"radius":"9px"},"shadow":"var:preset|shadow|natural"},"layout":{"type":"default"}} -->
			<div class="wp-block-group is-style-hover-shadow-deep" style="border-radius:9px;box-shadow:var(--wp--preset--shadow--natural)">
				<!-- wp:image {"aspectRatio":"1","scale":"cover","linkDestination":"none","style":{"border":{"radius":{"topLeft":"8px","topRight":"8px"}}}} -->
				<figure class="wp-block-image has-custom-border"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/700x700-watch.jpg') ); ?>" alt="" style="border-top-left-radius:8px;border-top-right-radius:8px;aspect-ratio:1;object-fit:cover" /></figure>
				<!-- /wp:image -->

				<!-- wp:group {"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}}},"layout":{"type":"constrained"}} -->
				<div class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
					<!-- wp:group {"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"space-between","orientation":"horizontal"}} -->
					<div class="wp-block-group">
						<!-- wp:heading {"level":3,"style":{"typography":{"fontStyle":"normal","fontWeight":"400"}},"fontSize":"small"} -->
						<h3 class="wp-block-heading has-small-font-size" style="font-style:normal;font-weight:400"><?php esc_html_e( 'Example Three', 'acai' ); ?></h3>
						<!-- /wp:heading -->

						<!-- wp:paragraph {"fontSize":"small"} -->
						<p class="has-small-font-size"><?php esc_html_e( '$49.99', 'acai' ); ?></p>
						<!-- /wp:paragraph -->
					</div>
					<!-- /wp:group -->

					<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
					<div class="wp-block-buttons">
						<!-- wp:button {"style":{"typography":{"fontStyle":"normal","fontWeight":"400"}},"fontSize":"small"} -->
						<div class="wp-block-button"><a class="wp-block-button__link has-small-font-size has-custom-font-size wp-element-button" style="font-style:normal;font-weight:400"><?php esc_html_e( 'Add to cart', 'acai' ); ?></a></div>
						<!-- /wp:button -->
					</div>
					<!-- /wp:buttons -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"className":"is-style-hover-shadow-deep","style":{"border":{"radius":"9px"},"shadow":"var:preset|shadow|natural"},"layout":{"type":"default"}} -->
			<div class="wp-block-group is-style-hover-shadow-deep" style="border-radius:9px;box-shadow:var(--wp--preset--shadow--natural)">
				<!-- wp:image {"aspectRatio":"1","scale":"cover","linkDestination":"none","style":{"border":{"radius":{"topLeft":"8px","topRight":"8px"}}}} -->
				<figure class="wp-block-image has-custom-border"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/700x700-shoes.jpg') ); ?>" alt="" style="border-top-left-radius:8px;border-top-right-radius:8px;aspect-ratio:1;object-fit:cover" /></figure>
				<!-- /wp:image -->

				<!-- wp:group {"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}}},"layout":{"type":"constrained"}} -->
				<div class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
					<!-- wp:group {"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"space-between","orientation":"horizontal"}} -->
					<div class="wp-block-group">
						<!-- wp:heading {"level":3,"style":{"typography":{"fontStyle":"normal","fontWeight":"400"}},"fontSize":"small"} -->
						<h3 class="wp-block-heading has-small-font-size" style="font-style:normal;font-weight:400"><?php esc_html_e( 'Example Four', 'acai' ); ?></h3>
						<!-- /wp:heading -->

						<!-- wp:paragraph {"fontSize":"small"} -->
						<p class="has-small-font-size"><?php esc_html_e( '$79.99', 'acai' ); ?></p>
						<!-- /wp:paragraph -->
					</div>
					<!-- /wp:group -->

					<!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
					<div class="wp-block-buttons">
						<!-- wp:button {"style":{"typography":{"fontStyle":"normal","fontWeight":"400"}},"fontSize":"small"} -->
						<div class="wp-block-button"><a class="wp-block-button__link has-small-font-size has-custom-font-size wp-element-button" style="font-style:normal;font-weight:400"><?php esc_html_e( 'Add to cart', 'acai' ); ?></a></div>
						<!-- /wp:button -->
					</div>
					<!-- /wp:buttons -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->
	</div>
	<!-- /wp:columns -->
</div>
<!-- /wp:group -->

<!-- wp:spacer -->
<div style="height:100px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:group {"align":"full","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull">
	<!-- wp:heading {"align":"wide","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|40"}}}} -->
	<h2 class="wp-block-heading alignwide" style="margin-bottom:var(--wp--preset--spacing--40)"><?php esc_html_e( '7. Boxed style', 'acai' ); ?></h2>
	<!-- /wp:heading -->

	<!-- wp:columns {"align":"wide","style":{"spacing":{"blockGap":{"top":"var:preset|spacing|30","left":"var:preset|spacing|30"}},"elements":{"link":{"color":{"text":"var:preset|color|contrast"}},"heading":{"color":{"text":"var:preset|color|contrast"}}}},"textColor":"contrast"} -->
	<div class="wp-block-columns alignwide has-contrast-color has-text-color has-link-color">
		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"style":{"border":{"width":"1px"}},"backgroundColor":"base-2","borderColor":"contrast","layout":{"type":"default"}} -->
			<div class="wp-block-group has-border-color has-contrast-border-color has-base-2-background-color has-background" style="border-width:1px">
				<!-- wp:image {"aspectRatio":"1","scale":"cover","linkDestination":"none"} -->
				 <figure class="wp-block-image"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/700x700-ladies-jacket.jpg') ); ?>" alt="" style="aspect-ratio:1;object-fit:cover" /></figure>
				<!-- /wp:image -->

				<!-- wp:group {"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}}},"layout":{"type":"constrained"}} -->
				<div class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
					<!-- wp:group {"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"space-between","orientation":"horizontal"}} -->
					<div class="wp-block-group">
						<!-- wp:heading {"level":3,"style":{"typography":{"fontStyle":"normal","fontWeight":"400"}},"fontSize":"small"} -->
						<h3 class="wp-block-heading has-small-font-size" style="font-style:normal;font-weight:400"><?php esc_html_e( 'Example One', 'acai' ); ?></h3>
						<!-- /wp:heading -->

						<!-- wp:paragraph {"fontSize":"small"} -->
						<p class="has-small-font-size"><?php esc_html_e( '$99.99', 'acai' ); ?></p>
						<!-- /wp:paragraph -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->

				<!-- wp:buttons {"style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"flex","justifyContent":"center"}} -->
				<div class="wp-block-buttons" style="margin-top:0;margin-bottom:0">
					<!-- wp:button {"backgroundColor":"contrast","textColor":"base","width":100,"style":{"typography":{"fontStyle":"normal","fontWeight":"400","textTransform":"uppercase"},"border":{"radius":"0px"},"elements":{"link":{"color":{"text":"var:preset|color|base"}}}},"fontSize":"small"} -->
					<div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link has-base-color has-contrast-background-color has-text-color has-background has-link-color has-small-font-size has-custom-font-size wp-element-button" style="border-radius:0px;font-style:normal;font-weight:400;text-transform:uppercase"><?php esc_html_e( 'Add to cart', 'acai' ); ?></a></div>
					<!-- /wp:button -->
				</div>
				<!-- /wp:buttons -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"style":{"border":{"width":"1px"}},"backgroundColor":"base-2","borderColor":"contrast","layout":{"type":"default"}} -->
			<div class="wp-block-group has-border-color has-contrast-border-color has-base-2-background-color has-background" style="border-width:1px">
				<!-- wp:image {"aspectRatio":"1","scale":"cover","linkDestination":"none"} -->
				 <figure class="wp-block-image"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/700x700-mens-shirt.jpg') ); ?>" alt="" style="aspect-ratio:1;object-fit:cover" /></figure>
				<!-- /wp:image -->

				<!-- wp:group {"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}}},"layout":{"type":"constrained"}} -->
				<div class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
					<!-- wp:group {"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"space-between","orientation":"horizontal"}} -->
					<div class="wp-block-group">
						<!-- wp:heading {"level":3,"style":{"typography":{"fontStyle":"normal","fontWeight":"400"}},"fontSize":"small"} -->
						<h3 class="wp-block-heading has-small-font-size" style="font-style:normal;font-weight:400"><?php esc_html_e( 'Example Two', 'acai' ); ?></h3>
						<!-- /wp:heading -->

						<!-- wp:paragraph {"fontSize":"small"} -->
						<p class="has-small-font-size"><?php esc_html_e( '$59.99', 'acai' ); ?></p>
						<!-- /wp:paragraph -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->

				<!-- wp:buttons {"style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"flex","justifyContent":"center"}} -->
				<div class="wp-block-buttons" style="margin-top:0;margin-bottom:0">
					<!-- wp:button {"backgroundColor":"contrast","textColor":"base","width":100,"style":{"typography":{"fontStyle":"normal","fontWeight":"400","textTransform":"uppercase"},"border":{"radius":"0px"},"elements":{"link":{"color":{"text":"var:preset|color|base"}}}},"fontSize":"small"} -->
					<div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link has-base-color has-contrast-background-color has-text-color has-background has-link-color has-small-font-size has-custom-font-size wp-element-button" style="border-radius:0px;font-style:normal;font-weight:400;text-transform:uppercase"><?php esc_html_e( 'Add to cart', 'acai' ); ?></a></div>
					<!-- /wp:button -->
				</div>
				<!-- /wp:buttons -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"style":{"border":{"width":"1px"}},"backgroundColor":"base-2","borderColor":"contrast","layout":{"type":"default"}} -->
			<div class="wp-block-group has-border-color has-contrast-border-color has-base-2-background-color has-background" style="border-width:1px">
				<!-- wp:image {"aspectRatio":"1","scale":"cover","linkDestination":"none"} -->
				 <figure class="wp-block-image"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/700x700-watch.jpg') ); ?>" alt="" style="aspect-ratio:1;object-fit:cover" /></figure>
				<!-- /wp:image -->

				<!-- wp:group {"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}}},"layout":{"type":"constrained"}} -->
				<div class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
					<!-- wp:group {"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"space-between","orientation":"horizontal"}} -->
					<div class="wp-block-group">
						<!-- wp:heading {"level":3,"style":{"typography":{"fontStyle":"normal","fontWeight":"400"}},"fontSize":"small"} -->
						<h3 class="wp-block-heading has-small-font-size" style="font-style:normal;font-weight:400"><?php esc_html_e( 'Example Three', 'acai' ); ?></h3>
						<!-- /wp:heading -->

						<!-- wp:paragraph {"fontSize":"small"} -->
						<p class="has-small-font-size"><?php esc_html_e( '$49.99', 'acai' ); ?></p>
						<!-- /wp:paragraph -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->

				<!-- wp:buttons {"style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"flex","justifyContent":"center"}} -->
				<div class="wp-block-buttons" style="margin-top:0;margin-bottom:0">
					<!-- wp:button {"backgroundColor":"contrast","textColor":"base","width":100,"style":{"typography":{"fontStyle":"normal","fontWeight":"400","textTransform":"uppercase"},"border":{"radius":"0px"},"elements":{"link":{"color":{"text":"var:preset|color|base"}}}},"fontSize":"small"} -->
					<div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link has-base-color has-contrast-background-color has-text-color has-background has-link-color has-small-font-size has-custom-font-size wp-element-button" style="border-radius:0px;font-style:normal;font-weight:400;text-transform:uppercase"><?php esc_html_e( 'Add to cart', 'acai' ); ?></a></div>
					<!-- /wp:button -->
				</div>
				<!-- /wp:buttons -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->

		<!-- wp:column -->
		<div class="wp-block-column">
			<!-- wp:group {"style":{"border":{"width":"1px"}},"backgroundColor":"base-2","borderColor":"contrast","layout":{"type":"default"}} -->
			<div class="wp-block-group has-border-color has-contrast-border-color has-base-2-background-color has-background" style="border-width:1px">
				<!-- wp:image {"aspectRatio":"1","scale":"cover","linkDestination":"none"} -->
				 <figure class="wp-block-image"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/700x700-shoes.jpg') ); ?>" alt="" style="aspect-ratio:1;object-fit:cover" /></figure>
				<!-- /wp:image -->

				<!-- wp:group {"style":{"spacing":{"margin":{"top":"0","bottom":"0"},"padding":{"top":"var:preset|spacing|30","bottom":"var:preset|spacing|30","left":"var:preset|spacing|30","right":"var:preset|spacing|30"}}},"layout":{"type":"constrained"}} -->
				<div class="wp-block-group" style="margin-top:0;margin-bottom:0;padding-top:var(--wp--preset--spacing--30);padding-right:var(--wp--preset--spacing--30);padding-bottom:var(--wp--preset--spacing--30);padding-left:var(--wp--preset--spacing--30)">
					<!-- wp:group {"layout":{"type":"flex","flexWrap":"wrap","justifyContent":"space-between","orientation":"horizontal"}} -->
					<div class="wp-block-group">
						<!-- wp:heading {"level":3,"style":{"typography":{"fontStyle":"normal","fontWeight":"400"}},"fontSize":"small"} -->
						<h3 class="wp-block-heading has-small-font-size" style="font-style:normal;font-weight:400"><?php esc_html_e( 'Example Four', 'acai' ); ?></h3>
						<!-- /wp:heading -->

						<!-- wp:paragraph {"fontSize":"small"} -->
						<p class="has-small-font-size"><?php esc_html_e( '$79.99', 'acai' ); ?></p>
						<!-- /wp:paragraph -->
					</div>
					<!-- /wp:group -->
				</div>
				<!-- /wp:group -->

				<!-- wp:buttons {"style":{"spacing":{"margin":{"top":"0","bottom":"0"}}},"layout":{"type":"flex","justifyContent":"center"}} -->
				<div class="wp-block-buttons" style="margin-top:0;margin-bottom:0">
					<!-- wp:button {"backgroundColor":"contrast","textColor":"base","width":100,"style":{"typography":{"fontStyle":"normal","fontWeight":"400","textTransform":"uppercase"},"border":{"radius":"0px"},"elements":{"link":{"color":{"text":"var:preset|color|base"}}}},"fontSize":"small"} -->
					<div class="wp-block-button has-custom-width wp-block-button__width-100"><a class="wp-block-button__link has-base-color has-contrast-background-color has-text-color has-background has-link-color has-small-font-size has-custom-font-size wp-element-button" style="border-radius:0px;font-style:normal;font-weight:400;text-transform:uppercase"><?php esc_html_e( 'Add to cart', 'acai' ); ?></a></div>
					<!-- /wp:button -->
				</div>
				<!-- /wp:buttons -->
			</div>
			<!-- /wp:group -->
		</div>
		<!-- /wp:column -->
	</div>
	<!-- /wp:columns -->
</div>
<!-- /wp:group -->

<!-- wp:spacer -->
<div style="height:100px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:group {"align":"full","style":{"spacing":{"padding":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50"}},"elements":{"link":{"color":{"text":"var:preset|color|contrast"}},"heading":{"color":{"text":"var:preset|color|contrast"}}}},"backgroundColor":"base-2","textColor":"contrast","layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull has-contrast-color has-base-2-background-color has-text-color has-background has-link-color" style="padding-top:var(--wp--preset--spacing--50);padding-bottom:var(--wp--preset--spacing--50)">
	<!-- wp:heading {"align":"wide","style":{"spacing":{"margin":{"bottom":"var:preset|spacing|40"}}}} -->
	<h2 class="wp-block-heading alignwide" style="margin-bottom:var(--wp--preset--spacing--40)"><?php esc_html_e( '8. Catalog style', 'acai' ); ?></h2>
	<!-- /wp:heading -->

	<!-- wp:group {"align":"wide","style":{"spacing":{"blockGap":"var:preset|spacing|30","margin":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50"}}},"layout":{"type":"default"}} -->
	<div class="wp-block-group alignwide" style="margin-top:var(--wp--preset--spacing--50);margin-bottom:var(--wp--preset--spacing--50)">
		<!-- wp:columns {"verticalAlignment":"center","style":{"spacing":{"blockGap":{"top":"0","left":"0"}}}} -->
		<div class="wp-block-columns are-vertically-aligned-center">
			<!-- wp:column {"verticalAlignment":"center"} -->
			<div class="wp-block-column is-vertically-aligned-center">
				<!-- wp:image {"aspectRatio":"4/3","scale":"cover","linkDestination":"none"} -->
				 <figure class="wp-block-image"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/700x700-ladies-jacket.jpg') ); ?>" alt="" style="aspect-ratio:4/3;object-fit:cover" /></figure>
				<!-- /wp:image -->
			</div>
			<!-- /wp:column -->

			<!-- wp:column {"width":"2.4rem"} -->
			<div class="wp-block-column" style="flex-basis:2.4rem"></div>
			<!-- /wp:column -->

			<!-- wp:column {"verticalAlignment":"center","style":{"spacing":{"blockGap":"var:preset|spacing|30"}}} -->
			<div class="wp-block-column is-vertically-aligned-center">
				<!-- wp:group {"className":"acai-overlap-14 acia-mobile-overlap-off","style":{"border":{"bottom":{"color":"var:preset|color|contrast","width":"4px"}}},"layout":{"type":"default"},"acaiOverlap":-14,"acaiOverlapMobileOff":true} -->
				<div class="wp-block-group acai-overlap-14 acia-mobile-overlap-off" style="border-bottom-color:var(--wp--preset--color--contrast);border-bottom-width:4px"></div>
				<!-- /wp:group -->

				<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40","left":"var:preset|spacing|40","right":"var:preset|spacing|40"},"margin":{"top":"-4px"}},"border":{"width":"4px"}},"backgroundColor":"base","borderColor":"contrast","layout":{"type":"default"}} -->
				<div class="wp-block-group has-border-color has-contrast-border-color has-base-background-color has-background" style="border-width:4px;margin-top:-4px;padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)">
					<!-- wp:heading {"level":3} -->
					<h3 class="wp-block-heading"><?php esc_html_e( 'Example One', 'acai' ); ?></h3>
					<!-- /wp:heading -->

					<!-- wp:paragraph {"fontSize":"large"} -->
					<p class="has-large-font-size"><?php esc_html_e( '$99.99', 'acai' ); ?></p>
					<!-- /wp:paragraph -->

					<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-3"}}}},"textColor":"accent-3","fontSize":"large"} -->
					<p class="has-accent-3-color has-text-color has-link-color has-large-font-size">★★★★★</p>
					<!-- /wp:paragraph -->

					<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|mid"}}}},"textColor":"mid"} -->
					<p class="has-mid-color has-text-color has-link-color">Lorem ipsum dolor sit amet consectetur adipiscing elit varius mus, morbi eros faucibus nam eu nullam tellus bibendum euismod, fringilla felis nulla turpis inceptos habitasse.</p>
					<!-- /wp:paragraph -->

					<!-- wp:paragraph -->
					<p><?php esc_html_e( 'SKU: ABC-123', 'acai' ); ?></p>
					<!-- /wp:paragraph -->

					<!-- wp:buttons -->
					<div class="wp-block-buttons">
						<!-- wp:button -->
						<div class="wp-block-button"><a class="wp-block-button__link wp-element-button"><?php esc_html_e( 'Add to cart', 'acai' ); ?></a></div>
						<!-- /wp:button -->
					</div>
					<!-- /wp:buttons -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:column -->
		</div>
		<!-- /wp:columns -->
	</div>
	<!-- /wp:group -->

	<!-- wp:group {"align":"wide","style":{"spacing":{"blockGap":"var:preset|spacing|30","margin":{"top":"var:preset|spacing|50","bottom":"var:preset|spacing|50"}}},"layout":{"type":"default"}} -->
	<div class="wp-block-group alignwide" style="margin-top:var(--wp--preset--spacing--50);margin-bottom:var(--wp--preset--spacing--50)">
		<!-- wp:columns {"verticalAlignment":"center","style":{"spacing":{"blockGap":{"top":"0","left":"0"}}}} -->
		<div class="wp-block-columns are-vertically-aligned-center">
			<!-- wp:column {"verticalAlignment":"center"} -->
			<div class="wp-block-column is-vertically-aligned-center">
				<!-- wp:image {"aspectRatio":"4/3","scale":"cover","linkDestination":"none"} -->
				 <figure class="wp-block-image"><img src="<?php echo esc_url( get_theme_file_uri('assets/images/700x700-mens-shirt.jpg') ); ?>" alt="" style="aspect-ratio:4/3;object-fit:cover" /></figure>
				<!-- /wp:image -->
			</div>
			<!-- /wp:column -->

			<!-- wp:column {"width":"2.4rem"} -->
			<div class="wp-block-column" style="flex-basis:2.4rem"></div>
			<!-- /wp:column -->

			<!-- wp:column {"verticalAlignment":"center","style":{"spacing":{"blockGap":"var:preset|spacing|30"}}} -->
			<div class="wp-block-column is-vertically-aligned-center">
				<!-- wp:group {"className":"acai-overlap-14 acia-mobile-overlap-off","style":{"border":{"bottom":{"color":"var:preset|color|contrast","width":"4px"}}},"layout":{"type":"default"},"acaiOverlap":-14,"acaiOverlapMobileOff":true} -->
				<div class="wp-block-group acai-overlap-14 acia-mobile-overlap-off" style="border-bottom-color:var(--wp--preset--color--contrast);border-bottom-width:4px"></div>
				<!-- /wp:group -->

				<!-- wp:group {"style":{"spacing":{"padding":{"top":"var:preset|spacing|40","bottom":"var:preset|spacing|40","left":"var:preset|spacing|40","right":"var:preset|spacing|40"},"margin":{"top":"-4px"}},"border":{"width":"4px"}},"backgroundColor":"base","borderColor":"contrast","layout":{"type":"default"}} -->
				<div class="wp-block-group has-border-color has-contrast-border-color has-base-background-color has-background" style="border-width:4px;margin-top:-4px;padding-top:var(--wp--preset--spacing--40);padding-right:var(--wp--preset--spacing--40);padding-bottom:var(--wp--preset--spacing--40);padding-left:var(--wp--preset--spacing--40)">
					<!-- wp:heading {"level":3} -->
					<h3 class="wp-block-heading"><?php esc_html_e( 'Example Two', 'acai' ); ?></h3>
					<!-- /wp:heading -->

					<!-- wp:paragraph {"fontSize":"large"} -->
					<p class="has-large-font-size"><?php esc_html_e( '$59.99', 'acai' ); ?></p>
					<!-- /wp:paragraph -->

					<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|accent-3"}}}},"textColor":"accent-3","fontSize":"large"} -->
					<p class="has-accent-3-color has-text-color has-link-color has-large-font-size">★★★★★</p>
					<!-- /wp:paragraph -->

					<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"var:preset|color|mid"}}}},"textColor":"mid"} -->
					<p class="has-mid-color has-text-color has-link-color">Lorem ipsum dolor sit amet consectetur adipiscing elit varius mus, morbi eros faucibus nam eu nullam tellus bibendum euismod, fringilla felis nulla turpis inceptos habitasse.</p>
					<!-- /wp:paragraph -->

					<!-- wp:paragraph -->
					<p><?php esc_html_e( 'SKU: ABC-123', 'acai' ); ?></p>
					<!-- /wp:paragraph -->

					<!-- wp:buttons -->
					<div class="wp-block-buttons">
						<!-- wp:button -->
						<div class="wp-block-button"><a class="wp-block-button__link wp-element-button"><?php esc_html_e( 'Add to cart', 'acai' ); ?></a></div>
						<!-- /wp:button -->
					</div>
					<!-- /wp:buttons -->
				</div>
				<!-- /wp:group -->
			</div>
			<!-- /wp:column -->
		</div>
		<!-- /wp:columns -->
	</div>
	<!-- /wp:group -->
</div>
<!-- /wp:group -->

<!-- wp:spacer -->
<div style="height:100px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->
