<?php
/**
 *
 * Register custom template part areas.
 *
 * @package Acai
 */

/**
 * Register template part areas.
 */
if ( ! function_exists( 'acai_template_part_areas' ) ) {
	function acai_template_part_areas( array $areas ) {
		$custom_areas = array(
			array(
				'area'        => 'comments',
				'area_tag'    => 'section',
				'label'       => __( 'Comments', 'acai' ),
				'description' => __( 'The comments template part area, typically found in the Single Posts template.', 'acai' ),
				'icon'        => ''
			),
			array(
				'area'        => 'sidebar',
				'area_tag'    => 'section',
				'label'       => __( 'Sidebar', 'acai' ),
				'description' => __( 'The sidebar template part area.', 'acai' ),
				'icon'        => 'sidebar'
			),
			array(
				'area'        => 'posts',
				'area_tag'    => 'section',
				'label'       => __( 'Posts', 'acai' ),
				'description' => __( 'The posts template part area, typically found in the All Archives, Index and Search Results templates.', 'acai' ),
				'icon'        => ''
			),
			array(
				'area'        => 'products',
				'area_tag'    => 'section',
				'label'       => __( 'Products', 'acai' ),
				'description' => __( 'The products template part area, typically found in the Product Catalog and Product Search Results templates.', 'acai' ),
				'icon'        => ''
			)
		);
		return array_merge( $areas, $custom_areas );
	}
}
add_filter( 'default_wp_template_part_areas', 'acai_template_part_areas' );
