<?php
define( 'ACAI_VERSION', acai_version() );
define( 'ACAI_TEMPLATE_DIR', get_template_directory() );
define( 'ACAI_TEMPLATE_DIR_URI', get_template_directory_uri() );

function acai_version() {
	if ( wp_is_development_mode( 'theme' ) ) {
		return time();
	} else {
		return wp_get_theme()->get( 'Version' );
	}
}

if ( ! function_exists( 'acai_support' ) ) {
	function acai_support() {
		load_theme_textdomain( 'acai', ACAI_TEMPLATE_DIR . '/languages' );
		// Define WooCommerce product image sizes.
		// Values from core media widths.
		add_theme_support(
			'woocommerce',
			apply_filters(
				'acai_wc_image_widths',
				array(
					'gallery_thumbnail_image_width' => (int) get_option( 'thumbnail_size_w' ),
					'thumbnail_image_width' => (int) get_option( 'medium_size_w' ),
					'single_image_width' => (int) get_option( 'large_size_w' ),
				)
			)
		);
		add_editor_style( ACAI_TEMPLATE_DIR_URI . '/assets/css/fixes.min.css' );
	}
}
add_action( 'after_setup_theme', 'acai_support' );

/**
 * Block styles.
 */
require ACAI_TEMPLATE_DIR . '/inc/block-styles.php';

/**
 * Block patterns.
 */
require ACAI_TEMPLATE_DIR . '/inc/block-patterns.php';

/**
 * Template part areas.
 */
require ACAI_TEMPLATE_DIR . '/inc/template-part-areas.php';

/**
 * Theme help page.
 */
require ACAI_TEMPLATE_DIR . '/inc/theme-page.php';

/**
 * Filter templates & template parts.
 * Add descriptions to custom templates.
 * Unregister templates & parts for WooCommerce if plugin not active.
 */
if ( ! function_exists( 'acai_filter_templates' ) ) {
	function acai_filter_templates( $templates, $query, $template_type ) {

		foreach ( $templates as $key => $template ) {
			if ( $template->slug === 'no-title' ) {
				$templates[$key]->description = __( 'Displays a page without a page title.', 'acai' );
			} elseif ( $template->slug === 'page-header-title' ) {
				$templates[$key]->description = __( 'Displays a page with page title in the "Header with Page Title" template part.', 'acai' );
			} elseif ( $template->slug === 'blank-canvas' ) {
				$templates[$key]->description = __( 'Displays a page with only the page content and no header or footer. Ideal for use as a landing page.', 'acai' );
			} elseif ( $template->slug === 'single-header-title' ) {
				$templates[$key]->description = __( 'Displays a single post with post title in the "Header with Page Title" template part.', 'acai' );
			} elseif ( $template->slug === 'front-page' ) {
				$templates[$key]->description = $template->description . ' ' . __( 'Contains the "Header with Hero Cover" template part.', 'acai' );
			} elseif ( $template->slug === 'archive' || $template->slug === 'index' || $template->slug === 'search' ) {
				$templates[$key]->description = $template->description . ' ' . __( 'Contains the "Posts Grid" template part.', 'acai' );
			} elseif ( $template->slug === 'archive-product' || $template->slug === 'product-search-results' || $template->slug === 'taxonomy-product_attribute' || $template->slug === 'taxonomy-product_cat' || $template->slug === 'taxonomy-product_tag' ) {
				$templates[$key]->description = $template->description . ' ' . __( 'Contains the "Products Grid" template part.', 'acai' );
			}
		}

		if ( !class_exists( 'WooCommerce' ) ) {
			if ( $template_type === 'wp_template_part' ) {
				$wc_templates = array(
					'products'
				);
			} else {
				$wc_templates = array(
					'archive-product',
					'order-confirmation',
					'page-cart',
					'page-checkout',
					'product-search-results',
					'single-product',
					'single-product-boxed',
					'single-product-boxed-2',
					'single-product-compacted',
					'single-product-full-width-80-20',
					'single-product-image-right',
					'taxonomy-product_attribute',
					'taxonomy-product_cat',
					'taxonomy-product_tag',
					'taxonomy-product_brand',
				);
			}
			foreach ( $templates as $key => $template ) {
				$slug = $template->slug;
				if ( in_array( $slug, $wc_templates ) ) {
					unset( $templates[$key] );
				}
			}
		}

		return $templates;

	}
}
add_filter( 'get_block_templates', 'acai_filter_templates', 11, 3 );

/**
 * Filter patterns.
 * Unregister core query patterns, as they take priority over the theme patterns.
 * Reference: /wp-includes/block-patterns.php -> _register_core_block_patterns_and_categories()
 * Unregister patterns for WooCommerce if plugin not active.
 */
if ( ! function_exists( 'acai_filter_patterns' ) ) {
	function acai_filter_patterns() {
		$patterns = WP_Block_Patterns_Registry::get_instance()->get_all_registered();
		foreach ( $patterns as $pattern ) {
			if ( str_starts_with( $pattern['name'], 'core/query-' ) ) {
				unregister_block_pattern( $pattern['name'] );
			}
		}
		if ( !class_exists( 'WooCommerce' ) ) {
			foreach ( $patterns as $pattern ) {
				if ( str_starts_with( $pattern['name'], 'acai/wc-' ) ) {
					unregister_block_pattern( $pattern['name'] );
				}
			}
		}
	}
}
add_action( 'init', 'acai_filter_patterns' );
