<?php
/**
 * Custom coded by Spiderfly Studios https://www.spiderflystudios.com
 * Modern Product Listing
 * Displays a single product listing with a modern style
 */


if( !class_exists( 'woocommerce' ) )
{
	add_shortcode('ss_product_modern', 'avia_please_install_woo');
	return;
}

if ( !class_exists( 'ss_wc_product_modern' ) ) 
{
	class ss_wc_product_modern extends aviaShortcodeTemplate
	{
			/**
			 * Create the config array for the shortcode button
			 */
			function shortcode_insert_button()
			{
				$template_url = get_stylesheet_directory_uri();
				$child_sc_imgs = $template_url.'/shortcodes/spiderfly-elements/images/';
				$this->config['name']		= __('Modern Product', 'avia_framework' );
				$this->config['tab']		= __('WooCommerce', 'avia_framework' );
				$this->config['icon']		= $child_sc_imgs."modern-product.png";
				$this->config['order']		= 95;
				$this->config['target']		= 'avia-target-insert';
				$this->config['shortcode'] 	= 'ss_product_modern';
				$this->config['tooltip'] 	= __('Displays a single product listing with a modern style.', 'avia_framework' );
				$this->config['tinyMCE']    = array('disable'=>true);
				$this->config['preview'] 	= true;
			}
		
		public function __construct( $builder ) 
		{
			add_filter( 'avf_preview_window_css_files', array( $this, 'handler_avf_preview_window_css_files'), 10, 1 );
				
			parent::__construct( $builder );
		}

		public function handler_avf_preview_window_css_files( $css = array() )
		{
			
			if(is_rtl()): $css_url = get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css'; else: $css_url = get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly.css'; endif;
			
			$css[ $css_url ] = 1;
			return $css;
		}
		
		function extra_assets()
			{
				if(is_rtl()): wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly-rtl.css',false,'1.1','all'); else: wp_enqueue_style( 'spiderfly', get_stylesheet_directory_uri() . '/shortcodes/spiderfly-elements/css/spiderfly.css',false,'1.1','all'); endif;
			}
		
		
			/**
			 * Popup Elements
			 *
			 * If this function is defined in a child class the element automatically gets an edit button, that, when pressed
			 * opens a modal window that allows to edit the element properties
			 *
			 * @return void
			 */
			function popup_elements()
			{

				$this->elements = array(
					
					array(
							"type" 	=> "tab_container", 'nodescription' => true
						),
						
					array(
							"type" 	=> "tab",
							"name"  => __("Content" , 'avia_framework'),
							'nodescription' => true
						),
					
				    array(
						"name" 	=> __("Which Product?", 'avia_framework' ),
						"desc" 	=> __("Select which product you would like displayed.", 'avia_framework' ),
						"id" 	=> "link",
						"type" 	=> "select",
						"taxonomy" => "single",
						"subtype" => "product",
						),
						
					array(	
						"name" 	=> __("Title Override", 'avia_framework' ),
						"desc" 	=> __("Here you can change the product title displayed. Leave blank to use the default product title.", 'avia_framework' ),
						"id" 	=> "new_title",
						"std" 	=> "",
						"type" 	=> "input"),
						
					array(	
						"name" 	=> __("Sale Tagline", 'avia_framework' ),
						"desc" 	=> __("Enter what you would like displayed when the product is on sale.<br /><strong>Example:</strong> SALE - 10% OFF<br />To disable the sale badge completely, simply leave the field blank.", 'avia_framework' ),
						"id" 	=> "tagline",
						"std" 	=> __("SALE", 'avia_framework' ),
						"type" 	=> "input"),
						
					array(	
						"name" 	=> __("Extra Tagline", 'avia_framework' ),
						"desc" 	=> __("Here you can enter any brief text you want to promote a key feature of the product.", 'avia_framework' ),
						"id" 	=> "extratag",
						"std" 	=> "",
						"type" 	=> "input"),
						
					array(	
						"name" 	=> __("Price Prefix", 'avia_framework' ),
						"desc" 	=> __("Enter what you would like displayed before the poduct price.", 'avia_framework' ),
						"id" 	=> "prefix",
						"std" 	=> __("Starting at", 'avia_framework' ),
						"type" 	=> "input"),
						
					array(	
						"name" 	=> __("Price Suffix", 'avia_framework' ),
						"desc" 	=> __("Enter what you would like displayed after the product price.<br /><strong>Example:</strong> per yard, each, etc.", 'avia_framework' ),
						"id" 	=> "suffix",
						"std" 	=> "",
						"type" 	=> "input"),
							
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
					array(
							"type" 	=> "tab",
							"name"  => __("Style Options" , 'avia_framework'),
							'nodescription' => true
						),
						
					array(	
							"name" 	=> __("Image Size", 'avia_framework' ),
							"desc" 	=> __("Select an image thumbnail size.", 'avia_framework' ),
							"id" 	=> "img_size",
							"type" 	=> "select",
							"std" 	=> "",
							"subtype" => array( __("Default (Shop)", 'avia_framework' )=>'shop_catalog', __("Portfolio", 'avia_framework' )=>'portfolio', __("Gallery", 'avia_framework' )=>'gallery', __("Masonry", 'avia_framework' )=>'masonry', __("Magazine", 'avia_framework' )=>'magazine', __("Modern Magazine", 'avia_framework' )=>'magazine_alt', __("Modern Product", 'avia_framework' )=>'product', __("Modern Product Alt", 'avia_framework' )=>'product_alt')
							),
							
					array(	
							"name" 	=> __("Sale Text Style", 'avia_framework' ),
							"desc" 	=> __("Select the text style for the sale tagline.", 'avia_framework' ),
							"id" 	=> "sale",
							"type" 	=> "select",
							"container_class" => 'av_half',
							"std" 	=> "light",
							"subtype" => array("Light"=>'light',"Dark"=>'dark')
							),
							
					array(	
							"name" 	=> __("Sale Badge Background Color", 'avia_framework' ),
							"desc" 	=> __("Select any color to use for the badge background.", 'avia_framework' ),
							"id" 	=> "sale_bg",
							"type" 	=> "colorpicker",
							"container_class" => 'av_half',
							"std" 	=> "#d54e21",
						),  
						
					array(	
							"name" 	=> __("New Product Badge", 'avia_framework' ),
							"desc" 	=> __("Display a corner badge indicating that the product is new. By default it is set to 60 days.", 'avia_framework' ),
							"id" 	=> "newprod",
							"type" 	=> "select",
							"std" 	=> "enabled",
							"subtype" => array("Enabled"=>'enabled',"Disabled"=>'disabled')
							),
							
					array(	
							"name" 	=> __("New Badge Font Color", 'avia_framework' ),
							"desc" 	=> __("Select any color to use for the badge text.", 'avia_framework' ),
							"id" 	=> "newprod_font",
							"type" 	=> "colorpicker",
							"container_class" => 'av_half',
							"std" 	=> "#ffffff",
						),
							
					array(	
							"name" 	=> __("New Badge Background Color", 'avia_framework' ),
							"desc" 	=> __("Select any color to use for the badge background.", 'avia_framework' ),
							"id" 	=> "newprod_bg",
							"type" 	=> "colorpicker",
							"container_class" => 'av_half',
							"std" 	=> "#588737",
						),
						
					array(	"name" 	=> __("Heading Size", 'avia_framework' ),
							"desc" 	=> __("Adjust the size of the product title in pixels.", 'avia_framework' ),
				            "id" 	=> "heading_size",
				            "type" 	=> "select",
				            "subtype" => AviaHtmlHelper::number_array(20,45,1, array( __("Default Size", 'avia_framework' )=>'30')),
				            "std" => ""),
							
					array(	
							"name" 	=> __("Extra Tagline Background Color", 'avia_framework' ),
							"desc" 	=> __("Select any color to use for the badge background.", 'avia_framework' ),
							"id" 	=> "extra_bg",
							"type" 	=> "colorpicker",
							"std" 	=> "#0074aa",
						), 
						
					array(
							"name" 	=> __("TIP",'avia_framework' ),
							"desc" 	=> __("If you make the Gradient Start and Gradient End options equal, the overlay effect will have no gradient and will have a hard edge.", 'avia_framework' ),
							"type" 	=> "heading",
							"description_class" => "av-builder-note av-neutral",
						),
							
					array(	"name" 	=> __("Overlay Transparency", 'avia_framework' ),
							"desc" 	=> __("Adjust the transparency of the overlay behind the product title.", 'avia_framework' ),
				            "id" 	=> "overlay",
				            "type" 	=> "select",
				            "subtype" => AviaHtmlHelper::number_array(0.1,1,0.05, array( __("Default Transparency", 'avia_framework' )=>'0.6')),
				            "std" => ""),
							
					array(	"name" 	=> __("Gradient Start", 'avia_framework' ),
							"desc" 	=> __("Adjust where you would like the gradient effect to start. Values are a percentage relative to the bottom of the image.", 'avia_framework' ),
				            "id" 	=> "overlay_start",
				            "type" 	=> "select",
				            "subtype" => AviaHtmlHelper::number_array(0,100,1, array( __("Default Gradient Start", 'avia_framework' )=>'10')),
							"container_class" => 'av_half',
				            "std" => ""),
							
					array(	"name" 	=> __("Gradient End", 'avia_framework' ),
							"desc" 	=> __("Adjust where you would like the gradient effect to end. Values are a percentage relative to the bottom of the image.", 'avia_framework' ),
				            "id" 	=> "overlay_end",
				            "type" 	=> "select",
				            "subtype" => AviaHtmlHelper::number_array(0,100,1, array( __("Default Gradient End", 'avia_framework' )=>'50')),
							"container_class" => 'av_half',
				            "std" => ""),
						
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
					array(
									"type" 	=> "tab",
									"name"	=> __("Screen Options",'avia_framework' ),
									'nodescription' => true
								),
								
								
								array(
								"name" 	=> __("Element Visibility",'avia_framework' ),
								"desc" 	=> __("Set the visibility for this element, based on the device screensize.", 'avia_framework' ),
								"type" 	=> "heading",
								"description_class" => "av-builder-note av-neutral",
								),
							
								array(	
										"desc" 	=> __("Hide on large screens (wider than 990px - eg: Desktop)", 'avia_framework'),
										"id" 	=> "av-desktop-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
								
								array(	
									
										"desc" 	=> __("Hide on medium sized screens (between 768px and 989px - eg: Tablet Landscape)", 'avia_framework'),
										"id" 	=> "av-medium-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on small screens (between 480px and 767px - eg: Tablet Portrait)", 'avia_framework'),
										"id" 	=> "av-small-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
										
								array(	
									
										"desc" 	=> __("Hide on very small screens (smaller than 479px - eg: Smartphone Portrait)", 'avia_framework'),
										"id" 	=> "av-mini-hide",
										"std" 	=> "",
										"container_class" => 'av-multi-checkbox',
										"type" 	=> "checkbox"),
						
								
							array(
									"type" 	=> "close_div",
									'nodescription' => true
								),	
						
					array(
							"type" 	=> "close_div",
							'nodescription' => true
						),
						
				);

			}
			
			function editor_element($params)
			{
				
				$params['args'] = shortcode_atts(array('link' => '', 'new_title' => '', 'tagline' => '', 'newbadge' => '', 'sale' => '', 'sale_bg' => '', 'newprod' => '', 'newprod_font' => '', 'newprod_bg' => '#588737', 'extratag' => '', 'extra_bg' => '', 'img_size' => 'shop_catalog','heading_size' => '30', 'prefix' => '', 'suffix' => '', 'overlay' => '0.6', 'overlay_start' => '10', 'overlay_end' => '50'
				
				
				), $params['args'], $this->config['shortcode']);
				
				$templateNAME  	= $this->update_template("name", "{{name}}");
				global $product;
				$link = isset( $params['args']['link'] ) ? $params['args']['link'] : '';
				$product = wc_get_product( $link );
				$prod_title = $product->post->post_title;
				
				$params['innerHtml'] = "<img src='".$this->config['icon']."' title='".$this->config['name']."' />";
				if ($link) {$params['innerHtml'].= "<div class='avia-element-label'>".$prod_title."</div>";}
				else {$params['innerHtml'].= "<div class='avia-element-label'>".$this->config['name']."</div>";}
				return $params;
			}
			
			/**
			 * Frontend Shortcode Handler
			 *
			 * @param array $atts array of attributes
			 * @param string $content text within enclosing form of shortcode element 
			 * @param string $shortcodename the shortcode found, when == callback name
			 * @return string $output returns the modified html string 
			 */
			function shortcode_handler($atts, $content = "", $shortcodename = "", $meta = "")
			{
				
				extract(AviaHelper::av_mobile_sizes($atts)); //return $av_font_classes, $av_title_font_classes and $av_display_classes 
			   $atts =  shortcode_atts(array('link' => '', 'new_title' => '', 'tagline' => '', 'newbadge' => '', 'sale' => '', 'sale_bg' => '', 'newprod' => '', 'newprod_font' => '', 'newprod_bg' => '#588737', 'extratag' => '', 'extra_bg' => '', 'img_size' => 'shop_catalog','heading_size' => '30', 'prefix' => '', 'suffix' => '', 'overlay' => '0.6', 'overlay_start' => '10', 'overlay_end' => '50'
			                                 ), $atts, $this->config['shortcode']);
				
			    $link  = $atts['link'];
				$new_title  = $atts['new_title'];
				$img_size  = $atts['img_size'];
				$heading_size  = $atts['heading_size'];
				$prefix = $atts['prefix'];
				$suffix = $atts['suffix'];
				$overlay = $atts['overlay'];
				$overlay_start = $atts['overlay_start'];
				$overlay_end = $atts['overlay_end'];
				global $product;
				$product = wc_get_product( $link );
				$prod_title = $product->post->post_title;
				if(!empty($new_title)) $prod_title = $new_title;
				$product_image = get_the_post_thumbnail( $link, $img_size );
				$price = $product->get_price();
				$url = get_permalink( $link );
				
				if (!empty($heading_size)) {$headstyling .= "font-size:".$heading_size."px !important; text-shadow: 1px 1px 1px #000000;";}
				if(!empty($headstyling)) $headstyling = "style='{$headstyling}'";
				if ( (!empty($overlay)) || (!empty($overlay_start)) || (!empty($overlay_end)) ) {$overlaystyling .= "background-image: -webkit-linear-gradient(bottom, rgba(0, 0, 0, ".$overlay.") ".$overlay_start."%, transparent ".$overlay_end."%) !important; background-image: linear-gradient(to top, rgba(0, 0, 0, ".$overlay.") ".$overlay_start."%, transparent ".$overlay_end."%) !important;";}
				if(!empty($overlaystyling)) $overlaystyling = "style='{$overlaystyling}'";
				if(!empty($prefix)) $prefix = " <small>{$prefix}</small>";
				if(!empty($suffix)) $suffix = " <small>{$suffix}</small>";
				
				$sale  = $atts['sale'];
				$sale_bg  = $atts['sale_bg'];
				if($sale == 'light') $sale = 'style="color:#f5f5f5; background-color:'.$sale_bg.' !important;"';
				if($sale == 'dark') $sale = 'style="color:#151515; text-shadow:none !important; background-color:'.$sale_bg.' !important;"';
				
				$tagline  = $atts['tagline'];
				if ( ($product->is_on_sale($link)) && ($tagline) ) {
					$saletag = '<h3 '.$sale.' class="sale">'.$tagline.'</h3>';
				}
				
				$extratag  = $atts['extratag'];
				$extra_bg  = $atts['extra_bg'];
				$newprod  = $atts['newprod'];
				$newprod_font  = $atts['newprod_font'];
				$newprod_bg  = $atts['newprod_bg'];
				if($extratag){
					if(is_rtl()){
						$extra = '<h3 class="title2" style="color: #f5f5f5; font-weight: 700;font-size: 16px; text-shadow:none; width: fit-content; padding: 7px 20px 5px 7px; margin-right: -20px;background-color:'.$extra_bg.' !important;">'.$extratag.'</h3>';
					} else {
						$extra = '<h3 class="title2" style="color: #f5f5f5; font-weight: 700;font-size: 16px; text-shadow:none; width: fit-content; padding: 7px 7px 5px 20px; margin-left: -20px;background-color:'.$extra_bg.' !important;">'.$extratag.'</h3>';
					}
				}
				
				if($newprod == 'disabled') {$newhide = 'display:none !important;';}
				$newstyle = 'style="color:'.$newprod_font.'!important; background:'.$newprod_bg.'!important;'.$newhide.'"';
				
				$postdate 		= get_the_time('Y-m-d',$link);			// Post date
				$postdatestamp 	= strtotime( $postdate );			// Timestamped post date
				if ( ( time() - ( 60 * 60 * 24 * 60 ) ) < $postdatestamp ) { // The last value accounts for days
					$newtag = '<div class="corner-ribbon top-right sticky blue" '.$newstyle.'>NEW</div>';
				}
				
				$currency .= get_woocommerce_currency_symbol();
				$currency = "<sup style='position:relative;font-size:75%;top:-0.2em;vertical-align:baseline;'>".$currency."</sup>";
				
			    $content_html = "";
			    $content_html .= "<figure class='modprod {$av_display_classes}'>". $product_image;
				$content_html .= '<figcaption '.$overlaystyling.'>';
				$content_html .= $newtag;
				$content_html .= $saletag;
				$content_html .= '<h3 class="title1" '.$headstyling.'>'.$prod_title.'</h3>';
				$content_html .= $extra;
				$content_html .= '<h3 class="title3">'.$prefix.' <span style="color:#f5f5f5;">'.$currency.$price.'</span>'.$suffix.'</h3>';
				$content_html .= '</figcaption><a href="'.$url.'"></a>';
				$content_html .= '</figure>';
  
			    $output  = "";
				$output .= do_shortcode( $content_html );
				
				return $output;
			}
	}
}
