<?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('manage-orders')): ?>
    <li>
        <a aria-expanded="false" href="javascript:void()" class="has-arrow ai-icon">
            <i class="fi fi-rr-boxes"></i>
            <span class="nav-text">سفارشات</span>
        </a>
        <ul aria-expanded="false" class="mm-collapse">
            <li>
                <a href="<?php echo e(route('admin.orders.index' , ['type' => 'preparation'])); ?>" class="nav-link">
                    <p>در حال پردازش
                        <span class="badge badge-primary right"><?php echo e(\Modules\Order\Entities\Order::whereStatus('preparation')->count()); ?></span>
                    </p>
                </a>
            </li>
            <li>
                <a href="<?php echo e(route('admin.orders.index' , ['type' => 'unpaid'])); ?>" class="nav-link">
                    <p>پرداخت نشده
                        <span class="badge badge-warning right"><?php echo e(\Modules\Order\Entities\Order::whereStatus('unpaid')->count()); ?></span>
                    </p>
                </a>
            </li>
            <li>
                <a href="<?php echo e(route('admin.orders.index' , ['type' => 'paid'])); ?>" class="nav-link">
                    <p>پرداخت شده
                        <span class="badge badge-info right"><?php echo e(\Modules\Order\Entities\Order::whereStatus('paid')->count()); ?></span>
                    </p>
                </a>
            </li>
            <li>
                <a href="<?php echo e(route('admin.orders.index' , ['type' => 'posted'])); ?>" class="nav-link">
                    <p>ارسال شده
                        <span class="badge badge-light right"><?php echo e(\Modules\Order\Entities\Order::whereStatus('posted')->count()); ?></span>
                    </p>
                </a>
            </li>
            <li>
                <a href="<?php echo e(route('admin.orders.index' , ['type' => 'received'])); ?>" class="nav-link">
                    <p>رسیده به مشتری
                        <span class="badge badge-success right"><?php echo e(\Modules\Order\Entities\Order::whereStatus('received')->count()); ?></span>
                    </p>
                </a>
            </li>
            <li>
                <a href="<?php echo e(route('admin.orders.index' , ['type' => 'canceled'])); ?>" class="nav-link">
                    <p>کنسل شده
                        <span class="badge badge-danger right"><?php echo e(\Modules\Order\Entities\Order::whereStatus('canceled')->count()); ?></span>
                    </p>
                </a>
            </li>

        </ul>
    </li>
<?php endif; ?>
<?php /**PATH /home/icworld/core/Modules/Order/Resources/views/backend/sidebar.blade.php ENDPATH**/ ?>