@component('backend.layouts.components.main',['title' => 'ویرایش محصول','titleBar' => false])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">ویرایش محصول</li>
    @endslot
    {{-- Section Start --}}

    <div class="col-md-8">
        <div class="sidebar-admin">
            <div class="card-header">
                <h4 class="card-title">جزئیات محصول</h4>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <input name="title" type="text"
                           class="form-control input-rounded @error('title') is-invalid @enderror" placeholder="عنوان"
                           form="store" required value="{{old('title') ? old('title') : $product->title}}">
                    @error('title')
                    <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                    @enderror
                </div>
                <div class="custom-tab-1">
                    <ul class="nav nav-tabs">
                        <li class="nav-item">
                            <a class="nav-link active" data-toggle="tab" href="#detail">
                                <i class="la la-dot-circle ml-2"></i>
                                اطلاعات
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#attributes-data">
                                <i class="la la-expand ml-2"></i>
                                ویژگی ها
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#short-desc">
                                <i class="la la-file-text ml-2"></i>
                                توضیحات کوتاه
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#long-desc">
                                <i class="la la-file-text ml-2"></i>
                                توضیحات بلند
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-toggle="tab" href="#seo">
                                <i class="la la-rocket ml-2"></i>
                                سئو
                            </a>
                        </li>
                    </ul>
                    <form action="{{route('admin.products.update' , $product->id)}}" method="post" id="store"
                          enctype="multipart/form-data">
                        @csrf
                        @method('patch')
                        <div class="tab-content">
                            <div class="tab-pane fade show active" id="detail">
                                <div class="pt-4">
                                    <p class="text-justify">
                                        <i class="fa fa-circle text-blue ml-1"></i>
                                        لینک به صورت پیش فرض از عنوان نوشته ساخته میشود، درصورتی که قصد تغییر آن را
                                        دارید در این باکس لینک را وارد کنید
                                    </p>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">عنوان انگلیسی</label>
                                        <div class="col-sm-9">
                                            <input type="text" name="english_title"
                                                   class="form-control input-rounded @error('english_title') is-invalid @enderror"
                                                   placeholder="عنوان انگلیسی" value="{{old('english_title') ? old('english_title') : $product->english_title}}">
                                            @error('english_title')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">حداقل تعداد سفارش (پیشفرض 1 است)</label>
                                        <div class="col-sm-9">
                                            <input type="number" name="min_order_quantity"
                                                   class="form-control input-rounded @error('min_order_quantity') is-invalid @enderror"
                                                   placeholder="حداقل تعداد سفارش" value="{{old('min_order_quantity') ? old('min_order_quantity') : $product->min_order_quantity}}">
                                            @error('min_order_quantity')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">لینک</label>
                                        <div class="col-sm-9">
                                            <input type="text" name="slug"
                                                   class="form-control input-rounded @error('slug') is-invalid @enderror"
                                                   placeholder="لینک"
                                                   value="{{old('slug') ? old('slug') : $product->slug}}">
                                            @error('slug')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">قیمت</label>
                                        <div class="col-sm-9">
                                            <input type="text" name="price"
                                                   class="form-control input-rounded @error('price') is-invalid @enderror"
                                                   placeholder="قیمت"
                                                   value="{{old('price') ? old('price') : $product->price}}">
                                            @error('price')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">قیمت فروش فوق العاده</label>
                                        <div class="col-sm-9">
                                            <input type="text" name="sale_price"
                                                   class="form-control input-rounded @error('sale_price') is-invalid @enderror"
                                                   placeholder="قیمت فروش فوق العاده"
                                                   value="{{old('sale_price') ? old('sale_price') : $product->sale_price}}">
                                            @error('sale_price')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">موجودی انبار</label>
                                        <div class="col-sm-9">
                                            <input type="number" name="inventory"
                                                   class="form-control input-rounded @error('inventory') is-invalid @enderror"
                                                   placeholder="موجودی انبار"
                                                   value="{{old('inventory') ? old('inventory') : $product->inventory}}">
                                            @error('inventory')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">شناسه محصول</label>
                                        <div class="col-sm-9">
                                            <input type="text" name="sku"
                                                   class="form-control input-rounded @error('sku') is-invalid @enderror"
                                                   placeholder="شناسه محصول"
                                                   value="{{old('sku') ? old('sku') : $product->sku}}">
                                            @error('sku')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">برند</label>
                                        <div class="col-sm-9">
                                            <input type="text" name="brand"
                                                   class="form-control input-rounded @error('brand') is-invalid @enderror"
                                                   placeholder="برند"
                                                   value="{{old('brand') ? old('brand') : $product->brand}}">
                                            @error('brand')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">تک فروشی</label>
                                        <div class="col-sm-9">
                                            <div class="dropdown bootstrap-select form-control default-select dropup">
                                                <select name="is_single_sell"
                                                        class="form-control default-select input-rounded @error('is_single_sell') is-invalid @enderror"
                                                        id="sel1" tabindex="-98">
                                                    <option value="">انتخاب کنید</option>
                                                    <option value="1"
                                                            @if($product->is_single_sell == 1) selected @endif>دارد
                                                    </option>
                                                    <option value="0"
                                                            @if($product->is_single_sell == 0) selected @endif>ندارد
                                                    </option>
                                                </select>
                                                @error('is_single_sell')
                                                <span class="invalid-feedback">
                                        <strong>
                                            {{$message}}
                                        </strong>
                                    </span>

                                                @enderror
                                            </div>

                                        </div>

                                    </div>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">تصویر اصلی</label>
                                        <div class="col-sm-9">
                                            <div class="input-group">
                                                <input type="text" id="image_label" class="form-control" name="image"
                                                       aria-label="Image" aria-describedby="button-image"
                                                       style="direction: ltr;border-radius: 0 50px 50px 0"
                                                       value="{{old('image') ? old('image') : $product->single_image}}">
                                                <div class="input-group-append">
                                                    <button class="btn btn-outline-info" type="button"
                                                            id="button-image">
                                                        انتخاب
                                                    </button>
                                                </div>
                                            </div>
                                            @error('image')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="upload__box">
                                        <div class="upload__btn-box">
                                            <label class="upload__btn">
                                                <p class="mb-0">آپلود تصاویر</p>
                                                <input type="file" class="upload__inputfile" name="photos[]" id="photos"
                                                       multiple>
                                            </label>
                                            <input type="hidden" name="new-product-photos" id="new-product-photos">
                                        </div>
                                        <div class="upload__img-wrap">
                                            @foreach($product->photos as $photo )
                                                <div class="upload__img-box">
                                                    <div style='background: url("{{asset($photo->path)}}")'
                                                         data-number="{{$loop->index}}" data-file="{{$photo->id}}"
                                                         class="img-bg photo-gallery">
                                                        <div class="upload__img-close" id="{{$photo->id}}"
                                                             onclick="filterPhotoIds({{$photo->id}})"></div>
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>


                                </div>
                            </div>
                            <div class="tab-pane fade" id="attributes-data">
                                <div class="pt-4">
                                    <div id="attributes" data-attributes="{{ json_encode(\Modules\Attribute\Entities\Attribute::all()->pluck('name')) }}"></div>
                                    <div id="attribute_section" >
                                        <button class="btn btn-sm btn-success mb-3" type="button" id="add_product_attribute">ویژگی جدید</button>
                                    @foreach($product->attributes as $attribute)
                                            <div class="row" id="attribute-{{ $loop->index }}">
                                                <div class="col-5">
                                                    <div class="form-group">
                                                        <label>عنوان ویژگی</label>
                                                        <select name="attributes[{{ $loop->index }}][name]" onchange="changeAttributeValues(event, {{ $loop->index }});" class="attribute-select form-control">
                                                            <option value="">انتخاب کنید</option>
                                                            @foreach(\Modules\Attribute\Entities\Attribute::all() as $attr)
                                                                <option value="{{ $attr->name }}" {{ $attr->name ==  $attribute->name ? 'selected' : '' }}>{{ $attr->name }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-5">
                                                    <div class="form-group">
                                                        <label>مقدار ویژگی</label>
                                                        <select name="attributes[{{ $loop->index }}][value]" class="attribute-select form-control">
                                                            <option value="">انتخاب کنید</option>
                                                            @foreach($attribute->values as $value)
                                                                <option value="{{ $value->value }}" {{ $value->id  === $attribute->pivot->value_id ? 'selected' : '' }}>{{ $value->value }}</option>
                                                            @endforeach
                                                        </select>
                                                    </div>
                                                </div>
                                                <div class="col-2">
                                                    <label >اقدامات</label>
                                                    <div>
                                                        <button type="button" class="btn btn-sm btn-warning" onclick="document.getElementById('attribute-{{ $loop->index }}').remove()">حذف</button>
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="short-desc" role="tabpanel">
                                <div class="pt-4">
                                    <div class="basic-form">
                                        <div class="card-body">
                                                <textarea class="@error('short_description') is-invalid @enderror"
                                                          name="short_description"
                                                          id="editor1">{!! old('short_description') ? old('short_description') : $product->short_description !!}</textarea>
                                            @error('short_description')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="long-desc" role="tabpanel">
                                <div class="pt-4">
                                    <div class="basic-form">

                                        <div class="card-body">
                                                <textarea class="@error('long_description') is-invalid @enderror"
                                                          name="long_description"
                                                          id="editor2">{!! old('long_description') ? old('long_description') : $product->long_description !!}</textarea>
                                            @error('long_description')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tab-pane fade" id="seo">
                                <div class="pt-4">
                                    <div class="card">
                                        <div class="card-header">
                                            <h4 class="card-title">سیستم نمایش در گوگل</h4>
                                            <img src="{{asset('/images/google-icon.png')}}"
                                                 style="width: 50px; height: auto">
                                        </div>
                                        <div class="card-body">
                                            <div class="results">
                                                <div class="ind">
                                                    <a class="link" id="g-link" href="#">
                                                        @if($product->meta_title != null)
                                                            {{$product->meta_title}}
                                                        @else
                                                            عنوان متا یک | عنوان متا 2 | نام وب سایت
                                                        @endif
                                                    </a>
                                                    <br/>
                                                    <a class="url" href="#">
                                                        {{asset('/')}} &#9662;
                                                    </a>
                                                    <p id="g-desc" class="desc">
                                                        @if($product->meta_description != null)
                                                            {{$product->meta_description}}
                                                        @else
                                                            لطفا توضیحاتی را درباره ی این پست بنویسید
                                                        @endif
                                                    </p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">عنوان متا</label>
                                        <div class="col-sm-9">
                                            <input type="text" id="meta-title" name="meta_title"
                                                   class="form-control input-rounded @error('meta_title') is-invalid @enderror"
                                                   placeholder="عنوان متا"
                                                   value="{{old('meta_title') ? old('meta_title') : $product->meta_title}}">
                                            @error('meta_title')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">توضیحات متا</label>
                                        <div class="col-sm-9">
                                            <textarea placeholder="توضیحات متا" name="meta_description"
                                                      class="form-control @error('meta_description') is-invalid @enderror"
                                                      rows="4"
                                                      id="meta-desc">{{old('meta_description') ? old('meta_description') : $product->meta_description}}</textarea>
                                            @error('meta_description')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="form-group row">
                                        <label class="col-sm-3 col-form-label">کلمات کلیدی</label>
                                        <div class="col-sm-9">
                                            <input type="text" name="meta_keywords"
                                                   class="form-control input-rounded @error('meta_keywords') is-invalid @enderror"
                                                   placeholder="مثلا: طراحی سایت , طراحی سایت من"
                                                   value="{{old('meta_keywords') ? old('meta_keywords') : $product->meta_keywords}}">
                                            @error('meta_keywords')
                                            <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
    {{-- Section End --}}

    {{-- Sidebar Start --}}

    <div class="col-md-4">
        @if($errors->any())
            <div class="alert alert-danger left-icon-big alert-dismissible fade show">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span><i
                            class="mdi mdi-close"></i></span>
                </button>
                <div class="media">
                    <div class="alert-left-icon-big">
                        <span><i class="mdi mdi-alert"></i></span>
                    </div>
                    <div class="media-body">
                        <h5 class="mt-1 mb-2">خطا!</h5>
                        @foreach($errors->all() as $error)
                            <p class="mb-0">{{$error}}</p>
                        @endforeach
                    </div>
                </div>
            </div>
        @endif
        <div class="sidebar-admin overflow-hidden">
            <div class="card-header">
                <h4 class="card-title">عملیات</h4>
                <a href="{{route('admin.products.index')}}" role="button" class="btn btn-xs btn-info light"
                   title="بازگشت">
                    بازگشت
                    <i class="fa fa-arrow-left"></i>
                </a>
            </div>
            <div class="card-body">
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    برای اعمال ویرایش ها، روی دکمه "به روز رسانی" کلیک کنید.
                </p>
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    در صورتی که میخواهید محصول منتشر شده اما در سایت نمایش داده نشود وضعیت را در حالت خاموش قرار دهید.
                </p>

                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    پیوند یکتا:
                    <br>
                </p>
                <p style="direction: ltr">
                    <a style="color:dodgerblue;"
                       href="{{asset('blog/' . $product->slug)}}">{{asset('blog/' . $product->slug)}}</a>
                </p>
                <div class="row">
                    <div class="col-md-6">
                        <div class="custom-control custom-switch toggle-switch text-right mr-4 mb-2">
                            <input type="checkbox" class="custom-control-input" id="customSwitch12" form="store"
                                   name="status" @if($product->status) checked @endif>
                            <label class="custom-control-label fs-14 text-black pr-2" for="customSwitch12">وضعیت</label>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <button class="btn btn-success btn-sm btn-block light"
                                onclick="document.getElementById('store').submit()">
                            <i class="fa fa-refresh"></i>
                            به روز رسانی
                        </button>
                    </div>

                </div>

            </div>
        </div>
        <div class="sidebar-admin">
            <div class="card-header">
                <h4 class="card-title">دسته بندی</h4>
            </div>
            <div class="card-body">
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    لطفا دسته بندی مورد نظر خود را از باکس زیر انتخاب کنید
                </p>

                <select name="categories[]" multiple
                        class="form-control default-select input-rounded" form="store">
                    @include('category::backend.products.partials.categories-dropdown-edit' ,
                             [
                                 'categories' => $categories ,
                                 'level' => 0,
                                 'post' => $product
                                 ])
                </select>


            </div>
        </div>
        <div class="sidebar-admin">
            <div class="card-header">
                <h4 class="card-title">تصویر</h4>
            </div>
            <div class="card-body">
                <p class="text-justify">
                    <i class="fa fa-circle text-blue ml-1"></i>
                    برای تغییر یا افزودن تصویر میتوانید از منوی "جزئیات" اقدام نمایید
                </p>
                <div class=" text-center">
                    <img src="{{$product->single_image}}"
                         style="border-radius: 50px 50px 50px 50px; width: 100%; height: auto">
                </div>
            </div>
        </div>
    </div>

    {{-- Sidebar End --}}

    {{-- Scripts --}}
@section('script')
    <script src="{{ asset('/vendor/file-manager/js/file-manager.js') }}"></script>
    <script src="{{asset('/backend/js/file-editor.js')}}"></script>
    <script src="{{asset('/backend/js/file-editor2.js')}}"></script>
    <script src="{{asset('/backend/js/file-button.js')}}"></script>
    <script>
        let meta_title = document.getElementById('meta-title');
        let meta_desc = document.getElementById('meta-desc');
        let g_link = document.getElementById('g-link');
        let g_desc = document.getElementById('g-desc');
        meta_title.addEventListener('change', function () {
            g_link.innerText = meta_title.value;
        })
        meta_desc.addEventListener('change', function () {
            g_desc.innerText = meta_desc.value;
        })
    </script>
    <script src="/backend/js/uploader.js"></script>
    <script>
        function arrayRemove(arr, value) {
            return arr.filter(function (ele) {
                return ele != value;
            });
        }

        let list = new Array;
        let list2 = new Array;
        list = $('.photo-gallery');
        let productPhotos = $('#new-product-photos');
        for (let i = 0; i < list.length; i++) {
            list2.push(list[i].getAttribute('data-file'))
        }
        productPhotos.val(list2);

        function filterPhotoIds(id) {
            productPhotos.val('');
            var result = arrayRemove(list2, id);
            productPhotos.val(result);
            list2 = result;
        }
    </script>
    <script src="/backend/js/attribute-selector.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script>
        $('.attribute-select').select2({tags: true});
    </script>
@stop

@section('head')
    <script src="https://cdn.tiny.cloud/1/piqrm2bib3zv8de8a26kklh89gvqb0bhm9a14mjb88jwos8r/tinymce/5/tinymce.min.js"
            referrerpolicy="origin"></script>

    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.0/css/all.css">
    <link rel="stylesheet" href="{{ asset('/vendor/file-manager/css/file-manager.css') }}">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <style>
        .upload__box {
            padding: 40px;
        }

        .upload__inputfile {
            width: 0.1px;
            height: 0.1px;
            opacity: 0;
            overflow: hidden;
            position: absolute;
            z-index: -1;
        }

        .upload__btn {
            display: inline-block;
            font-weight: 600;
            color: #fff;
            text-align: center;
            min-width: 116px;
            padding: 5px;
            transition: all 0.3s ease;
            cursor: pointer;
            border: 2px solid;
            background-color: #4045ba;
            border-color: #4045ba;
            border-radius: 10px;
            line-height: 26px;
            font-size: 14px;
        }

        .upload__btn:hover {
            background-color: unset;
            color: #4045ba;
            transition: all 0.3s ease;
        }

        .upload__btn-box {
            margin-bottom: 10px;
        }

        .upload__img-wrap {
            display: flex;
            flex-wrap: wrap;
            margin: 0 -10px;
        }

        .upload__img-box {
            width: 200px;
            padding: 0 10px;
            margin-bottom: 12px;
        }

        .upload__img-close {
            width: 24px;
            height: 24px;
            border-radius: 50%;
            background-color: rgba(0, 0, 0, 0.5);
            position: absolute;
            top: 10px;
            right: 10px;
            text-align: center;
            line-height: 24px;
            z-index: 1;
            cursor: pointer;
        }

        .upload__img-close:after {
            content: "✖";
            font-size: 14px;
            color: white;
        }

        .img-bg {
            background-repeat: no-repeat;
            background-position: center;
            background-size: cover !important;
            position: relative;
            padding-bottom: 100%;
            border-radius: 0.4rem;
        }
    </style>

@stop
@endcomponent
