<?php

namespace Modules\Product\Http\Controllers\Front;

use Artesaos\SEOTools\Facades\JsonLd;
use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Category\Entities\Category;

class ProductCategoryController extends Controller
{
    use SEOTools;

    public function show(Category $category, Request $request)
    {
        $this->seo()
            ->setTitle($category->name)
            ->addImages($category->cat_image)
            ->setDescription($category->cat_desc);
        $this->seo()->opengraph()->addProperty('type', 'article');
        $this->seo()->opengraph()->setUrl(asset('product/category/' . $category->slug));
        $this->seo()->opengraph()->setSiteName('فروشگاه دنیای آی سی');
        $this->seo()->opengraph()->setDescription($category->cat_desc);
        if ($category->cat_image) {
            JsonLd::addValue('primaryImageOfPage',asset($category->cat_image));
        }
        if ($category->products->count()) {
            $products = $category->products->paginate(12);
            return view('product::frontend.categories.content', compact(['category', 'products']));
        }
        return view('product::frontend.categories.content', compact(['category']));
    }

    public function searchCategory(Category $category, Request $request)
    {
        if ($request->ajax()) {
            if ($category->products->count()) {
                $borderStyle = 'dashed';
                $products = '';
                $products .= view('product::frontend.product-cards.style-1',
                    [
                        'products' => $category->products->paginate(12),
                        'columns' => true,
                        'border_style' => $borderStyle,
                    ]
                );
                return response()->json([
                    'success' => true,
                    'data' => $products
                ]);
            }
            return response()->json([
                'success' => false,
                'data' => "محصولی در دسته بندی $category->name وجود ندارد"
            ]);
        }
    }

}
