@component('backend.layouts.components.main',['title' => 'ویرایش سفارش','titleBar' => false])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">ویرایش سفارش</li>
    @endslot
    {{-- Section Start --}}

    <div class="col-md-8">
        <div class="sidebar-admin">
            <div class="card-header">
                <h4 class="card-title">جزئیات سفارش</h4>
            </div>
            <div class="card-body">
                <div class="custom-tab-1">
                    <ul class="nav nav-tabs">
                        <li class="nav-item">
                            <a class="nav-link active" data-toggle="tab" href="#detail">
                                <i class="la la-dot-circle ml-2"></i>
                                جزئیات سفارش
                            </a>
                        </li>
                    </ul>
                    <form action="{{route('admin.orders.update' , $order->id)}}" method="post" id="store"
                          enctype="multipart/form-data">
                        @csrf
                        @method('patch')
                        <div class="tab-content">
                            <div class="tab-pane fade show active" id="detail">
                                <div class="pt-4">
                                    <h5>لیست سفارش و اقلام</h5>
                                    <table class="table table-hover">
                                        <tbody>
                                        <tr>
                                            <th>SKU</th>
                                            <th>نام محصول</th>
                                            <th>تعداد سفارش</th>
                                            <th>قیمت کل</th>
                                        </tr>

                                        @foreach($order->products as $product)
                                            <tr>
                                                <td>
                                                    @if($product->sku)
                                                        {{$product->sku}}
                                                    @else
                                                        ندارد
                                                    @endif
                                                </td>
                                                <td>
                                                    <strong class="text-black">
                                                        <a class="text-black"
                                                           href="{{asset('product/' . $product->slug)}}">{{ $product->title }}</a>
                                                    </strong>
                                                </td>
                                                <td>
                                                    <strong class="text-black">
                                                        {{ $product->pivot->quantity }}
                                                    </strong>
                                                </td>
                                                <td>
                                                    <strong class="text-black">
                                                        {{ number_format($product->pivot->price)}}
                                                        تومان
                                                    </strong>
                                                </td>
                                            </tr>
                                        @endforeach


                                        </tbody>
                                    </table>


                                    <h5>ارسال به: </h5>
                                    <ul>
                                        <li>
                                            نام سفارش دهنده:
                                            <strong>
                                                {{$order->address->user->name}}
                                            </strong>
                                            <hr>
                                        </li>
                                        <li>
                                            نام خانوادگی:
                                            <strong>
                                                {{$order->address->user->last_name}}
                                            </strong>
                                            <hr>
                                        </li>
                                           <li>
                                            موبایل:
                                            <strong>
                                                {{$order->user->phone}}
                                            </strong>
                                            <hr>
                                        </li>
                                        <li>
                                            شهر:
                                            <strong>
                                                {{$order->address->city->name}}
                                            </strong>
                                            <hr>
                                        </li>
                                        <li>
                                            کد پستی:
                                            <strong>
                                                {{$order->address->postal_code}}
                                            </strong>
                                            <hr>
                                        </li>
                                        <li>
                                            آدرس:
                                            <strong>
                                                {{$order->address->address}}
                                            </strong>
                                            <hr>
                                        </li>
                                        <li>
                                            روش ارسال:
                                            <strong>
                                                {{$order->shipping->label}}
                                            </strong>
                                        </li>
                                    </ul>

                                </div>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>
    </div>
    {{-- Section End --}}

    {{-- Sidebar Start --}}

    <div class="col-md-4">
        @if($errors->any())
            <div class="alert alert-danger left-icon-big alert-dismissible fade show">
                <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span><i
                            class="mdi mdi-close"></i></span>
                </button>
                <div class="media">
                    <div class="alert-left-icon-big">
                        <span><i class="mdi mdi-alert"></i></span>
                    </div>
                    <div class="media-body">
                        <h5 class="mt-1 mb-2">خطا!</h5>
                        @foreach($errors->all() as $error)
                            <p class="mb-0">{{$error}}</p>
                        @endforeach
                    </div>
                </div>
            </div>
        @endif

        <div class="sidebar-admin overflow-hidden">
            <div class="card-header">
                <h4 class="card-title">عملیات</h4>
                <a href="{{route('admin.orders.index')}}" role="button" class="btn btn-xs btn-info light"
                   title="بازگشت">
                    بازگشت
                    <i class="fa fa-arrow-left"></i>
                </a>
            </div>
            <div class="card-body">
                <div class="form-group">
                    <label for="inputPassword3" class="control-label">وضعیت سفارش</label>
                    <select form="store" name="status" class="form-control">
                        <option value="unpaid" {{ old('status' , $order->status) == 'unpaid' ? 'selected' : '' }}>پرداخت
                            نشده
                        </option>
                        <option value="paid" {{ old('status' , $order->status) == 'paid' ? 'selected' : '' }}>پرداخت
                            شده
                        </option>
                        <option
                            value="preparation" {{ old('status' , $order->status) == 'preparation' ? 'selected' : '' }}>
                            در حال پردازش
                        </option>
                        <option value="posted" {{ old('status' , $order->status) == 'posted' ? 'selected' : '' }}>ارسال
                            شد
                        </option>
                        <option value="received" {{ old('status' , $order->status) == 'received' ? 'selected' : '' }}>
                            دریافت شد
                        </option>
                        <option value="canceled" {{ old('status' , $order->status) == 'canceled' ? 'selected' : '' }}>
                            کنسل شده
                        </option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="inputPassword3" class="control-label">کد پیگیری پستی</label>
                    <input form="store" type="text" name="tracking_serial" class="form-control" id="inputPassword3"
                           placeholder="کد پیگیری را وارد کنید"
                           value="{{ old('tracking_serial', $order->tracking_serial )}}">
                </div>
                <h5>یادداشت سفارش</h5>
                @if($order->notes)
                    <p>{{$order->note}}</p>
                @else
                    <p>بدون یادداشت</p>
                @endif
                <div class="row">
                    <div class="col-md-6">
                        <button class="btn btn-success btn-sm btn-block light"
                                onclick="document.getElementById('store').submit()">
                            <i class="fa fa-refresh"></i>
                            به روز رسانی
                        </button>
                    </div>

                </div>

            </div>
        </div>
    </div>

    {{-- Sidebar End --}}

    {{-- Scripts --}}
@section('script')
    <script src="{{ asset('/vendor/file-manager/js/file-manager.js') }}"></script>
    <script src="{{asset('/backend/js/file-editor.js')}}"></script>
    <script src="{{asset('/backend/js/file-editor2.js')}}"></script>
    <script src="{{asset('/backend/js/file-button.js')}}"></script>
    <script>
        let meta_title = document.getElementById('meta-title');
        let meta_desc = document.getElementById('meta-desc');
        let g_link = document.getElementById('g-link');
        let g_desc = document.getElementById('g-desc');
        meta_title.addEventListener('change', function () {
            g_link.innerText = meta_title.value;
        })
        meta_desc.addEventListener('change', function () {
            g_desc.innerText = meta_desc.value;
        })
    </script>
    <script src="/backend/js/uploader.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
@stop

@section('head')
    <script src="https://cdn.tiny.cloud/1/piqrm2bib3zv8de8a26kklh89gvqb0bhm9a14mjb88jwos8r/tinymce/5/tinymce.min.js"
            referrerpolicy="origin"></script>

    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.0/css/all.css">
    <link rel="stylesheet" href="{{ asset('/vendor/file-manager/css/file-manager.css') }}">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet"/>
    <style>
        .upload__box {
            padding: 40px;
        }

        .upload__inputfile {
            width: 0.1px;
            height: 0.1px;
            opacity: 0;
            overflow: hidden;
            position: absolute;
            z-index: -1;
        }

        .upload__btn {
            display: inline-block;
            font-weight: 600;
            color: #fff;
            text-align: center;
            min-width: 116px;
            padding: 5px;
            transition: all 0.3s ease;
            cursor: pointer;
            border: 2px solid;
            background-color: #4045ba;
            border-color: #4045ba;
            border-radius: 10px;
            line-height: 26px;
            font-size: 14px;
        }

        .upload__btn:hover {
            background-color: unset;
            color: #4045ba;
            transition: all 0.3s ease;
        }

        .upload__btn-box {
            margin-bottom: 10px;
        }

        .upload__img-wrap {
            display: flex;
            flex-wrap: wrap;
            margin: 0 -10px;
        }

        .upload__img-box {
            width: 200px;
            padding: 0 10px;
            margin-bottom: 12px;
        }

        .upload__img-close {
            width: 24px;
            height: 24px;
            border-radius: 50%;
            background-color: rgba(0, 0, 0, 0.5);
            position: absolute;
            top: 10px;
            right: 10px;
            text-align: center;
            line-height: 24px;
            z-index: 1;
            cursor: pointer;
        }

        .upload__img-close:after {
            content: "✖";
            font-size: 14px;
            color: white;
        }

        .img-bg {
            background-repeat: no-repeat;
            background-position: center;
            background-size: cover !important;
            position: relative;
            padding-bottom: 100%;
            border-radius: 0.4rem;
        }
    </style>

@stop
@endcomponent
