<?php

namespace Modules\Order\Http\Controllers\Admin;

use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Validation\Rule;
use Modules\Address\Entities\Address;
use Modules\Order\Entities\Order;

class OrderController extends Controller
{
    use SEOTools;
    public function __construct()
    {
        $this->middleware('can:manage-orders');
    }
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function index()
    {
        $this->seo()->setTitle('همه محصولات');
        $orders = Order::query();

        if($search = \request('search')) {
            $orders->where('id' , $search)->orWhere('tracking_serial' , $search)->orWhere('order_code' , $search);
        }
        $orders = $orders->where('status' , request('type'))->latest()->paginate(30);
        return view('order::backend.all' , compact('orders'));
    }
    public function payments(Order $order)
    {
        $payments = $order->payments()->latest()->paginate(20);
        return view('order::backend.payments' , compact('payments' , 'order'));
    }
    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('order::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        //
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('order::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit(Order $order)
    {
        return view('order::backend.edit' , compact('order'));
    }

    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, Order $order)
    {
        $data = $request->validate([
            'status' => ['required' , Rule::in(['unpaid' , 'paid' , 'preparation' , 'posted' , 'received' , 'canceled'])],
            'tracking_serial' => 'nullable'
        ]);

        $order->update($data);
        alert()->success('موفق' , 'ویرایش با موفقیت انجام شد');
        return back();
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy(Order $order)
    {
        $order->delete();
        alert()->success('موفق' , 'حذف با موفقیت انجام شد');
        return back();
    }
}
