<?php

namespace Modules\LoginWithCode\Http\Controllers\Auth;

use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\LoginWithCode\Entities\Code;
use Modules\User\Entities\User;

class TokenController extends Controller
{
    use SEOTools;
    public function showToken(Request $request)
    {
        $this->seo()
            ->settitle('کد تایید موبایل');
        if(! $request->session()->has('auth')) {
            return view('loginwithcode::auth.login');
        }
        $request->session()->reflash();
        return view('loginwithcode::auth.token');
    }

    public function token(Request $request)
    {
        if(! $request->session()->has('auth')) {
            toast('خطا کد ارسالی منقضی شده است' , 'warning');
            return view('loginwithcode::auth.login');
        }
        $request->session()->reflash();
        $user = User::findOrFail($request->session()->get('auth.user_id'));
        $status = Code::verifyCode($request->token , $user);
        $request->validate([
            'token' => 'required'
        ]);

        if(! $request->session()->has('auth')) {
            return view('loginwithcode::auth.login');
        }

        if (! $status){
            return response()->json([
               'success' => false,
               'data' => 'کد وارد شده صحیح نمیباشد'
            ]);
        }else{
            auth()->loginUsingId($user->id);
            $user->activeCode()->delete();
            toast('ورود با موفقیت انجام شد' , 'success');
            return response()->json([
                'success' => true
            ]);
        }
    }
}
