@component('backend.layouts.components.main',['title' => 'مدیریت دسته بندی','titleBar' => false])

    @slot('breadcrumb')
        <li class="breadcrumb-item active">
            <a href="{{route('admin.index')}}">پیشخوان</a>
        </li>
        <li class="breadcrumb-item">ویرایش دسته بندی</li>
        <li class="breadcrumb-item">{{$categories_product->name}}</li>
    @endslot
    {{-- Section Start --}}
    <div class="col-md-8">
        <div class="card">
            <div class="card-header">
                <h4 class="card-title">جزئیات دسته بندی</h4>
            </div>
            <div class="card-body">
                <div class="basic-form">
                    <form action="{{route('admin.categories-products.update' , $categories_product->id)}}" method="post" id="update">
                        @csrf
                        @method('patch')
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">نام</label>
                            <div class="col-sm-9">
                                <input name="name" type="text"
                                       class="form-control input-rounded @error('name') is-invalid @enderror"
                                       placeholder="نام"
                                       value="{{$categories_product->name}}">
                                @error('name')
                                <span class="invalid-feedback">
                                        <strong>
                                            {{$message}}
                                        </strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">لینک</label>
                            <div class="col-sm-9">
                                <input name="slug" type="text" style="direction: ltr;"
                                       class="form-control input-rounded @error('slug') is-invalid @enderror"
                                       placeholder="لینک"
                                       value="{{$categories_product->slug}}">
                                @error('slug')
                                <span class="invalid-feedback">
                                        <strong>
                                            {{$message}}
                                        </strong>
                                    </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">دسته بندی مادر</label>
                            <div class="col-sm-9">
                                <div class="dropdown bootstrap-select form-control default-select dropup">
                                    <select name="parent_id"
                                            class="form-control default-select input-rounded @error('parent_id') is-invalid @enderror" id="sel1" tabindex="-98">
                                        <option value="">ندارد</option>
                                        @include('category::backend.products.partials.category-dropdown-edit' ,
                                        [
                                            'categories' => $categories ,
                                            'level' => 0,
                                            'categories_post' => $categories_product
                                            ])
                                    </select>
                                </div>

                            </div>

                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">کلمات کلیدی</label>
                            <div class="col-sm-9">
                                <input type="text" name="keywords"
                                       class="form-control input-rounded @error('keywords') is-invalid @enderror"
                                       placeholder="مثلا: طراحی سایت , طراحی سایت من"
                                       value="{{old('keywords') ? old('keywords') : $categories_product->keywords}}">
                                @error('keywords')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                        <div class="form-group row">
                            <label class="col-sm-3 col-form-label">تصویر دسته بندی</label>
                            <div class="col-sm-9">
                                <div class="input-group">
                                    <input type="text" id="image_label" class="form-control" name="image"
                                           aria-label="Image" aria-describedby="button-image"
                                           style="direction: ltr;border-radius: 0 50px 50px 0" value="{{$categories_product->cat_image}}">
                                    <div class="input-group-append">
                                        <button class="btn btn-outline-info" type="button"
                                                id="button-image">
                                            انتخاب
                                        </button>
                                    </div>
                                </div>
                                @error('image')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>

                        <label class="col-sm-3 col-form-label">توضیحات دسته بندی (برای سئوی بهتر)</label>

                        <div class="basic-form">

                            <div class="card-body">
                                                <textarea class="@error('cat_desc') is-invalid @enderror"
                                                          name="cat_desc" id="editor1" required>{{old('cat_desc' , $categories_product->cat_desc)}}</textarea>
                                @error('cat_desc')
                                <span class="invalid-feedback">
                                                <strong>
                                                    {{$message}}
                                                </strong>
                                            </span>
                                @enderror
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
    {{-- Section End --}}

    {{-- Sidebar Start --}}
    <div class="col-md-4">
        <div class=" sidebar-admin overflow-hidden">
            <div class="card-header">
                <h4 class="card-title">عملیات</h4>
                <a href="{{route('admin.categories-products.index')}}" role="button" class="btn btn-xs btn-info light" title="بازگشت">
                    بازگشت
                    <i class="fa fa-arrow-left"></i>
                </a>
            </div>
            <div class="card-body">
                <p class="text-justify">
                    @if($categories_product->cat_image)
                        <span class="badge badge-sm badge-success">تصویر دارد</span>
                    @else
                        <span class="badge badge-sm badge-warning">تصویر ندارد</span>

                    @endif
                </p>
                <p class="text-justify">
                    <i class="fa fa-circle text-warning ml-1"></i>
                    در صورت حذف، آیتم مورد نظر برای همیشه حذف شده و راهی برای بازگشت آن وجود ندارد.
                </p>
                <div class="row">
                    <form action="{{route('admin.categories-products.destroy', $categories_product->id)}}" method="post" id="delete-{{$categories_product->id}}">
                        @method('delete')
                        @csrf
                    </form>
                    <div class="col-md-6">
                        <button class="btn btn-danger btn-sm btn-block light" onclick="document.getElementById('delete-{{$categories_product->id}}').submit()">
                            <i class="fa fa-trash"></i>
                            حذف
                        </button>
                    </div>
                    <div class="col-md-6">
                        <button class="btn btn-success btn-sm btn-block light"
                                onclick="document.getElementById('update').submit()">
                            <i class="fa fa-refresh"></i>
                            به روز رسانی
                        </button>
                    </div>
                </div>

            </div>
        </div>
    </div>
    {{-- Sidebar End --}}
@section('head')
    <script src="https://cdn.tiny.cloud/1/piqrm2bib3zv8de8a26kklh89gvqb0bhm9a14mjb88jwos8r/tinymce/5/tinymce.min.js" referrerpolicy="origin"></script>
    <link rel="stylesheet" href="https://use.fontawesome.com/releases/v5.7.0/css/all.css">
    <link rel="stylesheet" href="{{ asset('/vendor/file-manager/css/file-manager.css') }}">
    <link rel="stylesheet" href="{{ asset('/backend/vendor/nestable2/css/jquery.nestable.min.css') }}">
@stop
@section('script')
    <script src="{{ asset('/vendor/file-manager/js/file-manager.js') }}"></script>

    <script src="{{asset('/backend/js/file-editor.js')}}"></script>
    <script src="{{asset('/backend/js/file-button.js')}}"></script>
    <script src="/backend/vendor/nestable2/js/jquery.nestable.min.js"></script>

@stop
@endcomponent
