<?php

namespace Modules\Admin\Http\Controllers;

use Artesaos\SEOTools\Traits\SEOTools;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Auth;
use Modules\Order\Entities\Order;
use Modules\Price\Entities\Price;
use Modules\ProductReview\Entities\ProductReview;
use Modules\User\Entities\User;

class AdminController extends Controller
{
    use SEOTools;

    public function index()
    {
        $this->seo()->setTitle('پنل مدیریت سایت');
        $orders = Order::latest()->simplePaginate(5);
        $prices = Price::latest()->simplePaginate(5);
        $reviews = ProductReview::latest()->simplePaginate(5);
        return view('admin::backend.index', [
            'orders' => $orders,
            'prices' => $prices,
            'reviews' => $reviews
        ]);
    }

    public function showlogin()
    {
        $this->seo()->setTitle('ورود');

        if (auth()->user()) {
            return redirect('/');
        }
        return view('admin::login');

    }

    public function login(Request $request)
    {

        $validData = $request->validate([
            'phone' => 'required|exists:users',
            'password' => 'required'
        ]);
        if (Auth::attempt($validData)) {
            $user = User::with('roles')->where('phone', $validData['phone'])->first();
            if ($user->isAdmin()) {
                auth()->loginUsingId($user->id);
                return redirect(route('admin.index'));
            }
        }
        return back();
    }
}
